/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener {
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize = 0;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler;
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    static final Cursor horizontalCursor = Cursor.getPredefinedCursor(11);
    static final Cursor verticalCursor = Cursor.getPredefinedCursor(9);
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private Border border;

    public int getDividerSize() {
        return this.dividerSize;
    }

    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable() && this.leftButton == null && this.rightButton == null) {
            this.leftButton = this.createLeftOneTouchButton();
            if (this.leftButton != null) {
                this.leftButton.addActionListener(new OneTouchActionHandler(this, true));
            }
            this.rightButton = this.createRightOneTouchButton();
            if (this.rightButton != null) {
                this.rightButton.addActionListener(new OneTouchActionHandler(this, false));
            }
            if (this.leftButton != null && this.rightButton != null) {
                this.add(this.leftButton);
                this.add(this.rightButton);
            }
        }
        this.invalidate();
        this.validate();
    }

    protected void prepareForDragging() {
        this.splitPaneUI.startDragging();
    }

    protected void dragDividerTo(int n2) {
        this.splitPaneUI.dragDividerTo(n2);
    }

    protected void finishDraggingTo(int n2) {
        this.splitPaneUI.finishDraggingTo(n2);
    }

    public void setDividerSize(int n2) {
        this.dividerSize = n2;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (this.orientation == 1) {
            return new Dimension(this.getDividerSize(), 1);
        }
        return new Dimension(1, this.getDividerSize());
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Border border = this.getBorder();
        if (border != null) {
            Dimension dimension = this.getSize();
            border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
    }

    public Insets getInsets() {
        Border border = this.getBorder();
        if (border != null) {
            return border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.splitPane) {
            if (propertyChangeEvent.getPropertyName().equals("orientation")) {
                this.orientation = this.splitPane.getOrientation();
                this.setCursor(this.orientation == 1 ? horizontalCursor : verticalCursor);
                this.invalidate();
                this.validate();
            } else if (propertyChangeEvent.getPropertyName().equals("oneTouchExpandable")) {
                this.oneTouchExpandableChanged();
            }
        }
    }

    protected JButton createLeftOneTouchButton() {
        JButton jButton = new JButton(this){
            private final BasicSplitPaneDivider this$0;

            public boolean isFocusTraversable() {
                return false;
            }

            public void paint(Graphics graphics) {
                if (this.this$0.splitPane != null) {
                    int[] nArray = new int[3];
                    int[] nArray2 = new int[3];
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    graphics.setColor(Color.black);
                    if (this.this$0.orientation == 0) {
                        int n2;
                        nArray[0] = n2 = Math.min(this.getHeight(), 6);
                        nArray[1] = 0;
                        nArray[2] = n2 << 1;
                        nArray2[0] = 0;
                        nArray2[1] = nArray2[2] = n2;
                        graphics.drawPolygon(nArray, nArray2, 3);
                    } else {
                        int n3;
                        nArray[0] = nArray[2] = (n3 = Math.min(this.getWidth(), 6));
                        nArray[1] = 0;
                        nArray2[0] = 0;
                        nArray2[1] = n3;
                        nArray2[2] = n3 << 1;
                    }
                    graphics.fillPolygon(nArray, nArray2, 3);
                }
            }

            public void setBorder(Border border) {
            }
            {
                this.this$0 = basicSplitPaneDivider;
            }
        };
        jButton.setMinimumSize(new Dimension(6, 6));
        jButton.setCursor(defaultCursor);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    protected JButton createRightOneTouchButton() {
        JButton jButton = new JButton(this){
            private final BasicSplitPaneDivider this$0;

            public boolean isFocusTraversable() {
                return false;
            }

            public void paint(Graphics graphics) {
                if (this.this$0.splitPane != null) {
                    int[] nArray = new int[3];
                    int[] nArray2 = new int[3];
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (this.this$0.orientation == 0) {
                        int n2;
                        nArray[0] = n2 = Math.min(this.getHeight(), 6);
                        nArray[1] = n2 << 1;
                        nArray[2] = 0;
                        nArray2[0] = n2;
                        nArray2[2] = 0;
                        nArray2[1] = 0;
                    } else {
                        int n3 = Math.min(this.getWidth(), 6);
                        nArray[2] = 0;
                        nArray[0] = 0;
                        nArray[1] = n3;
                        nArray2[0] = 0;
                        nArray2[1] = n3;
                        nArray2[2] = n3 << 1;
                    }
                    graphics.setColor(Color.black);
                    graphics.fillPolygon(nArray, nArray2, 3);
                }
            }

            public void setBorder(Border border) {
            }
            {
                this.this$0 = basicSplitPaneDivider;
            }
        };
        jButton.setMinimumSize(new Dimension(6, 6));
        jButton.setCursor(defaultCursor);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    public Border getBorder() {
        return this.border;
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public BasicSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        this.setLayout(new DividerLayout(this));
        this.setBasicSplitPaneUI(basicSplitPaneUI);
        this.orientation = this.splitPane.getOrientation();
        this.setCursor(this.orientation == 1 ? horizontalCursor : verticalCursor);
        this.setBackground(UIManager.getColor("SplitPane.background"));
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI basicSplitPaneUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPaneUI = basicSplitPaneUI;
        if (basicSplitPaneUI != null) {
            this.splitPane = basicSplitPaneUI.getSplitPane();
            if (this.splitPane != null) {
                if (this.mouseHandler == null) {
                    this.mouseHandler = new MouseHandler(this);
                }
                this.splitPane.addMouseListener(this.mouseHandler);
                this.splitPane.addMouseMotionListener(this.mouseHandler);
                this.addMouseListener(this.mouseHandler);
                this.addMouseMotionListener(this.mouseHandler);
                this.splitPane.addPropertyChangeListener(this);
                if (this.splitPane.isOneTouchExpandable()) {
                    this.oneTouchExpandableChanged();
                }
            }
        } else {
            this.splitPane = null;
        }
    }

    protected class DividerLayout
    implements LayoutManager {
        private final BasicSplitPaneDivider this$0;

        public void removeLayoutComponent(Component component) {
        }

        public void layoutContainer(Container container) {
            if (this.this$0.leftButton != null && this.this$0.rightButton != null && container == this.this$0) {
                if (this.this$0.splitPane.isOneTouchExpandable()) {
                    Insets insets = this.this$0.getInsets();
                    if (this.this$0.orientation == 0) {
                        int n2 = insets != null ? insets.left : 0;
                        int n3 = this.this$0.getHeight();
                        if (insets != null) {
                            n3 -= insets.top + insets.bottom;
                            n3 = Math.max(n3, 0);
                        }
                        n3 = Math.min(n3, 6);
                        int n4 = (container.getSize().height - n3) / 2;
                        this.this$0.leftButton.setBounds(n2 + 2, n4, n3 * 2, n3);
                        this.this$0.rightButton.setBounds(n2 + 2 + 12, n4, n3 * 2, n3);
                    } else {
                        int n5 = insets != null ? insets.top : 0;
                        int n6 = this.this$0.getWidth();
                        if (insets != null) {
                            n6 -= insets.left + insets.right;
                            n6 = Math.max(n6, 0);
                        }
                        n6 = Math.min(n6, 6);
                        int n7 = (container.getSize().width - n6) / 2;
                        this.this$0.leftButton.setBounds(n7, n5 + 2, n6, n6 * 2);
                        this.this$0.rightButton.setBounds(n7, n5 + 2 + 12, n6, n6 * 2);
                    }
                } else {
                    this.this$0.leftButton.setBounds(-5, -5, 1, 1);
                    this.this$0.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        protected DividerLayout(BasicSplitPaneDivider basicSplitPaneDivider) {
            this.this$0 = basicSplitPaneDivider;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2;
            if (container != this.this$0 || this.this$0.splitPane == null) {
                return new Dimension(0, 0);
            }
            Dimension dimension = null;
            if (this.this$0.splitPane.isOneTouchExpandable() && this.this$0.leftButton != null) {
                dimension = this.this$0.leftButton.getMinimumSize();
            }
            Insets insets = this.this$0.getInsets();
            int n3 = n2 = this.this$0.getDividerSize();
            if (this.this$0.orientation == 0) {
                if (dimension != null) {
                    int n4 = dimension.height;
                    if (insets != null) {
                        n4 += insets.top + insets.bottom;
                    }
                    n3 = Math.max(n3, n4);
                }
                n2 = 1;
            } else {
                if (dimension != null) {
                    int n5 = dimension.width;
                    if (insets != null) {
                        n5 += insets.left + insets.right;
                    }
                    n2 = Math.max(n2, n5);
                }
                n3 = 1;
            }
            return new Dimension(n2, n3);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }
    }

    protected class DragController {
        int initialX;
        int maxX;
        int minX;
        int offset;
        private final BasicSplitPaneDivider this$0;

        protected boolean isValid() {
            return this.maxX > 0;
        }

        protected int getNeededLocation(int n2, int n3) {
            int n4 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
            return n4;
        }

        protected void completeDrag(int n2, int n3) {
            this.this$0.finishDraggingTo(this.getNeededLocation(n2, n3));
        }

        protected void continueDrag(int n2, int n3) {
            this.this$0.dragDividerTo(this.getNeededLocation(n2, n3));
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getSource() == this.this$0 ? mouseEvent.getX() + this.this$0.getLocation().x : mouseEvent.getX();
            n2 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
            return n2;
        }

        protected void completeDrag(MouseEvent mouseEvent) {
            this.this$0.finishDraggingTo(this.positionForMouseEvent(mouseEvent));
        }

        protected void continueDrag(MouseEvent mouseEvent) {
            this.this$0.dragDividerTo(this.positionForMouseEvent(mouseEvent));
        }

        protected DragController(BasicSplitPaneDivider basicSplitPaneDivider, MouseEvent mouseEvent) {
            this.this$0 = basicSplitPaneDivider;
            JSplitPane jSplitPane = basicSplitPaneDivider.splitPaneUI.getSplitPane();
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            this.initialX = basicSplitPaneDivider.getLocation().x;
            this.offset = mouseEvent.getSource() == basicSplitPaneDivider ? mouseEvent.getX() : mouseEvent.getX() - this.initialX;
            if (component == null || component2 == null || this.offset < -1 || this.offset >= basicSplitPaneDivider.getSize().width) {
                this.maxX = -1;
            } else {
                Insets insets = jSplitPane.getInsets();
                if (component.isVisible()) {
                    this.minX = component.getMinimumSize().width;
                    if (insets != null) {
                        this.minX += insets.left;
                    }
                } else {
                    this.minX = 0;
                }
                if (component2.isVisible()) {
                    int n2 = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().width - (basicSplitPaneDivider.getSize().width + n2) - component2.getMinimumSize().width);
                } else {
                    int n3 = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().width - (basicSplitPaneDivider.getSize().width + n3));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private final BasicSplitPaneDivider this$0;

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.this$0.dragger != null) {
                if (mouseEvent.getSource() == this.this$0.splitPane) {
                    this.this$0.dragger.continueDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == this.this$0) {
                    Point point = this.this$0.getLocation();
                    this.this$0.dragger.continueDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                } else if (mouseEvent.getSource() == this.this$0.hiddenDivider) {
                    Point point = this.this$0.hiddenDivider.getLocation();
                    int n2 = mouseEvent.getX() + point.x;
                    int n3 = mouseEvent.getY() + point.y;
                    this.this$0.dragger.continueDrag(n2, n3);
                }
                mouseEvent.consume();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getSource() == this.this$0 || mouseEvent.getSource() == this.this$0.splitPane) && this.this$0.dragger == null && this.this$0.splitPane.isEnabled()) {
                Component component = this.this$0.splitPaneUI.getNonContinuousLayoutDivider();
                if (this.this$0.hiddenDivider != component) {
                    if (this.this$0.hiddenDivider != null) {
                        this.this$0.hiddenDivider.removeMouseListener(this);
                        this.this$0.hiddenDivider.removeMouseMotionListener(this);
                    }
                    this.this$0.hiddenDivider = component;
                    if (this.this$0.hiddenDivider != null) {
                        this.this$0.hiddenDivider.addMouseMotionListener(this);
                        this.this$0.hiddenDivider.addMouseListener(this);
                    }
                }
                if (this.this$0.splitPane.getLeftComponent() != null && this.this$0.splitPane.getRightComponent() != null) {
                    this.this$0.dragger = this.this$0.orientation == 1 ? new DragController(this.this$0, mouseEvent) : new VerticalDragController(this.this$0, mouseEvent);
                    if (!this.this$0.dragger.isValid()) {
                        this.this$0.dragger = null;
                    } else {
                        this.this$0.prepareForDragging();
                        this.this$0.dragger.continueDrag(mouseEvent);
                    }
                }
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.this$0.dragger != null) {
                if (mouseEvent.getSource() == this.this$0.splitPane) {
                    this.this$0.dragger.completeDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == this.this$0) {
                    Point point = this.this$0.getLocation();
                    this.this$0.dragger.completeDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                } else if (mouseEvent.getSource() == this.this$0.hiddenDivider) {
                    Point point = this.this$0.hiddenDivider.getLocation();
                    int n2 = mouseEvent.getX() + point.x;
                    int n3 = mouseEvent.getY() + point.y;
                    this.this$0.dragger.completeDrag(n2, n3);
                }
                this.this$0.dragger = null;
                mouseEvent.consume();
            }
        }

        protected MouseHandler(BasicSplitPaneDivider basicSplitPaneDivider) {
            this.this$0 = basicSplitPaneDivider;
        }
    }

    private class OneTouchActionHandler
    implements ActionListener {
        private boolean toMinimum;
        private final BasicSplitPaneDivider this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            Insets insets = this.this$0.splitPane.getInsets();
            int n2 = this.this$0.splitPane.getLastDividerLocation();
            int n3 = this.this$0.splitPaneUI.getDividerLocation(this.this$0.splitPane);
            int n4 = this.toMinimum ? (this.this$0.orientation == 0 ? (n3 >= this.this$0.splitPane.getHeight() - insets.bottom - this.this$0.getHeight() ? n2 : insets.top) : (n3 >= this.this$0.splitPane.getWidth() - insets.right - this.this$0.getWidth() ? n2 : insets.left)) : (this.this$0.orientation == 0 ? (n3 == insets.top ? n2 : this.this$0.splitPane.getHeight() - this.this$0.getHeight() - insets.top) : (n3 == insets.left ? n2 : this.this$0.splitPane.getWidth() - this.this$0.getWidth() - insets.left));
            if (n3 != n4) {
                this.this$0.splitPane.setDividerLocation(n4);
                this.this$0.splitPane.setLastDividerLocation(n3);
            }
        }

        OneTouchActionHandler(BasicSplitPaneDivider basicSplitPaneDivider, boolean bl2) {
            this.this$0 = basicSplitPaneDivider;
            this.toMinimum = bl2;
        }
    }

    protected class VerticalDragController
    extends DragController {
        private final BasicSplitPaneDivider this$0;

        protected int getNeededLocation(int n2, int n3) {
            int n4 = Math.min(this.maxX, Math.max(this.minX, n3 - this.offset));
            return n4;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getSource() == this.this$0 ? mouseEvent.getY() + this.this$0.getLocation().y : mouseEvent.getY();
            n2 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
            return n2;
        }

        protected VerticalDragController(BasicSplitPaneDivider basicSplitPaneDivider, MouseEvent mouseEvent) {
            this.this$0 = basicSplitPaneDivider;
            super(basicSplitPaneDivider, mouseEvent);
            JSplitPane jSplitPane = basicSplitPaneDivider.splitPaneUI.getSplitPane();
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            this.initialX = basicSplitPaneDivider.getLocation().y;
            this.offset = mouseEvent.getSource() == basicSplitPaneDivider ? mouseEvent.getY() : mouseEvent.getY() - this.initialX;
            if (component == null || component2 == null || this.offset < -1 || this.offset > basicSplitPaneDivider.getSize().height) {
                this.maxX = -1;
            } else {
                Insets insets = jSplitPane.getInsets();
                if (component.isVisible()) {
                    this.minX = component.getMinimumSize().height;
                    if (insets != null) {
                        this.minX += insets.top;
                    }
                } else {
                    this.minX = 0;
                }
                if (component2.isVisible()) {
                    int n2 = insets != null ? insets.bottom : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().height - (basicSplitPaneDivider.getSize().height + n2) - component2.getMinimumSize().height);
                } else {
                    int n3 = insets != null ? insets.bottom : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().height - (basicSplitPaneDivider.getSize().height + n3));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }
    }
}

