/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html.parser;

import java.util.Hashtable;
import javax.swing.text.html.parser.DTDConstants;

public final class Entity
implements DTDConstants {
    public String name;
    public int type;
    public char[] data;
    static Hashtable entityTypes = new Hashtable();

    public int getType() {
        return this.type & 0xFFFF;
    }

    static {
        entityTypes.put("PUBLIC", new Integer(10));
        entityTypes.put("CDATA", new Integer(1));
        entityTypes.put("SDATA", new Integer(11));
        entityTypes.put("PI", new Integer(12));
        entityTypes.put("STARTTAG", new Integer(13));
        entityTypes.put("ENDTAG", new Integer(14));
        entityTypes.put("MS", new Integer(15));
        entityTypes.put("MD", new Integer(16));
        entityTypes.put("SYSTEM", new Integer(17));
    }

    public boolean isGeneral() {
        return (this.type & 0x10000) != 0;
    }

    public boolean isParameter() {
        return (this.type & 0x40000) != 0;
    }

    public char[] getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }

    public String getString() {
        return new String(this.data, 0, this.data.length);
    }

    public static int name2type(String string) {
        Integer n2 = (Integer)entityTypes.get(string);
        return n2 == null ? 1 : n2;
    }

    public Entity(String string, int n2, char[] cArray) {
        this.name = string;
        this.type = n2;
        this.data = cArray;
    }
}

