/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import java.io.IOException;
import java.io.Writer;
import org.apache.crimson.tree.DataNode;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.tree.XmlWriteContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class TextNode
extends DataNode
implements Text {
    public short getNodeType() {
        return 3;
    }

    public TextNode() {
    }

    public void joinNextText() {
        Node node = this.getNextSibling();
        if (node == null || node.getNodeType() != 3) {
            return;
        }
        this.getParentNode().removeChild(node);
        char[] cArray = ((TextNode)node).getText();
        char[] cArray2 = new char[this.data.length + cArray.length];
        System.arraycopy(this.data, 0, cArray2, 0, this.data.length);
        System.arraycopy(cArray, 0, cArray2, this.data.length, cArray.length);
        this.data = cArray2;
    }

    public TextNode(char[] cArray, int n2, int n3) {
        super(cArray, n2, n3);
    }

    public String getNodeName() {
        return "#text";
    }

    public TextNode(String string) {
        super(string);
    }

    public void writeXml(XmlWriteContext xmlWriteContext) throws IOException {
        int n2;
        Writer writer = xmlWriteContext.getWriter();
        int n3 = 0;
        if (this.data == null) {
            System.err.println("Null text data??");
            return;
        }
        for (n2 = 0; n2 < this.data.length; ++n2) {
            char c2 = this.data[n2];
            if (c2 == '<') {
                writer.write(this.data, n3, n2 - n3);
                n3 = n2 + 1;
                writer.write("&lt;");
                continue;
            }
            if (c2 == '>') {
                writer.write(this.data, n3, n2 - n3);
                n3 = n2 + 1;
                writer.write("&gt;");
                continue;
            }
            if (c2 != '&') continue;
            writer.write(this.data, n3, n2 - n3);
            n3 = n2 + 1;
            writer.write("&amp;");
        }
        writer.write(this.data, n3, n2 - n3);
    }

    public Node cloneNode(boolean bl2) {
        TextNode textNode = new TextNode(this.data, 0, this.data.length);
        textNode.setOwnerDocument((XmlDocument)this.getOwnerDocument());
        return textNode;
    }

    public Text splitText(int n2) throws DOMException {
        TextNode textNode;
        if (this.isReadonly()) {
            throw new DomEx(7);
        }
        try {
            textNode = new TextNode(this.data, n2, this.data.length - n2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new DomEx(1);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new DomEx(1);
        }
        this.getParentNode().insertBefore(textNode, this.getNextSibling());
        char[] cArray = new char[n2];
        System.arraycopy(this.data, 0, cArray, 0, n2);
        this.data = cArray;
        return textNode;
    }
}

