/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class ObjectVector
implements Cloneable {
    protected int m_blocksize;
    protected Object[] m_map;
    protected int m_firstFree = 0;
    protected int m_mapSize;

    public final int size() {
        return this.m_firstFree;
    }

    public ObjectVector() {
        this.m_mapSize = this.m_blocksize = 32;
        this.m_map = new Object[this.m_blocksize];
    }

    public final void removeAllElements() {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            this.m_map[i2] = null;
        }
        this.m_firstFree = 0;
    }

    public ObjectVector(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = n2;
        this.m_map = new Object[n2];
    }

    public final void addElements(int n2) {
        if (this.m_firstFree + n2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize + n2;
            Object[] objectArray = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree + 1);
            this.m_map = objectArray;
        }
        this.m_firstFree += n2;
    }

    public final void removeElementAt(int n2) {
        if (n2 > this.m_firstFree) {
            System.arraycopy(this.m_map, n2 + 1, this.m_map, n2, this.m_firstFree);
        } else {
            this.m_map[n2] = null;
        }
        --this.m_firstFree;
    }

    public final void setSize(int n2) {
        this.m_firstFree = n2;
    }

    public final void setToSize(int n2) {
        Object[] objectArray = new Object[n2];
        System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree);
        this.m_mapSize = n2;
        this.m_map = objectArray;
    }

    public ObjectVector(int n2, int n3) {
        this.m_blocksize = n3;
        this.m_mapSize = n2;
        this.m_map = new Object[n2];
    }

    public Object clone() throws CloneNotSupportedException {
        return new ObjectVector(this);
    }

    public final Object elementAt(int n2) {
        return this.m_map[n2];
    }

    public final int indexOf(Object object) {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (this.m_map[i2] != object) continue;
            return i2;
        }
        return Integer.MIN_VALUE;
    }

    public final int lastIndexOf(Object object) {
        for (int i2 = this.m_firstFree - 1; i2 >= 0; --i2) {
            if (this.m_map[i2] != object) continue;
            return i2;
        }
        return Integer.MIN_VALUE;
    }

    public final void addElement(Object object) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Object[] objectArray = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree + 1);
            this.m_map = objectArray;
        }
        this.m_map[this.m_firstFree] = object;
        ++this.m_firstFree;
    }

    public final boolean contains(Object object) {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (this.m_map[i2] != object) continue;
            return true;
        }
        return false;
    }

    public final boolean removeElement(Object object) {
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            if (this.m_map[i2] != object) continue;
            if (i2 + 1 < this.m_firstFree) {
                System.arraycopy(this.m_map, i2 + 1, this.m_map, i2 - 1, this.m_firstFree - i2);
            } else {
                this.m_map[i2] = null;
            }
            --this.m_firstFree;
            return true;
        }
        return false;
    }

    public final int indexOf(Object object, int n2) {
        for (int i2 = n2; i2 < this.m_firstFree; ++i2) {
            if (this.m_map[i2] != object) continue;
            return i2;
        }
        return Integer.MIN_VALUE;
    }

    public final void addElements(Object object, int n2) {
        if (this.m_firstFree + n2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize + n2;
            Object[] objectArray = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree + 1);
            this.m_map = objectArray;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            this.m_map[this.m_firstFree] = object;
            ++this.m_firstFree;
        }
    }

    public final void insertElementAt(Object object, int n2) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Object[] objectArray = new Object[this.m_mapSize];
            System.arraycopy(this.m_map, 0, objectArray, 0, this.m_firstFree + 1);
            this.m_map = objectArray;
        }
        if (n2 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n2, this.m_map, n2 + 1, this.m_firstFree - n2);
        }
        this.m_map[n2] = object;
        ++this.m_firstFree;
    }

    public final void setElementAt(Object object, int n2) {
        this.m_map[n2] = object;
    }

    public ObjectVector(ObjectVector objectVector) {
        this.m_map = new Object[objectVector.m_mapSize];
        this.m_mapSize = objectVector.m_mapSize;
        this.m_firstFree = objectVector.m_firstFree;
        this.m_blocksize = objectVector.m_blocksize;
        System.arraycopy(objectVector.m_map, 0, this.m_map, 0, this.m_firstFree);
    }
}

