/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import org.apache.xalan.res.XSLMessages;
import org.apache.xpath.DOM2Helper;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.ContextNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSet
implements NodeList,
NodeIterator,
Cloneable,
ContextNodeList {
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    private transient int m_last = 0;
    private int m_blocksize;
    Node[] m_map;
    protected int m_firstFree = 0;
    private int m_mapSize;

    public int getCurrentPos() {
        return this.m_next;
    }

    public int getLast() {
        return this.m_last;
    }

    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public int getWhatToShow() {
        return -17;
    }

    public int size() {
        return this.m_firstFree;
    }

    public NodeSet() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public void detach() {
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = null;
        this.m_map[this.m_firstFree + 1] = null;
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
    }

    public void removeAllElements() {
        if (null == this.m_map) {
            return;
        }
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            this.m_map[i2] = null;
        }
        this.m_firstFree = 0;
    }

    public void reset() {
        this.m_next = 0;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    public boolean isFresh() {
        return this.m_next == 0;
    }

    public NodeSet(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = 0;
    }

    public void removeElementAt(int n2) {
        if (null == this.m_map) {
            return;
        }
        if (n2 > this.m_firstFree) {
            System.arraycopy(this.m_map, n2 + 1, this.m_map, n2 - 1, this.m_firstFree - n2);
        } else {
            this.m_map[n2] = null;
        }
    }

    public void runTo(int n2) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_CANNOT_INDEX", null));
        }
        this.m_next = n2 >= 0 && this.m_next < this.m_firstFree ? n2 : this.m_firstFree - 1;
    }

    public void setCurrentPos(int n2) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_CANNOT_INDEX", null));
        }
        this.m_next = n2;
    }

    public void setLast(int n2) {
        this.m_last = n2;
    }

    public void setShouldCacheNodes(boolean bl2) {
        if (!this.isFresh()) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_CANNOT_CALL_SETSHOULDCACHENODE", null));
        }
        this.m_cacheNodes = bl2;
        this.m_mutable = true;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeSet nodeSet = (NodeSet)super.clone();
        if (null != this.m_map && this.m_map == nodeSet.m_map) {
            nodeSet.m_map = new Node[this.m_map.length];
            System.arraycopy(this.m_map, 0, nodeSet.m_map, 0, this.m_map.length);
        }
        return nodeSet;
    }

    public NodeSet(NodeSet nodeSet) {
        this(32);
        this.addNodes((NodeIterator)nodeSet);
    }

    public void addNodes(NodeSet nodeSet) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.addNodes((NodeIterator)nodeSet);
    }

    public void appendNodes(NodeSet nodeSet) {
        int n2 = nodeSet.size();
        if (null == this.m_map) {
            this.m_mapSize = n2 + this.m_blocksize;
            this.m_map = new Node[this.m_mapSize];
        } else if (this.m_firstFree + n2 >= this.m_mapSize) {
            this.m_mapSize += n2 + this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + n2);
            this.m_map = nodeArray;
        }
        System.arraycopy(nodeSet.m_map, 0, this.m_map, this.m_firstFree, n2);
        this.m_firstFree += n2;
    }

    public Node getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_CANNOT_INDEX", null));
        }
        int n2 = this.m_next;
        Node node = this.m_next < this.m_firstFree ? this.elementAt(this.m_next) : null;
        this.m_next = n2;
        return node;
    }

    public Node getRoot() {
        return null;
    }

    public Node nextNode() throws DOMException {
        if (this.m_next < this.size()) {
            Node node = this.elementAt(this.m_next);
            ++this.m_next;
            return node;
        }
        return null;
    }

    public final Node peepOrNull() {
        return null != this.m_map && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : null;
    }

    public final Node peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final Node peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public final Node pop() {
        --this.m_firstFree;
        Node node = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = null;
        return node;
    }

    public final Node popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = null;
        return this.m_firstFree == 0 ? null : this.m_map[this.m_firstFree - 1];
    }

    public Node previousNode() throws DOMException {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_CANNOT_ITERATE", null));
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return null;
    }

    public Node elementAt(int n2) {
        if (null == this.m_map) {
            return null;
        }
        return this.m_map[n2];
    }

    public Node item(int n2) {
        this.runTo(n2);
        return this.elementAt(n2);
    }

    public int indexOf(Node node) {
        this.runTo(-1);
        if (null == this.m_map) {
            return -1;
        }
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            Node node2 = this.m_map[i2];
            if (null == node2 || !node2.equals(node)) continue;
            return i2;
        }
        return -1;
    }

    public NodeSet(Node node) {
        this(32);
        this.addNode(node);
    }

    public void addElement(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] nodeArray = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
                this.m_map = nodeArray;
            }
        }
        this.m_map[this.m_firstFree] = node;
        ++this.m_firstFree;
    }

    public void addNode(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.addElement(node);
    }

    public final void push(Node node) {
        int n2 = this.m_firstFree;
        if (n2 + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new Node[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                Node[] nodeArray = new Node[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nodeArray, 0, n2 + 1);
                this.m_map = nodeArray;
            }
        }
        this.m_map[n2] = node;
        this.m_firstFree = ++n2;
    }

    public void removeNode(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.removeElement(node);
    }

    public final void setTail(Node node) {
        this.m_map[this.m_firstFree - 1] = node;
    }

    public final void setTailSub1(Node node) {
        this.m_map[this.m_firstFree - 2] = node;
    }

    public boolean contains(Node node) {
        this.runTo(-1);
        if (null == this.m_map) {
            return false;
        }
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            Node node2 = this.m_map[i2];
            if (null == node2 || !node2.equals(node)) continue;
            return true;
        }
        return false;
    }

    public boolean removeElement(Node node) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null == this.m_map) {
            return false;
        }
        for (int i2 = 0; i2 < this.m_firstFree; ++i2) {
            Node node2 = this.m_map[i2];
            if (null == node2 || !node2.equals(node)) continue;
            if (i2 > this.m_firstFree) {
                System.arraycopy(this.m_map, i2 + 1, this.m_map, i2 - 1, this.m_firstFree - i2);
            } else {
                this.m_map[i2] = null;
            }
            --this.m_firstFree;
            return true;
        }
        return false;
    }

    public int indexOf(Node node, int n2) {
        this.runTo(-1);
        if (null == this.m_map) {
            return -1;
        }
        for (int i2 = n2; i2 < this.m_firstFree; ++i2) {
            Node node2 = this.m_map[i2];
            if (null == node2 || !node2.equals(node)) continue;
            return i2;
        }
        return -1;
    }

    public void insertElementAt(Node node, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null == this.m_map) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree + 1);
            this.m_map = nodeArray;
        }
        if (n2 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n2, this.m_map, n2 + 1, this.m_firstFree - n2);
        }
        this.m_map[n2] = node;
        ++this.m_firstFree;
    }

    public void insertNode(Node node, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        this.insertElementAt(node, n2);
    }

    public void setElementAt(Node node, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null == this.m_map) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        this.m_map[n2] = node;
    }

    public NodeSet(NodeList nodeList) {
        this(32);
        this.addNodes(nodeList);
    }

    public void addNodes(NodeList nodeList) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null != nodeList) {
            int n2 = nodeList.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Node node = nodeList.item(i2);
                if (null == node) continue;
                this.addElement(node);
            }
        }
    }

    public NodeFilter getFilter() {
        return null;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSet nodeSet = (NodeSet)this.clone();
        nodeSet.reset();
        return nodeSet;
    }

    public NodeSet(NodeIterator nodeIterator) {
        this(32);
        this.addNodes(nodeIterator);
    }

    public void addNodes(NodeIterator nodeIterator) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        if (null != nodeIterator) {
            Node node;
            while (null != (node = nodeIterator.nextNode())) {
                this.addElement(node);
            }
        }
    }

    public int addNodeInDocOrder(Node node, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        return this.addNodeInDocOrder(node, true, xPathContext);
    }

    public int addNodeInDocOrder(Node node, boolean bl2, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        int n2 = -1;
        if (bl2) {
            int n3;
            int n4 = this.size();
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                Node node2 = this.elementAt(n3);
                if (node2 == node) {
                    n3 = -2;
                    break;
                }
                if (!DOM2Helper.isNodeAfter(node, node2)) break;
            }
            if (n3 != -2) {
                n2 = n3 + 1;
                this.insertElementAt(node, n2);
            }
        } else {
            n2 = this.size();
            boolean bl3 = false;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.item(i2).equals(node)) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                this.addElement(node);
            }
        }
        return n2;
    }

    private boolean addNodesInDocOrder(int n2, int n3, int n4, NodeList nodeList, XPathContext xPathContext) {
        int n5;
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        boolean bl2 = false;
        Node node = nodeList.item(n4);
        for (n5 = n3; n5 >= n2; --n5) {
            boolean bl3;
            Node node2 = this.elementAt(n5);
            if (node2 == node) {
                n5 = -2;
                break;
            }
            if (DOM2Helper.isNodeAfter(node, node2)) continue;
            this.insertElementAt(node, n5 + 1);
            if (--n4 <= 0 || (bl3 = this.addNodesInDocOrder(0, n5, n4, nodeList, xPathContext))) break;
            this.addNodesInDocOrder(n5, this.size() - 1, n4, nodeList, xPathContext);
            break;
        }
        if (n5 == -1) {
            this.insertElementAt(node, 0);
        }
        return bl2;
    }

    public void addNodesInDocOrder(NodeList nodeList, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        int n2 = nodeList.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeList.item(i2);
            if (null == node) continue;
            this.addNodeInDocOrder(node, xPathContext);
        }
    }

    public void addNodesInDocOrder(NodeIterator nodeIterator, XPathContext xPathContext) {
        Node node;
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESET_NOT_MUTABLE", null));
        }
        while (null != (node = nodeIterator.nextNode())) {
            this.addNodeInDocOrder(node, xPathContext);
        }
    }

    public final void pushPair(Node node, Node node2) {
        if (null == this.m_map) {
            this.m_map = new Node[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            Node[] nodeArray = new Node[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nodeArray, 0, this.m_firstFree);
            this.m_map = nodeArray;
        }
        this.m_map[this.m_firstFree] = node;
        this.m_map[this.m_firstFree + 1] = node2;
        this.m_firstFree += 2;
    }
}

