/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.awt.print.NumericField;
import sun.awt.print.PrintControl;
import sun.awt.print.PrinterCapabilities;
import sun.awt.print.PrinterListUpdatable;

public class PrintDialog
extends JDialog
implements PrinterListUpdatable,
ItemListener,
ActionListener {
    private static String[] sortedPrinterList = null;
    private Frame parent;
    private PrintControl printControl;
    private boolean okayedDialog = false;
    private String fileName = "";
    private int minPage = 0;
    private int maxPage = Integer.MAX_VALUE;
    private JTabbedPane tabs;
    private JPanel printPanel;
    private JLabel pagesLabel;
    private ButtonGroup selectionGroup;
    private JRadioButton selectionAllRB;
    private JRadioButton selectionRangeRB;
    private JPanel panelSelection;
    private NumericField selectionFromText;
    private JLabel selectionToLabel;
    private NumericField selectionToText;
    private JRadioButton selectionSelectionRB;
    private JLabel copiesLabel;
    private NumericField copiesText;
    private JCheckBox collateCB;
    private JLabel optionsLabel;
    private JCheckBox titleSheetCB;
    private JTextField titleSheetText;
    private JLabel commandsLabel;
    private JTextField commandsText;
    private JLabel printToLabel;
    private ButtonGroup printDestGroup;
    private JRadioButton printerRB;
    private JComboBox printerCmB;
    private JRadioButton fileRB;
    private JPanel spacingPanel1;
    private JPanel spacingPanel2;
    private JPanel propertiesPanel;
    private JLabel orientationLabel;
    private ButtonGroup orientationGroup;
    private JPanel portraitPanel;
    private JRadioButton portraitRB;
    private OrientationLabel portraitLabel;
    private JPanel landscapePanel;
    private JRadioButton landscapeRB;
    private OrientationLabel landscapeLabel;
    private JLabel colorLabel;
    private ButtonGroup colorGroup;
    private JRadioButton colorRB;
    private JRadioButton monochromeRB;
    private JLabel paperLabel;
    private JComboBox paperCmB;
    private JCheckBox duplexCB;
    private JCheckBox tumbleCB;
    private JLabel qualityLabel;
    private ButtonGroup qualityGroup;
    private JRadioButton highQualityRB;
    private JRadioButton normalQualityRB;
    private JRadioButton draftQualityRB;
    private JPanel spacingPanel3;
    private JPanel buttonPanel;
    private JPanel buttonLeftPanel;
    private JPanel buttonRightPanel;
    private JButton printButton;
    private JButton cancelButton;
    private JButton helpButton;
    private ImageIcon landscapeIcon;
    private ImageIcon portraitIcon;
    private static ResourceBundle messageRB;
    private static final MediaString[] ALL_SIZES;
    private static final DefaultComboBoxModel ALL_SIZES_MODEL;
    static Class class$sun$awt$print$PrintDialog;

    public int getCopies() {
        try {
            return this.copiesText.getValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getFromPage() {
        try {
            return this.selectionFromText.getValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public int getToPage() {
        try {
            return this.selectionToText.getValue();
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    static {
        ALL_SIZES = new MediaString[PrintControl.SIZES.length];
        PrintDialog.initResource();
        for (int i2 = 0; i2 < ALL_SIZES.length; ++i2) {
            PrintDialog.ALL_SIZES[i2] = new MediaString(PrintControl.SIZES[i2]);
        }
        ALL_SIZES_MODEL = new DefaultComboBoxModel(ALL_SIZES);
    }

    private void actionPrint() {
        if (this.getPrintRange() == JobAttributes.DefaultSelectionType.RANGE) {
            int n2 = this.getFromPage();
            if (n2 < this.minPage || n2 > this.maxPage) {
                this.selectionFromText.selectAll();
                this.selectionFromText.requestFocus();
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            int n3 = this.getToPage();
            if (n3 < this.minPage || n3 > this.maxPage || n3 < n2) {
                this.selectionToText.selectAll();
                this.selectionToText.requestFocus();
                Toolkit.getDefaultToolkit().beep();
                return;
            }
        }
        if (this.getCopies() < 1) {
            this.copiesText.selectAll();
            this.copiesText.requestFocus();
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        this.okayedDialog = true;
        this.setVisible(false);
    }

    private void actionSave() {
        SaveFileChooser saveFileChooser = (SaveFileChooser)AccessController.doPrivileged(new PrivilegedAction(this){
            private final PrintDialog this$0;

            public Object run() {
                return new SaveFileChooser(this.this$0, PrintDialog.access$300(this.this$0));
            }
            {
                this.this$0 = printDialog;
            }
        });
        if (saveFileChooser.showSaveDialog(this.parent) == 0) {
            this.fileName = saveFileChooser.getFileName();
            this.actionPrint();
        }
    }

    private void initPrintPanel() {
        this.pagesLabel = new JLabel(PrintDialog.getMsg("label.pages"));
        this.addComponent(this.pagesLabel, this.printPanel, 0, 0, 1, 1, 1, 1, 10, 2, new Insets(3, 6, 0, 0));
        this.selectionGroup = new ButtonGroup();
        this.selectionAllRB = new JRadioButton(PrintDialog.getMsg("radiobutton.all"));
        this.selectionAllRB.setMnemonic(PrintDialog.getMnemonic("radiobutton.all"));
        this.addComponent(this.selectionAllRB, this.printPanel, 1, 0, 1, 1, 1, 1, 10, 2, new Insets(3, 6, 0, 0));
        this.selectionGroup.add(this.selectionAllRB);
        this.selectionRangeRB = new JRadioButton(PrintDialog.getMsg("radiobutton.range"));
        this.selectionRangeRB.setMnemonic(PrintDialog.getMnemonic("radiobutton.range"));
        this.selectionRangeRB.addItemListener(this);
        this.addComponent(this.selectionRangeRB, this.printPanel, 1, 1, 1, 1, 1, 1, 10, 2, new Insets(0, 6, 0, 0));
        this.selectionGroup.add(this.selectionRangeRB);
        this.selectionSelectionRB = new JRadioButton(PrintDialog.getMsg("radiobutton.selection"));
        this.selectionSelectionRB.setMnemonic(PrintDialog.getMnemonic("radiobutton.selection"));
        this.addComponent(this.selectionSelectionRB, this.printPanel, 1, 2, 1, 1, 1, 1, 10, 2, new Insets(0, 6, 5, 0));
        this.selectionGroup.add(this.selectionSelectionRB);
        this.panelSelection = new JPanel(new GridLayout(1, 1, 0, 0));
        this.addComponent(this.panelSelection, this.printPanel, 2, 1, 1, 1, 0, 1, 10, 2, new Insets(0, 0, 0, 0));
        this.selectionFromText = new NumericField();
        this.selectionFromText.setEnabled(false);
        this.panelSelection.add(this.selectionFromText);
        this.selectionToLabel = new JLabel(PrintDialog.getMsg("label.selection"), 0);
        this.selectionToLabel.setForeground(this.selectionSelectionRB.getForeground());
        this.panelSelection.add(this.selectionToLabel);
        this.selectionToText = new NumericField();
        this.selectionToText.setEnabled(false);
        this.panelSelection.add(this.selectionToText);
        this.copiesText = new NumericField();
        this.addComponent(this.copiesText, this.printPanel, 1, 3, 1, 1, 1, 1, 10, 2, new Insets(0, 6, 5, 5));
        this.copiesLabel = new JLabel(PrintDialog.getMsg("label.copies"));
        this.copiesLabel.setDisplayedMnemonic(PrintDialog.getMnemonic("label.copies"));
        this.copiesLabel.setLabelFor(this.copiesText);
        this.addComponent(this.copiesLabel, this.printPanel, 0, 3, 1, 1, 1, 1, 10, 2, new Insets(0, 6, 6, 0));
        this.collateCB = new JCheckBox(PrintDialog.getMsg("checkbox.collate"));
        this.collateCB.setMnemonic(PrintDialog.getMnemonic("checkbox.collate"));
        this.addComponent(this.collateCB, this.printPanel, 2, 3, 1, 1, 1, 1, 10, 2, new Insets(0, 0, 6, 0));
        this.optionsLabel = new JLabel(PrintDialog.getMsg("label.options"));
        this.addComponent(this.optionsLabel, this.printPanel, 0, 4, 1, 1, 1, 1, 10, 2, new Insets(0, 6, 0, 0));
        this.titleSheetCB = new JCheckBox(PrintDialog.getMsg("checkbox.titlesheet"));
        this.titleSheetCB.setMnemonic(PrintDialog.getMnemonic("checkbox.titlesheet"));
        this.titleSheetCB.addItemListener(this);
        this.addComponent(this.titleSheetCB, this.printPanel, 1, 4, 1, 1, 1, 1, 10, 2, new Insets(0, 6, 0, 0));
        this.titleSheetText = new JTextField();
        this.addComponent(this.titleSheetText, this.printPanel, 2, 4, 3, 1, 3, 1, 10, 2, new Insets(0, 0, 0, 6));
        this.commandsText = new JTextField();
        this.addComponent(this.commandsText, this.printPanel, 2, 5, 3, 1, 3, 1, 10, 2, new Insets(0, 0, 5, 6));
        this.commandsLabel = new JLabel(PrintDialog.getMsg("label.commands"));
        this.commandsLabel.setDisplayedMnemonic(PrintDialog.getMnemonic("label.commands"));
        this.commandsLabel.setLabelFor(this.commandsText);
        this.addComponent(this.commandsLabel, this.printPanel, 1, 5, 1, 1, 1, 1, 10, 2, new Insets(0, 6, 5, 0));
        this.printToLabel = new JLabel(PrintDialog.getMsg("label.printdest"));
        this.addComponent(this.printToLabel, this.printPanel, 0, 6, 1, 1, 1, 1, 10, 2, new Insets(0, 6, 0, 0));
        this.printDestGroup = new ButtonGroup();
        this.printerRB = new JRadioButton(PrintDialog.getMsg("radiobutton.printer"));
        this.printerRB.setMnemonic(PrintDialog.getMnemonic("radiobutton.printer"));
        this.printerRB.addItemListener(this);
        this.addComponent(this.printerRB, this.printPanel, 1, 6, 1, 1, 1, 1, 10, 2, new Insets(0, 6, 0, 0));
        this.printDestGroup.add(this.printerRB);
        this.printerCmB = new JComboBox();
        this.printerCmB.setEditable(true);
        this.printerCmB.addItemListener(this);
        this.printerCmB.setModel(new LoadingPrintersCBModel(this));
        this.addComponent(this.printerCmB, this.printPanel, 2, 6, 3, 1, 1, 1, 10, 2, new Insets(0, 0, 0, 6));
        this.fileRB = new JRadioButton(PrintDialog.getMsg("radiobutton.file"));
        this.fileRB.setMnemonic(PrintDialog.getMnemonic("radiobutton.file"));
        this.fileRB.addItemListener(this);
        this.addComponent(this.fileRB, this.printPanel, 1, 7, 1, 1, 1, 1, 10, 2, new Insets(0, 6, 5, 0));
        this.printDestGroup.add(this.fileRB);
        this.spacingPanel1 = new JPanel();
        this.addComponent(this.spacingPanel1, this.printPanel, 3, 1, 0, 1, 50, 1, 10, 0, new Insets(0, 0, 0, 0));
        this.spacingPanel2 = new JPanel();
        this.addComponent(this.spacingPanel2, this.printPanel, 0, 8, 1, 2, 0, 80, 10, 0, new Insets(0, 0, 0, 0));
    }

    private void initPropertiesPanel() {
        this.orientationLabel = new JLabel(PrintDialog.getMsg("label.orientation"));
        this.addComponent(this.orientationLabel, this.propertiesPanel, 0, 0, 1, 1, 1, 0, 10, 2, new Insets(6, 6, 0, 0));
        this.orientationGroup = new ButtonGroup();
        this.portraitPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.addComponent(this.portraitPanel, this.propertiesPanel, 1, 0, 1, 1, 1, 0, 10, 2, new Insets(6, 1, 0, 0));
        this.portraitRB = new JRadioButton();
        this.portraitRB.setHorizontalAlignment(0);
        this.portraitPanel.add(this.portraitRB);
        this.orientationGroup.add(this.portraitRB);
        this.portraitLabel = new OrientationLabel(this, "label.portrait", this.portraitRB);
        this.portraitLabel.setForeground(this.portraitRB.getForeground());
        this.portraitIcon = new ImageIcon(PrintDialog.getImageResource("orientPortrait.gif"));
        this.portraitLabel.setIcon(this.portraitIcon);
        this.portraitPanel.add(this.portraitLabel);
        this.landscapePanel = new JPanel(new FlowLayout(0, 0, 0));
        this.addComponent(this.landscapePanel, this.propertiesPanel, 1, 1, 1, 1, 0, 0, 10, 2, new Insets(0, 1, 0, 0));
        this.landscapeRB = new JRadioButton();
        this.landscapeRB.setHorizontalAlignment(0);
        this.landscapePanel.add(this.landscapeRB);
        this.orientationGroup.add(this.landscapeRB);
        this.landscapeLabel = new OrientationLabel(this, "label.landscape", this.landscapeRB);
        this.landscapeLabel.setForeground(this.landscapeRB.getForeground());
        this.landscapeIcon = new ImageIcon(PrintDialog.getImageResource("orientLandscape.gif"));
        this.landscapeLabel.setIcon(this.landscapeIcon);
        this.landscapePanel.add(this.landscapeLabel);
        this.colorLabel = new JLabel(PrintDialog.getMsg("label.color"));
        this.addComponent(this.colorLabel, this.propertiesPanel, 0, 2, 1, 1, 1, 0, 10, 2, new Insets(0, 6, 0, 0));
        this.colorGroup = new ButtonGroup();
        this.colorRB = new JRadioButton(PrintDialog.getMsg("radiobutton.color"));
        this.colorRB.setMnemonic(PrintDialog.getMnemonic("radiobutton.color"));
        this.addComponent(this.colorRB, this.propertiesPanel, 1, 2, 1, 1, 1, 0, 10, 2, new Insets(6, 6, 0, 0));
        this.colorGroup.add(this.colorRB);
        this.monochromeRB = new JRadioButton(PrintDialog.getMsg("radiobutton.monochrome"));
        this.monochromeRB.setMnemonic(PrintDialog.getMnemonic("radiobutton.monochrome"));
        this.addComponent(this.monochromeRB, this.propertiesPanel, 1, 3, 1, 1, 1, 0, 10, 2, new Insets(0, 6, 5, 0));
        this.colorGroup.add(this.monochromeRB);
        this.paperCmB = new JComboBox();
        this.paperCmB.setModel(ALL_SIZES_MODEL);
        this.addComponent(this.paperCmB, this.propertiesPanel, 1, 4, 2, 1, 60, 0, 10, 2, new Insets(0, 6, 0, 0));
        this.paperLabel = new JLabel(PrintDialog.getMsg("label.paper"));
        this.paperLabel.setDisplayedMnemonic(PrintDialog.getMnemonic("label.paper"));
        this.paperLabel.setLabelFor(this.paperCmB);
        this.addComponent(this.paperLabel, this.propertiesPanel, 0, 4, 1, 1, 1, 0, 10, 2, new Insets(0, 6, 0, 0));
        this.duplexCB = new JCheckBox(PrintDialog.getMsg("checkbox.duplex"));
        this.duplexCB.setMnemonic(PrintDialog.getMnemonic("checkbox.duplex"));
        this.duplexCB.addItemListener(this);
        this.addComponent(this.duplexCB, this.propertiesPanel, 1, 5, 1, 1, 0, 0, 10, 2, new Insets(0, 6, 0, 0));
        this.tumbleCB = new JCheckBox(PrintDialog.getMsg("checkbox.tumble"));
        this.tumbleCB.setMnemonic(PrintDialog.getMnemonic("checkbox.tumble"));
        this.addComponent(this.tumbleCB, this.propertiesPanel, 1, 6, 1, 1, 0, 0, 10, 2, new Insets(0, 22, 5, 0));
        this.qualityLabel = new JLabel(PrintDialog.getMsg("label.quality"));
        this.addComponent(this.qualityLabel, this.propertiesPanel, 0, 7, 1, 1, 1, 0, 10, 2, new Insets(0, 6, 0, 0));
        this.qualityGroup = new ButtonGroup();
        this.highQualityRB = new JRadioButton(PrintDialog.getMsg("radiobutton.highq"));
        this.highQualityRB.setMnemonic(PrintDialog.getMnemonic("radiobutton.highq"));
        this.addComponent(this.highQualityRB, this.propertiesPanel, 1, 7, 1, 1, 1, 0, 10, 2, new Insets(0, 6, 0, 0));
        this.qualityGroup.add(this.highQualityRB);
        this.normalQualityRB = new JRadioButton(PrintDialog.getMsg("radiobutton.normalq"));
        this.normalQualityRB.setMnemonic(PrintDialog.getMnemonic("radiobutton.normalq"));
        this.addComponent(this.normalQualityRB, this.propertiesPanel, 1, 8, 1, 1, 1, 0, 10, 2, new Insets(0, 6, 0, 0));
        this.qualityGroup.add(this.normalQualityRB);
        this.draftQualityRB = new JRadioButton(PrintDialog.getMsg("radiobutton.draftq"));
        this.draftQualityRB.setMnemonic(PrintDialog.getMnemonic("radiobutton.draftq"));
        this.addComponent(this.draftQualityRB, this.propertiesPanel, 1, 9, 1, 1, 0, 0, 10, 2, new Insets(0, 6, 0, 0));
        this.qualityGroup.add(this.draftQualityRB);
        this.spacingPanel3 = new JPanel();
        this.addComponent(this.spacingPanel3, this.propertiesPanel, 3, 0, 1, 1, 100, 0, 10, 0, new Insets(0, 0, 0, 0));
    }

    static void initResource() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    PrintDialog.access$002(ResourceBundle.getBundle("sun.awt.print.resources.pdialog"));
                    return null;
                }
                catch (MissingResourceException missingResourceException) {
                    throw new Error("Fatal: Resource for PrintDialog is missing.");
                }
            }
        });
    }

    private void setDefaultPrinter() {
        String string = this.printControl.getDefaultPrinterName();
        if (sortedPrinterList == null) {
            if (string != null) {
                this.printerCmB.insertItemAt(string, 0);
            }
        } else {
            this.printerCmB.setModel(new DefaultComboBoxModel(sortedPrinterList));
            if (string != null) {
                this.printerCmB.setSelectedItem(string);
            }
        }
        if (string != null) {
            PrinterCapabilities printerCapabilities = new PrinterCapabilities(string);
            this.updatePrinterCaps(this.printControl.getCapabilities(printerCapabilities) ? printerCapabilities : null);
        } else {
            this.updatePrinterCaps(null);
        }
        this.printControl.getPrinterList(this);
    }

    public boolean display() {
        this.setVisible(true);
        return this.okayedDialog;
    }

    public boolean getCollate() {
        return this.collateCB.isSelected();
    }

    public void setCopies(int n2) {
        this.copiesText.setValue(n2);
    }

    public void setFromPage(int n2) {
        this.selectionFromText.setValue(n2);
    }

    public void setToPage(int n2) {
        this.selectionToText.setValue(n2);
    }

    public void setMinMaxPage(int n2, int n3) {
        if (this.minPage == n2 && this.maxPage == n3) {
            return;
        }
        this.minPage = n2;
        this.maxPage = n3;
        if (this.getFromPage() < n2) {
            this.setFromPage(n2);
        }
        if (this.getToPage() > n3) {
            this.setToPage(n3);
        }
    }

    public void setCollate(boolean bl2) {
        this.collateCB.setSelected(bl2);
    }

    public void setPrintToFileEnabled(boolean bl2) {
        this.fileRB.setEnabled(bl2);
    }

    public JobAttributes.DefaultSelectionType getPrintRange() {
        if (this.selectionAllRB.isSelected()) {
            return JobAttributes.DefaultSelectionType.ALL;
        }
        if (this.selectionRangeRB.isSelected()) {
            return JobAttributes.DefaultSelectionType.RANGE;
        }
        return JobAttributes.DefaultSelectionType.SELECTION;
    }

    public void setPrintRange(JobAttributes.DefaultSelectionType defaultSelectionType) {
        if (defaultSelectionType == JobAttributes.DefaultSelectionType.ALL) {
            this.selectionAllRB.setSelected(true);
        } else if (defaultSelectionType == JobAttributes.DefaultSelectionType.RANGE) {
            this.selectionRangeRB.setSelected(true);
        } else {
            this.selectionSelectionRB.setSelected(true);
        }
    }

    public JobAttributes.DestinationType getDestType() {
        if (this.printerRB.isSelected()) {
            return JobAttributes.DestinationType.PRINTER;
        }
        return JobAttributes.DestinationType.FILE;
    }

    public void setDestType(JobAttributes.DestinationType destinationType) {
        if (destinationType == JobAttributes.DestinationType.PRINTER) {
            this.printerRB.setSelected(true);
        } else {
            this.fileRB.setSelected(true);
        }
    }

    public JobAttributes.SidesType getSides() {
        if (this.duplexCB.isSelected()) {
            if (this.tumbleCB.isSelected()) {
                return JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE;
            }
            return JobAttributes.SidesType.TWO_SIDED_LONG_EDGE;
        }
        return JobAttributes.SidesType.ONE_SIDED;
    }

    public void setSides(JobAttributes.SidesType sidesType) {
        boolean bl2 = sidesType != JobAttributes.SidesType.ONE_SIDED;
        this.duplexCB.setSelected(bl2);
        if (bl2) {
            this.tumbleCB.setSelected(sidesType == JobAttributes.SidesType.TWO_SIDED_SHORT_EDGE);
        }
    }

    public PageAttributes.ColorType getColor() {
        if (this.colorRB.isSelected()) {
            return PageAttributes.ColorType.COLOR;
        }
        return PageAttributes.ColorType.MONOCHROME;
    }

    public void setColor(PageAttributes.ColorType colorType) {
        if (colorType == PageAttributes.ColorType.COLOR) {
            this.colorRB.setSelected(true);
        } else {
            this.monochromeRB.setSelected(true);
        }
    }

    public PageAttributes.MediaType getMedia() {
        return ((MediaString)this.paperCmB.getSelectedItem()).media;
    }

    public void setMedia(PageAttributes.MediaType mediaType) {
        this.paperCmB.setSelectedItem(new MediaString(mediaType));
    }

    public PageAttributes.OrientationRequestedType getOrientation() {
        if (this.portraitRB.isSelected()) {
            return PageAttributes.OrientationRequestedType.PORTRAIT;
        }
        return PageAttributes.OrientationRequestedType.LANDSCAPE;
    }

    public void setOrientation(PageAttributes.OrientationRequestedType orientationRequestedType) {
        if (orientationRequestedType == PageAttributes.OrientationRequestedType.PORTRAIT) {
            this.portraitRB.setSelected(true);
        } else {
            this.landscapeRB.setSelected(true);
        }
    }

    public PageAttributes.PrintQualityType getQuality() {
        if (this.highQualityRB.isSelected()) {
            return PageAttributes.PrintQualityType.HIGH;
        }
        if (this.normalQualityRB.isSelected()) {
            return PageAttributes.PrintQualityType.NORMAL;
        }
        return PageAttributes.PrintQualityType.DRAFT;
    }

    public void setQuality(PageAttributes.PrintQualityType printQualityType) {
        if (printQualityType == PageAttributes.PrintQualityType.HIGH) {
            this.highQualityRB.setSelected(true);
        } else if (printQualityType == PageAttributes.PrintQualityType.NORMAL) {
            this.normalQualityRB.setSelected(true);
        } else {
            this.draftQualityRB.setSelected(true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.printButton) {
            if (this.printerRB.isSelected()) {
                this.actionPrint();
            } else {
                this.actionSave();
            }
        } else if (object == this.cancelButton) {
            this.setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.selectionRangeRB) {
            boolean bl2 = this.selectionRangeRB.isSelected();
            this.selectionFromText.setEnabled(bl2);
            this.selectionToText.setEnabled(bl2);
        } else if (object == this.titleSheetCB) {
            this.titleSheetText.setEnabled(this.titleSheetCB.isSelected());
        } else if (object == this.printerRB || object == this.fileRB) {
            boolean bl3 = this.printerRB.isSelected();
            this.printerCmB.setEnabled(bl3);
            String string = bl3 ? "button.print" : "button.save";
            this.printButton.setText(PrintDialog.getMsg(string));
            this.printButton.setMnemonic(PrintDialog.getMnemonic(string));
        } else if (object == this.duplexCB) {
            this.tumbleCB.setEnabled(this.duplexCB.isSelected());
        } else {
            String string = (String)this.printerCmB.getEditor().getItem();
            if (string != null) {
                PrinterCapabilities printerCapabilities = new PrinterCapabilities(string);
                this.updatePrinterCaps(this.printControl.getCapabilities(printerCapabilities) ? printerCapabilities : null);
            } else {
                this.updatePrinterCaps(null);
            }
        }
    }

    public String getDocumentTitle() {
        if (this.titleSheetCB.isSelected()) {
            return this.titleSheetText.getText();
        }
        return null;
    }

    public String getOptionsString() {
        return this.commandsText.getText();
    }

    static String[] access$200() {
        return sortedPrinterList;
    }

    static char getMnemonic(String string) {
        String string2 = PrintDialog.getMsg(string + ".mnemonic");
        if (string2 != null && string2.length() > 0) {
            return string2.charAt(0);
        }
        return '\u0000';
    }

    public void setDocumentTitle(String string) {
        boolean bl2 = string != null;
        this.titleSheetCB.setSelected(bl2);
        if (bl2) {
            this.titleSheetText.setText(string);
        } else {
            this.titleSheetText.setText("");
        }
    }

    public void setOptionsString(String string) {
        this.commandsText.setText(string);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        PrintDialog printDialog = new PrintDialog((Frame)jFrame, null);
        printDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        printDialog.setVisible(true);
    }

    public void updatePrinterList(String[] stringArray) {
        if (stringArray != null) {
            if (stringArray == sortedPrinterList) {
                return;
            }
        }
        sortedPrinterList = stringArray;
        EventQueue.invokeLater(new Runnable(this){
            private final PrintDialog this$0;

            public void run() {
                Object object = PrintDialog.access$100(this.this$0).getEditor().getItem();
                DefaultComboBoxModel defaultComboBoxModel = PrintDialog.access$200() != null ? new DefaultComboBoxModel(PrintDialog.access$200()) : new DefaultComboBoxModel();
                PrintDialog.access$100(this.this$0).setModel(defaultComboBoxModel);
                if (object != null) {
                    PrintDialog.access$100(this.this$0).setSelectedItem(object);
                    PrintDialog.access$100(this.this$0).getEditor().setItem(object);
                }
                PrintDialog.access$100(this.this$0).repaint();
            }
            {
                this.this$0 = printDialog;
            }
        });
    }

    private void updatePrinterCaps(PrinterCapabilities printerCapabilities) {
        if (printerCapabilities != null) {
            long l2 = printerCapabilities.getCapabilities();
            if ((l2 & 1L) != 0L) {
                this.colorRB.setEnabled(true);
                this.monochromeRB.setEnabled(true);
            } else {
                this.monochromeRB.setSelected(true);
                this.colorRB.setEnabled(false);
                this.monochromeRB.setEnabled(false);
            }
            if ((l2 & 2L) != 0L) {
                this.duplexCB.setEnabled(true);
                this.tumbleCB.setEnabled(this.duplexCB.isSelected());
            } else {
                this.tumbleCB.setSelected(false);
                this.duplexCB.setSelected(false);
                this.tumbleCB.setEnabled(false);
                this.duplexCB.setEnabled(false);
            }
            if ((l2 & 4L) != 0L) {
                DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)printerCapabilities.getUserData();
                if (defaultComboBoxModel == null) {
                    int[] nArray = printerCapabilities.getSizes();
                    Object[] objectArray = new MediaString[nArray.length];
                    for (int i2 = 0; i2 < nArray.length; ++i2) {
                        objectArray[i2] = new MediaString(PrintControl.SIZES[nArray[i2]]);
                    }
                    defaultComboBoxModel = new DefaultComboBoxModel(objectArray);
                    printerCapabilities.setUserData(defaultComboBoxModel);
                }
                this.paperCmB.setModel(defaultComboBoxModel);
            } else {
                this.paperCmB.setModel(ALL_SIZES_MODEL);
            }
            this.setMedia(PrintControl.SIZES[this.printControl.getMediaAttrib()]);
        } else {
            this.colorRB.setEnabled(true);
            this.monochromeRB.setEnabled(true);
            this.paperCmB.setModel(ALL_SIZES_MODEL);
            this.duplexCB.setEnabled(true);
            this.tumbleCB.setEnabled(this.duplexCB.isSelected());
        }
        this.duplexCB.repaint();
        this.tumbleCB.repaint();
        this.colorRB.repaint();
        this.monochromeRB.repaint();
        this.paperCmB.repaint();
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public String getDestString(JobAttributes.DestinationType destinationType) {
        if (destinationType == JobAttributes.DestinationType.PRINTER) {
            return this.printerCmB.getSelectedItem().toString();
        }
        return this.fileName;
    }

    public void setDestString(JobAttributes.DestinationType destinationType, String string) {
        if (destinationType == JobAttributes.DestinationType.PRINTER) {
            this.printerCmB.setSelectedItem(string);
        } else {
            this.fileName = string == null ? "" : string;
        }
    }

    static String getMsg(String string) {
        try {
            return messageRB.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PrintDialog is broken, There is no " + string + " key in resource");
        }
    }

    static String access$300(PrintDialog printDialog) {
        return printDialog.fileName;
    }

    static URL getImageResource(String string) {
        try {
            return (class$sun$awt$print$PrintDialog == null ? (class$sun$awt$print$PrintDialog = PrintDialog.class$("sun.awt.print.PrintDialog")) : class$sun$awt$print$PrintDialog).getResource("resources/" + string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for PrintDialog is broken, There is no " + string + " key in resource");
        }
    }

    static ResourceBundle access$002(ResourceBundle resourceBundle) {
        messageRB = resourceBundle;
        return messageRB;
    }

    static JComboBox access$100(PrintDialog printDialog) {
        return printDialog.printerCmB;
    }

    public PrintDialog(Frame frame, PrintControl printControl) {
        super(frame, PrintDialog.getMsg("dialog.title"), true);
        this.parent = frame;
        this.printControl = printControl;
        this.setDefaultCloseOperation(1);
        this.getContentPane().setLayout(new BorderLayout(6, 6));
        this.tabs = new JTabbedPane();
        this.getContentPane().add("Center", this.tabs);
        this.printPanel = new JPanel(new GridBagLayout());
        this.initPrintPanel();
        this.tabs.add(this.printPanel);
        this.propertiesPanel = new JPanel(new GridBagLayout());
        this.initPropertiesPanel();
        this.tabs.add(this.propertiesPanel);
        this.tabs.setSelectedIndex(0);
        this.tabs.setSelectedComponent(this.printPanel);
        this.tabs.setTitleAt(0, PrintDialog.getMsg("tab.print"));
        this.tabs.setTitleAt(1, PrintDialog.getMsg("tab.properties"));
        this.buttonPanel = new JPanel(new GridLayout(1, 1, 6, 6));
        this.getContentPane().add("South", this.buttonPanel);
        this.buttonLeftPanel = new JPanel(new FlowLayout(1, 5, 5));
        this.buttonPanel.add(this.buttonLeftPanel);
        this.buttonRightPanel = new JPanel(new FlowLayout());
        this.buttonPanel.add(this.buttonRightPanel);
        this.buttonRightPanel.add(new JPanel());
        this.printButton = new JButton(PrintDialog.getMsg("button.print"));
        this.printButton.setMnemonic(PrintDialog.getMnemonic("button.print"));
        this.printButton.addActionListener(this);
        this.buttonRightPanel.add(this.printButton);
        this.cancelButton = new JButton(PrintDialog.getMsg("button.cancel"));
        this.cancelButton.addActionListener(this);
        this.buttonRightPanel.add(this.cancelButton);
        this.helpButton = new JButton(PrintDialog.getMsg("button.help"));
        this.helpButton.addActionListener(this);
        this.paperCmB.setPreferredSize(new Dimension(370, 20));
        this.printerCmB.setPreferredSize(new Dimension(100, 20));
        this.setResizable(false);
        this.getRootPane().setDefaultButton(this.printButton);
        this.setDefaultPrinter();
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    private void addComponent(JComponent jComponent, Container container, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.gridheight = n5;
        gridBagConstraints.anchor = n8;
        gridBagConstraints.fill = n9;
        gridBagConstraints.insets = insets;
        gridBagConstraints.weightx = n6;
        gridBagConstraints.weighty = n7;
        container.add((Component)jComponent, gridBagConstraints);
    }

    class LoadingPrintersCBModel
    extends DefaultComboBoxModel {
        private final PrintDialog this$0;

        public void setSelectedItem(Object object) {
            if (!PrintDialog.getMsg("combobox.printers").equals(object)) {
                super.setSelectedItem(object);
            }
        }

        public LoadingPrintersCBModel(PrintDialog printDialog) {
            this.this$0 = printDialog;
            super(new String[]{PrintDialog.getMsg("combobox.printers")});
        }
    }

    private static final class MediaString {
        public final PageAttributes.MediaType media;
        public final String localizedString;

        public int hashCode() {
            return this.media.hashCode();
        }

        public MediaString(PageAttributes.MediaType mediaType) {
            this.media = mediaType;
            this.localizedString = PrintDialog.getMsg(mediaType.toString());
        }

        public boolean equals(Object object) {
            if (!(object instanceof MediaString)) {
                return false;
            }
            return this.media == ((MediaString)object).media;
        }

        public String toString() {
            return this.localizedString;
        }
    }

    class OrientationLabel
    extends JLabel
    implements ItemListener,
    FocusListener,
    MouseListener,
    ActionListener {
        private JRadioButton buddy;
        private final PrintDialog this$0;

        private void click() {
            this.buddy.requestFocus();
            this.buddy.doClick();
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void reshape(int n2, int n3, int n4, int n5) {
            super.reshape(n2, n3, n4 + 3, this.buddy.getHeight());
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.buddy.hasFocus() && this.buddy.isFocusPainted()) {
                Rectangle rectangle = this.computeLayout(graphics);
                graphics.setColor(UIManager.getColor("RadioButton.focus"));
                graphics.drawRect(rectangle.x, rectangle.y - 1, rectangle.width + 1, rectangle.height + 1);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.click();
        }

        public void focusGained(FocusEvent focusEvent) {
            this.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaint();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.repaint();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.click();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        private Rectangle computeLayout(Graphics graphics) {
            Dimension dimension = this.getSize();
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = new Rectangle(this.getSize());
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle();
            String string = SwingUtilities.layoutCompoundLabel(this, fontMetrics, this.getText(), this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, (Integer)UIManager.get("RadioButton.textIconGap"));
            return rectangle3;
        }

        public OrientationLabel(PrintDialog printDialog, String string, JRadioButton jRadioButton) {
            this.this$0 = printDialog;
            super(PrintDialog.getMsg(string));
            char c2 = PrintDialog.getMnemonic(string);
            this.setDisplayedMnemonic(c2);
            this.setLabelFor(jRadioButton);
            this.buddy = jRadioButton;
            jRadioButton.addItemListener(this);
            jRadioButton.addFocusListener(this);
            this.addMouseListener(this);
            ActionMap actionMap = SwingUtilities.getUIActionMap(this);
            this.registerKeyboardAction(this, KeyStroke.getKeyStroke(c2, 8, true), 0);
        }
    }

    class SaveFileChooser
    extends JFileChooser {
        private JDialog dialog;
        private int returnValue;
        private final PrintDialog this$0;

        public void approveSelection() {
            this.returnValue = 0;
            super.approveSelection();
            this.dialog.dispose();
        }

        public void cancelSelection() {
            this.returnValue = 1;
            super.cancelSelection();
            this.dialog.dispose();
        }

        public String getFileName() {
            return this.getSelectedFile().getAbsolutePath();
        }

        public int showDialog(Component component, String string) {
            String string2;
            if (string != null) {
                this.setApproveButtonText(string);
                this.setDialogType(2);
            }
            if ((string2 = this.getDialogTitle()) == null) {
                string2 = this.getUI().getDialogTitle(this);
            }
            this.dialog = new JDialog((Frame)component, string2, true);
            Container container = this.dialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this, "Center");
            this.dialog.pack();
            this.dialog.setLocationRelativeTo(component);
            this.rescanCurrentDirectory();
            this.dialog.show();
            return this.returnValue;
        }

        public SaveFileChooser(PrintDialog printDialog, String string) {
            this.this$0 = printDialog;
            super(string);
            this.returnValue = -1;
            this.setCurrentDirectory(new File(System.getProperty("user.dir", ".")));
            this.setSelectedFile(new File(string));
        }
    }
}

