/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

public final class IntHashtable {
    private int defaultValue = 0;
    private int primeIndex;
    private static final float HIGH_WATER_FACTOR = 0.4f;
    private int highWaterMark;
    private static final float LOW_WATER_FACTOR = 0.0f;
    private int lowWaterMark;
    private int count;
    private int[] values;
    private int[] keyList;
    private static final int EMPTY = Integer.MIN_VALUE;
    private static final int DELETED = -2147483647;
    private static final int MAX_UNUSED = -2147483647;
    private static final int[] PRIMES = new int[]{17, 37, 67, 131, 257, 521, 1031, 2053, 4099, 8209, 16411, 32771, 65537, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000003, Integer.MAX_VALUE};

    public int getDefaultValue() {
        return this.defaultValue;
    }

    public int hashCode() {
        int n2;
        int n3 = 465;
        int n4 = 1362796821;
        for (n2 = 0; n2 < this.keyList.length; ++n2) {
            n3 = n3 * n4 + 1;
            n3 += this.keyList[n2];
        }
        for (n2 = 0; n2 < this.values.length; ++n2) {
            n3 = n3 * n4 + 1;
            n3 += this.values[n2];
        }
        return n3;
    }

    public int size() {
        return this.count;
    }

    public IntHashtable() {
        this.initialize(3);
    }

    private void rehash() {
        int[] nArray = this.values;
        int[] nArray2 = this.keyList;
        int n2 = this.primeIndex;
        if (this.count > this.highWaterMark) {
            ++n2;
        } else if (this.count < this.lowWaterMark) {
            n2 -= 2;
        }
        this.initialize(n2);
        for (int i2 = nArray.length - 1; i2 >= 0; --i2) {
            int n3 = nArray2[i2];
            if (n3 <= -2147483647) continue;
            this.putInternal(n3, nArray[i2]);
        }
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    private int find(int n2) {
        if (n2 <= -2147483647) {
            throw new IllegalArgumentException("key can't be less than 0xFFFFFFFE");
        }
        int n3 = -1;
        int n4 = (n2 ^ 0x4000000) % this.keyList.length;
        if (n4 < 0) {
            n4 = -n4;
        }
        int n5 = 0;
        do {
            int n6;
            if ((n6 = this.keyList[n4]) == n2) {
                return n4;
            }
            if (n6 <= -2147483647) {
                if (n6 == Integer.MIN_VALUE) {
                    if (n3 >= 0) {
                        n4 = n3;
                    }
                    return n4;
                }
                if (n3 < 0) {
                    n3 = n4;
                }
            }
            if (n5 != 0) continue;
            n5 = n2 % (this.keyList.length - 1);
            if (n5 < 0) {
                n5 = -n5;
            }
            ++n5;
        } while ((n4 = (n4 + n5) % this.keyList.length) != n3);
        return n4;
    }

    public int get(int n2) {
        return this.values[this.find(n2)];
    }

    private static int leastGreaterPrimeIndex(int n2) {
        int n3;
        for (n3 = 0; n3 < PRIMES.length && n2 >= PRIMES[n3]; ++n3) {
        }
        return n3 == 0 ? 0 : n3 - 1;
    }

    public IntHashtable(int n2) {
        this.initialize(IntHashtable.leastGreaterPrimeIndex((int)((float)n2 / 0.4f)));
    }

    private void initialize(int n2) {
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= PRIMES.length) {
            System.out.println("TOO BIG");
            n2 = PRIMES.length - 1;
        }
        this.primeIndex = n2;
        int n3 = PRIMES[n2];
        this.values = new int[n3];
        this.keyList = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            this.keyList[i2] = Integer.MIN_VALUE;
            this.values[i2] = this.defaultValue;
        }
        this.count = 0;
        this.lowWaterMark = (int)((float)n3 * 0.0f);
        this.highWaterMark = (int)((float)n3 * 0.4f);
    }

    public void remove(int n2) {
        int n3 = this.find(n2);
        if (this.keyList[n3] > -2147483647) {
            this.keyList[n3] = -2147483647;
            this.values[n3] = this.defaultValue;
            --this.count;
            if (this.count < this.lowWaterMark) {
                this.rehash();
            }
        }
    }

    public void setDefaultValue(int n2) {
        this.defaultValue = n2;
        this.rehash();
    }

    public void put(int n2, int n3) {
        int n4;
        if (this.count > this.highWaterMark) {
            this.rehash();
        }
        if (this.keyList[n4 = this.find(n2)] <= -2147483647) {
            this.keyList[n4] = n2;
            ++this.count;
        }
        this.values[n4] = n3;
    }

    public void putInternal(int n2, int n3) {
        int n4 = this.find(n2);
        if (this.keyList[n4] < -2147483647) {
            this.keyList[n4] = n2;
            ++this.count;
        }
        this.values[n4] = n3;
    }

    public Object clone() throws CloneNotSupportedException {
        IntHashtable intHashtable = (IntHashtable)super.clone();
        this.values = (int[])this.values.clone();
        this.keyList = (int[])this.keyList.clone();
        return intHashtable;
    }

    public boolean equals(Object object) {
        if (object.getClass() != this.getClass()) {
            return false;
        }
        IntHashtable intHashtable = (IntHashtable)object;
        if (intHashtable.size() != this.count || intHashtable.defaultValue != this.defaultValue) {
            return false;
        }
        for (int i2 = 0; i2 < this.keyList.length; ++i2) {
            int n2 = this.keyList[i2];
            if (n2 <= -2147483647 || intHashtable.get(n2) == this.values[i2]) continue;
            return false;
        }
        return true;
    }
}

