/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sun.misc.JarIndex;
import sun.tools.jar.CRC32OutputStream;
import sun.tools.jar.JarException;
import sun.tools.util.CommandLine;

public class Main {
    String program;
    PrintStream out;
    PrintStream err;
    String fname;
    String mname;
    String zname = "";
    String[] files;
    String rootjar = null;
    Hashtable filesTable = new Hashtable();
    Vector paths = new Vector();
    Vector v;
    CRC32 crc32 = new CRC32();
    boolean cflag;
    boolean uflag;
    boolean xflag;
    boolean tflag;
    boolean vflag;
    boolean flag0;
    boolean Mflag;
    boolean iflag;
    static final String MANIFEST = "META-INF/MANIFEST.MF";
    static final String MANIFEST_DIR = "META-INF/";
    static final String VERSION = "1.0";
    static final char SEPARATOR = File.separatorChar;
    static final String INDEX = "META-INF/INDEX.LIST";
    private static ResourceBundle rsrc;
    private boolean ok;
    private Hashtable jarTable = new Hashtable();

    static {
        try {
            rsrc = ResourceBundle.getBundle("sun.tools.jar.resources.jar");
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Fatal: Resource for jar is missing");
        }
    }

    void usageError() {
        this.error(this.getMsg("usage"));
    }

    void fatalError(Exception exception) {
        exception.printStackTrace();
    }

    protected void error(String string) {
        this.err.println(string);
    }

    void fatalError(String string) {
        this.error(this.program + ": " + string);
    }

    protected void output(String string) {
        this.out.println(string);
    }

    public static void main(String[] stringArray) {
        Main main = new Main(System.out, System.err, "jar");
        System.exit(main.run(stringArray) ? 0 : 1);
    }

    boolean parseArgs(String[] stringArray) {
        int n2;
        try {
            stringArray = CommandLine.parse(stringArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.fatalError(this.formatMsg("error.cant.open", fileNotFoundException.getMessage()));
            return false;
        }
        catch (IOException iOException) {
            this.fatalError(iOException);
            return false;
        }
        int n3 = 1;
        try {
            String string = stringArray[0];
            if (string.startsWith("-")) {
                string = string.substring(1);
            }
            block19: for (n2 = 0; n2 < string.length(); ++n2) {
                switch (string.charAt(n2)) {
                    case 'c': {
                        if (this.xflag || this.tflag || this.uflag) {
                            this.usageError();
                            return false;
                        }
                        this.cflag = true;
                        continue block19;
                    }
                    case 'u': {
                        if (this.cflag || this.xflag || this.tflag) {
                            this.usageError();
                            return false;
                        }
                        this.uflag = true;
                        continue block19;
                    }
                    case 'x': {
                        if (this.cflag || this.uflag || this.tflag) {
                            this.usageError();
                            return false;
                        }
                        this.xflag = true;
                        continue block19;
                    }
                    case 't': {
                        if (this.cflag || this.uflag || this.xflag) {
                            this.usageError();
                            return false;
                        }
                        this.tflag = true;
                        continue block19;
                    }
                    case 'M': {
                        this.Mflag = true;
                        continue block19;
                    }
                    case 'v': {
                        this.vflag = true;
                        continue block19;
                    }
                    case 'f': {
                        this.fname = stringArray[n3++];
                        continue block19;
                    }
                    case 'm': {
                        this.mname = stringArray[n3++];
                        continue block19;
                    }
                    case '0': {
                        this.flag0 = true;
                        continue block19;
                    }
                    case 'i': {
                        this.rootjar = stringArray[n3++];
                        this.iflag = true;
                        continue block19;
                    }
                    default: {
                        this.error(this.formatMsg("error.illegal.option", String.valueOf(string.charAt(n2))));
                        this.usageError();
                        return false;
                    }
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.usageError();
            return false;
        }
        if (!(this.cflag || this.tflag || this.xflag || this.uflag || this.iflag)) {
            this.error(this.getMsg("error.bad.option"));
            this.usageError();
            return false;
        }
        int n4 = stringArray.length - n3;
        if (n4 > 0) {
            n2 = 0;
            String[] stringArray2 = new String[n4];
            try {
                for (int i2 = n3; i2 < stringArray.length; ++i2) {
                    if (stringArray[i2].equals("-C")) {
                        String string;
                        string = (string = stringArray[++i2]).endsWith(File.separator) ? string : string + File.separator;
                        this.paths.addElement(string.replace(File.separatorChar, '/'));
                        stringArray2[n2++] = string + stringArray[++i2];
                        continue;
                    }
                    stringArray2[n2++] = stringArray[i2];
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.usageError();
                return false;
            }
            this.files = new String[n2];
            System.arraycopy(stringArray2, 0, this.files, 0, n2);
        } else {
            if (this.cflag && this.mname == null) {
                this.error(this.getMsg("error.bad.cflag"));
                this.usageError();
                return false;
            }
            if (this.uflag) {
                if (this.mname != null) {
                    return true;
                }
                this.error(this.getMsg("error.bad.uflag"));
                this.usageError();
                return false;
            }
        }
        return true;
    }

    public synchronized boolean run(String[] stringArray) {
        this.ok = true;
        if (!this.parseArgs(stringArray)) {
            return false;
        }
        try {
            if ((this.cflag || this.uflag) && this.fname != null) {
                this.zname = this.fname.replace(File.separatorChar, '/');
                if (this.zname.startsWith("./")) {
                    this.zname = this.zname.substring(2);
                }
            }
            if (this.cflag) {
                FileOutputStream fileOutputStream;
                Manifest manifest = null;
                FileInputStream fileInputStream = null;
                if (!this.Mflag) {
                    if (this.mname != null) {
                        fileInputStream = new FileInputStream(this.mname);
                        manifest = new Manifest(new BufferedInputStream(fileInputStream));
                    } else {
                        manifest = new Manifest();
                    }
                    this.addVersion(manifest);
                    this.addCreatedBy(manifest);
                }
                if (this.fname != null) {
                    fileOutputStream = new FileOutputStream(this.fname);
                } else {
                    fileOutputStream = new FileOutputStream(FileDescriptor.out);
                    if (this.vflag) {
                        this.vflag = false;
                    }
                }
                this.create(new BufferedOutputStream(fileOutputStream), this.expand(this.files), manifest);
                if (fileInputStream != null) {
                    ((InputStream)fileInputStream).close();
                }
                ((OutputStream)fileOutputStream).close();
            } else if (this.uflag) {
                FileOutputStream fileOutputStream;
                FileInputStream fileInputStream;
                String string;
                File file = null;
                File file2 = null;
                if (this.fname != null) {
                    file = new File(this.fname);
                    string = file.getParent();
                    file2 = File.createTempFile("tmp", null, new File(string == null ? "." : string));
                    fileInputStream = new FileInputStream(file);
                    fileOutputStream = new FileOutputStream(file2);
                } else {
                    fileInputStream = new FileInputStream(FileDescriptor.in);
                    fileOutputStream = new FileOutputStream(FileDescriptor.out);
                    this.vflag = false;
                }
                string = !this.Mflag && this.mname != null ? new FileInputStream(this.mname) : null;
                this.expand(this.files);
                this.update(fileInputStream, new BufferedOutputStream(fileOutputStream), (InputStream)((Object)string));
                fileInputStream.close();
                fileOutputStream.close();
                if (string != null) {
                    ((InputStream)((Object)string)).close();
                }
                if (this.fname != null) {
                    file.delete();
                    if (!file2.renameTo(file)) {
                        file2.delete();
                        throw new IOException(this.getMsg("error.write.file"));
                    }
                    file2.delete();
                }
            } else if (this.xflag || this.tflag) {
                FileInputStream fileInputStream = this.fname != null ? new FileInputStream(this.fname) : new FileInputStream(FileDescriptor.in);
                if (this.xflag) {
                    this.extract(new BufferedInputStream(fileInputStream), this.files);
                } else {
                    this.list(new BufferedInputStream(fileInputStream), this.files);
                }
                ((InputStream)fileInputStream).close();
            } else if (this.iflag) {
                this.genIndex(this.rootjar, this.files);
            }
        }
        catch (IOException iOException) {
            this.fatalError(iOException);
            this.ok = false;
        }
        catch (Error error) {
            error.printStackTrace();
            this.ok = false;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.ok = false;
        }
        this.out.flush();
        this.err.flush();
        return this.ok;
    }

    private void addCreatedBy(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(new Attributes.Name("Created-By")) == null) {
            String string = System.getProperty("java.vendor");
            String string2 = System.getProperty("java.version");
            attributes.put(new Attributes.Name("Created-By"), string2 + " (" + string + ")");
        }
    }

    private void addVersion(Manifest manifest) {
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
            attributes.put(Attributes.Name.MANIFEST_VERSION, VERSION);
        }
    }

    void printEntry(ZipEntry zipEntry) throws IOException {
        if (this.vflag) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = Long.toString(zipEntry.getSize());
            for (int i2 = 6 - string.length(); i2 > 0; --i2) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string).append(' ').append(new Date(zipEntry.getTime()).toString());
            stringBuffer.append(' ').append(zipEntry.getName());
            this.output(stringBuffer.toString());
        } else {
            this.output(zipEntry.getName());
        }
    }

    private void crc32File(ZipEntry zipEntry, File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        byte[] byArray = new byte[1024];
        this.crc32.reset();
        int n2 = 0;
        int n3 = 0;
        long l2 = file.length();
        while ((n2 = ((InputStream)bufferedInputStream).read(byArray)) != -1) {
            n3 += n2;
            this.crc32.update(byArray, 0, n2);
        }
        ((InputStream)bufferedInputStream).close();
        if (n3 != (int)l2) {
            throw new JarException(this.formatMsg("error.incorrect.length", file.getPath()));
        }
        zipEntry.setCrc(this.crc32.getValue());
    }

    void addFile(ZipOutputStream zipOutputStream, File file) throws IOException {
        long l2;
        String string = file.getPath();
        boolean bl2 = file.isDirectory();
        if (bl2) {
            String string2 = string = string.endsWith(File.separator) ? string : string + File.separator;
        }
        if ((string = this.entryName(string)).equals("") || string.equals(".") || string.equals(this.zname)) {
            return;
        }
        if ((string.equals(MANIFEST_DIR) || string.equals(MANIFEST)) && !this.Mflag) {
            if (this.vflag) {
                this.output(this.formatMsg("out.ignore.entry", string));
            }
            return;
        }
        long l3 = l2 = bl2 ? 0L : file.length();
        if (this.vflag) {
            this.out.print(this.formatMsg("out.adding", string));
        }
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(file.lastModified());
        if (l2 == 0L) {
            zipEntry.setMethod(0);
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
        } else if (this.flag0) {
            zipEntry.setSize(l2);
            zipEntry.setMethod(0);
            this.crc32File(zipEntry, file);
        }
        zipOutputStream.putNextEntry(zipEntry);
        if (!bl2) {
            int n2;
            byte[] byArray = new byte[1024];
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            while ((n2 = ((InputStream)bufferedInputStream).read(byArray, 0, byArray.length)) != -1) {
                zipOutputStream.write(byArray, 0, n2);
            }
            ((InputStream)bufferedInputStream).close();
        }
        zipOutputStream.closeEntry();
        if (this.vflag) {
            l2 = zipEntry.getSize();
            long l4 = zipEntry.getCompressedSize();
            this.out.print(this.formatMsg2("out.size", String.valueOf(l2), String.valueOf(l4)));
            if (zipEntry.getMethod() == 8) {
                long l5 = 0L;
                if (l2 != 0L) {
                    l5 = (l2 - l4) * 100L / l2;
                }
                this.output(this.formatMsg("out.deflated", String.valueOf(l5)));
            } else {
                this.output(this.getMsg("out.stored"));
            }
        }
    }

    void extract(InputStream inputStream, String[] stringArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        block0: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (stringArray == null) {
                this.extractFile(zipInputStream, zipEntry);
                continue;
            }
            String string = zipEntry.getName();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2].replace(File.separatorChar, '/');
                if (!string.startsWith(string2)) continue;
                this.extractFile(zipInputStream, zipEntry);
                continue block0;
            }
        }
    }

    void list(InputStream inputStream, String[] stringArray) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        block0: while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            zipInputStream.closeEntry();
            if (stringArray == null) {
                this.printEntry(zipEntry);
                continue;
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string2 = stringArray[i2].replace(File.separatorChar, '/');
                if (!string.startsWith(string2)) continue;
                this.printEntry(zipEntry);
                continue block0;
            }
        }
    }

    private String entryName(String string) {
        string = string.replace(File.separatorChar, '/');
        String string2 = "";
        for (int i2 = 0; i2 < this.paths.size(); ++i2) {
            String string3 = (String)this.paths.elementAt(i2);
            if (!string.startsWith(string3) || string3.length() <= string2.length()) continue;
            string2 = string3;
        }
        if ((string = string.substring(string2.length())).startsWith("/")) {
            string = string.substring(1);
        } else if (string.startsWith("./")) {
            string = string.substring(2);
        }
        return string;
    }

    private String getMsg(String string) {
        try {
            return rsrc.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            throw new Error("Error in message file");
        }
    }

    void genIndex(String string, String[] stringArray) throws IOException {
        Vector vector = this.getJarPath(string);
        int n2 = vector.size();
        if (n2 == 1 && stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                vector.addAll(this.getJarPath(stringArray[i2]));
            }
            n2 = vector.size();
        }
        String[] stringArray2 = (String[])vector.toArray(new String[n2]);
        JarIndex jarIndex = new JarIndex(stringArray2);
        this.dumpIndex(string, jarIndex);
    }

    String[] expand(String[] stringArray) {
        this.v = new Vector();
        this.expand(null, stringArray, this.v, this.filesTable);
        stringArray = new String[this.v.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = ((File)this.v.elementAt(i2)).getPath();
        }
        return stringArray;
    }

    Vector getJarPath(String string) throws IOException {
        String string2;
        Attributes attributes;
        Manifest manifest;
        Vector vector = new Vector();
        vector.add(string);
        this.jarTable.put(string, string);
        String string3 = string.substring(0, Math.max(0, string.lastIndexOf(47) + 1));
        JarFile jarFile = new JarFile(string.replace('/', File.separatorChar));
        if (jarFile != null && (manifest = jarFile.getManifest()) != null && (attributes = manifest.getMainAttributes()) != null && (string2 = attributes.getValue(Attributes.Name.CLASS_PATH)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.endsWith("/") || this.jarTable.get(string4 = string3.concat(string4)) != null) continue;
                vector.addAll(this.getJarPath(string4));
            }
        }
        jarFile.close();
        return vector;
    }

    private void crc32Manifest(ZipEntry zipEntry, Manifest manifest) throws IOException {
        this.crc32.reset();
        CRC32OutputStream cRC32OutputStream = new CRC32OutputStream(this.crc32);
        manifest.write(cRC32OutputStream);
        zipEntry.setSize(cRC32OutputStream.n);
        zipEntry.setCrc(this.crc32.getValue());
    }

    void extractFile(ZipInputStream zipInputStream, ZipEntry zipEntry) throws IOException {
        String string = zipEntry.getName();
        File file = new File(zipEntry.getName().replace('/', File.separatorChar));
        if (zipEntry.isDirectory()) {
            if (!file.exists() && !file.mkdirs() || !file.isDirectory()) {
                throw new IOException(this.formatMsg("error.create.dir", file.getPath()));
            }
            if (this.vflag) {
                this.output(this.formatMsg("out.create", string));
            }
        } else {
            int n2;
            Object object;
            if (!(file.getParent() == null || (((File)(object = new File(file.getParent()))).exists() || ((File)object).mkdirs()) && ((File)object).isDirectory())) {
                throw new IOException(this.formatMsg("error.create.dir", ((File)object).getPath()));
            }
            object = new FileOutputStream(file);
            byte[] byArray = new byte[512];
            while ((n2 = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                ((OutputStream)object).write(byArray, 0, n2);
            }
            zipInputStream.closeEntry();
            ((OutputStream)object).close();
            if (this.vflag) {
                if (zipEntry.getMethod() == 8) {
                    this.output(this.formatMsg("out.extracted", string));
                } else {
                    this.output(this.formatMsg("out.inflated", string));
                }
            }
        }
    }

    private void updateManifest(Manifest manifest, ZipOutputStream zipOutputStream) throws IOException {
        this.addVersion(manifest);
        this.addCreatedBy(manifest);
        ZipEntry zipEntry = new ZipEntry(MANIFEST);
        zipEntry.setTime(System.currentTimeMillis());
        if (this.flag0) {
            zipEntry.setMethod(0);
            this.crc32Manifest(zipEntry, manifest);
        }
        zipOutputStream.putNextEntry(zipEntry);
        manifest.write(zipOutputStream);
        if (this.vflag) {
            this.output(this.getMsg("out.update.manifest"));
        }
    }

    private void addIndex(JarIndex jarIndex, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry(INDEX);
        zipEntry.setTime(System.currentTimeMillis());
        if (this.flag0) {
            zipEntry.setMethod(0);
            File file = File.createTempFile("index", null, new File("."));
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            jarIndex.write(bufferedOutputStream);
            this.crc32File(zipEntry, file);
            bufferedOutputStream.close();
            file.delete();
        }
        zipOutputStream.putNextEntry(zipEntry);
        jarIndex.write(zipOutputStream);
        if (this.vflag) {
            // empty if block
        }
    }

    void dumpIndex(String string, JarIndex jarIndex) throws IOException {
        this.filesTable.put(INDEX, jarIndex);
        File file = File.createTempFile("scratch", null, new File("."));
        File file2 = new File(string);
        this.update(new FileInputStream(file2), new FileOutputStream(file), null);
        file2.delete();
        if (!file.renameTo(file2)) {
            file.delete();
            throw new IOException(this.getMsg("error.write.file"));
        }
        file.delete();
    }

    void update(InputStream inputStream, OutputStream outputStream, InputStream inputStream2) throws IOException {
        Object object;
        Hashtable hashtable = this.filesTable;
        Vector vector = this.v;
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
        ZipEntry zipEntry = null;
        boolean bl2 = false;
        byte[] byArray = new byte[1024];
        int n2 = 0;
        if (hashtable.containsKey(INDEX)) {
            this.addIndex((JarIndex)hashtable.get(INDEX), jarOutputStream);
        }
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string = zipEntry.getName();
            if (string.toUpperCase().equals(INDEX) && hashtable.containsKey(INDEX) || this.Mflag && string.toUpperCase().equals(MANIFEST)) continue;
            if (inputStream2 != null && string.toUpperCase().equals(MANIFEST)) {
                bl2 = true;
                object = new Manifest(zipInputStream);
                ((Manifest)object).read(inputStream2);
                this.updateManifest((Manifest)object, jarOutputStream);
                continue;
            }
            if (!hashtable.containsKey(string)) {
                object = new ZipEntry(string);
                ((ZipEntry)object).setMethod(zipEntry.getMethod());
                ((ZipEntry)object).setTime(zipEntry.getTime());
                ((ZipEntry)object).setComment(zipEntry.getComment());
                ((ZipEntry)object).setExtra(zipEntry.getExtra());
                if (zipEntry.getMethod() == 0) {
                    ((ZipEntry)object).setSize(zipEntry.getSize());
                    ((ZipEntry)object).setCrc(zipEntry.getCrc());
                }
                ((ZipOutputStream)jarOutputStream).putNextEntry((ZipEntry)object);
                while ((n2 = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                    jarOutputStream.write(byArray, 0, n2);
                }
                continue;
            }
            this.addFile(jarOutputStream, (File)hashtable.get(string));
            hashtable.remove(string);
        }
        hashtable.remove(INDEX);
        if (!hashtable.isEmpty()) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                object = (File)vector.elementAt(i2);
                if (!hashtable.containsValue(object)) continue;
                this.addFile(jarOutputStream, (File)object);
            }
        }
        if (!bl2 && inputStream2 != null) {
            this.updateManifest(new Manifest(inputStream2), jarOutputStream);
        }
        zipInputStream.close();
        jarOutputStream.close();
    }

    public Main(PrintStream printStream, PrintStream printStream2, String string) {
        this.out = printStream;
        this.err = printStream2;
        this.program = string;
    }

    private String formatMsg(String string, String string2) {
        String string3 = this.getMsg(string);
        Object[] objectArray = new String[]{string2};
        return MessageFormat.format(string3, objectArray);
    }

    void create(OutputStream outputStream, String[] stringArray, Manifest manifest) throws IOException {
        JarOutputStream jarOutputStream = new JarOutputStream(outputStream);
        if (this.flag0) {
            jarOutputStream.setMethod(0);
        }
        if (manifest != null) {
            if (this.vflag) {
                this.output(this.getMsg("out.added.manifest"));
            }
            ZipEntry zipEntry = new ZipEntry(MANIFEST_DIR);
            zipEntry.setTime(System.currentTimeMillis());
            zipEntry.setSize(0L);
            zipEntry.setCrc(0L);
            ((ZipOutputStream)jarOutputStream).putNextEntry(zipEntry);
            zipEntry = new ZipEntry(MANIFEST);
            zipEntry.setTime(System.currentTimeMillis());
            if (this.flag0) {
                this.crc32Manifest(zipEntry, manifest);
            }
            ((ZipOutputStream)jarOutputStream).putNextEntry(zipEntry);
            manifest.write(jarOutputStream);
            jarOutputStream.closeEntry();
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.addFile(jarOutputStream, new File(stringArray[i2]));
        }
        jarOutputStream.close();
    }

    private String formatMsg2(String string, String string2, String string3) {
        String string4 = this.getMsg(string);
        Object[] objectArray = new String[]{string2, string3};
        return MessageFormat.format(string4, objectArray);
    }

    void expand(File file, String[] stringArray, Vector vector, Hashtable hashtable) {
        if (stringArray == null) {
            return;
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            File file2 = file == null ? new File(stringArray[i2]) : new File(file, stringArray[i2]);
            if (file2.isFile()) {
                if (hashtable.contains(file2)) continue;
                hashtable.put(this.entryName(file2.getPath()), file2);
                vector.addElement(file2);
                continue;
            }
            if (file2.isDirectory()) {
                String string = file2.getPath();
                string = string.endsWith(File.separator) ? string : string + File.separator;
                hashtable.put(this.entryName(string), file2);
                vector.addElement(file2);
                this.expand(file2, file2.list(), vector, hashtable);
                continue;
            }
            this.error(this.formatMsg("error.nosuch.fileordir", String.valueOf(file2)));
            this.ok = false;
        }
    }
}

