/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.preview;

import com.sun.security.sasl.preview.FactoryEnumeration;
import com.sun.security.sasl.preview.VersionHelper;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;

final class MergedEnumeration
implements Enumeration {
    private static final VersionHelper helper = VersionHelper.getVersionHelper();
    private Object first;
    private Object nextRet = null;
    private String propName;
    private String className;
    private int propPosn;
    private Class factoryClass;
    private boolean triedProp = false;
    private boolean triedSys = false;
    private boolean triedJars = false;
    private Enumeration currentEnum;
    private Map props;

    MergedEnumeration(Object object, String string, int n, String string2, Class clazz, Map map) {
        this.first = object;
        this.propName = string;
        this.propPosn = n;
        this.className = string2;
        this.props = map;
        this.factoryClass = clazz;
    }

    public boolean hasMoreElements() {
        if (this.nextRet != null) {
            return true;
        }
        this.nextRet = this.getNext();
        return this.nextRet != null;
    }

    public Object nextElement() {
        if (this.nextRet == null) {
            return this.getNext();
        }
        Object object = this.nextRet;
        this.nextRet = null;
        return object;
    }

    private Enumeration getNextEnum() {
        Enumeration enumeration;
        if (!this.triedProp) {
            this.triedProp = true;
            enumeration = this.getFactories((String)this.props.get(this.propName));
            if (enumeration != null) {
                return enumeration;
            }
        }
        if (!this.triedSys) {
            this.triedSys = true;
            enumeration = this.getFactories(helper.getSaslProperty(this.propPosn));
            if (enumeration != null) {
                return enumeration;
            }
        }
        if (!this.triedJars) {
            this.triedJars = true;
            enumeration = helper.getFactoriesFromJars(this.factoryClass);
            if (enumeration != null) {
                return enumeration;
            }
        }
        return null;
    }

    private Object getNext() {
        if (this.first != null) {
            Object object = this.first;
            this.first = null;
            return object;
        }
        while (true) {
            Object e;
            if (this.currentEnum == null) {
                this.currentEnum = this.getNextEnum();
            }
            if (this.currentEnum == null) {
                return null;
            }
            if (this.currentEnum.hasMoreElements() && (e = this.currentEnum.nextElement()) != null) {
                return e;
            }
            this.currentEnum = null;
        }
    }

    private Enumeration getFactories(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        ArrayList<Class> arrayList = new ArrayList<Class>(5);
        while (stringTokenizer.hasMoreTokens()) {
            try {
                String string2 = stringTokenizer.nextToken().trim();
                String string3 = string2 + "." + this.className;
                arrayList.add(helper.loadClass(string3));
            }
            catch (Exception exception) {}
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return new FactoryEnumeration(arrayList);
    }
}

