/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.IllegalComponentStateException;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class JComboBox
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    private static final String uiClassID = "ComboBoxUI";
    protected ComboBoxModel dataModel;
    protected ListCellRenderer renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount = 8;
    protected boolean isEditable = false;
    protected KeySelectionManager keySelectionManager = null;
    protected String actionCommand = "comboBoxChanged";
    protected boolean lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
    protected Object selectedItemReminder = null;
    private Object prototypeDisplayValue;
    private boolean firingActionEvent = false;
    private boolean selectingItem = false;
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;
    static Class class$java$awt$event$ItemListener;
    static Class class$java$awt$event$ActionListener;
    static Class class$javax$swing$event$PopupMenuListener;

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public int getSelectedIndex() {
        Object object = this.dataModel.getSelectedItem();
        int n2 = this.dataModel.getSize();
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2 = this.dataModel.getElementAt(i2);
            if (object2 == null || !object2.equals(object)) continue;
            return i2;
        }
        return -1;
    }

    public JComboBox() {
        this.setModel(new DefaultComboBoxModel());
        this.init();
    }

    void checkMutableComboBoxModel() {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Cannot use this method with a non-Mutable data model.");
        }
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent actionEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            long l2 = EventQueue.getMostRecentEventTime();
            int n2 = 0;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent) {
                n2 = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n2 = ((ActionEvent)aWTEvent).getModifiers();
            }
            for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
                if (objectArray[i2] != (class$java$awt$event$ActionListener == null ? JComboBox.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
                if (actionEvent == null) {
                    actionEvent = new ActionEvent(this, 1001, this.getActionCommand(), l2, n2);
                }
                ((ActionListener)objectArray[i2 + 1]).actionPerformed(actionEvent);
            }
            this.firingActionEvent = false;
        }
    }

    public void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$PopupMenuListener == null ? JComboBox.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuCanceled(popupMenuEvent);
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$PopupMenuListener == null ? JComboBox.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
        }
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$javax$swing$event$PopupMenuListener == null ? JComboBox.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
        }
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    private void init() {
        this.installAncestorListener();
        this.setOpaque(true);
        this.updateUI();
    }

    protected void installAncestorListener() {
        this.addAncestorListener(new AncestorListener(this){
            private final JComboBox this$0;
            {
                this.this$0 = jComboBox;
            }

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                this.this$0.hidePopup();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                if (ancestorEvent.getSource() != this.this$0) {
                    this.this$0.hidePopup();
                }
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                this.this$0.hidePopup();
            }
        });
    }

    public void removeAllItems() {
        this.checkMutableComboBoxModel();
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.dataModel;
        int n2 = mutableComboBoxModel.getSize();
        if (mutableComboBoxModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)mutableComboBoxModel).removeAllElements();
        } else {
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = mutableComboBoxModel.getElementAt(0);
                mutableComboBoxModel.removeElement(object);
            }
        }
        this.selectedItemReminder = null;
        if (this.isEditable()) {
            this.editor.setItem(null);
        }
    }

    protected void selectedItemChanged() {
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        this.selectedItemReminder = this.dataModel.getSelectedItem();
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        }
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public boolean isPopupVisible() {
        return this.getUI().isPopupVisible(this);
    }

    public boolean selectWithKeyChar(char c2) {
        int n2;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = this.createDefaultKeySelectionManager();
        }
        if ((n2 = this.keySelectionManager.selectionForKey(c2, this.getModel())) != -1) {
            this.setSelectedIndex(n2);
            return true;
        }
        return false;
    }

    public void removeItemAt(int n2) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElementAt(n2);
    }

    public void setMaximumRowCount(int n2) {
        int n3 = this.maximumRowCount;
        this.maximumRowCount = n2;
        this.firePropertyChange("maximumRowCount", n3, this.maximumRowCount);
    }

    public void setSelectedIndex(int n2) {
        int n3 = this.dataModel.getSize();
        if (n2 == -1) {
            this.setSelectedItem(null);
        } else {
            if (n2 < -1 || n2 >= n3) {
                throw new IllegalArgumentException("setSelectedIndex: " + n2 + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(n2));
        }
    }

    public void setEditable(boolean bl2) {
        boolean bl3 = this.isEditable;
        this.isEditable = bl2;
        this.firePropertyChange("editable", bl3, this.isEditable);
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        this.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
    }

    public void setLightWeightPopupEnabled(boolean bl2) {
        boolean bl3 = this.lightWeightPopupEnabled;
        this.lightWeightPopupEnabled = bl2;
        this.firePropertyChange("lightWeightPopupEnabled", bl3, this.lightWeightPopupEnabled);
    }

    public void setPopupVisible(boolean bl2) {
        this.getUI().setPopupVisible(this, bl2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.getEditor().getItem();
        this.setPopupVisible(false);
        this.getModel().setSelectedItem(object);
        String string = this.getActionCommand();
        this.setActionCommand("comboBoxEdited");
        this.fireActionEvent();
        this.setActionCommand(string);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null && this.getAction() == actionListener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != (class$java$awt$event$ItemListener == null ? JComboBox.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) continue;
            ((ItemListener)objectArray[i2 + 1]).itemStateChanged(itemEvent);
        }
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = JComboBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = JComboBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = JComboBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            this.hidePopup();
        }
        super.processKeyEvent(keyEvent);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    public Object getPrototypeDisplayValue() {
        return this.prototypeDisplayValue;
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public Object[] getSelectedObjects() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public Object getItemAt(int n2) {
        return this.dataModel.getElementAt(n2);
    }

    public void addItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).addElement(object);
    }

    public void removeItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElement(object);
    }

    public void setPrototypeDisplayValue(Object object) {
        Object object2 = this.prototypeDisplayValue;
        this.prototypeDisplayValue = object;
        this.firePropertyChange("prototypeDisplayValue", object2, object);
    }

    public void setSelectedItem(Object object) {
        Object object2 = this.selectedItemReminder;
        if (object2 == null || !object2.equals(object)) {
            if (object != null && !this.isEditable()) {
                boolean bl2 = false;
                for (int i2 = 0; i2 < this.dataModel.getSize(); ++i2) {
                    if (!object.equals(this.dataModel.getElementAt(i2))) continue;
                    bl2 = true;
                    break;
                }
                if (!bl2) {
                    return;
                }
            }
            this.selectingItem = true;
            this.dataModel.setSelectedItem(object);
            this.selectingItem = false;
            if (this.selectedItemReminder != this.dataModel.getSelectedItem()) {
                this.selectedItemChanged();
            }
        }
        this.fireActionEvent();
    }

    public void insertItemAt(Object object, int n2) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).insertElementAt(object, n2);
    }

    public JComboBox(Object[] objectArray) {
        this.setModel(new DefaultComboBoxModel(objectArray));
        this.init();
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected String paramString() {
        String string = this.selectedItemReminder != null ? this.selectedItemReminder.toString() : "";
        String string2 = this.isEditable ? "true" : "false";
        String string3 = this.lightWeightPopupEnabled ? "true" : "false";
        return super.paramString() + ",isEditable=" + string2 + ",lightWeightPopupEnabled=" + string3 + ",maximumRowCount=" + this.maximumRowCount + ",selectedItemReminder=" + string;
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public JComboBox(Vector vector) {
        this.setModel(new DefaultComboBoxModel(vector));
        this.init();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox(this);
        }
        return this.accessibleContext;
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action action) {
        this.setEnabled(action != null ? action.isEnabled() : true);
        this.setToolTipText(action != null ? (String)action.getValue("ShortDescription") : null);
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (this.action == null || !this.action.equals(action)) {
            this.action = action;
            if (action2 != null) {
                this.removeActionListener(action2);
                action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", action2, this.action);
            this.revalidate();
            this.repaint();
        }
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        ComboBoxEditor comboBoxEditor2 = this.editor;
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        this.editor = comboBoxEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", comboBoxEditor2, this.editor);
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public JComboBox(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel);
        this.init();
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        ComboBoxModel comboBoxModel2 = this.dataModel;
        if (comboBoxModel2 != null) {
            comboBoxModel2.removeListDataListener(this);
        }
        this.dataModel = comboBoxModel;
        this.dataModel.addListDataListener(this);
        this.selectedItemReminder = this.dataModel.getSelectedItem();
        this.firePropertyChange("model", comboBoxModel2, this.dataModel);
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return new DefaultKeySelectionManager(this);
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.renderer;
        this.renderer = listCellRenderer;
        this.firePropertyChange("renderer", listCellRenderer2, this.renderer);
        this.invalidate();
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        Object object = this.selectedItemReminder;
        Object object2 = this.dataModel.getSelectedItem();
        if (object == null || !object.equals(object2)) {
            this.selectedItemChanged();
            if (!this.selectingItem) {
                this.fireActionEvent();
            }
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        if (this.selectedItemReminder != this.dataModel.getSelectedItem()) {
            this.selectedItemChanged();
        }
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.contentsChanged(listDataEvent);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JComboBox.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener);
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JComboBox.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JComboBox.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener, popupMenuListener);
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(comboBoxUI);
    }

    private boolean isListener(Class clazz, ActionListener actionListener) {
        boolean bl2 = false;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != clazz || objectArray[i2 + 1] != actionListener) continue;
            bl2 = true;
        }
        return bl2;
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new AbstractActionPropertyChangeListener(this, this, action){
            private final JComboBox this$0;

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                JComboBox jComboBox = (JComboBox)this.getTarget();
                if (jComboBox == null) {
                    Action action = (Action)propertyChangeEvent.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    jComboBox.setToolTipText(string2);
                } else if (string.equals("enabled")) {
                    Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                    jComboBox.setEnabled(bl2);
                    jComboBox.repaint();
                }
            }
            {
                this.this$0 = jComboBox;
                super(jComponent, action);
            }
        };
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        comboBoxEditor.setItem(object);
    }

    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleSelection {
        private EditorAccessibleContext editorAccessibleContext;
        private final JComboBox this$0;

        public int getAccessibleActionCount() {
            return 1;
        }

        public int getAccessibleChildrenCount() {
            if (this.this$0.ui != null) {
                return this.this$0.ui.getAccessibleChildrenCount(this.this$0);
            }
            return super.getAccessibleChildrenCount();
        }

        public int getAccessibleSelectionCount() {
            Object object = this.this$0.getSelectedItem();
            if (object != null) {
                return 1;
            }
            return 0;
        }

        public void clearAccessibleSelection() {
            this.this$0.setSelectedIndex(-1);
        }

        public void selectAllAccessibleSelection() {
        }

        public void addAccessibleSelection(int n2) {
            this.this$0.setSelectedIndex(n2);
        }

        public void removeAccessibleSelection(int n2) {
            if (this.this$0.getSelectedIndex() == n2) {
                this.clearAccessibleSelection();
            }
        }

        public boolean doAccessibleAction(int n2) {
            if (n2 == 0) {
                this.this$0.setPopupVisible(!this.this$0.isPopupVisible());
                return true;
            }
            return false;
        }

        public boolean isAccessibleChildSelected(int n2) {
            return this.this$0.getSelectedIndex() == n2;
        }

        public String getAccessibleActionDescription(int n2) {
            if (n2 == 0) {
                return UIManager.getString("ComboBox.togglePopupText");
            }
            return null;
        }

        public Accessible getAccessibleChild(int n2) {
            if (this.this$0.ui != null) {
                return this.this$0.ui.getAccessibleChild(this.this$0, n2);
            }
            return super.getAccessibleChild(n2);
        }

        public Accessible getAccessibleSelection(int n2) {
            AccessibleSelection accessibleSelection;
            JList jList;
            AccessibleContext accessibleContext;
            Accessible accessible = this.this$0.getUI().getAccessibleChild(this.this$0, 0);
            if (accessible != null && accessible instanceof ComboPopup && (accessibleContext = (jList = ((ComboPopup)((Object)accessible)).getList()).getAccessibleContext()) != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                return accessibleSelection.getAccessibleSelection(n2);
            }
            return null;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        protected AccessibleJComboBox(JComboBox jComboBox) {
            this.this$0 = jComboBox;
            super(jComboBox);
            this.editorAccessibleContext = null;
        }

        static JComboBox access$100(AccessibleJComboBox accessibleJComboBox) {
            return accessibleJComboBox.this$0;
        }

        static EditorAccessibleContext access$000(AccessibleJComboBox accessibleJComboBox) {
            return accessibleJComboBox.editorAccessibleContext;
        }

        static EditorAccessibleContext access$002(AccessibleJComboBox accessibleJComboBox, EditorAccessibleContext editorAccessibleContext) {
            accessibleJComboBox.editorAccessibleContext = editorAccessibleContext;
            return accessibleJComboBox.editorAccessibleContext;
        }

        private class AccessibleEditor
        implements Accessible {
            private final AccessibleJComboBox this$1;

            public AccessibleContext getAccessibleContext() {
                Component component;
                if (AccessibleJComboBox.access$000(this.this$1) == null && (component = AccessibleJComboBox.access$100(this.this$1).getEditor().getEditorComponent()) instanceof Accessible) {
                    AccessibleJComboBox.access$002(this.this$1, new EditorAccessibleContext(this.this$1, (Accessible)((Object)component)));
                }
                return AccessibleJComboBox.access$000(this.this$1);
            }

            private AccessibleEditor(AccessibleJComboBox accessibleJComboBox) {
                this.this$1 = accessibleJComboBox;
            }
        }

        private class EditorAccessibleContext
        extends AccessibleContext {
            private AccessibleContext ac;
            private final AccessibleJComboBox this$1;

            public int getAccessibleChildrenCount() {
                return this.ac.getAccessibleChildrenCount();
            }

            public int getAccessibleIndexInParent() {
                return AccessibleJComboBox.access$100(this.this$1).getSelectedIndex();
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.ac.addPropertyChangeListener(propertyChangeListener);
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.ac.removePropertyChangeListener(propertyChangeListener);
            }

            public String getAccessibleDescription() {
                return this.ac.getAccessibleDescription();
            }

            public String getAccessibleName() {
                return this.ac.getAccessibleName();
            }

            public void setAccessibleDescription(String string) {
                this.ac.setAccessibleDescription(string);
            }

            public void setAccessibleName(String string) {
                this.ac.setAccessibleName(string);
            }

            public Locale getLocale() throws IllegalComponentStateException {
                return this.ac.getLocale();
            }

            public Accessible getAccessibleParent() {
                return this.ac.getAccessibleParent();
            }

            public Accessible getAccessibleChild(int n2) {
                return this.ac.getAccessibleChild(n2);
            }

            public void setAccessibleParent(Accessible accessible) {
                this.ac.setAccessibleParent(accessible);
            }

            public AccessibleAction getAccessibleAction() {
                return this.ac.getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this.ac.getAccessibleComponent();
            }

            public AccessibleEditableText getAccessibleEditableText() {
                return this.ac.getAccessibleEditableText();
            }

            public AccessibleIcon[] getAccessibleIcon() {
                return this.ac.getAccessibleIcon();
            }

            public AccessibleRelationSet getAccessibleRelationSet() {
                return this.ac.getAccessibleRelationSet();
            }

            public AccessibleRole getAccessibleRole() {
                return this.ac.getAccessibleRole();
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.ac.getAccessibleSelection();
            }

            public AccessibleStateSet getAccessibleStateSet() {
                return this.ac.getAccessibleStateSet();
            }

            public AccessibleTable getAccessibleTable() {
                return this.ac.getAccessibleTable();
            }

            public AccessibleText getAccessibleText() {
                return this.ac.getAccessibleText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.ac.getAccessibleValue();
            }

            private EditorAccessibleContext(AccessibleJComboBox accessibleJComboBox) {
                this.this$1 = accessibleJComboBox;
            }

            EditorAccessibleContext(AccessibleJComboBox accessibleJComboBox, Accessible accessible) {
                this.this$1 = accessibleJComboBox;
                this.ac = accessible.getAccessibleContext();
            }

            public void firePropertyChange(String string, Object object, Object object2) {
                this.ac.firePropertyChange(string, object, object2);
            }
        }
    }

    class DefaultKeySelectionManager
    implements KeySelectionManager,
    Serializable {
        private final JComboBox this$0;

        public int selectionForKey(char c2, ComboBoxModel comboBoxModel) {
            String string;
            Object object;
            int n2;
            int n3;
            int n4 = -1;
            Object object2 = comboBoxModel.getSelectedItem();
            if (object2 != null) {
                n3 = comboBoxModel.getSize();
                for (n2 = 0; n2 < n3; ++n2) {
                    if (object2 != comboBoxModel.getElementAt(n2)) continue;
                    n4 = n2;
                    break;
                }
            }
            String string2 = ("" + c2).toLowerCase();
            c2 = string2.charAt(0);
            n3 = comboBoxModel.getSize();
            for (n2 = ++n4; n2 < n3; ++n2) {
                object = comboBoxModel.getElementAt(n2);
                if (object == null || object.toString() == null || (string = object.toString().toLowerCase()).length() <= 0 || string.charAt(0) != c2) continue;
                return n2;
            }
            for (n2 = 0; n2 < n4; ++n2) {
                object = comboBoxModel.getElementAt(n2);
                if (object == null || object.toString() == null || (string = object.toString().toLowerCase()).length() <= 0 || string.charAt(0) != c2) continue;
                return n2;
            }
            return -1;
        }

        DefaultKeySelectionManager(JComboBox jComboBox) {
            this.this$0 = jComboBox;
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }
}

