/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.xpath.objects.XBoolean;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;

public class ExsltDatetime {
    static final String dt = "yyyy-MM-dd'T'HH:mm:ss";
    static final String d = "yyyy-MM-dd";
    static final String gym = "yyyy-MM";
    static final String gy = "yyyy";
    static final String gmd = "MM-dd";
    static final String gm = "MM";
    static final String gd = "dd";
    static final String t = "HH:mm:ss";

    private static String formatDigits(int n2) {
        String string = String.valueOf(Math.abs(n2));
        return string.length() == 1 ? '0' + string : string;
    }

    private static int getZoneStart(String string) {
        if (string.indexOf("Z") == string.length() - 1) {
            return string.indexOf("Z");
        }
        if (string.lastIndexOf("-") == string.length() - 6 && string.charAt(string.length() - 3) == ':' || string.indexOf("+") == string.length() - 6) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm");
                simpleDateFormat.setLenient(false);
                Date date = simpleDateFormat.parse(string.substring(string.length() - 5));
                return string.length() - 6;
            }
            catch (ParseException parseException) {
                System.out.println("ParseException " + parseException.getErrorOffset());
                return -2;
            }
        }
        return -1;
    }

    public static XBoolean leapYear() {
        Calendar calendar = Calendar.getInstance();
        int n2 = calendar.get(1);
        return new XBoolean(n2 % 400 == 0 || n2 % 100 != 0 && n2 % 4 == 0);
    }

    public static XNumber dayInMonth() {
        Calendar calendar = Calendar.getInstance();
        return new XNumber(calendar.get(5));
    }

    public static XNumber dayInWeek() {
        Calendar calendar = Calendar.getInstance();
        return new XNumber(calendar.get(7));
    }

    public static XNumber dayInYear() {
        Calendar calendar = Calendar.getInstance();
        return new XNumber(calendar.get(6));
    }

    public static XNumber dayOfWeekInMonth() {
        Calendar calendar = Calendar.getInstance();
        return new XNumber(calendar.get(8));
    }

    public static XNumber hourInDay() {
        Calendar calendar = Calendar.getInstance();
        return new XNumber(calendar.get(11));
    }

    public static XNumber minuteInHour() {
        Calendar calendar = Calendar.getInstance();
        return new XNumber(calendar.get(12));
    }

    public static XNumber monthInYear() {
        Calendar calendar = Calendar.getInstance();
        return new XNumber(calendar.get(2));
    }

    public static XNumber secondInMinute() {
        Calendar calendar = Calendar.getInstance();
        return new XNumber(calendar.get(13));
    }

    public static XNumber weekInYear() {
        Calendar calendar = Calendar.getInstance();
        return new XNumber(calendar.get(3));
    }

    public static XNumber year() {
        Calendar calendar = Calendar.getInstance();
        return new XNumber(calendar.get(1));
    }

    public static XString date() {
        String string = ExsltDatetime.dateTime().toString();
        String string2 = string.substring(0, string.indexOf("T"));
        String string3 = string.substring(ExsltDatetime.getZoneStart(string));
        return new XString(string2 + string3);
    }

    public static XString dateTime() {
        Calendar calendar = Calendar.getInstance();
        Date date = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dt);
        StringBuffer stringBuffer = new StringBuffer(simpleDateFormat.format(date));
        int n2 = calendar.get(15) + calendar.get(16);
        if (n2 == 0) {
            stringBuffer.append("Z");
        } else {
            int n3 = n2 / 3600000;
            int n4 = n2 % 3600000;
            char c2 = n3 < 0 ? (char)'-' : '+';
            stringBuffer.append(c2 + ExsltDatetime.formatDigits(n3) + ':' + ExsltDatetime.formatDigits(n4));
        }
        return new XString(stringBuffer.toString());
    }

    public static XString dayAbbreviation() {
        String string = "EEE";
        return new XString(ExsltDatetime.getNameOrAbbrev(string));
    }

    public static XString dayName() {
        String string = "EEEE";
        return new XString(ExsltDatetime.getNameOrAbbrev(string));
    }

    public static XString monthAbbreviation() {
        String string = "MMM";
        return new XString(ExsltDatetime.getNameOrAbbrev(string));
    }

    public static XString monthName() {
        Calendar calendar = Calendar.getInstance();
        String string = "MMMM";
        return new XString(ExsltDatetime.getNameOrAbbrev(string));
    }

    public static XString time() {
        String string = ExsltDatetime.dateTime().toString();
        String string2 = string.substring(string.indexOf("T") + 1);
        String string3 = string.substring(ExsltDatetime.getZoneStart(string));
        return new XString(string2 + string3);
    }

    private static String getNameOrAbbrev(String string) {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return simpleDateFormat.format(calendar.getTime());
    }

    private static String[] getEraDatetimeZone(String string) {
        int n2;
        String string2 = "";
        String string3 = string;
        String string4 = "";
        if (string.charAt(0) == '-') {
            string2 = "-";
            string3 = string.substring(1);
        }
        if ((n2 = ExsltDatetime.getZoneStart(string3)) > 0) {
            string4 = string3.substring(n2);
            string3 = string3.substring(0, n2);
        } else if (n2 == -2) {
            string4 = null;
        }
        return new String[]{string2, string3, string4};
    }

    private static double getNumber(String string, String[] stringArray, int n2) throws ParseException {
        Calendar calendar = Calendar.getInstance();
        calendar.setLenient(false);
        Date date = ExsltDatetime.testFormats(string, stringArray);
        if (date == null) {
            return Double.NaN;
        }
        calendar.setTime(date);
        return calendar.get(n2);
    }

    public static XNumber dayInMonth(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        String[] stringArray2 = new String[]{dt, d, gmd, gd};
        double d2 = ExsltDatetime.getNumber(string2, stringArray2, 5);
        return new XNumber(d2);
    }

    public static XNumber dayInWeek(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, d};
        return new XNumber(ExsltDatetime.getNumber(string2, stringArray2, 7));
    }

    public static XNumber dayInYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, d};
        return new XNumber(ExsltDatetime.getNumber(string2, stringArray2, 6));
    }

    public static XNumber dayOfWeekInMonth(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, d};
        return new XNumber(ExsltDatetime.getNumber(string2, stringArray2, 8));
    }

    public static XNumber hourInDay(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{d, t};
        return new XNumber(ExsltDatetime.getNumber(string2, stringArray2, 11));
    }

    public static XNumber minuteInHour(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, t};
        return new XNumber(ExsltDatetime.getNumber(string2, stringArray2, 12));
    }

    public static XNumber monthInYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, d, gym};
        return new XNumber(ExsltDatetime.getNumber(string2, stringArray2, 2));
    }

    public static XNumber secondInMinute(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, t};
        return new XNumber(ExsltDatetime.getNumber(string2, stringArray2, 13));
    }

    public static XNumber weekInYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, d};
        return new XNumber(ExsltDatetime.getNumber(string2, stringArray2, 3));
    }

    public static XNumber year(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        boolean bl2 = stringArray[0].length() == 0;
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, d, gym, gy};
        double d2 = ExsltDatetime.getNumber(string2, stringArray2, 1);
        if (bl2 || d2 == Double.NaN) {
            return new XNumber(d2);
        }
        return new XNumber(-d2);
    }

    public static XObject leapYear(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XNumber(Double.NaN);
        }
        String[] stringArray2 = new String[]{dt, d, gym, gy};
        double d2 = ExsltDatetime.getNumber(string2, stringArray2, 1);
        if (d2 == Double.NaN) {
            return new XNumber(Double.NaN);
        }
        int n2 = (int)d2;
        return new XBoolean(n2 % 400 == 0 || n2 % 100 != 0 && n2 % 4 == 0);
    }

    public static XString date(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = stringArray[2];
        if (string3 == null || string4 == null) {
            return new XString("");
        }
        String[] stringArray2 = new String[]{dt, d};
        String string5 = d;
        Date date = ExsltDatetime.testFormats(string3, stringArray2);
        if (date == null) {
            return new XString("");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string5);
        simpleDateFormat.setLenient(false);
        String string6 = simpleDateFormat.format(date);
        if (string6.length() == 0) {
            return new XString("");
        }
        return new XString(string2 + string6 + string4);
    }

    public static XString dayAbbreviation(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XString("");
        }
        String[] stringArray2 = new String[]{dt, d};
        String string3 = "EEE";
        return new XString(ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3));
    }

    public static XString dayName(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XString("");
        }
        String[] stringArray2 = new String[]{dt, d};
        String string3 = "EEEE";
        return new XString(ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3));
    }

    public static XString monthAbbreviation(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XString("");
        }
        String[] stringArray2 = new String[]{dt, d, gym, gm};
        String string3 = "MMM";
        return new XString(ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3));
    }

    public static XString monthName(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        if (string2 == null) {
            return new XString("");
        }
        String[] stringArray2 = new String[]{dt, d, gym, gm};
        String string3 = "MMMM";
        return new XString(ExsltDatetime.getNameOrAbbrev(string, stringArray2, string3));
    }

    public static XString time(String string) throws ParseException {
        String[] stringArray = ExsltDatetime.getEraDatetimeZone(string);
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (string2 == null || string3 == null) {
            return new XString("");
        }
        String[] stringArray2 = new String[]{dt, d};
        String string4 = t;
        Date date = ExsltDatetime.testFormats(string2, stringArray2);
        if (date == null) {
            return new XString("");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string4);
        String string5 = simpleDateFormat.format(date);
        return new XString(string5 + string3);
    }

    private static Date testFormats(String string, String[] stringArray) throws ParseException {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i2]);
                simpleDateFormat.setLenient(false);
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
                if (parseException.getErrorOffset() >= string.length()) continue;
                return null;
            }
        }
        return null;
    }

    private static String getNameOrAbbrev(String string, String[] stringArray, String string2) throws ParseException {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(stringArray[i2]);
                simpleDateFormat.setLenient(false);
                Date date = simpleDateFormat.parse(string);
                simpleDateFormat.applyPattern(string2);
                return simpleDateFormat.format(date);
            }
            catch (ParseException parseException) {
                if (parseException.getErrorOffset() >= string.length()) continue;
                return "";
            }
        }
        return "";
    }
}

