/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AllocatedNativeObject;

abstract class AbstractPollArrayWrapper {
    static final short POLLIN = 1;
    static final short POLLOUT = 4;
    static final short POLLERR = 8;
    static final short POLLHUP = 16;
    static final short POLLNVAL = 32;
    static final short POLLREMOVE = 2048;
    static final short SIZE_POLLFD = 8;
    static final short FD_OFFSET = 0;
    static final short EVENT_OFFSET = 4;
    static final short REVENT_OFFSET = 6;
    protected AllocatedNativeObject pollArray;
    protected int totalChannels = 0;
    protected long pollArrayAddress;

    AbstractPollArrayWrapper() {
    }

    int getDescriptor(int n2) {
        int n3 = 8 * n2 + 0;
        return this.pollArray.getInt(n3);
    }

    int getEventOps(int n2) {
        int n3 = 8 * n2 + 4;
        return this.pollArray.getShort(n3);
    }

    int getReventOps(int n2) {
        int n3 = 8 * n2 + 6;
        return this.pollArray.getShort(n3);
    }

    void putDescriptor(int n2, int n3) {
        int n4 = 8 * n2 + 0;
        this.pollArray.putInt(n4, n3);
    }

    void putEventOps(int n2, int n3) {
        int n4 = 8 * n2 + 4;
        this.pollArray.putShort(n4, (short)n3);
    }

    void putReventOps(int n2, int n3) {
        int n4 = 8 * n2 + 6;
        this.pollArray.putShort(n4, (short)n3);
    }
}

