/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.runtime;

import java.security.AccessController;
import java.util.LinkedList;
import sun.rmi.runtime.Executor;
import sun.rmi.runtime.NewThreadAction;
import sun.security.action.GetLongAction;

final class ThreadPool
implements Executor {
    private static final long idleTimeout = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.jrmp.idleThreadTimeout", 300000L));
    private final ThreadGroup threadGroup;
    private final Object lock = new Object();
    private int totalThreads = 0;
    private int idleThreads = 0;
    private final LinkedList queue = new LinkedList();

    static long access$300() {
        return idleTimeout;
    }

    ThreadPool(ThreadGroup threadGroup) {
        this.threadGroup = threadGroup;
    }

    static int access$208(ThreadPool threadPool) {
        return threadPool.idleThreads++;
    }

    static int access$210(ThreadPool threadPool) {
        return threadPool.idleThreads--;
    }

    static int access$410(ThreadPool threadPool) {
        return threadPool.totalThreads--;
    }

    static Object access$000(ThreadPool threadPool) {
        return threadPool.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable runnable, String string) {
        Task task = new Task(runnable, string);
        Object object = this.lock;
        synchronized (object) {
            if (this.queue.size() < this.idleThreads) {
                this.queue.addLast(task);
                this.lock.notify();
            } else {
                Thread thread = (Thread)AccessController.doPrivileged(new NewThreadAction(this.threadGroup, new Worker(this, task), string, true));
                thread.start();
                ++this.totalThreads;
            }
        }
    }

    static LinkedList access$100(ThreadPool threadPool) {
        return threadPool.queue;
    }

    private static class Task {
        final Runnable runnable;
        final String name;

        Task(Runnable runnable, String string) {
            this.runnable = runnable;
            this.name = string;
        }
    }

    private class Worker
    implements Runnable {
        private Task first;
        private final ThreadPool this$0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Task task = this.first;
                this.first = null;
                while (true) {
                    task.runnable.run();
                    Object object = ThreadPool.access$000(this.this$0);
                    synchronized (object) {
                        if (ThreadPool.access$100(this.this$0).isEmpty()) {
                            Thread.currentThread().setName("RMI Idle");
                            ThreadPool.access$208(this.this$0);
                            try {
                                ThreadPool.access$000(this.this$0).wait(ThreadPool.access$300());
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            finally {
                                ThreadPool.access$210(this.this$0);
                            }
                            if (ThreadPool.access$100(this.this$0).isEmpty()) {
                                break;
                            }
                        }
                        task = (Task)ThreadPool.access$100(this.this$0).removeFirst();
                        Thread.currentThread().setName("RMI " + task.name);
                    }
                }
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                Object object = ThreadPool.access$000(this.this$0);
                synchronized (object) {
                    ThreadPool.access$410(this.this$0);
                }
                throw throwable;
            }
            Object object = ThreadPool.access$000(this.this$0);
            synchronized (object) {
                ThreadPool.access$410(this.this$0);
            }
        }

        Worker(ThreadPool threadPool, Task task) {
            this.this$0 = threadPool;
            this.first = task;
        }
    }
}

