/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.X509TrustManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;
import javax.net.ssl.X509TrustManager;

abstract class TrustManagerFactoryImpl
extends TrustManagerFactorySpi {
    private static final Debug a = Debug.getInstance("ssl");
    private X509TrustManager b = null;
    private boolean c = false;

    TrustManagerFactoryImpl() {
    }

    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        if (keyStore == null) {
            try {
                keyStore = TrustManagerFactoryImpl.a("trustmanager");
            }
            catch (SecurityException securityException) {
                if (a != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + securityException);
                }
            }
            catch (Error error) {
                if (a != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + error);
                }
                throw error;
            }
            catch (RuntimeException runtimeException) {
                if (a != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + runtimeException);
                }
                throw runtimeException;
            }
            catch (Exception exception) {
                if (a != null && Debug.isOn("trustmanager")) {
                    System.out.println("SunX509: skip default keystore: " + exception);
                }
                throw new KeyStoreException("problem accessing trust store" + exception);
            }
        }
        this.b = this.a(keyStore);
        this.c = true;
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("SunJSSE does not use ManagerFactoryParameters");
    }

    protected TrustManager[] engineGetTrustManagers() {
        if (!this.c) {
            throw new IllegalStateException("TrustManagerFactoryImpl is not initialized");
        }
        return new TrustManager[]{this.b};
    }

    static FileInputStream a(File file) throws Exception {
        return (FileInputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(file){
            private final File a;
            {
                this.a = file;
            }

            public Object run() throws Exception {
                try {
                    if (this.a.exists()) {
                        return new FileInputStream(this.a);
                    }
                    return null;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
            }
        });
    }

    static KeyStore a(String string) throws Exception {
        Object object;
        String string2 = null;
        File file = null;
        FileInputStream fileInputStream = null;
        HashMap hashMap = new HashMap();
        String string3 = File.separator;
        KeyStore keyStore = null;
        AccessController.doPrivileged(new PrivilegedExceptionAction(hashMap){
            private final HashMap a;

            public Object run() throws Exception {
                this.a.put("trustStore", System.getProperty("javax.net.ssl.trustStore"));
                this.a.put("javaHome", System.getProperty("java.home"));
                this.a.put("trustStoreType", System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()));
                this.a.put("trustStorePasswd", System.getProperty("javax.net.ssl.trustStorePassword", ""));
                return null;
            }
            {
                this.a = hashMap;
            }
        });
        string2 = (String)hashMap.get("trustStore");
        if (string2 != null) {
            file = new File(string2);
            fileInputStream = TrustManagerFactoryImpl.a(file);
        } else {
            object = (String)hashMap.get("javaHome");
            file = new File((String)object + string3 + "lib" + string3 + "security" + string3 + "jssecacerts");
            fileInputStream = TrustManagerFactoryImpl.a(file);
            if (fileInputStream == null) {
                file = new File((String)object + string3 + "lib" + string3 + "security" + string3 + "cacerts");
                fileInputStream = TrustManagerFactoryImpl.a(file);
            }
        }
        string2 = fileInputStream != null ? file.getPath() : "No File Available, using empty keystore.";
        String string4 = (String)hashMap.get("trustStoreType");
        if (a != null && Debug.isOn(string)) {
            System.out.println("trustStore is: " + string2);
            System.out.println("trustStore type is : " + string4);
        }
        if (string4.length() != 0) {
            if (a != null && Debug.isOn(string)) {
                System.out.println("init truststore");
            }
            keyStore = KeyStore.getInstance(string4);
            object = null;
            String string5 = (String)hashMap.get("trustStorePasswd");
            if (string5.length() != 0) {
                object = string5.toCharArray();
            }
            keyStore.load(fileInputStream, (char[])object);
            if (object != null) {
                for (int i = 0; i < ((Object)object).length; ++i) {
                    object[i] = false;
                }
            }
        }
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        return keyStore;
    }

    abstract X509TrustManager a(KeyStore var1) throws KeyStoreException;

    public static final class PKIXFactory
    extends TrustManagerFactoryImpl {
        X509TrustManager a(KeyStore keyStore) throws KeyStoreException {
            return new X509TrustManagerImpl("PKIX", keyStore);
        }
    }

    public static final class SimpleFactory
    extends TrustManagerFactoryImpl {
        X509TrustManager a(KeyStore keyStore) throws KeyStoreException {
            return new X509TrustManagerImpl("Simple", keyStore);
        }
    }
}

