/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.Debug;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.X509TrustManager;
import sun.security.validator.KeyStores;
import sun.security.validator.PKIXValidator;
import sun.security.validator.Validator;

final class X509TrustManagerImpl
implements X509TrustManager {
    private static final boolean a = Debug.a("com.sun.net.ssl.checkRevocation", false);
    private final String b;
    private final Set c;
    private volatile Validator d;
    private volatile Validator e;
    private static final Debug f = Debug.getInstance("ssl");

    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[this.c.size()];
        this.c.toArray(x509CertificateArray);
        return x509CertificateArray;
    }

    private void a(Validator validator) {
        if (validator instanceof PKIXValidator) {
            PKIXValidator pKIXValidator = (PKIXValidator)validator;
            pKIXValidator.getParameters().setRevocationEnabled(a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        Validator validator = this.d;
        if (validator == null) {
            x509CertificateArray2 = this;
            // MONITORENTER : this
            if (validator == null) {
                validator = Validator.getInstance(this.b, "tls client", this.c);
                super.a(validator);
                this.d = validator;
            }
            // MONITOREXIT : x509CertificateArray2
        }
        x509CertificateArray2 = validator.validate(x509CertificateArray);
        if (f == null) return;
        if (!Debug.isOn("trustmanager")) return;
        System.out.println("Found trusted certificate:");
        System.out.println(x509CertificateArray2[x509CertificateArray2.length - 1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
        X509Certificate[] x509CertificateArray2;
        Validator validator = this.e;
        if (validator == null) {
            x509CertificateArray2 = this;
            // MONITORENTER : this
            if (validator == null) {
                validator = Validator.getInstance(this.b, "tls server", this.c);
                super.a(validator);
                this.e = validator;
            }
            // MONITOREXIT : x509CertificateArray2
        }
        x509CertificateArray2 = validator.validate(x509CertificateArray, null, string);
        if (f == null) return;
        if (!Debug.isOn("trustmanager")) return;
        System.out.println("Found trusted certificate:");
        System.out.println(x509CertificateArray2[x509CertificateArray2.length - 1]);
    }

    X509TrustManagerImpl(String string, KeyStore keyStore) throws KeyStoreException {
        this.b = string;
        this.c = keyStore == null ? Collections.EMPTY_SET : KeyStores.getTrustedCerts((KeyStore)keyStore);
        if (f != null && Debug.isOn("trustmanager")) {
            Iterator iterator = this.c.iterator();
            while (iterator.hasNext()) {
                System.out.println("adding as trusted cert:");
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                System.out.println("  Subject: " + x509Certificate.getSubjectX500Principal());
                System.out.println("  Issuer:  " + x509Certificate.getIssuerX500Principal());
                System.out.println("  Algorithm: " + x509Certificate.getPublicKey().getAlgorithm() + "; Serial number: 0x" + x509Certificate.getSerialNumber().toString(16));
                System.out.println("  Valid from " + x509Certificate.getNotBefore() + " until " + x509Certificate.getNotAfter());
                System.out.println();
            }
        }
    }
}

