/*
 * Decompiled with CFR 0.152.
 */
package gdtel.ui.graf;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Geometria {
    public static boolean intersects(Point2D puntoIni, Point2D puntoFin, Point puntoAEvaluar, int nUmbral) {
        boolean delimitado = false;
        double numerador = 0.0;
        double distancia = 0.0;
        double denominador = 1.0;
        Point aux1 = new Point();
        Point aux2 = new Point();
        aux1.x = (int)Math.abs(puntoAEvaluar.getX() - puntoFin.getX());
        aux1.y = (int)Math.abs(puntoAEvaluar.getY() - puntoFin.getY());
        aux2.x = (int)Math.abs(puntoAEvaluar.getX() - puntoIni.getX());
        aux2.y = (int)Math.abs(puntoAEvaluar.getY() - puntoIni.getY());
        denominador = Math.abs(aux1.x * aux2.y - aux2.x * aux1.y);
        aux1.x = (int)Math.pow(puntoIni.getX() - puntoFin.getX(), 2.0);
        aux1.y = (int)Math.pow(puntoIni.getY() - puntoFin.getY(), 2.0);
        numerador = Math.sqrt(aux1.x + aux1.y);
        if (numerador == 0.0) {
            return false;
        }
        distancia = denominador / numerador;
        if ((double)((int)puntoFin.getX()) >= puntoAEvaluar.getX() && puntoAEvaluar.getX() >= (double)((int)puntoIni.getX()) || puntoAEvaluar.getX() >= (double)((int)puntoFin.getX()) && (double)((int)puntoIni.getX()) >= puntoAEvaluar.getX()) {
            delimitado = puntoFin.getY() > puntoIni.getY() ? (double)((int)puntoFin.getY()) >= puntoAEvaluar.getY() && puntoAEvaluar.getY() >= (double)((int)puntoIni.getY()) : puntoAEvaluar.getY() >= (double)((int)puntoFin.getY()) && (double)((int)puntoIni.getY()) >= puntoAEvaluar.getY();
        }
        return distancia < (double)nUmbral && delimitado;
    }

    public static boolean intersects(Point2D puntoIni, Point2D puntoFin, Rectangle2D rectangulo) {
        double xAuxMax = 0.0;
        double yAuxMax = 0.0;
        double xAuxMin = 0.0;
        double yAuxMin = 0.0;
        xAuxMax = puntoIni.getX() > puntoFin.getX() ? puntoIni.getX() : puntoFin.getX();
        yAuxMax = puntoIni.getY() > puntoFin.getY() ? puntoIni.getY() : puntoFin.getY();
        xAuxMin = puntoIni.getX() < puntoFin.getX() ? puntoIni.getX() : puntoFin.getX();
        yAuxMin = puntoIni.getY() < puntoFin.getY() ? puntoIni.getY() : puntoFin.getY();
        if (xAuxMax < rectangulo.getMinX() || xAuxMin > rectangulo.getMaxX()) {
            return false;
        }
        return !(yAuxMax < rectangulo.getMinY()) && !(yAuxMin > rectangulo.getMaxY());
    }

    public static Point2D.Double intersects(Point2D.Double puntoIniSegmento1, Point2D.Double puntoFinSegmento1, Point2D.Double puntoIniSegmento2, Point2D.Double puntoFinSegmento2) {
        Point2D.Double pCorte = new Point2D.Double();
        double valorX = 0.0;
        double valorY = 0.0;
        boolean bEsHorizontal = false;
        boolean bEsVertical = false;
        if (puntoIniSegmento2.getX() == puntoFinSegmento2.getX()) {
            valorX = puntoIniSegmento2.getX();
            bEsVertical = true;
        } else {
            valorY = puntoIniSegmento2.getY();
            bEsHorizontal = true;
        }
        if (puntoIniSegmento1.getY() != puntoFinSegmento1.getY() && puntoIniSegmento1.getX() != puntoFinSegmento1.getX()) {
            double pendienteRectaTrans = (puntoFinSegmento1.getY() - puntoIniSegmento1.getY()) / (puntoFinSegmento1.getX() - puntoIniSegmento1.getX());
            double ordenadaRectaTrans = puntoIniSegmento1.getY() - pendienteRectaTrans * puntoIniSegmento1.getX();
            if (bEsHorizontal) {
                double temp = (valorY - ordenadaRectaTrans) / pendienteRectaTrans;
                pCorte.setLocation(temp, valorY);
            } else {
                double temp = pendienteRectaTrans * valorX + ordenadaRectaTrans;
                pCorte.setLocation(valorX, temp);
            }
        } else if (puntoIniSegmento1.getX() == puntoFinSegmento1.getX()) {
            if (bEsVertical) {
                pCorte = null;
            } else {
                valorX = puntoIniSegmento1.getX();
                valorY = puntoIniSegmento2.getY();
                pCorte.setLocation(valorX, valorY);
            }
        } else if (puntoIniSegmento1.getY() == puntoFinSegmento1.getY()) {
            if (bEsHorizontal) {
                pCorte = null;
            } else {
                valorX = puntoIniSegmento2.getX();
                valorY = puntoIniSegmento1.getY();
                pCorte.setLocation(valorX, valorY);
            }
        }
        return pCorte;
    }

    public static Point2D.Double puntoDeCorte(Point2D.Double pIniSegmento, Point2D.Double pFinSegmento, double margenIzquierdoRec, double margenDerechoRec, double margenSuperiorRec, double margenInferiorRec) {
        Point2D.Double puntoDestino = null;
        if (pIniSegmento == null) {
            return puntoDestino;
        }
        if (pFinSegmento == null) {
            return puntoDestino;
        }
        Point2D.Double puntoInicioSegmento = new Point2D.Double();
        Point2D.Double puntoFinSegmento = new Point2D.Double();
        Point2D.Double puntoCorteSup = new Point2D.Double();
        Point2D.Double puntoCorteInf = new Point2D.Double();
        Point2D.Double puntoCorteIzq = new Point2D.Double();
        Point2D.Double puntoCorteDer = new Point2D.Double();
        Point2D.Double[] arrPuntosCorte = new Point2D.Double[4];
        int indice = 0;
        puntoInicioSegmento.setLocation(margenIzquierdoRec, margenSuperiorRec);
        puntoFinSegmento.setLocation(margenDerechoRec, margenSuperiorRec);
        puntoCorteSup = Geometria.intersects(pIniSegmento, pFinSegmento, puntoInicioSegmento, puntoFinSegmento);
        if (puntoCorteSup != null && puntoCorteSup.getX() >= margenIzquierdoRec && puntoCorteSup.getX() <= margenDerechoRec) {
            arrPuntosCorte[indice] = puntoCorteSup;
            ++indice;
        }
        puntoInicioSegmento.setLocation(margenIzquierdoRec, margenInferiorRec);
        puntoFinSegmento.setLocation(margenDerechoRec, margenInferiorRec);
        puntoCorteInf = Geometria.intersects(pIniSegmento, pFinSegmento, puntoInicioSegmento, puntoFinSegmento);
        if (puntoCorteInf != null && puntoCorteInf.getX() >= margenIzquierdoRec && puntoCorteInf.getX() <= margenDerechoRec) {
            arrPuntosCorte[indice] = puntoCorteInf;
            ++indice;
        }
        puntoInicioSegmento.setLocation(margenIzquierdoRec, margenInferiorRec);
        puntoFinSegmento.setLocation(margenIzquierdoRec, margenSuperiorRec);
        puntoCorteIzq = Geometria.intersects(pIniSegmento, pFinSegmento, puntoInicioSegmento, puntoFinSegmento);
        if (puntoCorteIzq != null && puntoCorteIzq.getY() <= margenInferiorRec && puntoCorteIzq.getY() >= margenSuperiorRec) {
            arrPuntosCorte[indice] = puntoCorteIzq;
            ++indice;
        }
        puntoInicioSegmento.setLocation(margenDerechoRec, margenInferiorRec);
        puntoFinSegmento.setLocation(margenDerechoRec, margenSuperiorRec);
        puntoCorteDer = Geometria.intersects(pIniSegmento, pFinSegmento, puntoInicioSegmento, puntoFinSegmento);
        if (puntoCorteDer != null && puntoCorteDer.getY() <= margenInferiorRec && puntoCorteDer.getY() >= margenSuperiorRec) {
            arrPuntosCorte[indice] = puntoCorteDer;
            ++indice;
        }
        if (arrPuntosCorte[0] != null) {
            double disMenor = Point2D.distance(arrPuntosCorte[0].getX(), arrPuntosCorte[0].getY(), pIniSegmento.getX(), pIniSegmento.getY());
            puntoDestino = arrPuntosCorte[0];
            for (int i = 1; i < indice; ++i) {
                double disAux = Point2D.distance(arrPuntosCorte[i].getX(), arrPuntosCorte[i].getY(), pIniSegmento.getX(), pIniSegmento.getY());
                if (!(disAux < disMenor)) continue;
                disMenor = disAux;
                puntoDestino = arrPuntosCorte[i];
            }
        }
        return puntoDestino;
    }
}

