/*
 * Decompiled with CFR 0.152.
 */
package gdtel.ui.piccolo;

import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PDragEventHandler;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.event.PPanEventHandler;
import edu.umd.cs.piccolo.event.PZoomEventHandler;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import edu.umd.cs.piccolox.event.PZoomToEventHandler;
import gdtel.ui.piccolo.AccionPCanvas;
import modela.ui.piccolo.handlers.PSelectionEventHandlerEx;
import modela.ui.piccolo.handlers.PZoomVentanaEventHandler;

public class PCanvasEx
extends PCanvas {
    private static final long serialVersionUID = -8718895972241092791L;
    protected AccionPCanvas nAccion;
    protected PPanEventHandler panEvent;
    protected PSelectionEventHandler selEvent;
    protected PZoomEventHandler zoomEvent;
    protected PZoomVentanaEventHandler zoomVentanaEvent;
    protected PZoomToEventHandler zoomToEvent;
    protected PDragEventHandler dragEvent;
    protected PSelectionEventHandlerEx selectionEventHandler;

    public PCanvasEx() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.inicializarCanvas();
    }

    public void inicializarCanvas() {
        this.nAccion = AccionPCanvas.SIN_ACCION;
        this.removeInputEventListener((PInputEventListener)this.getPanEventHandler());
        this.removeInputEventListener((PInputEventListener)this.getZoomEventHandler());
        this.panEvent = null;
        this.selEvent = null;
        this.zoomEvent = null;
        this.zoomVentanaEvent = null;
        this.dragEvent = null;
        this.selectionEventHandler = null;
        this.controlarEvent(this.nAccion);
        this.getCamera().setTransparency(0.5f);
    }

    public boolean controlarEvent(AccionPCanvas pAccion) {
        if (this.zoomEvent != null) {
            this.removeInputEventListener((PInputEventListener)this.zoomEvent);
            this.zoomEvent = null;
        }
        if (this.zoomVentanaEvent != null) {
            this.removeInputEventListener((PInputEventListener)this.zoomVentanaEvent);
            this.zoomVentanaEvent = null;
        }
        if (this.panEvent != null) {
            this.removeInputEventListener((PInputEventListener)this.panEvent);
            this.panEvent = null;
        }
        if (this.selectionEventHandler != null) {
            this.removeInputEventListener((PInputEventListener)this.selectionEventHandler);
            this.getRoot().getDefaultInputManager().setKeyboardFocus(null);
            this.selectionEventHandler.unselectAll();
            this.selectionEventHandler = null;
        }
        if (pAccion == AccionPCanvas.SIN_ACCION) {
            return true;
        }
        if (pAccion == AccionPCanvas.ACCION_SEL || pAccion == AccionPCanvas.ACCION_SEL_LIMITADA) {
            this.selectionEventHandler = new PSelectionEventHandlerEx((PNode)this.getLayer(), (PNode)this.getLayer());
            this.addInputEventListener((PInputEventListener)this.selectionEventHandler);
            this.getRoot().getDefaultInputManager().setKeyboardFocus((PInputEventListener)this.selectionEventHandler);
            return true;
        }
        if (pAccion == AccionPCanvas.ACCION_ZOOM) {
            this.zoomEvent = new PZoomEventHandler();
            this.zoomEvent.setMaxScale(4.0);
            this.zoomEvent.setMinScale(0.025);
            this.zoomEvent.getEventFilter().setAndMask(16);
            this.addInputEventListener((PInputEventListener)this.zoomEvent);
            return true;
        }
        if (pAccion == AccionPCanvas.ACCION_ZOOM_VENTANA) {
            this.zoomVentanaEvent = new PZoomVentanaEventHandler((PNode)this.getLayer(), (PNode)this.getLayer(), this);
            this.addInputEventListener((PInputEventListener)this.zoomVentanaEvent);
        } else if (pAccion == AccionPCanvas.ACCION_DESPLAZAR) {
            this.panEvent = new PPanEventHandler();
            this.addInputEventListener((PInputEventListener)this.panEvent);
            return true;
        }
        return false;
    }

    public void limpiarDiagrama() {
        this.getLayer().removeAllChildren();
    }

    public PBasicInputEventHandler getSelectionEventHandler() {
        if (this.zoomEvent != null) {
            return this.zoomEvent;
        }
        if (this.panEvent != null) {
            return this.panEvent;
        }
        if (this.selectionEventHandler != null) {
            return this.selectionEventHandler;
        }
        if (this.zoomVentanaEvent != null) {
            return this.zoomVentanaEvent;
        }
        return null;
    }
}

