/*
 * Decompiled with CFR 0.152.
 */
package gdtel.ui.piccolo;

import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.swing.PScrollPane;
import gdtel.ui.piccolo.VistaReferenciaControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import modela.ui.piccolo.PCanvasModela;

public class VistaReferenciaJPanel
extends JPanel {
    private static final long serialVersionUID = -1008164080115876033L;
    private VistaReferenciaControl thumbnail;
    private PScrollPane scrollPane;
    private AdjustmentListener adjustmentListener = null;
    protected JSlider scaleBar = null;
    private JPanel panelScaleBar = null;
    private final int MINIMO_ELEMENTOS_SCALEBAR = 0;
    private final int MAXIMO_ELEMENTOS_SCALEBAR = 10;
    private final int ELEMENTO_CENTRAL_SCALEBAR = 5;
    private int valorActualScaleBar = 5;

    public VistaReferenciaJPanel(PCanvasModela aCanvas) {
        this.thumbnail = new VistaReferenciaControl(aCanvas);
        this.setLayout(new BorderLayout());
        this.panelScaleBar = new JPanel();
        this.panelScaleBar.setLayout(new BorderLayout());
        this.scaleBar = new JSlider();
        this.scaleBar.setOrientation(1);
        this.scaleBar.setMaximum(this.MAXIMO_ELEMENTOS_SCALEBAR);
        this.scaleBar.setMinimum(this.MINIMO_ELEMENTOS_SCALEBAR);
        this.scaleBar.setMinorTickSpacing(1);
        this.scaleBar.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                if (!((JSlider)evt.getSource()).getValueIsAdjusting()) {
                    VistaReferenciaJPanel.this.aplicarEscala(VistaReferenciaJPanel.this.scaleBar.getValue());
                }
            }
        });
        JLabel labelMas = new JLabel("+");
        JLabel labelMenos = new JLabel("-");
        labelMas.setHorizontalAlignment(0);
        labelMenos.setHorizontalAlignment(0);
        this.panelScaleBar.add((Component)this.scaleBar, "Center");
        this.panelScaleBar.add((Component)labelMas, "North");
        this.panelScaleBar.add((Component)labelMenos, "South");
        this.add((Component)this.panelScaleBar, "East");
        this.add(this.thumbnail.getRootPanel(), "Center");
    }

    public PScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void scrollListener(boolean bOn) {
        if (!bOn) {
            this.scrollPane.getHorizontalScrollBar().removeAdjustmentListener(this.adjustmentListener);
            this.scrollPane.getVerticalScrollBar().removeAdjustmentListener(this.adjustmentListener);
            this.adjustmentListener = null;
            return;
        }
        this.adjustmentListener = new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent evt) {
            }
        };
        this.scrollPane.getHorizontalScrollBar().addAdjustmentListener(this.adjustmentListener);
        this.scrollPane.getVerticalScrollBar().addAdjustmentListener(this.adjustmentListener);
    }

    public void aplicarExtensionTotal() {
        if (this.thumbnail.getThumbCanvas().getCamera() == null) {
            return;
        }
        PBounds boundsTotal2 = this.thumbnail.getThumbCanvas().getCamera().getUnionOfLayerFullBounds();
        this.thumbnail.getThumbCanvas().getCamera().animateViewToCenterBounds((Rectangle2D)boundsTotal2, true, 1000L);
        this.thumbnail.getThumbCanvas().repaint();
        this.scaleBar.setValue(this.ELEMENTO_CENTRAL_SCALEBAR);
        this.valorActualScaleBar = this.scaleBar.getValue();
    }

    void aplicarEscala(int nuevoValorScaleBar) {
        PBounds viewBounds = null;
        PBounds newBound = null;
        double nExtW = 0.0;
        double nExtH = 0.0;
        if (nuevoValorScaleBar == this.ELEMENTO_CENTRAL_SCALEBAR) {
            this.aplicarExtensionTotal();
            return;
        }
        int absDiferencia = Math.abs(nuevoValorScaleBar - this.valorActualScaleBar);
        if (nuevoValorScaleBar < this.valorActualScaleBar) {
            for (int a = 0; a < absDiferencia; ++a) {
                viewBounds = this.thumbnail.getThumbCanvas().getCamera().getViewBounds();
                newBound = new PBounds();
                nExtW = viewBounds.getSize().getWidth() / 4.0;
                nExtH = viewBounds.getSize().getHeight() / 4.0;
                newBound.setRect(viewBounds.getOrigin().getX() - nExtW, viewBounds.getOrigin().getY() - nExtH, viewBounds.getSize().getWidth() + 2.0 * nExtW, viewBounds.getSize().getHeight() + 2.0 * nExtH);
                if (absDiferencia == 1) {
                    this.thumbnail.getThumbCanvas().getCamera().animateViewToCenterBounds((Rectangle2D)newBound, true, 1000L);
                    continue;
                }
                this.thumbnail.getThumbCanvas().getCamera().animateViewToCenterBounds((Rectangle2D)newBound, true, 0L);
            }
        } else if (nuevoValorScaleBar > this.valorActualScaleBar) {
            for (int b = 0; b < absDiferencia; ++b) {
                viewBounds = this.thumbnail.getThumbCanvas().getCamera().getViewBounds();
                newBound = new PBounds();
                nExtW = viewBounds.getSize().getWidth() / 6.0;
                nExtH = viewBounds.getSize().getHeight() / 6.0;
                newBound.setRect(viewBounds.getCenter2D().getX() - 2.0 * nExtW, viewBounds.getCenter2D().getY() - 2.0 * nExtH, 4.0 * nExtW, 4.0 * nExtH);
                if (absDiferencia == 1) {
                    this.thumbnail.getThumbCanvas().getCamera().animateViewToCenterBounds((Rectangle2D)newBound, true, 1000L);
                    continue;
                }
                this.thumbnail.getThumbCanvas().getCamera().animateViewToCenterBounds((Rectangle2D)newBound, true, 0L);
            }
        }
        this.valorActualScaleBar = nuevoValorScaleBar;
    }
}

