/*
 * Decompiled with CFR 0.152.
 */
package gdtel.ui.swing.calendario;

import gdtel.ui.swing.calendario.ObservingTextField;
import gdtel.ui.swing.excontrols.JDialogEx;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Observable;
import java.util.Observer;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.MouseInputListener;
import modela.ui.ModelaUI;

public class DatePicker
extends Observable
implements Runnable,
WindowFocusListener {
    Observer auxOb;
    private MonthPanel monthPanel;
    private NavigatePanel navPanel;
    protected Calendar calendar;
    private Calendar selectedDate;
    private boolean closeOnSelect = true;
    private Locale locale = Locale.ITALIAN;
    private DateFormat sdf;
    private final JDialogEx screen;
    private ResourceBundle i18n;
    static /* synthetic */ Class class$gdtel$ui$swing$calendario$DatePicker;
    static /* synthetic */ Class class$modela$ui$swing$PropOrganismoProcedimientoJPanel;

    public DatePicker(Observer observer) {
        this(observer, new Date());
    }

    public DatePicker(Observer observer, Date selecteddate) {
        this(observer, selecteddate, Locale.ITALIAN);
    }

    public DatePicker(Observer observer, Locale locale) {
        this(observer, new Date(), locale);
        this.auxOb = observer;
    }

    public DatePicker(Observer observer, Date selecteddate, Locale locale) {
        this.locale = locale;
        this.register(observer);
        this.screen = new JDialogEx();
        this.screen.addWindowFocusListener(this);
        this.screen.setSize(200, 200);
        this.screen.setResizable(false);
        this.screen.setModal(true);
        JDialog.setDefaultLookAndFeelDecorated(true);
        this.screen.getRootPane().setWindowDecorationStyle(1);
        this.screen.setDefaultCloseOperation(2);
        this.screen.getContentPane().setLayout(new BorderLayout());
        this.calendar = new GregorianCalendar();
        this.setSelectedDate(selecteddate);
        Calendar c = this.calendar;
        if (this.selectedDate != null) {
            c = this.selectedDate;
        }
        this.updateScreen(c);
        this.screen.getContentPane().add((Component)this.navPanel, "North");
    }

    public void start(Component c) {
        if (c != null) {
            int x = c.getX() + c.getWidth();
            int y = c.getY() + c.getHeight();
            for (Container p = c.getParent(); p != null; p = p.getParent()) {
                x += p.getX();
                y += p.getY();
            }
            this.screen.setLocation(x, y);
        } else {
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            this.screen.setLocation((int)(dim.getWidth() - (double)this.screen.getWidth()) / 2, (int)(dim.getHeight() - (double)this.screen.getHeight()) / 2);
        }
        SwingUtilities.invokeLater(this);
    }

    public void run() {
        this.screen.pack();
        this.screen.setVisible(true);
    }

    public Date parseDate(String date) {
        if (this.sdf == null) {
            this.sdf = new SimpleDateFormat("dd/MM/yyyy");
        }
        try {
            return this.sdf.parse(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        if (this.sdf == null) {
            this.sdf = new SimpleDateFormat("dd/MM/yyyy");
        }
        return this.sdf.format(date);
    }

    public String formatDate(Date date, String pattern) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(pattern).format(date);
    }

    public String formatDate(Calendar date) {
        if (date == null) {
            return "";
        }
        return this.formatDate(date.getTime());
    }

    public String formatDate(Calendar date, String pattern) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat(pattern).format(date.getTime());
    }

    public void setLocale(Locale l) {
        this.locale = l;
    }

    public Locale getLocale() {
        return this.locale == null ? Locale.ITALIAN : this.locale;
    }

    public void register(Observer observer) {
        if (observer != null) {
            this.addObserver(observer);
        }
    }

    public void unregister(Observer observer) {
        if (observer != null) {
            this.deleteObserver(observer);
        }
    }

    private Calendar getCalendar() {
        return this.calendar;
    }

    private void setCalendar(Calendar c) {
        this.calendar = c;
    }

    public void setSelectedDate(Date d) {
        if (d != null) {
            if (this.selectedDate == null) {
                this.selectedDate = new GregorianCalendar();
            }
            this.selectedDate.setTime(d);
            this.updateScreen(this.selectedDate);
        }
    }

    protected void updateScreen(Calendar c) {
        if (this.navPanel == null) {
            this.navPanel = new NavigatePanel(this);
        }
        this.navPanel.setCurrentMonth(c);
        this.setMonthPanel(c);
        this.screen.pack();
    }

    protected void setMonthPanel(Calendar calendar) {
        if (calendar != null) {
            this.calendar.setTime(calendar.getTime());
        }
        if (this.monthPanel != null) {
            this.screen.getContentPane().remove(this.monthPanel);
        }
        this.monthPanel = new MonthPanel(this, calendar);
        this.screen.getContentPane().add((Component)this.monthPanel, "Center");
    }

    protected void dayPicked(int day) {
        this.calendar.set(5, day);
        this.setSelectedDate(this.calendar.getTime());
        this.setChanged();
        this.notifyObservers(this.selectedDate);
        if (this.closeOnSelect) {
            if (this.auxOb != null && this.auxOb instanceof ObservingTextField) {
                ((ObservingTextField)this.auxOb).setBackground(ModelaUI.colorFondoTextoModificandose);
            }
            this.screen.dispose();
            this.screen.setVisible(false);
        }
    }

    public String getString(String key, String dv) {
        String val;
        if (this.i18n == null || this.getLocale() != this.i18n.getLocale()) {
            this.i18n = ResourceBundle.getBundle("i18n", this.getLocale());
        }
        if ((val = this.i18n.getString(key)) == null) {
            return dv;
        }
        return val;
    }

    public boolean isCloseOnSelect() {
        return this.closeOnSelect;
    }

    public void windowGainedFocus(WindowEvent e) {
    }

    public void windowLostFocus(WindowEvent e) {
        this.screen.toFront();
    }

    public JDialog getScreen() {
        return this.screen;
    }

    public void setCloseOnSelect(boolean closeOnSelect) {
        this.closeOnSelect = closeOnSelect;
    }

    public static void main(String[] argv) {
        DatePicker dp = new DatePicker(null);
        dp.start(null);
    }

    public static class NavigatePanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = -4815487723470318188L;
        private final DatePicker parent;
        private final JButton premon;
        private final JButton preyear;
        private final JButton nextmon;
        private final JButton nextyear;
        private JLabel lbl;
        private JComboBox monthBox;
        private JComboBox yearBox;
        private static String[] months = null;
        private Integer[] years;
        private Box box;
        final int height = 10;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] getImage(String fileName) {
            InputStream is = null;
            try {
                is = new BufferedInputStream((class$gdtel$ui$swing$calendario$DatePicker == null ? (class$gdtel$ui$swing$calendario$DatePicker = DatePicker.class$("gdtel.ui.swing.calendario.DatePicker")) : class$gdtel$ui$swing$calendario$DatePicker).getClassLoader().getResourceAsStream(fileName));
                byte[] b = new byte[is.available()];
                is.read(b);
                byte[] byArray = b;
                return byArray;
            }
            catch (IOException e) {
                e.printStackTrace();
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException e) {}
            }
        }

        public NavigatePanel(DatePicker parent) {
            ImageIcon iconoNextYear = new ImageIcon((class$modela$ui$swing$PropOrganismoProcedimientoJPanel == null ? (class$modela$ui$swing$PropOrganismoProcedimientoJPanel = DatePicker.class$("modela.ui.swing.PropOrganismoProcedimientoJPanel")) : class$modela$ui$swing$PropOrganismoProcedimientoJPanel).getResource(ModelaUI.IMG_CALENDARIO_NEXT_YEAR));
            ImageIcon iconoNextMonth = new ImageIcon((class$modela$ui$swing$PropOrganismoProcedimientoJPanel == null ? (class$modela$ui$swing$PropOrganismoProcedimientoJPanel = DatePicker.class$("modela.ui.swing.PropOrganismoProcedimientoJPanel")) : class$modela$ui$swing$PropOrganismoProcedimientoJPanel).getResource(ModelaUI.IMG_CALENDARIO_NEXT_MONTH));
            ImageIcon iconoPrevYear = new ImageIcon((class$modela$ui$swing$PropOrganismoProcedimientoJPanel == null ? (class$modela$ui$swing$PropOrganismoProcedimientoJPanel = DatePicker.class$("modela.ui.swing.PropOrganismoProcedimientoJPanel")) : class$modela$ui$swing$PropOrganismoProcedimientoJPanel).getResource(ModelaUI.IMG_CALENDARIO_PREV_YEAR));
            ImageIcon iconoPrevMonth = new ImageIcon((class$modela$ui$swing$PropOrganismoProcedimientoJPanel == null ? (class$modela$ui$swing$PropOrganismoProcedimientoJPanel = DatePicker.class$("modela.ui.swing.PropOrganismoProcedimientoJPanel")) : class$modela$ui$swing$PropOrganismoProcedimientoJPanel).getResource(ModelaUI.IMG_CALENDARIO_PREV_MONTH));
            this.parent = parent;
            this.setLayout(new BorderLayout());
            Dimension d = new Dimension(20, 20);
            Box box = new Box(0);
            this.preyear = new JButton();
            this.preyear.setToolTipText("A\u00f1o anterior");
            this.preyear.setIcon(iconoPrevYear);
            this.preyear.addActionListener(this);
            this.preyear.setPreferredSize(d);
            box.add(this.preyear);
            box.add(Box.createHorizontalStrut(3));
            this.premon = new JButton();
            this.premon.setToolTipText("Mes anterior");
            this.premon.setIcon(iconoPrevMonth);
            this.premon.addActionListener(this);
            this.premon.setPreferredSize(d);
            box.add(this.premon);
            this.add((Component)box, "West");
            box = new Box(0);
            this.nextmon = new JButton();
            this.nextmon.setToolTipText("Mes siguiente");
            this.nextmon.setIcon(iconoNextYear);
            this.nextmon.setPreferredSize(d);
            this.nextmon.addActionListener(this);
            box.add(this.nextmon);
            box.add(Box.createHorizontalStrut(3));
            this.nextyear = new JButton();
            this.nextyear.setToolTipText("A\u00f1o siguiente");
            this.nextyear.setIcon(iconoNextMonth);
            this.nextyear.setPreferredSize(d);
            this.nextyear.addActionListener(this);
            box.add(this.nextyear);
            this.add((Component)box, "East");
            this.setCurrentMonth(parent.calendar);
        }

        public void setCurrentMonth(Calendar c) {
            this.setMonthComboBox(c);
            this.setYearComboBox(c);
            if (this.box == null) {
                this.box = new Box(0);
                this.box.add(this.monthBox);
                this.box.add(this.yearBox);
                this.add((Component)this.box, "Center");
            }
        }

        private void setMonthComboBox(Calendar c) {
            if (months == null) {
                months = new String[12];
                NavigatePanel.inicializarMeses();
            }
            if (this.monthBox == null) {
                this.monthBox = new JComboBox();
                this.monthBox.addActionListener(this);
                this.monthBox.setFont(ModelaUI.fuenteCalendarioLetrasMeses);
                this.monthBox.setSize(this.monthBox.getWidth(), this.height);
                this.monthBox.setPreferredSize(new Dimension(this.monthBox.getWidth(), this.height));
            }
            this.monthBox.setModel(new DefaultComboBoxModel<String>(months));
            this.monthBox.setSelectedIndex(c.get(2));
        }

        private void setYearComboBox(Calendar c) {
            int y = c.get(1);
            this.years = new Integer[41];
            int i = y - 20;
            int j = 0;
            while (i <= y + 20) {
                this.years[j] = new Integer(i);
                ++i;
                ++j;
            }
            if (this.yearBox == null) {
                this.yearBox = new JComboBox();
                this.yearBox.addActionListener(this);
                this.yearBox.setFont(ModelaUI.fuenteCalendarioLetrasAnios);
                this.yearBox.setSize(this.yearBox.getWidth(), this.height);
                this.yearBox.setPreferredSize(new Dimension(this.yearBox.getWidth(), this.height));
            }
            this.yearBox.setModel(new DefaultComboBoxModel<Integer>(this.years));
            this.yearBox.setSelectedItem(this.years[20]);
        }

        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            GregorianCalendar c = new GregorianCalendar();
            c.setTime(this.parent.getCalendar().getTime());
            if (src instanceof JButton) {
                if (e.getSource() == this.premon) {
                    ((Calendar)c).add(2, -1);
                } else if (e.getSource() == this.nextmon) {
                    ((Calendar)c).add(2, 1);
                } else if (e.getSource() == this.nextyear) {
                    ((Calendar)c).add(1, 1);
                }
                if (e.getSource() == this.preyear) {
                    ((Calendar)c).add(1, -1);
                }
                this.parent.updateScreen(c);
            } else if (src instanceof JComboBox) {
                JComboBox jcb = (JComboBox)src;
                if (src == this.monthBox) {
                    c.set(2, jcb.getSelectedIndex());
                } else if (e.getSource() == this.yearBox) {
                    c.set(1, this.years[jcb.getSelectedIndex()]);
                    this.setYearComboBox(c);
                }
                this.parent.setMonthPanel(c);
                this.parent.screen.pack();
            }
        }

        public static void inicializarMeses() {
            months = new String[12];
            NavigatePanel.months[0] = new String("Ene");
            NavigatePanel.months[1] = new String("Feb");
            NavigatePanel.months[2] = new String("Mar");
            NavigatePanel.months[3] = new String("Abr");
            NavigatePanel.months[4] = new String("May");
            NavigatePanel.months[5] = new String("Jun");
            NavigatePanel.months[6] = new String("Jul");
            NavigatePanel.months[7] = new String("Ago");
            NavigatePanel.months[8] = new String("Sep");
            NavigatePanel.months[9] = new String("Oct");
            NavigatePanel.months[10] = new String("Nov");
            NavigatePanel.months[11] = new String("Dic");
        }
    }

    public static class MonthPanel
    extends JPanel {
        private static final long serialVersionUID = -1710500516067179192L;
        private final DatePicker parent;

        public MonthPanel(DatePicker parent, Calendar c) {
            this.parent = parent;
            GridLayout g = new GridLayout();
            g.setColumns(7);
            g.setRows(0);
            this.setLayout(g);
            JLabel lunes = new JLabel("L");
            lunes.setFont(ModelaUI.fuenteCalendarioLetrasDias);
            lunes.setHorizontalAlignment(0);
            this.add(lunes);
            JLabel martes = new JLabel("M");
            martes.setFont(ModelaUI.fuenteCalendarioLetrasDias);
            martes.setHorizontalAlignment(0);
            this.add(martes);
            JLabel miercoles = new JLabel("X");
            miercoles.setFont(ModelaUI.fuenteCalendarioLetrasDias);
            miercoles.setHorizontalAlignment(0);
            this.add(miercoles);
            JLabel jueves = new JLabel("J");
            jueves.setFont(ModelaUI.fuenteCalendarioLetrasDias);
            jueves.setHorizontalAlignment(0);
            this.add(jueves);
            JLabel viernes = new JLabel("V");
            viernes.setFont(ModelaUI.fuenteCalendarioLetrasDias);
            viernes.setHorizontalAlignment(0);
            this.add(viernes);
            JLabel sabado = new JLabel("S");
            sabado.setFont(ModelaUI.fuenteCalendarioLetrasDias);
            sabado.setHorizontalAlignment(0);
            sabado.setForeground(Color.GRAY);
            this.add(sabado);
            JLabel domingo = new JLabel("D");
            domingo.setFont(ModelaUI.fuenteCalendarioLetrasDias);
            domingo.setHorizontalAlignment(0);
            domingo.setForeground(Color.RED);
            this.add(domingo);
            this.setDaysOfMonth(c);
            this.setPreferredSize(new Dimension(200, 120));
        }

        private void setDaysOfMonth(Calendar c) {
            GregorianCalendar curr = new GregorianCalendar();
            int currdate = curr.get(5);
            int currmon = curr.get(2);
            int curryear = curr.get(1);
            int seldate = -1;
            int selmon = -1;
            int selyear = -1;
            if (this.parent.selectedDate != null) {
                seldate = this.parent.selectedDate.get(5);
                selmon = this.parent.selectedDate.get(2);
                selyear = this.parent.selectedDate.get(1);
            }
            int date = c.get(5);
            int mon = c.get(2);
            int year = c.get(1);
            int day = c.get(7) - 1;
            int start = (7 - (date - day) % 7) % 7;
            int days = c.getActualMaximum(5);
            for (int i = 0; i < start; ++i) {
                JLabel lbl = new JLabel("");
                this.add(lbl);
            }
            int pos = start;
            for (int i = 1; i <= days; ++i) {
                ++pos;
                DayLabel lbl = new DayLabel(this.parent, i);
                if (seldate == i && selmon == mon && selyear == year) {
                    lbl.setSelectedDayStyle();
                }
                if (currdate == i && currmon == mon && curryear == year) {
                    lbl.setCurrentDayStyle();
                }
                if (pos % 7 == 6 || pos % 7 == 0) {
                    lbl.setWeekendStyle();
                }
                this.add(lbl);
            }
        }
    }

    public static class DayLabel
    extends JLabel
    implements MouseInputListener,
    MouseMotionListener {
        private static final long serialVersionUID = -4464604617619981588L;
        private final DatePicker parent;
        private Border oldBorder;
        private Font oldFont;

        public DayLabel(DatePicker parent, int day) {
            super(Integer.toString(day));
            this.parent = parent;
            this.setHorizontalAlignment(0);
            this.setFont(ModelaUI.fuenteCalendarioDiasNormales);
            this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            this.addMouseListener(this);
        }

        public void setCurrentDayStyle() {
            this.setFont(ModelaUI.fuenteCalendarioDiaActual);
            this.setForeground(Color.BLUE);
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        }

        public void setSelectedDayStyle() {
            this.setFont(ModelaUI.fuenteCalendarioDiasNormales);
            this.setForeground(Color.BLACK);
        }

        public void setWeekendStyle() {
            this.setFont(ModelaUI.fuenteCalendarioDiasNormales);
            this.setForeground(Color.GRAY);
        }

        public void mouseClicked(MouseEvent e) {
            this.parent.dayPicked(Integer.parseInt(this.getText()));
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
            this.oldBorder = this.getBorder();
            this.oldFont = this.getFont();
            Border b = BorderFactory.createBevelBorder(1);
            b = BorderFactory.createEtchedBorder();
            this.setBorder(b);
            this.setCursor(new Cursor(12));
            this.setFont(this.oldFont.deriveFont(16.0f));
        }

        public void mouseExited(MouseEvent e) {
            this.setBorder(this.oldBorder);
            this.setFont(this.oldFont);
            this.setCursor(new Cursor(0));
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }
    }
}

