/*
 * Decompiled with CFR 0.152.
 */
package gdtel.ui.swing.excontrols;

import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class JListBase
extends JList {
    private static final long serialVersionUID = -6011910053640993288L;
    protected DefaultListModel model;
    protected ArrayList listaElementos;
    protected JScrollPane scrollPane;

    public JListBase() {
        this.jbInit();
    }

    private void jbInit() {
        this.setSize(new Dimension(128, 155));
        this.model = new DefaultListModel();
        this.setModel(this.model);
        this.setSelectionMode(0);
        this.addListeners();
    }

    private void addListeners() {
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                JListBase.this.ensureIndexIsVisible(JListBase.this.getSelectedIndex());
            }
        });
    }

    public boolean addItem(Object objetoToAdd) {
        if (objetoToAdd == null) {
            return false;
        }
        this.model.addElement(objetoToAdd);
        return true;
    }

    public boolean addArrayDatos(ArrayList datos) {
        if (datos == null) {
            return false;
        }
        for (int j = 0; j < datos.size(); ++j) {
            this.model.addElement(datos.get(j));
        }
        return true;
    }

    public boolean removeItem(int index) {
        if (index < 0 || index >= this.model.size()) {
            return false;
        }
        this.model.removeElementAt(index);
        return true;
    }

    public boolean removeItem(Object objetoToDel) {
        if (objetoToDel == null) {
            return false;
        }
        return this.model.removeElement(objetoToDel);
    }

    public void removeAllItems() {
        if (this.getModel().getSize() > 0) {
            this.model.removeAllElements();
        }
    }

    public Object getElementAt(int i) {
        return this.model.elementAt(i);
    }

    public ArrayList toArrayList() {
        ArrayList arr = new ArrayList();
        for (int i = 0; i < this.model.getSize(); ++i) {
            arr.add(this.model.getElementAt(i));
        }
        return arr;
    }

    public JScrollPane getScrollableArea() {
        JScrollPane scroll = new JScrollPane(this);
        return scroll;
    }

    public int getNumItems() {
        return this.model.size();
    }

    public void ordenarAZ() {
        ArrayList arrAsinables = this.toArrayList();
        Object aux = this.getSelectedValue();
        Collections.sort(arrAsinables);
        this.removeAllItems();
        this.addArrayDatos(arrAsinables);
        if (aux != null) {
            this.setSelectedValue(aux, true);
        }
    }
}

