/*
 * Decompiled with CFR 0.152.
 */
package gdtel.ui.swing.excontrols;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PlainDocumentEx
extends PlainDocument {
    private static final long serialVersionUID = -8704028604608214724L;
    public static final String LOWERCASE = " abcdefghijklmn\u00f1opqrstuvwxyz1234567890\u00e1\u00e9\u00ed\u00f3\u00fa!\u00a1\"$%&/()=?\u00bf'|@#~><{}[]*/+-.:,;._\\\u00aa\u00ba\n\u00e0\u00e7\u00e8\u00ec\u00ef\u00f2\u00f9\u00fc\u00b7";
    public static final String UPPERCASE = " ABCDEFGHIJKLMN\u00d1OPQRSTUVWXYZ1234567890\u00c1\u00c9\u00cd\u00d3\u00da\u00a1!\"$%&/()=?\u00bf'|@#~><{}[]*/-+.:,;._\\\u00aa\u00ba\n\u00c0\u00c8\u00c7\u00cc\u00cf\u00d2\u00d9\u00dc\u00b7";
    public static final String ALPHA = " abcdefghijklmn\u00f1opqrstuvwxyz1234567890\u00e1\u00e9\u00ed\u00f3\u00fa!\u00a1\"$%&/()=?\u00bf'|@#~><{}[]*/+-.:,;._\\\u00aa\u00ba\n\u00e0\u00e7\u00e8\u00ec\u00ef\u00f2\u00f9\u00fc\u00b7 ABCDEFGHIJKLMN\u00d1OPQRSTUVWXYZ1234567890\u00c1\u00c9\u00cd\u00d3\u00da\u00a1!\"$%&/()=?\u00bf'|@#~><{}[]*/-+.:,;._\\\u00aa\u00ba\n\u00c0\u00c8\u00c7\u00cc\u00cf\u00d2\u00d9\u00dc\u00b7";
    public static final String NUMERIC = "0123456789";
    public static final String FLOAT = "0123456789.";
    public static final String ALPHA_NUMERIC = " abcdefghijklmn\u00f1opqrstuvwxyz1234567890\u00e1\u00e9\u00ed\u00f3\u00fa!\u00a1\"$%&/()=?\u00bf'|@#~><{}[]*/+-.:,;._\\\u00aa\u00ba\n\u00e0\u00e7\u00e8\u00ec\u00ef\u00f2\u00f9\u00fc\u00b7 ABCDEFGHIJKLMN\u00d1OPQRSTUVWXYZ1234567890\u00c1\u00c9\u00cd\u00d3\u00da\u00a1!\"$%&/()=?\u00bf'|@#~><{}[]*/-+.:,;._\\\u00aa\u00ba\n\u00c0\u00c8\u00c7\u00cc\u00cf\u00d2\u00d9\u00dc\u00b70123456789";
    protected String acceptedChars = null;
    protected boolean negativeAccepted = false;

    public PlainDocumentEx() {
        this(ALPHA_NUMERIC);
    }

    public PlainDocumentEx(String acceptedchars) {
        this.acceptedChars = acceptedchars;
    }

    public void setNegativeAccepted(boolean negativeaccepted) {
        if (this.acceptedChars.equals(NUMERIC) || this.acceptedChars.equals(FLOAT) || this.acceptedChars.equals(ALPHA_NUMERIC)) {
            this.negativeAccepted = negativeaccepted;
            this.acceptedChars = this.acceptedChars + "-";
        }
    }

    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        if (this.acceptedChars.equals(UPPERCASE)) {
            str = str.toUpperCase();
        } else if (this.acceptedChars.equals(LOWERCASE)) {
            str = str.toLowerCase();
        }
        for (int i = 0; i < str.length(); ++i) {
            if (this.acceptedChars.indexOf(String.valueOf(str.charAt(i))) != -1) continue;
            return;
        }
        if ((this.acceptedChars.equals(FLOAT) || this.acceptedChars.equals("0123456789.-") && this.negativeAccepted) && str.indexOf(".") != -1 && this.getText(0, this.getLength()).indexOf(".") != -1) {
            return;
        }
        if (this.negativeAccepted && str.indexOf("-") != -1 && (str.indexOf("-") != 0 || offset != 0)) {
            return;
        }
        super.insertString(offset, str, attr);
    }
}

