/*
 * Decompiled with CFR 0.152.
 */
package modela.bd;

import modela.bd.obj.ConjuntoDatosSistema;
import modela.bd.obj.TrSistema;

public class RepositorioModela {
    private static RepositorioModela instanciaRepositorio = null;
    public static String SISTEMA_GENERAL = "TREW@";
    protected static ConjuntoDatosSistema trSistemasDefinidos;
    protected static TrSistema trSistemaGeneral;

    public static RepositorioModela obtenerRepositorio() {
        if (instanciaRepositorio == null) {
            instanciaRepositorio = new RepositorioModela();
            TrSistema sistemaNuevo = new TrSistema(SISTEMA_GENERAL, "Repositorio general de Model@");
            instanciaRepositorio.setTrSistemaGeneral(sistemaNuevo);
        }
        return instanciaRepositorio;
    }

    public static void limpiarRepositorio() {
        if (trSistemasDefinidos != null && trSistemasDefinidos.getListaDatos() != null) {
            TrSistema sistemaAux = null;
            for (int s = 0; s < trSistemasDefinidos.getListaDatos().size(); ++s) {
                sistemaAux = (TrSistema)trSistemasDefinidos.getListaDatos().get(s);
                if (sistemaAux == null) continue;
                sistemaAux.limpiar();
                sistemaAux = null;
            }
            trSistemasDefinidos = null;
            trSistemasDefinidos = new ConjuntoDatosSistema();
            if (trSistemaGeneral != null) {
                trSistemaGeneral.limpiar();
            }
            trSistemaGeneral = null;
        }
    }

    private RepositorioModela() {
        trSistemasDefinidos = new ConjuntoDatosSistema();
        trSistemaGeneral = null;
    }

    TrSistema obtenerSistema(String nombreSistema) {
        return trSistemasDefinidos.contains(nombreSistema);
    }

    public TrSistema addSistema(String sSistemaNuevo) {
        TrSistema sistemaNuevo = trSistemasDefinidos.obtenerSistema(sSistemaNuevo, "");
        if (trSistemasDefinidos.contains(sSistemaNuevo) == null) {
            trSistemasDefinidos.add(sistemaNuevo);
            sistemaNuevo.setSistemaGeneral(this.getTrSistemaGeneral());
        }
        return sistemaNuevo;
    }

    public TrSistema addSistema(TrSistema sistemaNuevo) {
        if (sistemaNuevo == null) {
            return null;
        }
        TrSistema sistemaCreado = trSistemasDefinidos.obtenerSistema(sistemaNuevo.getIDENTIFICATIVO(), sistemaNuevo.getDESCRIPCION());
        if (trSistemasDefinidos.contains(sistemaCreado.getIDENTIFICATIVO()) == null) {
            trSistemasDefinidos.add(sistemaCreado);
            sistemaCreado.setSistemaGeneral(this.getTrSistemaGeneral());
        }
        return sistemaCreado;
    }

    protected void setTrSistemaGeneral(TrSistema trSistemaGeneral) {
        RepositorioModela.trSistemaGeneral = trSistemaGeneral;
    }

    public TrSistema getTrSistemaGeneral() {
        return trSistemaGeneral;
    }
}

