/*
 * Decompiled with CFR 0.152.
 */
package modela.bd.obj;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.util.GeneradorID;
import java.math.BigDecimal;
import modela.bd.obj.TrOrganismo;
import modela.bd.obj.TrTipoCategoria;
import modela.graf.Referencia;

public class TrTipoEvol
extends Referencia
implements Cloneable,
IAsignable {
    private String D_DESCRIPCION = null;
    private String C_ABREVIATURA = null;
    private String SISTEMA = null;
    private BigDecimal X_TIEV;
    protected ConjuntoDatos PlantillasProcInvolucradas = new ConjuntoDatos();
    protected ConjuntoDatos FichaProcedimientoInvolucradas = new ConjuntoDatos();
    protected ConjuntoDatos normativasProcedimiento = new ConjuntoDatos();
    protected ConjuntoDatos plazosCompuestosProcedimiento = new ConjuntoDatos();
    protected ConjuntoDatos organismosProcedimientoInvolucrados = new ConjuntoDatos();
    private String L_INFORMAR = "N";
    private String L_VIGENTE = "S";
    private TrTipoCategoria V_CATEGORIA;
    private String T_DESCRIPCION_AMP = null;
    private TrOrganismo UORG_X_UROG = null;
    private TrOrganismo UORG_X_UROG_COMP = null;
    private TrOrganismo UORG_X_UROG_RES = null;
    private TrOrganismo UORG_X_UROG_TRAM = null;
    private String motorTramita = null;
    private String comentarios = null;
    private BigDecimal idOrganoCarga = null;
    private BigDecimal idOrganoCompetenteCarga = null;
    private BigDecimal idOrganoResuelveCarga = null;
    private BigDecimal idOrganoTramitaCarga = null;
    private String familia = null;
    private String descripcionFamilia = null;
    private String subfamilia = null;
    private String descripcionSubfamilia = null;
    private TrTipoEvol procedimientoPadre = null;
    private ConjuntoDatos procedimientosHijos = null;

    public TrTipoEvol() {
        this.X_TIEV = BigDecimal.valueOf(GeneradorID.getID());
        this.V_CATEGORIA = TrTipoCategoria.PROCEDIMIENTO;
        this.PlantillasProcInvolucradas = new ConjuntoDatos();
        this.FichaProcedimientoInvolucradas = new ConjuntoDatos();
        this.organismosProcedimientoInvolucrados = new ConjuntoDatos();
        this.normativasProcedimiento = new ConjuntoDatos();
        this.plazosCompuestosProcedimiento = new ConjuntoDatos();
    }

    public String getDESCRIPCION() {
        return this.D_DESCRIPCION;
    }

    public void setDESCRIPCION(String _D_DESCRIPCION) {
        this.D_DESCRIPCION = _D_DESCRIPCION;
    }

    public String getABREVIATURA() {
        return this.C_ABREVIATURA;
    }

    public void setABREVIATURA(String _C_ABREVIATURA) {
        this.C_ABREVIATURA = _C_ABREVIATURA;
    }

    public BigDecimal getTIEVID() {
        return this.X_TIEV;
    }

    public void setTIEVID(BigDecimal _X_TIEV) {
        this.X_TIEV = _X_TIEV;
    }

    public double getID() {
        if (this.getTIEVID() == null) {
            return 0.0;
        }
        return this.getTIEVID().doubleValue();
    }

    public String getClave() {
        return String.valueOf(this.getTIEVID());
    }

    public String getNombre() {
        return this.getABREVIATURA();
    }

    public String getDescripcion() {
        return this.getDESCRIPCION();
    }

    public void setSISTEMA(String pSistema) {
        this.SISTEMA = pSistema;
    }

    public String getSISTEMA() {
        return this.SISTEMA;
    }

    public String toString() {
        return this.getABREVIATURA();
    }

    public Object clone() {
        Object obj = null;
        try {
            obj = super.clone();
        }
        catch (CloneNotSupportedException ex) {
            ex.printStackTrace();
        }
        return obj;
    }

    public boolean equals(TrTipoEvol tipoEvol) {
        if (tipoEvol == null) {
            return false;
        }
        if (tipoEvol.getTIEVID().compareTo(this.getTIEVID()) != 0) {
            return false;
        }
        if (!tipoEvol.getNombre().equals(this.getNombre())) {
            return false;
        }
        if (!tipoEvol.getDescripcion().equals(this.getDescripcion())) {
            return false;
        }
        if (!tipoEvol.getABREVIATURA().equals(this.getABREVIATURA())) {
            return false;
        }
        return tipoEvol.getSISTEMA().equals(this.getSISTEMA());
    }

    public void setPlantillasProcInvolucradas(ConjuntoDatos nuevasPlantillasProc) {
        this.PlantillasProcInvolucradas = nuevasPlantillasProc;
    }

    public ConjuntoDatos getPlantillasProcInvolucradas() {
        return this.PlantillasProcInvolucradas;
    }

    public void setFichaProcedimientoInvolucradas(ConjuntoDatos nuevasFichaProcedimiento) {
        this.FichaProcedimientoInvolucradas = nuevasFichaProcedimiento;
    }

    public ConjuntoDatos getFichaProcedimientoInvolucradas() {
        return this.FichaProcedimientoInvolucradas;
    }

    public void setOrganismosProcedimientoInvolucrados(ConjuntoDatos nuevosOrganismosInvolucrados) {
        this.organismosProcedimientoInvolucrados = nuevosOrganismosInvolucrados;
    }

    public ConjuntoDatos getOrganismosProcedimientoInvolucrados() {
        return this.organismosProcedimientoInvolucrados;
    }

    public void setNormativasProcInvolucradas(ConjuntoDatos nuevasNormativasProc) {
        this.normativasProcedimiento = nuevasNormativasProc;
    }

    public ConjuntoDatos getNormativasProcedimiento() {
        return this.normativasProcedimiento;
    }

    public void setPlazosCompuestosProcedimientoInvolucrados(ConjuntoDatos nuevasPlazosCompuestosProcedimiento) {
        this.plazosCompuestosProcedimiento = nuevasPlazosCompuestosProcedimiento;
    }

    public ConjuntoDatos getPlazosCompuestosProcedimiento() {
        return this.plazosCompuestosProcedimiento;
    }

    public void setDESCRIPCION_AMP(String T_DESCRIPCION_AMP) {
        this.T_DESCRIPCION_AMP = T_DESCRIPCION_AMP;
    }

    public String getDESCRIPCION_AMP() {
        return this.T_DESCRIPCION_AMP;
    }

    public void setINFORMAR(String L_INFORMAR) {
        this.L_INFORMAR = L_INFORMAR;
    }

    public void setINFORMAR(boolean bInformar) {
        this.L_INFORMAR = bInformar ? "S" : "N";
    }

    public String getINFORMAR() {
        return this.L_INFORMAR;
    }

    public boolean isInformar() {
        return this.L_INFORMAR.compareTo("S") == 0;
    }

    public void setVIGENTE(String L_VIGENTE) {
        this.L_VIGENTE = L_VIGENTE;
    }

    public void setVIGENTE(boolean bVigente) {
        this.L_VIGENTE = bVigente ? "S" : "N";
    }

    public String getVIGENTE() {
        return this.L_VIGENTE;
    }

    public boolean isVigente() {
        return this.L_VIGENTE.compareTo("S") == 0;
    }

    public void setCATEGORIA(TrTipoCategoria V_CATEGORIA) {
        this.V_CATEGORIA = V_CATEGORIA;
    }

    public TrTipoCategoria getCATEGORIA() {
        return this.V_CATEGORIA;
    }

    public void setUORG_X_UROG(TrOrganismo UORG_X_UROG) {
        this.UORG_X_UROG = UORG_X_UROG;
    }

    public TrOrganismo getUORG_X_UROG() {
        return this.UORG_X_UROG;
    }

    public void setUORG_X_UROG_COMP(TrOrganismo UORG_X_UROG_COMP) {
        this.UORG_X_UROG_COMP = UORG_X_UROG_COMP;
    }

    public TrOrganismo getUORG_X_UROG_COMP() {
        return this.UORG_X_UROG_COMP;
    }

    public void setUORG_X_UROG_RES(TrOrganismo UORG_X_UROG_RES) {
        this.UORG_X_UROG_RES = UORG_X_UROG_RES;
    }

    public TrOrganismo getUORG_X_UROG_RES() {
        return this.UORG_X_UROG_RES;
    }

    public void setUORG_X_UROG_TRAM(TrOrganismo UORG_X_UROG_TRAM) {
        this.UORG_X_UROG_TRAM = UORG_X_UROG_TRAM;
    }

    public TrOrganismo getUORG_X_UROG_TRAM() {
        return this.UORG_X_UROG_TRAM;
    }

    public void setProcedimientoPadre(TrTipoEvol padre) {
        if (this.procedimientoPadre != null) {
            this.procedimientoPadre.eliminarProcedimientoHijo(this);
        }
        this.procedimientoPadre = padre;
        this.procedimientoPadre.addProcedimientoHijo(this);
    }

    public TrTipoEvol getProcedimientoPadre() {
        return this.procedimientoPadre;
    }

    public void addProcedimientoHijo(TrTipoEvol nuevoHijo) {
        if (this.procedimientosHijos == null) {
            this.procedimientosHijos = new ConjuntoDatos();
        }
        if (this.procedimientosHijos.contains(nuevoHijo)) {
            return;
        }
        this.procedimientosHijos.add(nuevoHijo);
        nuevoHijo.setProcedimientoPadre(this);
    }

    public void eliminarProcedimientoHijo(TrTipoEvol nuevoHijo) {
        if (this.procedimientosHijos == null) {
            return;
        }
        this.procedimientosHijos.remove(nuevoHijo);
        nuevoHijo.setProcedimientoPadre(null);
    }

    public void eliminarHijos() {
        if (this.procedimientosHijos == null) {
            return;
        }
        this.procedimientosHijos.removeAllElements();
    }

    public ConjuntoDatos getProcedimientosHijos() {
        return this.procedimientosHijos;
    }

    public void setFamilia(String familia) {
        this.familia = familia;
    }

    public String getFamilia() {
        return this.familia;
    }

    public void setDescripcionFamilia(String descripcionFamilia) {
        this.descripcionFamilia = descripcionFamilia;
    }

    public String getDescripcionFamilia() {
        return this.descripcionFamilia;
    }

    public void setSubfamilia(String subfamilia) {
        this.subfamilia = subfamilia;
    }

    public String getSubfamilia() {
        return this.subfamilia;
    }

    public void setDescripcionSubfamilia(String descripcionSubfamilia) {
        this.descripcionSubfamilia = descripcionSubfamilia;
    }

    public String getDescripcionSubfamilia() {
        return this.descripcionSubfamilia;
    }

    public boolean actualizarFamiliaSubfamilia() {
        if (this.procedimientoPadre == null) {
            return false;
        }
        this.familia = null;
        this.descripcionFamilia = null;
        this.subfamilia = null;
        this.descripcionSubfamilia = null;
        if (this.procedimientoPadre.getCATEGORIA() == TrTipoCategoria.SUBFAMILIA) {
            this.subfamilia = this.procedimientoPadre.getABREVIATURA();
            this.descripcionSubfamilia = this.procedimientoPadre.getDESCRIPCION();
        }
        if (this.procedimientoPadre.getCATEGORIA() == TrTipoCategoria.FAMILIA) {
            this.familia = this.procedimientoPadre.getABREVIATURA();
            this.descripcionFamilia = this.procedimientoPadre.getDESCRIPCION();
        }
        TrTipoEvol procCandidatoFamilia = this.procedimientoPadre;
        for (TrTipoEvol procRecorrido = this.procedimientoPadre.getProcedimientoPadre(); procRecorrido != null; procRecorrido = procRecorrido.getProcedimientoPadre()) {
            procCandidatoFamilia = procRecorrido;
        }
        if (procCandidatoFamilia.getCATEGORIA() == TrTipoCategoria.FAMILIA) {
            this.familia = procCandidatoFamilia.getABREVIATURA();
            this.descripcionFamilia = procCandidatoFamilia.getDESCRIPCION();
        }
        return true;
    }

    public boolean actualizarFamiliaSubfamiliaPadre(TrTipoEvol padre) {
        this.familia = null;
        this.descripcionFamilia = null;
        this.subfamilia = null;
        this.descripcionSubfamilia = null;
        if (padre == null) {
            return false;
        }
        if (padre.getCATEGORIA() == TrTipoCategoria.SUBFAMILIA) {
            this.subfamilia = padre.getABREVIATURA();
            this.descripcionSubfamilia = padre.getDESCRIPCION();
        }
        if (padre.getCATEGORIA() == TrTipoCategoria.FAMILIA) {
            this.familia = padre.getABREVIATURA();
            this.descripcionFamilia = padre.getDESCRIPCION();
        }
        TrTipoEvol procCandidatoFamilia = padre;
        for (TrTipoEvol procRecorrido = padre.getProcedimientoPadre(); procRecorrido != null; procRecorrido = procRecorrido.getProcedimientoPadre()) {
            procCandidatoFamilia = procRecorrido;
        }
        if (procCandidatoFamilia.getCATEGORIA() == TrTipoCategoria.FAMILIA) {
            this.familia = procCandidatoFamilia.getABREVIATURA();
            this.descripcionFamilia = procCandidatoFamilia.getDESCRIPCION();
        }
        return true;
    }

    public void setMotorTramita(String nuevoMotor) {
        this.motorTramita = nuevoMotor;
    }

    public String getMotorTramita() {
        return this.motorTramita;
    }

    public void setIdOrganoCarga(BigDecimal id) {
        this.idOrganoCarga = id;
    }

    public BigDecimal getIdOrganoCarga() {
        return this.idOrganoCarga;
    }

    public void setIdOrganoCompetenteCarga(BigDecimal id) {
        this.idOrganoCompetenteCarga = id;
    }

    public BigDecimal getIdOrganoCompetenteCarga() {
        return this.idOrganoCompetenteCarga;
    }

    public void setIdOrganoResuelveCarga(BigDecimal id) {
        this.idOrganoResuelveCarga = id;
    }

    public BigDecimal getIdOrganoResuelveCarga() {
        return this.idOrganoResuelveCarga;
    }

    public void setIdOrganoTramitaCarga(BigDecimal id) {
        this.idOrganoTramitaCarga = id;
    }

    public BigDecimal getIdOrganoTramitaCarga() {
        return this.idOrganoTramitaCarga;
    }

    public void setComentarios(String comentarios) {
        this.comentarios = comentarios;
    }

    public String getComentarios() {
        return this.comentarios;
    }
}

