/*
 * Decompiled with CFR 0.152.
 */
package modela.bean.ui.swing;

import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JTreePanelEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import modela.bd.obj.TrExpediente;
import modela.bd.obj.TrExpedienteEnFase;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrTareaExpediente;
import modela.bean.ui.swing.renderers.HistoricoTreeRenderer;
import modela.ui.ModelaUI;
import modela.ui.swing.VisorEtiquetaValorJPanel;

public class HistoricoEvolucionFaseJDialog
extends JDialog
implements ContainerListener,
KeyListener {
    private static final long serialVersionUID = 406577204081027012L;
    ImageIcon cerrarIconN = new ImageIcon(HistoricoEvolucionFaseJDialog.class.getResource(ModelaUI.IMG_MTTO_CERRAR));
    ImageIcon cerrarIconS = new ImageIcon(HistoricoEvolucionFaseJDialog.class.getResource(ModelaUI.IMG_MTTO_CERRAR_SOBRE));
    JButton cerrarButton = (JButton)CreadorButton.crearBoton(1, false, this.cerrarIconN, this.cerrarIconN, this.cerrarIconS, this.cerrarIconS);
    JLabel tituloLabel = new JLabel();
    JLabel subTitulo1Label = new JLabel();
    JLabel subTitulo2Label = new JLabel();
    JTreePanelEx treeHistorial = null;
    VisorEtiquetaValorJPanel panelValores = null;
    TrExpediente expediente = null;

    public HistoricoEvolucionFaseJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.prepararDisenio();
        this.addListeners();
        this.limpiarListaElementos();
        this.treeHistorial.getTree().setCellRenderer(new HistoricoTreeRenderer());
        this.expediente = null;
    }

    private void prepararDisenio() {
        this.setSize(new Dimension(650, 580));
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Hist\u00f3rico de pasos por la fase");
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new XYLayout());
        this.tituloLabel.setText("Hist\u00f3rico de pasos por la fase...");
        this.tituloLabel.setFont(ModelaUI.fuentePrincipalNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.subTitulo1Label.setText("Descripci\u00f3n de la fase...");
        this.subTitulo1Label.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.subTitulo1Label.setForeground(ModelaUI.colorSeleccion);
        this.subTitulo2Label.setText("Metafase...");
        this.subTitulo2Label.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.subTitulo2Label.setForeground(ModelaUI.colorSeleccion);
        this.treeHistorial = new JTreePanelEx();
        this.treeHistorial.getTree().setRootVisible(false);
        this.panelValores = new VisorEtiquetaValorJPanel();
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 10, 650, 25));
        this.getContentPane().add((Component)this.subTitulo1Label, new XYConstraints(20, 30, 650, 25));
        this.getContentPane().add((Component)this.subTitulo2Label, new XYConstraints(20, 50, 650, 25));
        this.getContentPane().add((Component)this.treeHistorial, new XYConstraints(20, 70, 610, 130));
        this.getContentPane().add((Component)this.panelValores, new XYConstraints(20, 210, 610, 295));
        this.getContentPane().add((Component)this.cerrarButton, new XYConstraints(515, 515, 120, 30));
    }

    private void addListeners() {
        this.cerrarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HistoricoEvolucionFaseJDialog.this.cerrar();
            }
        });
        this.treeHistorial.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                HistoricoEvolucionFaseJDialog.this.mostrarAtributosElemento(e);
            }
        });
        this.addKeyAndContainerListenerRecursively(this);
    }

    public void limpiarListaElementos() {
        this.treeHistorial.clear();
    }

    protected void cerrar() {
        this.dispose();
    }

    public void contraerArbol() {
        for (int r = 0; r < this.treeHistorial.getTree().getRowCount(); ++r) {
            this.treeHistorial.getTree().collapseRow(r);
        }
        if (this.treeHistorial.getTree().getRowCount() > 0) {
            this.treeHistorial.getTree().setSelectionRow(0);
        }
    }

    public void setExpediente(TrExpediente exp) {
        this.expediente = exp;
    }

    public void cargarHistoriaFase(TrFase fase) {
        if (fase == null) {
            return;
        }
        this.tituloLabel.setText("Hist\u00f3rico de pasos por la fase " + fase.getNOMBRE());
        if (fase.getDESCRIPCION() != null) {
            this.subTitulo1Label.setText("Descripci\u00f3n de la fase: " + fase.getDESCRIPCION());
        }
        if (fase.getMETAFASE() != null) {
            this.subTitulo2Label.setText("Metafase: " + fase.getMETAFASE().getNOMBRE());
        }
        if (this.expediente == null) {
            return;
        }
        ArrayList arrEvolucionFase = this.expediente.obtenerExpedientesEnFaseDe(fase);
        if (arrEvolucionFase == null || arrEvolucionFase.size() < 1) {
            return;
        }
        DefaultMutableTreeNode rootRaiz = null;
        rootRaiz = this.treeHistorial.addObject(null, fase, true);
        TrExpedienteEnFase expedienteFaseActual = null;
        DefaultMutableTreeNode itemNuevo = null;
        for (int n = 0; n < arrEvolucionFase.size(); ++n) {
            expedienteFaseActual = (TrExpedienteEnFase)arrEvolucionFase.get(n);
            itemNuevo = this.treeHistorial.addObject(rootRaiz, expedienteFaseActual, true);
            if (fase.getTIPOEVOL() != null) {
                this.montarHijos(itemNuevo, expedienteFaseActual);
            }
            this.montarTareas(itemNuevo, expedienteFaseActual);
        }
        this.contraerArbol();
    }

    private void montarHijos(DefaultMutableTreeNode itemPadre, TrExpedienteEnFase expFasePadre) {
        TrFase faseTemp = null;
        ArrayList arrHijos = this.expediente.obtenerHijosExpFase(expFasePadre);
        DefaultMutableTreeNode itemNuevo = null;
        TrExpedienteEnFase expedienteFaseActualHijo = null;
        for (int h = 0; h < arrHijos.size(); ++h) {
            expedienteFaseActualHijo = (TrExpedienteEnFase)arrHijos.get(h);
            itemNuevo = this.treeHistorial.addObject(itemPadre, expedienteFaseActualHijo, true);
            faseTemp = expedienteFaseActualHijo.getFase();
            if (faseTemp != null && faseTemp.getTIPOEVOL() != null) {
                this.montarHijos(itemNuevo, expedienteFaseActualHijo);
            }
            this.montarTareas(itemNuevo, expedienteFaseActualHijo);
        }
    }

    private void montarTareas(DefaultMutableTreeNode rootExpedienteEnFase, TrExpedienteEnFase expedienteFaseActual) {
        TrTareaExpediente tareaExpedienteActual = null;
        for (int t = 0; t < expedienteFaseActual.getTareasExpediente().size(); ++t) {
            tareaExpedienteActual = (TrTareaExpediente)expedienteFaseActual.getTareasExpediente().get(t);
            this.treeHistorial.addObject(rootExpedienteEnFase, tareaExpedienteActual, true);
        }
    }

    void mostrarAtributosElemento(TreeSelectionEvent e) {
        TreePath pathActual = e.getPath();
        this.panelValores.limpiarAtributos();
        this.panelValores.setTitulo("Ficha");
        if (((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject() instanceof TrExpedienteEnFase) {
            TrExpedienteEnFase elementoSeleccionado = (TrExpedienteEnFase)((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject();
            if (elementoSeleccionado.getFECHA_FINALIZACION() == null) {
                this.panelValores.setTitulo("Desde " + elementoSeleccionado.getFECHA_COMIENZO().toString() + " --> Sin finalizar");
            } else {
                this.panelValores.setTitulo("Desde " + elementoSeleccionado.getFECHA_COMIENZO().toString() + " --> " + elementoSeleccionado.getFECHA_FINALIZACION().toString());
            }
            this.panelValores.mostrarAtributos(elementoSeleccionado);
        } else if (((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject() instanceof TrTareaExpediente) {
            TrTareaExpediente elementoSeleccionado = (TrTareaExpediente)((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject();
            if (elementoSeleccionado.getFechaFinalizacion() == null) {
                this.panelValores.setTitulo("Desde " + elementoSeleccionado.getFechaComienzo().toString() + " --> Sin finalizar");
            } else {
                this.panelValores.setTitulo("Desde " + elementoSeleccionado.getFechaComienzo().toString() + " --> " + elementoSeleccionado.getFechaFinalizacion().toString());
            }
            this.panelValores.mostrarAtributos(elementoSeleccionado);
        }
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.dispose();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

