/*
 * Decompiled with CFR 0.152.
 */
package modela.bean.ui.swing.renderers;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import modela.bd.obj.TrExpedienteEnFase;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrTareaExpediente;
import modela.bd.obj.TrTipoTarea;
import modela.ui.ModelaUI;

public class HistoricoTreeRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -2250930860990535602L;
    ImageIcon faseAbierto = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_FASE_OPEN));
    ImageIcon faseCerrado = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_FASE_CLOSED));
    ImageIcon expedienteFaseAbierto = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_EXP_FASE_OPEN));
    ImageIcon expedienteFaseCerrado = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_EXP_FASE_CLOSED));
    ImageIcon tareaIncorporar = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_TAREA_INCORPORAR));
    ImageIcon tareaGenerar = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_TAREA_GENERAR));
    ImageIcon tareaManipular = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_TAREA_MANIPULAR));
    ImageIcon tareaOtros = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_TAREA_OTROS));
    ImageIcon tareaDescartada = null;
    ImageIcon tareaIniciada = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_TAREA_INICIADA));
    ImageIcon tareaFinalizada = null;

    public HistoricoTreeRenderer() {
        this.tareaDescartada = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_TAREA_DESCARTADA));
        this.tareaFinalizada = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_HISTORICO_TAREA_FINALIZADA));
    }

    public Component getTreeCellRendererComponent(JTree arbol, Object valor, boolean seleccionado, boolean expandido, boolean rama, int fila, boolean conFoco) {
        JLabel label = (JLabel)super.getTreeCellRendererComponent(arbol, valor, seleccionado, expandido, rama, fila, conFoco);
        DefaultMutableTreeNode nodo = (DefaultMutableTreeNode)valor;
        Object clase = nodo.getUserObject();
        if (clase instanceof TrFase) {
            if (!expandido) {
                label.setIcon(this.faseCerrado);
            } else {
                label.setIcon(this.faseAbierto);
            }
        } else if (clase instanceof TrExpedienteEnFase) {
            if (!expandido) {
                label.setIcon(this.expedienteFaseCerrado);
            } else {
                label.setIcon(this.expedienteFaseAbierto);
            }
        } else if (clase instanceof TrTareaExpediente && ((TrTareaExpediente)clase).getTipoTarea() != null) {
            if (((TrTareaExpediente)clase).getTipoTarea().equals(TrTipoTarea.INCORPORAR_DOCUMENTO.toString())) {
                label.setIcon(this.tareaIncorporar);
            } else if (((TrTareaExpediente)clase).getTipoTarea().equals(TrTipoTarea.MANIPULAR_DATOS.toString())) {
                label.setIcon(this.tareaManipular);
            } else if (((TrTareaExpediente)clase).getTipoTarea().equals(TrTipoTarea.GENERAR_DOCUMENTO.toString())) {
                label.setIcon(this.tareaGenerar);
            } else if (((TrTareaExpediente)clase).getTipoTarea().equals(TrTipoTarea.OTROS.toString())) {
                label.setIcon(this.tareaOtros);
            }
        }
        return label;
    }
}

