/*
 * Decompiled with CFR 0.152.
 */
package modela.graf;

import java.util.ArrayList;
import modela.bd.obj.TrFase;
import modela.graf.DDPGrafico;

public class CalculaEstadisticas {
    DDPGrafico diagramaAsociado;

    public CalculaEstadisticas(DDPGrafico pDiagrama) {
        this.diagramaAsociado = pDiagrama;
    }

    public int getNumTotalTareasEnFaseDefProc() {
        int nTotalTareas = 0;
        try {
            ArrayList listaReutilizables = new ArrayList();
            if (this.diagramaAsociado.getDDPPadre() == null) {
                listaReutilizables = this.diagramaAsociado.getListaDDPs();
                nTotalTareas = this.diagramaAsociado.getTareaFaseDefProcInvolucradas().obtenerNumRegistros();
            } else {
                listaReutilizables = this.diagramaAsociado.getDDPPadre().getListaDDPs();
                nTotalTareas = this.diagramaAsociado.getDDPPadre().getTareaFaseDefProcInvolucradas().obtenerNumRegistros();
            }
            DDPGrafico graficoAux = null;
            for (int n = 0; n < listaReutilizables.size(); ++n) {
                graficoAux = (DDPGrafico)listaReutilizables.get(n);
                nTotalTareas += graficoAux.getTareaFaseDefProcInvolucradas().obtenerNumRegistros();
            }
        }
        catch (Exception e) {
            System.out.println("\u00b7 [ Error ] Obteniendo el n\u00famero de tareas en fase totales.");
        }
        return nTotalTareas;
    }

    public ArrayList getArrTotalTrTareaEnFaseDefProc(TrFase faseBusca) {
        ArrayList arrTareasTotal = new ArrayList();
        ArrayList arrAuxTareasPorDDP = new ArrayList();
        try {
            ArrayList listaReutilizables = new ArrayList();
            if (this.diagramaAsociado.getDDPPadre() == null) {
                listaReutilizables = this.diagramaAsociado.getListaDDPs();
                arrAuxTareasPorDDP = this.diagramaAsociado.getTareasEnFaseDefProc(faseBusca).getListaDatos();
            } else {
                listaReutilizables = this.diagramaAsociado.getDDPPadre().getListaDDPs();
                arrAuxTareasPorDDP = this.diagramaAsociado.getDDPPadre().getTareasEnFaseDefProc(faseBusca).getListaDatos();
            }
            for (int n = 0; arrAuxTareasPorDDP != null && n < arrAuxTareasPorDDP.size(); ++n) {
                arrTareasTotal.add(arrAuxTareasPorDDP.get(n));
            }
            DDPGrafico graficoAux = null;
            for (int n = 0; n < listaReutilizables.size(); ++n) {
                graficoAux = (DDPGrafico)listaReutilizables.get(n);
                arrAuxTareasPorDDP = graficoAux.getTareasEnFaseDefProc(faseBusca).getListaDatos();
                for (int t = 0; arrAuxTareasPorDDP != null && t < arrAuxTareasPorDDP.size(); ++t) {
                    arrTareasTotal.add(arrAuxTareasPorDDP.get(t));
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u00b7 [ Error ] Obteniendo las TareasEnFaseDefProc totales de una fase.");
        }
        return arrTareasTotal;
    }

    public int getNumTotalTransicionesDefProc() {
        int nTotalTransi = 0;
        try {
            ArrayList listaReutilizables = new ArrayList();
            if (this.diagramaAsociado.getDDPPadre() == null) {
                listaReutilizables = this.diagramaAsociado.getListaDDPs();
                nTotalTransi = this.diagramaAsociado.getTransicionesDelProcInvolucradas().obtenerNumRegistros();
            } else {
                listaReutilizables = this.diagramaAsociado.getDDPPadre().getListaDDPs();
                nTotalTransi = this.diagramaAsociado.getDDPPadre().getTransicionesDelProcInvolucradas().obtenerNumRegistros();
            }
            DDPGrafico graficoAux = null;
            for (int n = 0; n < listaReutilizables.size(); ++n) {
                graficoAux = (DDPGrafico)listaReutilizables.get(n);
                nTotalTransi += graficoAux.getTransicionesDelProcInvolucradas().obtenerNumRegistros();
            }
        }
        catch (Exception e) {
            System.out.println("\u00b7 [ Error ] Obteniendo el n\u00famero de Transiciones Def Proc.");
        }
        return nTotalTransi;
    }

    public ArrayList getArrTotalTrTareaEnFaseDefProc() {
        ArrayList arrTotal = new ArrayList();
        ArrayList arrAuxTareasPorDDP = new ArrayList();
        try {
            ArrayList listaReutilizables = new ArrayList();
            if (this.diagramaAsociado.getDDPPadre() == null) {
                listaReutilizables = this.diagramaAsociado.getListaDDPs();
                arrAuxTareasPorDDP = this.diagramaAsociado.getTareaFaseDefProcInvolucradas().getListaDatos();
            } else {
                listaReutilizables = this.diagramaAsociado.getDDPPadre().getListaDDPs();
                arrAuxTareasPorDDP = this.diagramaAsociado.getDDPPadre().getTareaFaseDefProcInvolucradas().getListaDatos();
            }
            for (int n = 0; arrAuxTareasPorDDP != null && n < arrAuxTareasPorDDP.size(); ++n) {
                arrTotal.add(arrAuxTareasPorDDP.get(n));
            }
            DDPGrafico graficoAux = null;
            for (int n = 0; n < listaReutilizables.size(); ++n) {
                graficoAux = (DDPGrafico)listaReutilizables.get(n);
                arrAuxTareasPorDDP = graficoAux.getTareaFaseDefProcInvolucradas().getListaDatos();
                for (int t = 0; arrAuxTareasPorDDP != null && t < arrAuxTareasPorDDP.size(); ++t) {
                    arrTotal.add(arrAuxTareasPorDDP.get(t));
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u00b7 [ Error ] Obteniendo el n\u00famero de Tareas en Fase Def. Proc. totales.");
        }
        return arrTotal;
    }

    public ArrayList getArrTotalTrTransicionesDefProc() {
        ArrayList arrTotal = new ArrayList();
        ArrayList arrAuxTransiPorDDP = new ArrayList();
        try {
            ArrayList listaReutilizables = new ArrayList();
            if (this.diagramaAsociado.getDDPPadre() == null) {
                listaReutilizables = this.diagramaAsociado.getListaDDPs();
                arrAuxTransiPorDDP = this.diagramaAsociado.getTransicionesDelProcInvolucradas().getListaDatos();
            } else {
                listaReutilizables = this.diagramaAsociado.getDDPPadre().getListaDDPs();
                arrAuxTransiPorDDP = this.diagramaAsociado.getDDPPadre().getTransicionesDelProcInvolucradas().getListaDatos();
            }
            for (int n = 0; arrAuxTransiPorDDP != null && n < arrAuxTransiPorDDP.size(); ++n) {
                arrTotal.add(arrAuxTransiPorDDP.get(n));
            }
            DDPGrafico graficoAux = null;
            for (int n = 0; n < listaReutilizables.size(); ++n) {
                graficoAux = (DDPGrafico)listaReutilizables.get(n);
                arrAuxTransiPorDDP = graficoAux.getTransicionesDelProcInvolucradas().getListaDatos();
                for (int t = 0; arrAuxTransiPorDDP != null && t < arrAuxTransiPorDDP.size(); ++t) {
                    arrTotal.add(arrAuxTransiPorDDP.get(t));
                }
            }
        }
        catch (Exception e) {
            System.out.println("\u00b7 [ Error ] Obteniendo el n\u00famero de Transiciones Def Proc Totales.");
        }
        return arrTotal;
    }
}

