/*
 * Decompiled with CFR 0.152.
 */
package modela.graf;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import modela.bd.ConjuntoDatosModela;
import modela.bd.obj.DefProcGr;
import modela.bd.obj.TrCabeceraSistema;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrIndicacionFicha;
import modela.bd.obj.TrNormativa;
import modela.bd.obj.TrOrganismo;
import modela.bd.obj.TrPlantillaProcedimiento;
import modela.bd.obj.TrSistema;
import modela.bd.obj.TrTipoCategoria;
import modela.bd.obj.TrTipoEvol;
import modela.bd.obj.TrTipoIndicacionFicha;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.graf.LectorXMLDefProc;
import modela.ui.piccolo.PCanvasModela;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class LectorXMLDES
extends LectorXMLDefProc {
    protected TrSistema sistemaActivo = null;
    protected TrCabeceraSistema cabeceraSistema = null;
    private boolean bObtencionSistema = false;
    private boolean bSistemaObtenido = false;
    private TrTipoEvol tipoEvolucionActivo = null;
    private TrTipoEvol tipoEvolucionTemporal = null;
    private ConjuntoDatosModela cdArbol = null;
    private int nNivelHijos = 0;
    private boolean bXMLValido = true;
    private boolean bPrimeraEtiqueta = true;
    private ArrayList arrIDsReutilizables = new ArrayList();
    private boolean bFasesAsociadasAlPrincipal = false;

    public void startDocument() {
        this.bXMLValido = true;
        this.bPrimeraEtiqueta = true;
        this.arrIDsReutilizables = new ArrayList();
        this.bFasesAsociadasAlPrincipal = false;
        System.out.println("- [ Info ] Comienza la lectura del XML de Definici\u00f3n de Entidades del Sistema...");
        if (this.grafico == null) {
            return;
        }
    }

    public void endDocument() {
        if (this.grafico != null && this.grafico.getCanvas() != null) {
            this.grafico.getCanvas().repaint();
        }
        System.out.println("- Termina la lectura del XML de Definici\u00f3n de Entidades del Sistema");
    }

    public void startElement(String uri, String localName, String qName, Attributes att) throws SAXException {
        if (this.bPrimeraEtiqueta) {
            this.bXMLValido = qName.equals("DEF_ENTIDADES_STMA");
            this.bPrimeraEtiqueta = false;
        }
        if (!this.bXMLValido) {
            return;
        }
        if (this.bObtencionSistema && this.bSistemaObtenido) {
            return;
        }
        if (qName.equals("DEF_ENTIDADES_STMA")) {
            this.crearEntidadesSistema(att);
            return;
        }
        if (qName.equals("PERFIL_USUARIO")) {
            try {
                super.crearPerfilUsuario(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PERFIL DE USUARIO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("PARAMETRO")) {
            try {
                super.crearParametro(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PAR\u00c1METROS:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("BLOQUE")) {
            try {
                super.crearBloque(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("BLOQUE:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("PARAMETRO_BLOQUE")) {
            try {
                super.addParametroBloque(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PAR\u00c1METRO DEL BLOQUE:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("TIPO_PARRAFO") || qName.equals("PARRAFO")) {
            try {
                super.crearTipoParrafo(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE P\u00c1RRAFO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("PLANTILLA")) {
            try {
                super.crearPlantilla(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PLANTILLA:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("TIPO_ACTO")) {
            try {
                super.crearTipoActo(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE ACTO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("VARIABLE")) {
            try {
                super.crearVariable(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("VARIABLE:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("PARAMETRO_VARIABLE")) {
            try {
                super.addParametroVariable(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PAR\u00c1METRO DE LA VARIABLE:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("TIPO_DOCUMENTO")) {
            try {
                super.crearTipoDocumento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE DOCUMENTO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("PARRAFO_TIPDOC")) {
            try {
                super.addParrafoTipoDocTipoDocumento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("P\u00c1RRAFO DEL TIPO DOCUMENTO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("VARIABLE_ID")) {
            try {
                super.addVariableTipoDocumento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("VARIABLE DEL TIPO DE DOCUMENTO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("CONDICION")) {
            try {
                super.crearCondicion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("CONDICI\u00d3N:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("ACCION")) {
            try {
                super.crearAccion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("ACCI\u00d3N:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("AVISO")) {
            try {
                super.crearAviso(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("AVISO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("METAFASE")) {
            try {
                super.crearMetafase(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("METAFASE:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("FASE")) {
            try {
                this.crearFase(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("FASE:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("TIPO_ORGANISMO")) {
            try {
                super.crearTipoOrganismo(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE ORGANISMO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("ORGANISMO")) {
            try {
                super.crearOrganismo(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("ORGANISMO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("TIPO_INDICACION")) {
            try {
                super.crearTipoIndicacion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE INDICACI\u00d3N:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("TIPO_NORMATIVA")) {
            try {
                super.crearTipoNormativa(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE NORMATIVA:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("TIPO_PUBLICACION")) {
            try {
                super.crearTipoPublicacion(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("TIPO DE PUBLICACI\u00d3N:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("AMBITO_LEY")) {
            try {
                super.crearAmbitoLey(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("\u00c1MBITO LEY:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("NORMATIVA")) {
            try {
                super.crearNormativa(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("NORMATIVA:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("ARBOL_FAMILIAS")) {
            this.cdArbol = new ConjuntoDatosModela();
        }
        if (qName.equals("DEF_FAMSUBPRO")) {
            try {
                if (this.nNivelHijos > 0) {
                    this.tipoEvolucionTemporal = new TrTipoEvol();
                    this.tipoEvolucionActivo.addProcedimientoHijo(this.tipoEvolucionTemporal);
                    this.tipoEvolucionActivo = this.tipoEvolucionTemporal;
                } else {
                    this.tipoEvolucionActivo = new TrTipoEvol();
                }
                this.crearTipoEvolucionEnArbol(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("DEFINICI\u00d3N DE FAMSUBPRO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("DEF_FSPHIJAS")) {
            ++this.nNivelHijos;
        }
        if (qName.equals("INDICACION_FICHA")) {
            try {
                this.crearFichaProcedimiento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("FICHA DEL PROCEDIMIENTO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("NORMATIVA_ID")) {
            try {
                this.crearNormativaDelProcedimiento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("NORMATIVA DEL PROCEDIMIENTO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("PLANTILLA_PROCEDIMIENTO")) {
            try {
                this.crearPlantillaProcedimiento(att);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("PLANTILLA DEL PROCEDIMIENTO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!this.bXMLValido) {
            return;
        }
        if (this.bObtencionSistema && this.bSistemaObtenido) {
            return;
        }
        if (qName.equals("BLOQUE")) {
            try {
                super.controlDuplicidadBloque();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/BLOQUE:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("VARIABLE")) {
            try {
                super.controlDuplicidadVariable();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/VARIABLE:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("TIPO_DOCUMENTO")) {
            try {
                super.controlDuplicidadTipoDocumento();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new SAXException("/TIPO DE DOCUMENTO:\nError durante el proceso de importaci\u00f3n");
            }
            return;
        }
        if (qName.equals("METAFASE")) {
            this.metafaseActiva = null;
            return;
        }
        if (qName.equals("FASE")) {
            this.faseActiva = null;
            return;
        }
        if (qName.equals("ORGANISMOS")) {
            super.asociarOrganismosPadre();
            return;
        }
        if (qName.equals("ARBOL_FAMILIAS")) {
            this.grafico.setArbolTiposEvolucion(this.cdArbol);
        }
        if (qName.equals("DEF_FAMSUBPRO")) {
            this.comprobarEvolucionAsociadaAFase();
            if (this.tipoEvolucionActivo.getProcedimientoPadre() != null) {
                this.tipoEvolucionActivo = this.tipoEvolucionActivo.getProcedimientoPadre();
            } else {
                this.cdArbol.add(this.tipoEvolucionActivo);
                this.tipoEvolucionActivo = new TrTipoEvol();
            }
        }
        if (qName.equals("DEF_FSPHIJAS")) {
            --this.nNivelHijos;
        }
    }

    public void warning(SAXParseException e) throws SAXException {
        System.out.println("\u00b7 [ Alerta ] " + e.getMessage());
        this.bProcesoFallido = true;
    }

    public void error(SAXParseException e) throws SAXException {
        System.out.println("- [ Error ] Durante la lectura del XML de Definici\u00f3n de Entidades del Sistema");
        this.bProcesoFallido = true;
        throw new SAXException(e.getMessage());
    }

    public void fatalError(SAXParseException e) throws SAXException {
        System.out.println("- [ Error ] Durante la lectura del XML de Definici\u00f3n de Entidades del Sistema: ");
        System.out.println("- Linea: " + this.locator.getLineNumber());
        System.out.println("- Columna: " + this.locator.getColumnNumber());
        System.out.println("- PublicID: " + this.locator.getPublicId());
        System.out.println("- SystemID: " + this.locator.getSystemId());
        System.out.println(e.getMessage());
        this.bProcesoFallido = true;
        throw new SAXException(e.getMessage());
    }

    public boolean leerArchivo(File openFile) {
        if (openFile == null) {
            return false;
        }
        if (this.grafico == null) {
            return false;
        }
        ModelaConf.setRutaArchivo(openFile.getParent());
        this.grafico.setIncoherente(false);
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            saxParser.parse(openFile, (DefaultHandler)this);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
            ex.printStackTrace();
            return false;
        }
        if (!this.bXMLValido) {
            JOptionPane.showMessageDialog(null, "El fichero seleccionado no es v\u00e1lido:\nLa definici\u00f3n de entidades del sistema no est\u00e1 bien formada.", "Fichero no v\u00e1lido", 2);
            return false;
        }
        if (this.bFasesAsociadasAlPrincipal) {
            JOptionPane.showMessageDialog(null, "Se encontraron fases que utilizan el procedimiento principal como reutilizable asociado:\nEstas fases perder\u00e1n tal asociaci\u00f3n.", "Atenci\u00f3n", 2);
        }
        return true;
    }

    public boolean isFicheroValido() {
        return this.bXMLValido;
    }

    public TrCabeceraSistema obtenerSistema(File openFile) {
        if (openFile == null) {
            return null;
        }
        SAXParserFactory saxFactory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = saxFactory.newSAXParser();
            this.bObtencionSistema = true;
            saxParser.parse(openFile, (DefaultHandler)this);
            this.bObtencionSistema = false;
            this.bSistemaObtenido = false;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.bObtencionSistema = false;
            this.bSistemaObtenido = false;
            return null;
        }
        return this.cabeceraSistema;
    }

    public boolean crearEntidadesSistema(Attributes att) {
        if (att.getLength() < 1) {
            return false;
        }
        this.cabeceraSistema = new TrCabeceraSistema();
        if (att.getValue("sistema") != null) {
            this.cabeceraSistema.setSistema(att.getValue("sistema"));
            if (this.bObtencionSistema) {
                this.bSistemaObtenido = true;
            }
        } else {
            return false;
        }
        if (att.getValue("motor_tramita") != null) {
            this.cabeceraSistema.setMotorTramitacion(att.getValue("motor_tramita"));
        }
        if (att.getValue("version") != null) {
            this.cabeceraSistema.setVersion(att.getValue("version"));
            String strVersion = this.cabeceraSistema.getVersion();
            strVersion = strVersion.replace('.', '-');
            strVersion = strVersion.replaceAll("-", "");
            int nVersionTmp = Integer.parseInt(strVersion);
            if (nVersionTmp < 100) {
                // empty if block
            }
            if (nVersionTmp >= 100) {
                // empty if block
            }
        }
        if (att.getValue("fecha_generacion") != null) {
            this.cabeceraSistema.setFechaGeneracion(att.getValue("fecha_generacion"));
        }
        return true;
    }

    public boolean crearFase(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        this.faseActiva = new TrFase();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            this.faseActiva.setFASEID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.faseActiva.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.faseActiva.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("orden") != null) {
            this.faseActiva.setORDEN(new Integer(att.getValue("orden")));
        }
        if (att.getValue("defproc_r_id") != null) {
            BigDecimal idReutilizable = new BigDecimal(att.getValue("defproc_r_id"));
            boolean idEnLista = false;
            for (int n = 0; n < this.arrIDsReutilizables.size(); ++n) {
                if (((BigDecimal)this.arrIDsReutilizables.get(n)).longValue() != idReutilizable.longValue()) continue;
                idEnLista = true;
            }
            if (!idEnLista) {
                this.arrIDsReutilizables.add(idReutilizable);
            }
            this.faseActiva.setIdEvolucionCarga(idReutilizable);
        }
        boolean bLogico = false;
        String sLogico = "N";
        if (att.getValue("informar") != null) {
            sLogico = att.getValue("informar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.faseActiva.setINFORMAR(bLogico);
        if (att.getValue("texto_aux") != null) {
            this.faseActiva.setTextoAuxiliar(att.getValue("texto_aux"));
        }
        this.faseActiva.setMETAFASE(this.metafaseActiva);
        this.controlDuplicidadFase();
        return true;
    }

    public boolean crearTipoEvolucionEnArbol(Attributes att) throws Exception {
        TrOrganismo organismoAux;
        BigDecimal idOrg;
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        if (att.getValue("id") == null) {
            return false;
        }
        String strId = att.getValue("id");
        this.tipoEvolucionActivo.setTIEVID(new BigDecimal(strId));
        if (att.getValue("nombre") == null) {
            return false;
        }
        this.tipoEvolucionActivo.setABREVIATURA(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        this.tipoEvolucionActivo.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("sistema") == null) {
            return false;
        }
        this.tipoEvolucionActivo.setSISTEMA(att.getValue("sistema"));
        if (att.getValue("organo") != null) {
            idOrg = new BigDecimal(att.getValue("organo"));
            organismoAux = null;
            if (this.grafico.getOrganismosInvolucradosEnCarga() != null && (organismoAux = this.grafico.getOrganismosInvolucradosEnCarga().obtenerOrganismoDeOrganismosEnCarga(idOrg)) != null) {
                this.tipoEvolucionActivo.setUORG_X_UROG(organismoAux);
            }
        }
        if (att.getValue("organo_competente") != null) {
            idOrg = new BigDecimal(att.getValue("organo_competente"));
            organismoAux = null;
            if (this.grafico.getOrganismosInvolucradosEnCarga() != null && (organismoAux = this.grafico.getOrganismosInvolucradosEnCarga().obtenerOrganismoDeOrganismosEnCarga(idOrg)) != null) {
                this.tipoEvolucionActivo.setUORG_X_UROG_COMP(organismoAux);
            }
        }
        if (att.getValue("organo_resuelve") != null) {
            idOrg = new BigDecimal(att.getValue("organo_resuelve"));
            organismoAux = null;
            if (this.grafico.getOrganismosInvolucradosEnCarga() != null && (organismoAux = this.grafico.getOrganismosInvolucradosEnCarga().obtenerOrganismoDeOrganismosEnCarga(idOrg)) != null) {
                this.tipoEvolucionActivo.setUORG_X_UROG_RES(organismoAux);
            }
        }
        if (att.getValue("organo_tramita") != null) {
            idOrg = new BigDecimal(att.getValue("organo_tramita"));
            organismoAux = null;
            if (this.grafico.getOrganismosInvolucradosEnCarga() != null && (organismoAux = this.grafico.getOrganismosInvolucradosEnCarga().obtenerOrganismoDeOrganismosEnCarga(idOrg)) != null) {
                this.tipoEvolucionActivo.setUORG_X_UROG_TRAM(organismoAux);
            }
        }
        if (att.getValue("motor_tramita") != null) {
            this.tipoEvolucionActivo.setMotorTramita(att.getValue("motor_tramita"));
        }
        boolean bLogico = false;
        String sLogico = "N";
        if (att.getValue("informar") != null) {
            sLogico = att.getValue("informar");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoEvolucionActivo.setINFORMAR(bLogico);
        if (att.getValue("descrip_ampliada") != null) {
            this.tipoEvolucionActivo.setDESCRIPCION_AMP(att.getValue("descrip_ampliada"));
        }
        sLogico = "N";
        if (att.getValue("vigente") != null) {
            sLogico = att.getValue("vigente");
        }
        if (sLogico.equals("S")) {
            bLogico = true;
        } else if (sLogico.equals("N")) {
            bLogico = false;
        }
        this.tipoEvolucionActivo.setVIGENTE(bLogico);
        if (att.getValue("categoria") != null) {
            this.tipoEvolucionActivo.setCATEGORIA(TrTipoCategoria.obtenerTipoCategoria(att.getValue("categoria")));
        }
        if (att.getValue("familia") != null) {
            this.tipoEvolucionActivo.setFamilia(att.getValue("familia"));
        }
        if (att.getValue("desc_familia") != null) {
            this.tipoEvolucionActivo.setDescripcionFamilia(att.getValue("desc_familia"));
        }
        if (att.getValue("subfamilia") != null) {
            this.tipoEvolucionActivo.setSubfamilia(att.getValue("subfamilia"));
        }
        if (att.getValue("desc_subfamilia") != null) {
            this.tipoEvolucionActivo.setDescripcionSubfamilia(att.getValue("desc_subfamilia"));
        }
        if (att.getValue("comentarios") != null) {
            this.tipoEvolucionActivo.setComentarios(att.getValue("comentarios"));
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean crearFichaProcedimiento(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        TrIndicacionFicha indicacionFichaActiva = new TrIndicacionFicha();
        if (att.getValue("id") == null) {
            return false;
        }
        String strId = att.getValue("id");
        indicacionFichaActiva.setINFIID(new BigDecimal(strId));
        if (att.getValue("tipo_indicacion_id") == null) return false;
        BigDecimal idTipo = new BigDecimal(att.getValue("tipo_indicacion_id"));
        TrTipoIndicacionFicha tipoIndicacion = null;
        if (this.grafico.getTiposIndicacionInvolucradosEnCarga() == null) return false;
        tipoIndicacion = this.grafico.getTiposIndicacionInvolucradosEnCarga().obtenerTipoIndicacionFichaDeTiposIndicacionFichaEnCarga(idTipo);
        if (tipoIndicacion == null) {
            return false;
        }
        indicacionFichaActiva.setTipoIndicacionFicha(tipoIndicacion);
        if (att.getValue("descripcion") != null) {
            indicacionFichaActiva.setDESCRIPCION(att.getValue("descripcion"));
        }
        if (this.tipoEvolucionActivo == null) return true;
        if (this.tipoEvolucionActivo.getFichaProcedimientoInvolucradas().obtenerDato(indicacionFichaActiva.getINFIID()) == null) {
            this.tipoEvolucionActivo.getFichaProcedimientoInvolucradas().add(indicacionFichaActiva);
            return true;
        } else {
            indicacionFichaActiva = (TrIndicacionFicha)this.tipoEvolucionActivo.getFichaProcedimientoInvolucradas().obtenerDato(indicacionFichaActiva.getINFIID());
        }
        return true;
    }

    public boolean crearNormativaDelProcedimiento(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        BigDecimal idBuscado = null;
        if (att.getValue("id") == null) {
            return false;
        }
        String strId = att.getValue("id");
        idBuscado = new BigDecimal(strId);
        TrNormativa normativaAdd = this.grafico.getNormativasInvolucradasEnCarga().obtenerNormativaDeNormativasEnCarga(idBuscado);
        if (normativaAdd == null) {
            return false;
        }
        if (this.tipoEvolucionActivo != null && this.tipoEvolucionActivo.getNormativasProcedimiento().obtenerDato(normativaAdd.getX_ID()) == null) {
            this.tipoEvolucionActivo.getNormativasProcedimiento().add(normativaAdd);
        }
        return true;
    }

    public boolean crearPlantillaProcedimiento(Attributes att) throws Exception {
        if (this.grafico == null) {
            return false;
        }
        if (att.getLength() < 1) {
            return false;
        }
        TrPlantillaProcedimiento plantillaProc = new TrPlantillaProcedimiento();
        if (att.getValue("id") != null) {
            String strId = att.getValue("id");
            plantillaProc.setXID(new BigDecimal(strId));
            if (this.auxID < Long.parseLong(strId)) {
                this.auxID = Long.parseLong(strId);
            }
        } else {
            return false;
        }
        if (att.getValue("nombre") == null) {
            return false;
        }
        plantillaProc.setNOMBRE(att.getValue("nombre"));
        if (att.getValue("descripcion") == null) {
            return false;
        }
        plantillaProc.setDESCRIPCION(att.getValue("descripcion"));
        if (att.getValue("nombre_fichero") != null) {
            plantillaProc.setNOMB_FICHERO(att.getValue("nombre_fichero"));
        }
        if (att.getValue("formato") != null) {
            plantillaProc.setFORMATO(att.getValue("formato"));
        }
        if (this.tipoEvolucionActivo != null) {
            if (this.tipoEvolucionActivo.getPlantillasProcInvolucradas().obtenerDato(plantillaProc.getXID()) == null) {
                this.tipoEvolucionActivo.getPlantillasProcInvolucradas().add(plantillaProc);
            } else {
                plantillaProc = (TrPlantillaProcedimiento)this.tipoEvolucionActivo.getPlantillasProcInvolucradas().obtenerDato(plantillaProc.getXID());
            }
        }
        return true;
    }

    private void comprobarEvolucionAsociadaAFase() {
        if (this.arrIDsReutilizables == null) {
            return;
        }
        if (this.arrIDsReutilizables.size() < 1) {
            return;
        }
        if (this.tipoEvolucionActivo == null) {
            return;
        }
        if (this.grafico == null) {
            return;
        }
        if (this.grafico.getDDP() == null) {
            return;
        }
        if (this.grafico.getDDP().getTIPOEVOL() == null) {
            return;
        }
        if (this.grafico.getFasesInvolucradas() == null) {
            return;
        }
        if (this.grafico.getFasesInvolucradas().getListaDatos() == null) {
            return;
        }
        if (this.grafico.getFasesInvolucradas().getListaDatos().size() < 1) {
            return;
        }
        boolean bFaseAsociadaAPrincipal = false;
        TrTipoEvol tipoEvolucionEncontrada = null;
        for (int n = 0; n < this.arrIDsReutilizables.size(); ++n) {
            if (((BigDecimal)this.arrIDsReutilizables.get(n)).longValue() != this.tipoEvolucionActivo.getTIEVID().longValue()) continue;
            if (this.grafico.existeDDPGrafico(this.tipoEvolucionActivo.getABREVIATURA()) == null) {
                this.tipoEvolucionActivo.setSISTEMA(this.grafico.getDDP().getTIPOEVOL().getSISTEMA());
                this.addEvolucionAListaReutilizables(this.tipoEvolucionActivo);
                continue;
            }
            tipoEvolucionEncontrada = this.grafico.existeDDPGrafico(this.tipoEvolucionActivo.getABREVIATURA()).getDDP().getTIPOEVOL();
            if (this.grafico.existeDDPGrafico(this.tipoEvolucionActivo.getABREVIATURA()).getDDPPadre() != null) continue;
            bFaseAsociadaAPrincipal = true;
        }
        ArrayList arrFases = this.grafico.getFasesInvolucradas().getListaDatos();
        for (int f = 0; f < arrFases.size(); ++f) {
            if (((TrFase)arrFases.get(f)).getIdEvolucionCarga() == null || ((TrFase)arrFases.get(f)).getIdEvolucionCarga().longValue() != this.tipoEvolucionActivo.getTIEVID().longValue()) continue;
            if (tipoEvolucionEncontrada == null) {
                ((TrFase)arrFases.get(f)).setTIPOEVOL(this.tipoEvolucionActivo);
                continue;
            }
            if (!bFaseAsociadaAPrincipal) {
                ((TrFase)arrFases.get(f)).setTIPOEVOL(tipoEvolucionEncontrada);
                continue;
            }
            this.bFasesAsociadasAlPrincipal = true;
        }
    }

    private void addEvolucionAListaReutilizables(TrTipoEvol evolucion) {
        if (evolucion == null) {
            return;
        }
        if (this.grafico == null) {
            return;
        }
        DDPGrafico nuevoDDPReu = null;
        PCanvasModela nuevoCanvasReu = new PCanvasModela();
        if (this.grafico.getDDPPadre() != null) {
            nuevoDDPReu = new DDPGrafico(this.grafico.getDDPPadre());
            this.grafico.getDDPPadre().addDDP(nuevoDDPReu);
        } else {
            nuevoDDPReu = new DDPGrafico(this.grafico);
            this.grafico.addDDP(nuevoDDPReu);
        }
        nuevoDDPReu.setCanvas(nuevoCanvasReu);
        nuevoCanvasReu.setDiagrama(nuevoDDPReu);
        DefProcGr datosNuevoReu = new DefProcGr();
        datosNuevoReu.setTITULO(evolucion.getDESCRIPCION());
        datosNuevoReu.setTIPOEVOL(evolucion);
        nuevoDDPReu.setDDP(datosNuevoReu);
        nuevoDDPReu.setEditable(false);
    }
}

