/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.informes;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import com.lowagie.text.pdf.PdfWriter;
import gdtel.bd.ConjuntoDatos;
import gdtel.ui.ValidarNombreFichero;
import gdtel.ui.swing.FileFilterEx;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFileChooser;
import modela.bd.ConjuntoDatosModela;
import modela.bd.obj.ConjuntoDatosPerfilTransEvol;
import modela.bd.obj.ConjuntoDatosTareaFaseDefProcedimiento;
import modela.bd.obj.ConjuntoDatosTransicionDefProcedimiento;
import modela.bd.obj.TrAccionTareaFase;
import modela.bd.obj.TrAccionTransicion;
import modela.bd.obj.TrAvisoTareaFase;
import modela.bd.obj.TrAvisoTransicion;
import modela.bd.obj.TrCondicionTareaFase;
import modela.bd.obj.TrCondicionTransicion;
import modela.bd.obj.TrDocumentoPermitido;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrMetafase;
import modela.bd.obj.TrPerfilTareaFase;
import modela.bd.obj.TrPerfilTransEvol;
import modela.bd.obj.TrPlazoSimple;
import modela.bd.obj.TrTareaEnFaseDefProcedimiento;
import modela.bd.obj.TrTipoTarea;
import modela.bd.obj.TrTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;

public class InformeGuiaProcedimientosPDF {
    private DDPGrafico m_grafico = null;
    Image logoJusticia = null;
    private Font tituloFont = FontFactory.getFont((String)"Helvetica", (float)12.0f, (int)1);
    private Font camposFont = FontFactory.getFont((String)"Helvetica", (float)10.0f, (int)1);
    private Font valoresFont = FontFactory.getFont((String)"Helvetica", (float)9.0f, (int)0);
    private Font transicionesFont = FontFactory.getFont((String)"Helvetica", (float)13.0f, (int)5);
    Image transN = null;
    Image transD = null;
    Image transU = null;
    Image transES = null;
    Image transEN = null;
    Image transI = null;
    Image transF = null;
    Image tareaManipular = null;
    Image tareaGenerar = null;
    Image tareaGenerarMultiple = null;
    Image tareaIncorporar = null;
    Image tareaIncorporarMultiple = null;
    Image tareaOtros = null;

    public InformeGuiaProcedimientosPDF(DDPGrafico grafico) {
        this.m_grafico = grafico;
    }

    public void crearInformePDF() {
        Document document = new Document();
        try {
            String strRuta = this.seleccionarRutaInforme();
            if (strRuta == null) {
                return;
            }
            if (strRuta.equals("")) {
                return;
            }
            if (this.m_grafico.getFasesInvolucradasGr() == null) {
                return;
            }
            if (this.m_grafico.getFasesInvolucradasGr().getListaDatos() == null) {
                return;
            }
            if (ModelaConf.getParametrosInformeGuia() == null) {
                return;
            }
            PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(strRuta));
            this.transN = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_NORMAL));
            this.transD = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_DIVISION));
            this.transU = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_UNION));
            this.transES = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_ES));
            this.transEN = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_EN));
            this.transI = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_INICIO));
            this.transF = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOCALIZAR_TR_GR_FIN));
            this.tareaManipular = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_TAREA_MANIPULAR));
            this.tareaGenerar = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_TAREA_GENERAR));
            this.tareaGenerarMultiple = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_TAREA_GENERAR_MULTIPLE));
            this.tareaIncorporar = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_TAREA_INCORPORAR));
            this.tareaIncorporarMultiple = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_TAREA_INCORPORAR_MULTIPLE));
            this.tareaOtros = Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_TAREA_OTROS));
            this.logoJusticia = ModelaConf.getLogoInforme().equals(ModelaUI.IMG_LOGO_JUSTICIA) ? Image.getInstance((URL)this.getClass().getResource(ModelaUI.IMG_LOGO_JUSTICIA)) : Image.getInstance((String)ModelaConf.getLogoInforme());
            Image jpg = Image.getInstance((Image)this.logoJusticia);
            jpg.scaleAbsolute(160.0f, 40.0f);
            Chunk ck = new Chunk(jpg, 0.0f, -5.0f);
            Phrase p1 = new Phrase();
            p1.add((Object)ck);
            p1.add((Object)new Paragraph("   Guia del procedimiento  ", this.tituloFont));
            p1.add((Object)new Paragraph(this.getNombreProcedimiento(), this.tituloFont));
            HeaderFooter header = new HeaderFooter(p1, false);
            header.setBorder(2);
            document.setHeader(header);
            HeaderFooter footer = new HeaderFooter(new Phrase("P\u00e1gina ", this.camposFont), new Phrase("", this.camposFont));
            new HeaderFooter(new Phrase("P\u00e1gina ", this.camposFont), new Phrase("", this.camposFont));
            footer.setAlignment(2);
            footer.setBorder(1);
            document.setFooter(footer);
            document.open();
            document.setPageSize(PageSize.A4);
            document.add((Element)new Paragraph(" "));
            if (!ModelaConf.getParametrosInformeGuia().isAgruparMetafases()) {
                this.cargarFases(document, -1.0);
            } else {
                this.cargarMetaFases(document);
            }
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
        catch (IOException ioe) {
            System.err.println(ioe.getMessage());
        }
        document.close();
    }

    private void cargarFases(Document document, double fMetafase) {
        try {
            if (this.m_grafico.getFasesInvolucradasGr() == null) {
                return;
            }
            if (this.m_grafico.getFasesInvolucradasGr().getListaDatos() == null) {
                return;
            }
            ConjuntoDatosModela fasesOrdenadas = this.m_grafico.getFasesInvolucradasGr();
            fasesOrdenadas.ordenar();
            ArrayList listaFases = fasesOrdenadas.getListaDatos();
            if (listaFases.size() > 0) {
                for (int i = 0; i < listaFases.size(); ++i) {
                    TrFase fase = (TrFase)listaFases.get(i);
                    if (fase == null) continue;
                    if (fMetafase == -1.0) {
                        document.add((Element)new Paragraph(" "));
                        this.cargarFase(document, fase);
                        continue;
                    }
                    if (fase.getMETAFASE() == null || fase.getMETAFASE().getID() != fMetafase) continue;
                    this.cargarFase(document, fase);
                }
            }
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
    }

    private void cargarMetaFases(Document document) {
        try {
            if (this.m_grafico.getMetafasesInvolucradasGr() == null) {
                return;
            }
            if (this.m_grafico.getMetafasesInvolucradasGr().getListaDatos() == null) {
                return;
            }
            ConjuntoDatosModela metafasesOrdenadas = this.m_grafico.getMetafasesInvolucradasGr();
            metafasesOrdenadas.ordenar();
            ArrayList listaMetafases = metafasesOrdenadas.getListaDatos();
            PdfPTable table = null;
            if (listaMetafases.size() > 0) {
                document.add((Element)new Paragraph(" "));
                for (int i = 0; i < listaMetafases.size(); ++i) {
                    TrMetafase metafase = (TrMetafase)listaMetafases.get(i);
                    if (metafase == null) continue;
                    document.add((Element)new Paragraph(" "));
                    document.add((Element)new Paragraph(" "));
                    table = new PdfPTable(1);
                    PdfPCell cell = null;
                    Phrase frase = new Phrase();
                    frase.add((Object)new Paragraph("   METAFASE:  ", this.tituloFont));
                    if (metafase.getNOMBRE() != null) {
                        frase.add((Object)new Paragraph(metafase.getNOMBRE(), this.valoresFont));
                    }
                    cell = new PdfPCell(frase);
                    table.addCell(cell);
                    table.setWidthPercentage(100.0f);
                    document.add((Element)table);
                    this.cargarFases(document, metafase.getID());
                }
            }
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
    }

    private String seleccionarRutaInforme() {
        String strRuta = null;
        JFileChooser fileDlg = new JFileChooser(ModelaConf.getRutaArchivo());
        fileDlg.setFileSelectionMode(0);
        FileFilterEx filter = new FileFilterEx("pdf");
        filter.setDescription("Archivos pdf");
        fileDlg.addChoosableFileFilter(filter);
        int nRet = fileDlg.showSaveDialog(null);
        if (nRet == 0) {
            ValidarNombreFichero validaFichero;
            String strNombreFichero;
            File fich = fileDlg.getSelectedFile();
            strRuta = fich.getPath();
            if (!strRuta.endsWith(".pdf")) {
                strRuta = strRuta + ".pdf";
            }
            if (!(strNombreFichero = fich.getName()).endsWith(".pdf")) {
                strNombreFichero = strNombreFichero + ".pdf";
            }
            if (!(validaFichero = new ValidarNombreFichero()).validaNombreFichero(strNombreFichero)) {
                return null;
            }
        }
        ModelaConf.setRutaArchivo(fileDlg.getCurrentDirectory().getPath());
        ModelaConf.salvar();
        return strRuta;
    }

    private String getNombreProcedimiento() {
        if (this.m_grafico.getDDP() == null) {
            return "";
        }
        if (this.m_grafico.getDDP().getTIPOEVOL() == null) {
            return "";
        }
        return this.m_grafico.getDDP().getTIPOEVOL().getNombre();
    }

    private void cargarFase(Document document, TrFase fase) {
        try {
            if (fase == null) {
                return;
            }
            PdfPCell cell = null;
            Phrase frase = new Phrase();
            PdfPTable table = null;
            table = new PdfPTable(2);
            document.add((Element)new Paragraph(" "));
            frase.add((Object)new Paragraph("   FASE:  ", this.tituloFont));
            if (fase.getNOMBRE() != null) {
                frase.add((Object)new Paragraph(fase.getNOMBRE(), this.valoresFont));
            }
            cell = new PdfPCell(frase);
            cell.setColspan(2);
            table.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph("Metafase:", this.camposFont));
            table.addCell(cell);
            cell = fase.getMETAFASE() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(fase.getMETAFASE().toString(), this.valoresFont));
            table.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph("Fase:", this.camposFont));
            table.addCell(cell);
            cell = fase.getNOMBRE() != null ? new PdfPCell((Phrase)new Paragraph(fase.getNOMBRE(), this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(" "));
            table.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n de la fase:", this.camposFont));
            table.addCell(cell);
            cell = fase.getDESCRIPCION() != null ? new PdfPCell((Phrase)new Paragraph(fase.getDESCRIPCION(), this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(" "));
            table.addCell(cell);
            cell = new PdfPCell((Phrase)new Paragraph("Representa al m\u00f3dulo reutilizable:", this.camposFont));
            table.addCell(cell);
            cell = fase.getTIPOEVOL() != null ? new PdfPCell((Phrase)new Paragraph(fase.getTIPOEVOL().getNombre(), this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(" "));
            table.addCell(cell);
            table.setWidthPercentage(100.0f);
            document.add((Element)table);
            if (ModelaConf.getParametrosInformeGuia().isMostrarTransiciones()) {
                if (ModelaConf.getParametrosInformeGuia().isEntrada()) {
                    this.cargarTransiciones(document, fase, true);
                } else if (ModelaConf.getParametrosInformeGuia().isSalida()) {
                    this.cargarTransiciones(document, fase, false);
                } else {
                    this.cargarTransiciones(document, fase, true);
                    this.cargarTransiciones(document, fase, false);
                }
            }
            if (ModelaConf.getParametrosInformeGuia().isMostrarTareas()) {
                this.cargarTareas(document, fase);
            }
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
    }

    private void cargarTransiciones(Document document, TrFase fase, boolean bInicio) {
        String strEtiqTrans = "";
        ConjuntoDatosTransicionDefProcedimiento cdTransDefProc = null;
        if (bInicio) {
            strEtiqTrans = "Transiciones de entrada";
            cdTransDefProc = this.m_grafico.getTransicionesDefProcEntrada(fase);
        } else {
            strEtiqTrans = "Transiciones de salida";
            cdTransDefProc = this.m_grafico.getTransicionesDefProcSalida(fase);
        }
        if (cdTransDefProc == null) {
            return;
        }
        if (cdTransDefProc.getListaDatos() == null) {
            return;
        }
        if (cdTransDefProc.getListaDatos().size() <= 0) {
            return;
        }
        cdTransDefProc.ordenar();
        try {
            document.add((Element)new Paragraph(" "));
            document.add((Element)new Paragraph(strEtiqTrans, this.transicionesFont));
            TrTransicionDefProcedimiento transicionDefProc = null;
            for (int i = 0; i < cdTransDefProc.getListaDatos().size(); ++i) {
                TrTransicion transicionAux;
                transicionDefProc = (TrTransicionDefProcedimiento)cdTransDefProc.getListaDatos().get(i);
                if (transicionDefProc == null || (transicionAux = transicionDefProc.getTransicion()) == null) continue;
                document.add((Element)new Paragraph(" "));
                PdfPCell cell = null;
                Phrase frase = new Phrase();
                PdfPTable table = null;
                table = new PdfPTable(7);
                frase.add((Object)new Paragraph("Transici\u00f3n:  ", this.tituloFont));
                if (transicionAux.getNombre() != null) {
                    frase.add((Object)new Paragraph(transicionAux.getNombre(), this.valoresFont));
                }
                cell = new PdfPCell(frase);
                cell.setColspan(7);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Tipo", this.camposFont));
                cell.setColspan(1);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Etiqueta", this.camposFont));
                cell.setColspan(1);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                cell.setColspan(2);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("V\u00e1lida", this.camposFont));
                cell.setColspan(1);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Tipo de acto administrativo", this.camposFont));
                cell.setColspan(2);
                table.addCell(cell);
                if (transicionAux.getTIPO() == null) {
                    cell = new PdfPCell((Phrase)new Paragraph(" "));
                } else if (transicionAux.getTIPO().equals("")) {
                    cell = new PdfPCell((Phrase)new Paragraph(" "));
                } else {
                    if (transicionAux.getTIPO().equals("N")) {
                        cell = new PdfPCell(this.transN);
                    }
                    if (transicionAux.getTIPO().equals("D")) {
                        cell = new PdfPCell(this.transD);
                    }
                    if (transicionAux.getTIPO().equals("U")) {
                        cell = new PdfPCell(this.transU);
                    }
                    if (transicionAux.getTIPO().equals("ES")) {
                        cell = new PdfPCell(this.transES);
                    }
                    if (transicionAux.getTIPO().equals("EN")) {
                        cell = new PdfPCell(this.transEN);
                    }
                    if (transicionAux.getTIPO().equals("I")) {
                        cell = new PdfPCell(this.transI);
                    }
                    if (transicionAux.getTIPO().equals("F")) {
                        cell = new PdfPCell(this.transF);
                    }
                }
                cell.setColspan(1);
                cell.setMinimumHeight(25.0f);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
                cell = transicionAux.getETIQUETA() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (transicionAux.getETIQUETA().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(transicionAux.getETIQUETA(), this.valoresFont)));
                cell.setColspan(1);
                table.addCell(cell);
                cell = transicionAux.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (transicionAux.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(transicionAux.getDescripcion(), this.valoresFont)));
                cell.setColspan(2);
                table.addCell(cell);
                cell = transicionAux.getVALIDA() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (transicionAux.getVALIDA().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(transicionAux.getValidaToString(), this.valoresFont)));
                cell.setColspan(1);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
                cell = transicionAux.getTipoActo() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(transicionAux.getTipoActo().toString(), this.valoresFont));
                cell.setColspan(2);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Etiqueta larga", this.camposFont));
                cell.setColspan(2);
                table.addCell(cell);
                cell = transicionAux.getETIQUETA_LARGA() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (transicionAux.getETIQUETA_LARGA().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(transicionAux.getETIQUETA_LARGA(), this.valoresFont)));
                cell.setColspan(2);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("N\u00fam. ocurrencias:", this.camposFont));
                cell.setColspan(2);
                table.addCell(cell);
                String strNumOcurrencias = String.valueOf(transicionDefProc.getMaxOcurrencias());
                cell = strNumOcurrencias == null ? new PdfPCell((Phrase)new Paragraph("", this.valoresFont)) : (strNumOcurrencias.equals("") ? new PdfPCell((Phrase)new Paragraph("", this.valoresFont)) : (strNumOcurrencias.equals("null") ? new PdfPCell((Phrase)new Paragraph("", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(strNumOcurrencias, this.valoresFont))));
                cell.setColspan(1);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n de la fecha:", this.camposFont));
                cell.setColspan(2);
                table.addCell(cell);
                cell = transicionAux.getDESCRIPCIONFECHA() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (transicionAux.getDESCRIPCIONFECHA().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(transicionAux.getDESCRIPCIONFECHA(), this.valoresFont)));
                cell.setColspan(5);
                table.addCell(cell);
                if (bInicio) {
                    if (transicionAux.getTrFaseIni() != null) {
                        cell = new PdfPCell((Phrase)new Paragraph("Sale de la fase", this.camposFont));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Nombre", this.camposFont));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                        cell.setColspan(3);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph(" "));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph(transicionAux.getTrFaseIni().getNOMBRE(), this.valoresFont));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph(transicionAux.getTrFaseIni().getDescripcion(), this.valoresFont));
                        cell.setColspan(3);
                        table.addCell(cell);
                    }
                } else if (transicionAux.getTIPO().equals("D")) {
                    if (transicionAux.getConjuntoFasesFin() != null && transicionAux.getConjuntoFasesFin().getListaDatos() != null && transicionAux.getConjuntoFasesFin().getListaDatos().size() > 0) {
                        cell = new PdfPCell((Phrase)new Paragraph("Lleva a las fases", this.camposFont));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Nombre", this.camposFont));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                        cell.setColspan(3);
                        table.addCell(cell);
                        TrFase faseAux = null;
                        for (int j = 0; j < transicionAux.getConjuntoFasesFin().getListaDatos().size(); ++j) {
                            faseAux = (TrFase)transicionAux.getConjuntoFasesFin().getListaDatos().get(j);
                            cell = new PdfPCell((Phrase)new Paragraph(" "));
                            cell.setColspan(2);
                            table.addCell(cell);
                            cell = new PdfPCell((Phrase)new Paragraph(faseAux.getNOMBRE(), this.valoresFont));
                            cell.setColspan(2);
                            table.addCell(cell);
                            cell = new PdfPCell((Phrase)new Paragraph(faseAux.getDescripcion(), this.valoresFont));
                            cell.setColspan(3);
                            table.addCell(cell);
                        }
                    }
                } else if (transicionAux.getFaseFin() != null) {
                    cell = new PdfPCell((Phrase)new Paragraph("Lleva a las fases", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Nombre", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                    cell.setColspan(3);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph(" "));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph(transicionAux.getFaseFin().getNOMBRE(), this.valoresFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph(transicionAux.getFaseFin().getDescripcion(), this.valoresFont));
                    cell.setColspan(3);
                    table.addCell(cell);
                }
                boolean bVisualizarPerfiles = false;
                bVisualizarPerfiles = bInicio ? ModelaConf.getParametrosInformeGuia().isPerfilEntrada() : ModelaConf.getParametrosInformeGuia().isPerfilSalida();
                if (bVisualizarPerfiles && transicionDefProc.getConjuntoPerfilTransEvol() != null && transicionDefProc.getConjuntoPerfilTransEvol().getListaDatos() != null && transicionDefProc.getConjuntoPerfilTransEvol().getListaDatos().size() > 0) {
                    cell = new PdfPCell((Phrase)new Paragraph("Perfiles", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Perfil", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Permiso", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    ConjuntoDatosPerfilTransEvol perfilesOrdenados = transicionDefProc.getConjuntoPerfilTransEvol();
                    perfilesOrdenados.ordenar();
                    ArrayList listaPerfiles = perfilesOrdenados.getListaDatos();
                    for (int j = 0; j < listaPerfiles.size(); ++j) {
                        TrPerfilTransEvol perfil = (TrPerfilTransEvol)listaPerfiles.get(j);
                        if (perfil == null) continue;
                        cell = new PdfPCell((Phrase)new Paragraph(" "));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = perfil.getNombre() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (perfil.getNombre().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(perfil.getNombre(), this.valoresFont)));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = perfil.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (perfil.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(perfil.getDescripcion(), this.valoresFont)));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = perfil.getPermisoToString() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (perfil.getPermisoToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(perfil.getPermisoToString(), this.valoresFont)));
                        cell.setColspan(2);
                        table.addCell(cell);
                    }
                }
                boolean bVisualizarAcciones = false;
                bVisualizarAcciones = bInicio ? ModelaConf.getParametrosInformeGuia().isAccionEntrada() : ModelaConf.getParametrosInformeGuia().isAccionSalida();
                if (bVisualizarAcciones && transicionDefProc.getConjuntoAccionTransicion() != null && transicionDefProc.getConjuntoAccionTransicion().getListaDatos() != null && transicionDefProc.getConjuntoAccionTransicion().getListaDatos().size() > 0) {
                    cell = new PdfPCell((Phrase)new Paragraph("Acciones", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Acci\u00f3n", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("V\u00e1lida", this.camposFont));
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Comprobar", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    ConjuntoDatos accionesOrdenados = transicionDefProc.getConjuntoAccionTransicion();
                    accionesOrdenados.ordenar();
                    ArrayList listaAcciones = accionesOrdenados.getListaDatos();
                    for (int j = 0; j < listaAcciones.size(); ++j) {
                        TrAccionTransicion accion = (TrAccionTransicion)listaAcciones.get(j);
                        if (accion == null) continue;
                        cell = new PdfPCell((Phrase)new Paragraph(" "));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = accion.getNombre() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (accion.getNombre().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(accion.getNombre(), this.valoresFont)));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = accion.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (accion.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(accion.getDescripcion(), this.valoresFont)));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = accion.getValidaToString() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (accion.isValidaToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(accion.getValidaToString(), this.valoresFont)));
                        cell.setHorizontalAlignment(1);
                        cell.setVerticalAlignment(5);
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph(accion.getComprobarToString(), this.valoresFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                    }
                }
                boolean bVisualizarCondiciones = false;
                bVisualizarCondiciones = bInicio ? ModelaConf.getParametrosInformeGuia().isCondicionEntrada() : ModelaConf.getParametrosInformeGuia().isCondicionSalida();
                if (bVisualizarCondiciones && transicionDefProc.getConjuntoCondicionTransicion() != null && transicionDefProc.getConjuntoCondicionTransicion().getListaDatos() != null && transicionDefProc.getConjuntoCondicionTransicion().getListaDatos().size() > 0) {
                    cell = new PdfPCell((Phrase)new Paragraph("Condiciones", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Condici\u00f3n", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("V\u00e1lida", this.camposFont));
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Obligatoria", this.camposFont));
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Comprobar", this.camposFont));
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.setColspan(1);
                    table.addCell(cell);
                    ConjuntoDatos condicionesOrdenados = transicionDefProc.getConjuntoCondicionTransicion();
                    condicionesOrdenados.ordenar();
                    ArrayList listaCondiciones = condicionesOrdenados.getListaDatos();
                    for (int j = 0; j < listaCondiciones.size(); ++j) {
                        TrCondicionTransicion condicion = (TrCondicionTransicion)listaCondiciones.get(j);
                        if (condicion == null) continue;
                        cell = new PdfPCell((Phrase)new Paragraph(" "));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = condicion.getNombre() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (condicion.getNombre().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(condicion.getNombre(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = condicion.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (condicion.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ")) : new PdfPCell((Phrase)new Paragraph(condicion.getDescripcion(), this.valoresFont)));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph(condicion.getValidaToString(), this.valoresFont));
                        cell.setHorizontalAlignment(1);
                        cell.setVerticalAlignment(5);
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph(condicion.getObligatoriaToString(), this.valoresFont));
                        cell.setHorizontalAlignment(1);
                        cell.setVerticalAlignment(5);
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph(condicion.getComprobarToString(), this.valoresFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                    }
                }
                boolean bVisualizarAvisos = false;
                bVisualizarAvisos = bInicio ? ModelaConf.getParametrosInformeGuia().isAvisoEntrada() : ModelaConf.getParametrosInformeGuia().isAvisoSalida();
                if (bVisualizarAvisos && transicionDefProc.getConjuntoAvisoTransicion() != null && transicionDefProc.getConjuntoAvisoTransicion().getListaDatos() != null && transicionDefProc.getConjuntoAvisoTransicion().getListaDatos().size() > 0) {
                    cell = new PdfPCell((Phrase)new Paragraph("Avisos", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Aviso", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("V\u00e1lida", this.camposFont));
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Comprobar", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    ConjuntoDatos avisosOrdenados = transicionDefProc.getConjuntoAvisoTransicion();
                    avisosOrdenados.ordenar();
                    ArrayList listaAvisos = avisosOrdenados.getListaDatos();
                    for (int j = 0; j < listaAvisos.size(); ++j) {
                        TrAvisoTransicion aviso = (TrAvisoTransicion)listaAvisos.get(j);
                        if (aviso == null) continue;
                        cell = new PdfPCell((Phrase)new Paragraph(" "));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = aviso.getNombre() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (aviso.getNombre().equals("") ? new PdfPCell((Phrase)new Paragraph(aviso.getNombre(), this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(aviso.getNombre(), this.valoresFont)));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = aviso.getNombre() == null ? new PdfPCell((Phrase)new Paragraph(" ")) : (aviso.getNombre().equals("") ? new PdfPCell((Phrase)new Paragraph(aviso.getDescripcion(), this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(aviso.getDescripcion(), this.valoresFont)));
                        cell.setColspan(2);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph(aviso.getValidaToString(), this.valoresFont));
                        cell.setHorizontalAlignment(1);
                        cell.setVerticalAlignment(5);
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = new PdfPCell((Phrase)new Paragraph(aviso.getComprobarToString(), this.valoresFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                    }
                }
                table.setWidthPercentage(100.0f);
                document.add((Element)table);
                if (!ModelaConf.getParametrosInformeGuia().isMostrarPlazos()) continue;
                this.cargarPlazoSimple(document, transicionDefProc);
            }
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
    }

    private void cargarPlazoSimple(Document document, TrTransicionDefProcedimiento transicionDefProc) {
        try {
            if (transicionDefProc == null) {
                return;
            }
            if (transicionDefProc.getTransicion() == null) {
                return;
            }
            ArrayList<TrPlazoSimple> listaPlazos = null;
            if (transicionDefProc.getTransicion().getTIPO().equals("D")) {
                if (transicionDefProc.getPlazosSimple() != null) {
                    listaPlazos = transicionDefProc.getPlazosSimple();
                }
            } else if (transicionDefProc.getPlazoSimple() != null) {
                listaPlazos = new ArrayList<TrPlazoSimple>();
                listaPlazos.add(transicionDefProc.getPlazoSimple());
            }
            if (listaPlazos == null) {
                return;
            }
            if (listaPlazos.size() <= 0) {
                return;
            }
            PdfPCell cell = null;
            PdfPTable table = null;
            table = new PdfPTable(5);
            if (listaPlazos.size() > 0) {
                document.add((Element)new Paragraph(" "));
                for (int i = 0; i < listaPlazos.size(); ++i) {
                    TrPlazoSimple plazo = (TrPlazoSimple)listaPlazos.get(i);
                    Phrase frase = new Phrase();
                    frase.add((Object)new Paragraph("Plazo simple:  ", this.camposFont));
                    if (plazo.getDescripcion() != null) {
                        frase.add((Object)new Paragraph(plazo.getDescripcion(), this.valoresFont));
                    }
                    cell = new PdfPCell(frase);
                    cell.setColspan(5);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("N\u00famero de unidades", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    String strUnidades = String.valueOf(plazo.getNumUnidades());
                    cell = new PdfPCell((Phrase)new Paragraph(strUnidades, this.valoresFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Unidad", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = plazo.getUnidad() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (plazo.getUnidad().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(plazo.getUnidadesToString(), this.valoresFont)));
                    cell.setColspan(1);
                    table.addCell(cell);
                    TrTransicion transicionP = plazo.getTransicionQueProvoca();
                    if (transicionP != null) {
                        Phrase fraseTrans = new Phrase();
                        cell = new PdfPCell((Phrase)new Paragraph("Transici\u00f3n que se provoca", this.camposFont));
                        cell.setColspan(2);
                        table.addCell(cell);
                        if (transicionP.getTIPO() != null) {
                            fraseTrans.add((Object)new Paragraph(transicionP.getTIPO(), this.valoresFont));
                        }
                        fraseTrans.add((Object)new Paragraph(" - ", this.valoresFont));
                        if (transicionP.getETIQUETA() != null) {
                            fraseTrans.add((Object)new Paragraph(transicionP.getETIQUETA(), this.valoresFont));
                        }
                        fraseTrans.add((Object)new Paragraph(" - ", this.valoresFont));
                        if (transicionP.getDescripcion() != null) {
                            fraseTrans.add((Object)new Paragraph(transicionP.getDescripcion(), this.valoresFont));
                        }
                        cell = new PdfPCell(fraseTrans);
                        cell.setColspan(3);
                        table.addCell(cell);
                        if (transicionP.getTIPO().equals("D")) {
                            if (transicionP.getConjuntoFasesFin() != null && transicionP.getConjuntoFasesFin().getListaDatos().size() > 0) {
                                cell = new PdfPCell((Phrase)new Paragraph("Fase(s) a la que lleva la transici\u00f3n que se provoca", this.camposFont));
                                cell.setColspan(2);
                                table.addCell(cell);
                                cell = new PdfPCell((Phrase)new Paragraph("Nombre", this.camposFont));
                                cell.setColspan(1);
                                table.addCell(cell);
                                cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                                cell.setColspan(2);
                                table.addCell(cell);
                                TrFase faseAux = null;
                                for (int j = 0; j < transicionP.getConjuntoFasesFin().getListaDatos().size(); ++j) {
                                    faseAux = (TrFase)transicionP.getConjuntoFasesFin().getListaDatos().get(j);
                                    cell = new PdfPCell((Phrase)new Paragraph(" "));
                                    cell.setColspan(2);
                                    table.addCell(cell);
                                    cell = faseAux.getNOMBRE() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (faseAux.getNOMBRE().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(faseAux.getNOMBRE(), this.valoresFont)));
                                    cell.setColspan(1);
                                    table.addCell(cell);
                                    cell = faseAux.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (faseAux.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(faseAux.getDescripcion(), this.valoresFont)));
                                    cell.setColspan(2);
                                    table.addCell(cell);
                                }
                            }
                        } else if (transicionP.getFaseFin() != null) {
                            cell = new PdfPCell((Phrase)new Paragraph("Fase(s) a la que lleva la transici\u00f3n que se provoca", this.camposFont));
                            cell.setColspan(2);
                            table.addCell(cell);
                            cell = new PdfPCell((Phrase)new Paragraph("Nombre", this.camposFont));
                            cell.setColspan(1);
                            table.addCell(cell);
                            cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                            cell.setColspan(2);
                            table.addCell(cell);
                            cell = new PdfPCell((Phrase)new Paragraph(" "));
                            cell.setColspan(2);
                            table.addCell(cell);
                            cell = transicionP.getFaseFin().getNOMBRE() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (transicionP.getFaseFin().getNOMBRE().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(transicionP.getFaseFin().getNOMBRE(), this.valoresFont)));
                            cell.setColspan(1);
                            table.addCell(cell);
                            cell = transicionP.getFaseFin().getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (transicionP.getFaseFin().getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(transicionP.getFaseFin().getDescripcion(), this.valoresFont)));
                            cell.setColspan(2);
                            table.addCell(cell);
                        }
                    }
                    table.setWidthPercentage(100.0f);
                    document.add((Element)table);
                }
            }
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
    }

    private void cargarTareas(Document document, TrFase fase) {
        if (fase == null) {
            return;
        }
        ConjuntoDatosTareaFaseDefProcedimiento cdTareaDefProc = null;
        cdTareaDefProc = this.m_grafico.getTareasEnFaseDefProc(fase);
        if (cdTareaDefProc == null) {
            return;
        }
        if (cdTareaDefProc.getListaDatos() == null) {
            return;
        }
        if (cdTareaDefProc.getListaDatos().size() <= 0) {
            return;
        }
        cdTareaDefProc.ordenar();
        PdfPCell cell = null;
        PdfPTable table = null;
        table = new PdfPTable(8);
        try {
            TrTareaEnFaseDefProcedimiento tareaDefProc = null;
            for (int i = 0; i < cdTareaDefProc.getListaDatos().size(); ++i) {
                boolean bMultiple;
                tareaDefProc = (TrTareaEnFaseDefProcedimiento)cdTareaDefProc.getListaDatos().get(i);
                if (tareaDefProc == null) continue;
                boolean bTareaVisible = false;
                if (tareaDefProc.getTareaEnFase().getTarea().getTrTipoTarea() == TrTipoTarea.MANIPULAR_DATOS) {
                    if (ModelaConf.getParametrosInformeGuia().isManipular()) {
                        bTareaVisible = true;
                    }
                } else if (tareaDefProc.getTareaEnFase().getTarea().getTrTipoTarea() == TrTipoTarea.GENERAR_DOCUMENTO) {
                    if (ModelaConf.getParametrosInformeGuia().isGenerar()) {
                        bTareaVisible = true;
                    }
                } else if (tareaDefProc.getTareaEnFase().getTarea().getTrTipoTarea() == TrTipoTarea.INCORPORAR_DOCUMENTO) {
                    if (ModelaConf.getParametrosInformeGuia().isIncorporar()) {
                        bTareaVisible = true;
                    }
                } else if (tareaDefProc.getTareaEnFase().getTarea().getTrTipoTarea() == TrTipoTarea.OTROS) {
                    if (ModelaConf.getParametrosInformeGuia().isOtras()) {
                        bTareaVisible = true;
                    }
                } else {
                    bTareaVisible = false;
                }
                if (!bTareaVisible) continue;
                document.add((Element)new Paragraph(" "));
                table = new PdfPTable(8);
                cell = new PdfPCell((Phrase)new Paragraph("Tarea:", this.camposFont));
                cell.setColspan(1);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph(tareaDefProc.getDescripcion(), this.valoresFont));
                cell.setColspan(3);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Tipo:", this.camposFont));
                cell.setColspan(1);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph(tareaDefProc.getTareaEnFase().getTarea().getTrTipoTarea().toString(), this.valoresFont));
                cell.setColspan(3);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Tipo", this.camposFont));
                cell.setColspan(1);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Etiqueta", this.camposFont));
                cell.setColspan(1);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                cell.setColspan(2);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Etiqueta larga", this.camposFont));
                cell.setColspan(2);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("V\u00e1lida", this.camposFont));
                cell.setColspan(1);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph("Obligatoria", this.camposFont));
                cell.setColspan(1);
                table.addCell(cell);
                if (tareaDefProc.getTareaEnFase().getTarea().getTrTipoTarea() == TrTipoTarea.MANIPULAR_DATOS) {
                    cell = new PdfPCell(this.tareaManipular);
                } else if (tareaDefProc.getTareaEnFase().getTarea().getTrTipoTarea() == TrTipoTarea.GENERAR_DOCUMENTO) {
                    bMultiple = false;
                    if (tareaDefProc.getTareaEnFase().getTarea() instanceof TrDocumentoPermitido && ((TrDocumentoPermitido)tareaDefProc.getTareaEnFase().getTarea()).getTipoDocumento() != null && ((TrDocumentoPermitido)tareaDefProc.getTareaEnFase().getTarea()).getTipoDocumento().isMultiple()) {
                        bMultiple = true;
                    }
                    cell = bMultiple ? new PdfPCell(this.tareaGenerarMultiple) : new PdfPCell(this.tareaGenerar);
                } else if (tareaDefProc.getTareaEnFase().getTarea().getTrTipoTarea() == TrTipoTarea.INCORPORAR_DOCUMENTO) {
                    bMultiple = false;
                    if (tareaDefProc.getTareaEnFase().getTarea() instanceof TrDocumentoPermitido && ((TrDocumentoPermitido)tareaDefProc.getTareaEnFase().getTarea()).getTipoDocumento() != null && ((TrDocumentoPermitido)tareaDefProc.getTareaEnFase().getTarea()).getTipoDocumento().isMultiple()) {
                        bMultiple = true;
                    }
                    cell = bMultiple ? new PdfPCell(this.tareaIncorporarMultiple) : new PdfPCell(this.tareaIncorporar);
                } else {
                    cell = tareaDefProc.getTareaEnFase().getTarea().getTrTipoTarea() == TrTipoTarea.OTROS ? new PdfPCell(this.tareaOtros) : new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont));
                }
                cell.setColspan(1);
                cell.setMinimumHeight(35.0f);
                cell.setHorizontalAlignment(1);
                cell.setVerticalAlignment(5);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph(tareaDefProc.getTareaEnFase().getETIQUETA(), this.valoresFont));
                cell.setColspan(1);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph(tareaDefProc.getDescripcion(), this.valoresFont));
                cell.setColspan(2);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph(tareaDefProc.getTareaEnFase().getETIQUETALARGA(), this.valoresFont));
                cell.setColspan(2);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph(tareaDefProc.getTareaEnFase().getValidaToString(), this.valoresFont));
                cell.setColspan(1);
                table.addCell(cell);
                cell = new PdfPCell((Phrase)new Paragraph(tareaDefProc.getTareaEnFase().getObligatoriaToString(), this.valoresFont));
                cell.setColspan(1);
                table.addCell(cell);
                if (tareaDefProc.getTareaEnFase().getTareaLlamante() != null) {
                    cell = new PdfPCell((Phrase)new Paragraph("Nombre y descripci\u00f3n tarea llamante", this.camposFont));
                    cell.setColspan(3);
                    table.addCell(cell);
                    Phrase fraseTareaLlamante = new Phrase();
                    fraseTareaLlamante.add((Object)new Paragraph(tareaDefProc.getTareaEnFase().getTareaLlamante().getNOMBRE(), this.valoresFont));
                    fraseTareaLlamante.add((Object)new Paragraph(" - ", this.valoresFont));
                    fraseTareaLlamante.add((Object)new Paragraph(tareaDefProc.getTareaEnFase().getTareaLlamante().getDESCRIPCION(), this.valoresFont));
                    cell = new PdfPCell(fraseTareaLlamante);
                    cell.setColspan(5);
                    table.addCell(cell);
                }
                boolean bVisualizarPerfiles = false;
                bVisualizarPerfiles = ModelaConf.getParametrosInformeGuia().isPerfilTarea();
                if (bVisualizarPerfiles && tareaDefProc.getConjuntoPerfilesTareaFase() != null && tareaDefProc.getConjuntoPerfilesTareaFase().getListaDatos() != null && tareaDefProc.getConjuntoPerfilesTareaFase().getListaDatos().size() > 0) {
                    TrPerfilTareaFase perfil = null;
                    cell = new PdfPCell((Phrase)new Paragraph("Perfiles", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Perfil", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                    cell.setColspan(4);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Permiso", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    ConjuntoDatos perfilesOrdenados = tareaDefProc.getConjuntoPerfilesTareaFase();
                    perfilesOrdenados.ordenar();
                    ArrayList listaPerfiles = perfilesOrdenados.getListaDatos();
                    for (int j = 0; j < listaPerfiles.size(); ++j) {
                        perfil = (TrPerfilTareaFase)listaPerfiles.get(j);
                        if (perfil == null) continue;
                        cell = new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = perfil.getNombre() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (perfil.getNombre().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(perfil.getNombre(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = perfil.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (perfil.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(perfil.getDescripcion(), this.valoresFont)));
                        cell.setColspan(4);
                        table.addCell(cell);
                        cell = perfil.getPermisoToString() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (perfil.getPermisoToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(perfil.getPermisoToString(), this.valoresFont)));
                        cell.setColspan(2);
                        table.addCell(cell);
                    }
                }
                boolean bVisualizarAcciones = false;
                bVisualizarAcciones = ModelaConf.getParametrosInformeGuia().isAccionTarea();
                if (bVisualizarAcciones && tareaDefProc.getConjuntoAccionTareaFase() != null && tareaDefProc.getConjuntoAccionTareaFase().getListaDatos() != null && tareaDefProc.getConjuntoAccionTareaFase().getListaDatos().size() > 0) {
                    TrAccionTareaFase accion = null;
                    cell = new PdfPCell((Phrase)new Paragraph("Acciones", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Acci\u00f3n", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                    cell.setColspan(4);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("V\u00e1lida", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Comprobar", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    ConjuntoDatos accionesOrdenados = tareaDefProc.getConjuntoAccionTareaFase();
                    accionesOrdenados.ordenar();
                    ArrayList listaAcciones = accionesOrdenados.getListaDatos();
                    for (int j = 0; j < listaAcciones.size(); ++j) {
                        accion = (TrAccionTareaFase)listaAcciones.get(j);
                        if (accion == null) continue;
                        cell = new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = accion.getNombre() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (accion.getNombre().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(accion.getNombre(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = accion.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (accion.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(accion.getDescripcion(), this.valoresFont)));
                        cell.setColspan(4);
                        table.addCell(cell);
                        cell = accion.isValidaToString() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (accion.isValidaToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(accion.getValidaToString(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = accion.getComprobarToString() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (accion.getComprobarToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(accion.getComprobarToString(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                    }
                }
                boolean bVisualizarCondiciones = false;
                bVisualizarCondiciones = ModelaConf.getParametrosInformeGuia().isCondicionTarea();
                if (bVisualizarCondiciones && tareaDefProc.getConjuntoCondicionTareaFase() != null && tareaDefProc.getConjuntoCondicionTareaFase().getListaDatos() != null && tareaDefProc.getConjuntoCondicionTareaFase().getListaDatos().size() > 0) {
                    TrCondicionTareaFase condicion = null;
                    cell = new PdfPCell((Phrase)new Paragraph("Condiciones", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Condici\u00f3n", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                    cell.setColspan(3);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("V\u00e1lida", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Obligatoria", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Comprobar", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    ConjuntoDatos condicionesOrdenados = tareaDefProc.getConjuntoCondicionTareaFase();
                    condicionesOrdenados.ordenar();
                    ArrayList listaCondiciones = condicionesOrdenados.getListaDatos();
                    for (int j = 0; j < listaCondiciones.size(); ++j) {
                        condicion = (TrCondicionTareaFase)listaCondiciones.get(j);
                        if (condicion == null) continue;
                        cell = new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = condicion.getNombre() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (condicion.getNombre().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(condicion.getNombre(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = condicion.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (condicion.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(condicion.getDescripcion(), this.valoresFont)));
                        cell.setColspan(3);
                        table.addCell(cell);
                        cell = condicion.getValidaToString() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (condicion.getValidaToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(condicion.getValidaToString(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = condicion.getObligatoriaToString() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (condicion.getObligatoriaToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(condicion.getObligatoriaToString(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = condicion.getComprobarToString() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (condicion.getComprobarToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(condicion.getComprobarToString(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                    }
                }
                boolean bVisualizarAvisos = false;
                bVisualizarAvisos = ModelaConf.getParametrosInformeGuia().isAvisoTarea();
                if (bVisualizarAvisos && tareaDefProc.getConjuntoAvisoTareaFase() != null && tareaDefProc.getConjuntoAvisoTareaFase().getListaDatos() != null && tareaDefProc.getConjuntoAvisoTareaFase().getListaDatos().size() > 0) {
                    TrAvisoTareaFase aviso = null;
                    cell = new PdfPCell((Phrase)new Paragraph("Avisos", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Aviso", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                    cell.setColspan(4);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("V\u00e1lida", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Comprobar", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    ConjuntoDatos avisosOrdenados = tareaDefProc.getConjuntoAvisoTareaFase();
                    avisosOrdenados.ordenar();
                    ArrayList listaAvisos = avisosOrdenados.getListaDatos();
                    for (int j = 0; j < listaAvisos.size(); ++j) {
                        aviso = (TrAvisoTareaFase)listaAvisos.get(j);
                        if (aviso == null) continue;
                        cell = new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = aviso.getNombre() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (aviso.getNombre().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(aviso.getNombre(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = aviso.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (aviso.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(aviso.getDescripcion(), this.valoresFont)));
                        cell.setColspan(4);
                        table.addCell(cell);
                        cell = aviso.getValidaToString() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (aviso.getValidaToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(aviso.getValidaToString(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                        cell = aviso.getComprobarToString() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (aviso.getComprobarToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(aviso.getComprobarToString(), this.valoresFont)));
                        cell.setColspan(1);
                        table.addCell(cell);
                    }
                }
                boolean bVisualizarPlazos = false;
                bVisualizarPlazos = ModelaConf.getParametrosInformeGuia().isMostrarPlazosTareas();
                if (bVisualizarPlazos && tareaDefProc.getPlazoSimple() != null && tareaDefProc.getPlazoSimple() != null) {
                    TrPlazoSimple plazo = tareaDefProc.getPlazoSimple();
                    cell = new PdfPCell((Phrase)new Paragraph("Plazo Simple", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("N\u00famero de unidades", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Unidad", this.camposFont));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph("Descripci\u00f3n", this.camposFont));
                    cell.setColspan(3);
                    table.addCell(cell);
                    cell = new PdfPCell((Phrase)new Paragraph(" ", this.camposFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    String strUnidades = String.valueOf(plazo.getNumUnidades());
                    cell = new PdfPCell((Phrase)new Paragraph(strUnidades, this.valoresFont));
                    cell.setColspan(2);
                    table.addCell(cell);
                    cell = plazo.getUnidadesToString() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (plazo.getUnidadesToString().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(plazo.getUnidadesToString(), this.valoresFont)));
                    cell.setColspan(1);
                    table.addCell(cell);
                    cell = plazo.getDescripcion() == null ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : (plazo.getDescripcion().equals("") ? new PdfPCell((Phrase)new Paragraph(" ", this.valoresFont)) : new PdfPCell((Phrase)new Paragraph(plazo.getDescripcion(), this.valoresFont)));
                    cell.setColspan(3);
                    table.addCell(cell);
                }
                table.setWidthPercentage(100.0f);
                document.add((Element)table);
            }
        }
        catch (DocumentException de) {
            System.err.println(de.getMessage());
        }
    }
}

