/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.informes;

import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.excontrols.CreadorButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import modela.ui.ModelaUI;

public class PrintPreview
extends JDialog {
    private static final long serialVersionUID = -7252258313109585556L;
    ImageIcon imprimirIconN = new ImageIcon(PrintPreview.class.getResource(ModelaUI.IMG_PRINT_IMPRIMIR));
    ImageIcon imprimirIconS = new ImageIcon(PrintPreview.class.getResource(ModelaUI.IMG_PRINT_IMPRIMIR_SOBRE));
    ImageIcon imprimirIconD = new ImageIcon(PrintPreview.class.getResource(ModelaUI.IMG_PRINT_IMPRIMIR_NO_ENABLED));
    ImageIcon salirIconN = new ImageIcon(PrintPreview.class.getResource(ModelaUI.IMG_PRINT_SALIR));
    ImageIcon salirIconS = new ImageIcon(PrintPreview.class.getResource(ModelaUI.IMG_PRINT_SALIR_SOBRE));
    ImageIcon salirIconD = new ImageIcon(PrintPreview.class.getResource(ModelaUI.IMG_PRINT_SALIR_NO_ENABLED));
    protected int m_wPage;
    protected int m_hPage;
    protected Printable m_target;
    protected JComboBox m_cbScale;
    protected PreviewContainer m_preview;

    public PrintPreview(Printable target, String title) {
        this.setTitle(title);
        this.m_target = target;
        this.m_preview = new PreviewContainer();
        this.prepararDisenio();
        this.prepararVistaPreliminar();
        this.setVisible(true);
    }

    private void prepararDisenio() {
        this.setDefaultCloseOperation(2);
        this.setSize(585, 400);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        JPanel tb = new JPanel();
        JButton bt = (JButton)CreadorButton.crearBoton(1, false, this.imprimirIconN, this.imprimirIconD, this.imprimirIconS, this.imprimirIconS);
        ActionListener lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    PrinterJob prnJob = PrinterJob.getPrinterJob();
                    prnJob.setPrintable(PrintPreview.this.m_target);
                    PrintPreview.this.setCursor(Cursor.getPredefinedCursor(3));
                    prnJob.print();
                    PrintPreview.this.setCursor(Cursor.getPredefinedCursor(0));
                    PrintPreview.this.dispose();
                }
                catch (PrinterException ex) {
                    ex.printStackTrace();
                    System.err.println("Error durante la impresi\u00f3n: " + ex.toString());
                }
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(4, 6, 4, 6));
        tb.setLayout(new XYLayout());
        tb.add((Component)bt, new XYConstraints(315, 2, 120, 30));
        bt = (JButton)CreadorButton.crearBoton(1, false, this.salirIconN, this.salirIconD, this.salirIconS, this.salirIconS);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PrintPreview.this.dispose();
            }
        };
        bt.addActionListener(lst);
        bt.setAlignmentY(0.5f);
        bt.setMargin(new Insets(2, 6, 2, 6));
        tb.add((Component)bt, new XYConstraints(445, 2, 120, 30));
        String[] scales = new String[]{"10 %", "25 %", "50 %", "75 %", "100 %"};
        this.m_cbScale = new JComboBox<String>(scales);
        lst = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Thread runner = new Thread(){

                    public void run() {
                        String str = (this).PrintPreview.this.m_cbScale.getSelectedItem().toString();
                        if (str.endsWith("%")) {
                            str = str.substring(0, str.length() - 1);
                        }
                        str = str.trim();
                        int scale = 0;
                        try {
                            scale = Integer.parseInt(str);
                        }
                        catch (NumberFormatException ex) {
                            return;
                        }
                        int w = (this).PrintPreview.this.m_wPage * scale / 100;
                        int h = (this).PrintPreview.this.m_hPage * scale / 100;
                        Component[] comps = (this).PrintPreview.this.m_preview.getComponents();
                        for (int k = 0; k < comps.length; ++k) {
                            if (!(comps[k] instanceof PagePreview)) continue;
                            PagePreview pp = (PagePreview)comps[k];
                            pp.setScaledSize(w, h);
                        }
                        (this).PrintPreview.this.m_preview.doLayout();
                        (this).PrintPreview.this.m_preview.getParent().getParent().validate();
                    }
                };
                runner.start();
            }
        };
        this.m_cbScale.addActionListener(lst);
        this.m_cbScale.setMaximumSize(this.m_cbScale.getPreferredSize());
        this.m_cbScale.setEditable(true);
        JLabel labelScala = new JLabel("Zoom: ");
        tb.add((Component)labelScala, new XYConstraints(10, 3, 55, 25));
        tb.add((Component)this.m_cbScale, new XYConstraints(55, 3, 80, 25));
        this.getContentPane().add((Component)tb, "South");
        JScrollPane ps = new JScrollPane(this.m_preview);
        this.getContentPane().add((Component)ps, "Center");
    }

    private void prepararVistaPreliminar() {
        PrinterJob prnJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = prnJob.defaultPage();
        if (pageFormat.getHeight() == 0.0 || pageFormat.getWidth() == 0.0) {
            System.err.println("Imposible determinar el tipo de papel por defecto");
            return;
        }
        this.m_wPage = (int)pageFormat.getWidth();
        this.m_hPage = (int)pageFormat.getHeight();
        int scale = 10;
        int w = this.m_wPage * scale / 100;
        int h = this.m_hPage * scale / 100;
        int pageIndex = 0;
        try {
            while (true) {
                BufferedImage img = new BufferedImage(this.m_wPage, this.m_hPage, 1);
                Graphics g = img.getGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.m_wPage, this.m_hPage);
                if (this.m_target.print(g, pageFormat, pageIndex) == 0) {
                    PagePreview pp = new PagePreview(w, h, img);
                    this.m_preview.add(pp);
                    ++pageIndex;
                    continue;
                }
                break;
            }
        }
        catch (PrinterException e) {
            e.printStackTrace();
            System.err.println("Error durante la impresi\u00f3n: " + e.toString());
        }
    }

    class PagePreview
    extends JPanel {
        private static final long serialVersionUID = -3281618377582503582L;
        protected int m_w;
        protected int m_h;
        protected Image m_source;
        protected Image m_img;

        public PagePreview(int w, int h, Image source) {
            this.m_w = w;
            this.m_h = h;
            this.m_source = source;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.m_img.flush();
            this.setBackground(Color.white);
            this.setBorder(new MatteBorder(1, 1, 2, 2, Color.black));
        }

        public void setScaledSize(int w, int h) {
            this.m_w = w;
            this.m_h = h;
            this.m_img = this.m_source.getScaledInstance(this.m_w, this.m_h, 4);
            this.repaint();
        }

        public Dimension getPreferredSize() {
            Insets ins = this.getInsets();
            return new Dimension(this.m_w + ins.left + ins.right, this.m_h + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paint(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.drawImage(this.m_img, 0, 0, this);
            this.paintBorder(g);
        }
    }

    class PreviewContainer
    extends JPanel {
        private static final long serialVersionUID = -7501024201456988333L;
        protected int H_GAP = 1;
        protected int V_GAP = 1;

        PreviewContainer() {
        }

        public Dimension getPreferredSize() {
            int n = this.getComponentCount();
            if (n == 0) {
                return new Dimension(this.H_GAP, this.V_GAP);
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int ww = nCol * (w + this.H_GAP) + this.H_GAP;
            int hh = nRow * (h + this.V_GAP) + this.V_GAP;
            Insets ins = this.getInsets();
            return new Dimension(ww + ins.left + ins.right, hh + ins.top + ins.bottom);
        }

        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void doLayout() {
            Insets ins = this.getInsets();
            int x = ins.left + this.H_GAP;
            int y = ins.top + this.V_GAP;
            int n = this.getComponentCount();
            if (n == 0) {
                return;
            }
            Component comp = this.getComponent(0);
            Dimension dc = comp.getPreferredSize();
            int w = dc.width;
            int h = dc.height;
            Dimension dp = this.getParent().getSize();
            int nCol = Math.max((dp.width - this.H_GAP) / (w + this.H_GAP), 1);
            int nRow = n / nCol;
            if (nRow * nCol < n) {
                ++nRow;
            }
            int index = 0;
            for (int k = 0; k < nRow; ++k) {
                for (int m = 0; m < nCol; ++m) {
                    if (index >= n) {
                        return;
                    }
                    comp = this.getComponent(index++);
                    comp.setBounds(x, y, w, h);
                    x += w + this.H_GAP;
                }
                y += h + this.V_GAP;
                x = ins.left + this.H_GAP;
            }
        }
    }
}

