/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo;

import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.swing.PScrollPane;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import modela.ui.piccolo.PCanvasModela;

public class PScrollCanvas
extends PScrollPane
implements MouseWheelListener {
    private static final long serialVersionUID = 3449800128118301175L;
    private PCanvasModela canvasAsociado;
    private final int EXTENSION_VISTA_MINIMA = 30;
    private final long EXTENSION_VISTA_MAXIMA = 30000L;

    public PScrollCanvas() {
        this.canvasAsociado = null;
        this.addMouseWheelListener(this);
    }

    public PScrollCanvas(Component param1) {
        super(param1);
        if (param1 instanceof PCanvasModela) {
            this.canvasAsociado = (PCanvasModela)((Object)param1);
        }
        this.addMouseWheelListener(this);
    }

    public void setCanvas(PCanvasModela pCanvas) {
        this.canvasAsociado = pCanvas;
    }

    public PCanvasModela getCanvas() {
        return this.canvasAsociado;
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (this.canvasAsociado == null) {
            return;
        }
        if ((e.getModifiers() & 2) == 0) {
            return;
        }
        PBounds viewBounds = this.canvasAsociado.getCamera().getViewBounds();
        PBounds newBound = new PBounds();
        double nExtW = viewBounds.getSize().getWidth();
        double nExtH = viewBounds.getSize().getHeight();
        int notches = e.getWheelRotation();
        if (notches < 0) {
            nExtW /= 6.0;
            nExtH /= 6.0;
            if (nExtW < (double)this.EXTENSION_VISTA_MINIMA) {
                return;
            }
            if (nExtH < (double)this.EXTENSION_VISTA_MINIMA) {
                return;
            }
            newBound.setRect(viewBounds.getCenter2D().getX() - 2.0 * nExtW, viewBounds.getCenter2D().getY() - 2.0 * nExtH, 4.0 * nExtW, 4.0 * nExtH);
        } else {
            nExtW /= 4.0;
            nExtH /= 4.0;
            this.getClass();
            if (nExtW > 30000.0) {
                return;
            }
            this.getClass();
            if (nExtH > 30000.0) {
                return;
            }
            newBound.setRect(viewBounds.getOrigin().getX() - nExtW, viewBounds.getOrigin().getY() - nExtH, viewBounds.getSize().getWidth() + 2.0 * nExtW, viewBounds.getSize().getHeight() + 2.0 * nExtH);
        }
        this.canvasAsociado.getCamera().animateViewToCenterBounds((Rectangle2D)newBound, true, 0L);
    }
}

