/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.handlers;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import modela.conf.ModelaConf;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.events.GraficoGeneradoEvent;
import modela.ui.piccolo.events.GraficoGeneradoListener;
import modela.ui.piccolo.handlers.PGrTransicionEventHandler;
import modela.ui.piccolo.nodes.EventoSalidaPNode;
import modela.ui.piccolo.nodes.EventoSinSalidaPNode;
import modela.ui.piccolo.nodes.FasePNode;
import modela.ui.piccolo.nodes.InicioPNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.PostItPNode;
import modela.ui.piccolo.nodes.TransicionPNode;

public class EventoCreationEventHandler
extends PGrTransicionEventHandler {
    public static final int TIPO_EVENTO_ES = 1;
    public static final int TIPO_EVENTO_EN = 2;
    public static final int TIPO_EVENTO_INICIO = 3;
    private int nTipoEvento;
    protected TransicionPNode tr;
    protected PNodoGrafico faseGIni;
    protected FasePNode faseGFin;
    private TransicionPNode trNew = null;
    private Point2D pInicial;
    private transient ArrayList GraficoGeneradoListeners = new ArrayList(2);

    public EventoCreationEventHandler(int nNuevoTipo, PNode param1, PNode param2, PCanvasModela pCanvas) {
        super(param1, param2, pCanvas);
        this.setTipoEvento(nNuevoTipo);
        this.faseGIni = null;
        this.faseGFin = null;
        this.tr = null;
        this.trNew = null;
        this.pInicial = null;
    }

    public void setTipoEvento(int nNuevoTipo) {
        switch (nNuevoTipo) {
            case 1: 
            case 2: 
            case 3: {
                this.nTipoEvento = nNuevoTipo;
                break;
            }
            default: {
                this.nTipoEvento = 1;
            }
        }
    }

    public int getTipoEvento() {
        return this.nTipoEvento;
    }

    public void cancelarProceso(PInputEvent e) {
        this.eliminarPath();
        this.eliminarLayer(e);
        this.pInicial = null;
        this.trNew = null;
    }

    public void mouseMoved(PInputEvent e) {
        if (this.trNew == null) {
            return;
        }
        this.faseGIni.repaint();
        this.trNew.updateBounds();
        this.trNew.repaint();
        this.dragPoint = e.getPosition();
        this.updateRectangle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mousePressed(PInputEvent e) {
        Point2D pActual = null;
        if (e.getButton() == 3) {
            this.cancelarProceso(e);
            return;
        }
        if (e.getButton() != 1) return;
        this.eliminarPath();
        this.pressPoint = e.getPosition();
        if (e.getClickCount() > 1) {
            GraficoGeneradoEvent ggE;
            if (e.getPickedNode() instanceof PNodoGrafico && !(e.getPickedNode() instanceof PostItPNode)) {
                if (this.trNew == null) {
                    return;
                }
                if (this.trNew.getTrTransicion() != null) {
                    PNode evaluarFinal = e.getPickedNode();
                    if ((this.trNew.getTrTransicion().getTIPO().equals("I") || this.trNew.getTrTransicion().getTIPO().equals("EN") || this.trNew.getTrTransicion().getTIPO().equals("ES")) && !(evaluarFinal instanceof FasePNode)) {
                        this.cancelarProceso(e);
                        return;
                    }
                }
                this.faseGFin = (FasePNode)e.getPickedNode();
                this.trNew.setPNodoGraficoFaseFin(this.faseGFin);
                if (this.faseGIni.getTrFaseGrAsociada() != null && this.faseGFin.getTrFaseGrAsociada() != null) {
                    this.faseGIni.getTrFaseGrAsociada().setTrFase(this.faseGFin.getTrFaseGrAsociada().getTrFase());
                }
                System.out.println("- [ Info ] Transici\u00f3n creada: " + this.trNew);
                this.trNew.setPickable(true);
                ModelaConf.setCreacionRapidaTransiciones(false);
                if ((e.getModifiers() & 2) != 0) {
                    ModelaConf.setCreacionRapidaTransiciones(true);
                }
                ggE = new GraficoGeneradoEvent((Object)this);
                switch (this.nTipoEvento) {
                    case 2: {
                        ggE.setTipo(6);
                        break;
                    }
                    case 3: {
                        ggE.setTipo(7);
                        break;
                    }
                    default: {
                        ggE.setTipo(5);
                    }
                }
            } else {
                this.cancelarProceso(e);
                return;
            }
            ggE.setGraficoGenerado(this.trNew);
            this.fireGraficoGenerado(ggE);
            this.cancelarProceso(e);
            return;
        }
        pActual = e.getPosition();
        this.crearPath(e);
        if (this.trNew == null) {
            if (e.getPickedNode() instanceof PNodoGrafico) return;
            switch (this.nTipoEvento) {
                case 2: {
                    this.trNew = new TransicionPNode("EN", this.getCanvas());
                    this.trNew.setPickable(false);
                    this.faseGIni = new EventoSinSalidaPNode(this.getCanvas());
                    break;
                }
                case 3: {
                    this.trNew = new TransicionPNode("I", this.getCanvas());
                    this.trNew.setPickable(false);
                    this.faseGIni = new InicioPNode(this.getCanvas());
                    break;
                }
                default: {
                    this.trNew = new TransicionPNode("ES", this.getCanvas());
                    this.trNew.setPickable(false);
                    this.faseGIni = new EventoSalidaPNode(this.getCanvas());
                }
            }
            this.crearLayer(e);
            this.crearPath(e);
            this.pInicial = pActual;
            this.trNew.setPNodoGraficoFaseIni(this.faseGIni);
            this.layer.addChild((PNode)this.trNew);
            this.layer.addChild((PNode)this.faseGIni);
            this.faseGIni.centerBoundsOnPoint(pActual.getX() + this.faseGIni.getBounds().getWidth() / 2.0 + 1.0, pActual.getY());
            this.trNew.getPoints2D().addElement(this.pInicial.clone());
            this.trNew.updateBounds();
            this.faseGIni.repaint();
            return;
        } else if (this.trNew != null) {
            this.trNew.getPoints2D().addElement(pActual.clone());
            this.trNew.updateBounds();
            this.trNew.repaint();
            return;
        } else {
            this.cancelarProceso(e);
            return;
        }
    }

    public synchronized void addGraficoGeneradoListener(GraficoGeneradoListener l) {
        if (!this.GraficoGeneradoListeners.contains(l)) {
            this.GraficoGeneradoListeners.add(l);
        }
    }

    public synchronized void removeGraficoGeneradoListener(GraficoGeneradoListener l) {
        this.GraficoGeneradoListeners.remove(l);
    }

    protected void fireGraficoGenerado(GraficoGeneradoEvent e) {
        List listeners = (List)this.GraficoGeneradoListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((GraficoGeneradoListener)listeners.get(i)).obtenerGraficoGenerado(e);
        }
    }
}

