/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.handlers;

import edu.umd.cs.piccolo.PLayer;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.util.PPaintContext;
import gdtel.ui.graf.grafobjects.FlechaShp;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.handlers.PSelectionEventHandlerEx;

public class PGrTransicionEventHandler
extends PSelectionEventHandlerEx {
    protected Point2D pressPoint;
    protected Point2D dragPoint;
    protected PPath rectangle;
    protected PLayer layer = null;
    protected PCanvasModela canvas = null;

    public PGrTransicionEventHandler(PNode param1, PNode param2, PCanvasModela pCanvas) {
        super(param1, param2);
        this.canvas = pCanvas;
        this.dragPoint = null;
        this.pressPoint = null;
        this.rectangle = null;
        this.layer = null;
    }

    public PCanvasModela getCanvas() {
        return this.canvas;
    }

    public void updateRectangle() {
        if (this.pressPoint != null && this.rectangle != null && this.dragPoint != null) {
            Point2D[] arrPt = new Point2D[]{this.pressPoint, this.dragPoint};
            this.rectangle.setPathToPolyline(arrPt);
            PPaintContext pPaint = PPaintContext.CURRENT_PAINT_CONTEXT;
            FlechaShp flecha = new FlechaShp();
            flecha.setTipo(2);
            flecha.dibujar(this.pressPoint, this.dragPoint, pPaint.getGraphics());
        }
    }

    public boolean crearPath(PInputEvent e) {
        if (this.layer == null) {
            return false;
        }
        this.rectangle = new PPath();
        this.rectangle.setStroke((Stroke)new BasicStroke((float)(1.0 / e.getCamera().getViewScale())));
        this.layer.addChild((PNode)this.rectangle);
        return true;
    }

    public void eliminarPath() {
        if (this.layer != null && this.rectangle != null) {
            this.layer.removeChild((PNode)this.rectangle);
        }
        this.rectangle = null;
        this.dragPoint = null;
        this.pressPoint = null;
    }

    public boolean crearLayer(PInputEvent e) {
        this.layer = new PLayer();
        e.getCamera().addLayer(this.layer);
        return true;
    }

    public void eliminarLayer(PInputEvent e) {
        if (this.layer != null) {
            e.getCamera().removeLayer(this.layer);
            this.layer = null;
        }
    }
}

