/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.handlers;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import modela.conf.ModelaConf;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.events.GraficoGeneradoEvent;
import modela.ui.piccolo.events.GraficoGeneradoListener;
import modela.ui.piccolo.handlers.PGrTransicionEventHandler;
import modela.ui.piccolo.nodes.DivisionPNode;
import modela.ui.piccolo.nodes.FasePNode;
import modela.ui.piccolo.nodes.InicioPNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.PostItPNode;
import modela.ui.piccolo.nodes.TransicionPNode;
import modela.ui.piccolo.nodes.UnionPNode;

public class TransicionCreationEventHandler
extends PGrTransicionEventHandler {
    protected TransicionPNode tr = null;
    protected PNodoGrafico faseGIni = null;
    protected PNodoGrafico faseGFin = null;
    private TransicionPNode trNew = null;
    protected Point2D pInicial = null;
    protected Point2D pFinal = null;
    private transient ArrayList GraficoGeneradoListeners = new ArrayList(2);

    public TransicionCreationEventHandler(PNode param1, PNode param2, PCanvasModela pCanvas) {
        super(param1, param2, pCanvas);
    }

    public void cancelarProceso(PInputEvent e) {
        this.eliminarPath();
        this.eliminarLayer(e);
        this.pInicial = null;
        this.pFinal = null;
        this.trNew = null;
    }

    public void mouseMoved(PInputEvent e) {
        if (this.trNew == null) {
            return;
        }
        this.dragPoint = e.getPosition();
        this.updateRectangle();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void mousePressed(PInputEvent e) {
        Point2D pActual = null;
        if (e.getButton() == 3) {
            this.cancelarProceso(e);
            return;
        }
        if (e.getButton() != 1) return;
        this.eliminarPath();
        this.pressPoint = e.getPosition();
        if (e.getClickCount() > 1) {
            if (e.getPickedNode() instanceof PNodoGrafico && !(e.getPickedNode() instanceof PostItPNode)) {
                if (this.trNew == null) {
                    return;
                }
                this.faseGFin = (PNodoGrafico)e.getPickedNode();
                if (!(this.faseGFin instanceof FasePNode) && !(this.faseGFin instanceof UnionPNode)) {
                    System.out.println("- [ Alerta ] La transici\u00f3n no finaliz\u00f3 en un elemento gr\u00e1fico correcto");
                    this.cancelarProceso(e);
                    return;
                }
                if (this.faseGIni instanceof DivisionPNode) {
                    if (!(this.faseGFin instanceof FasePNode)) {
                        System.out.println("- [ Alerta ] Una transici\u00f3n de divisi\u00f3n tiene que terminar en un gr\u00e1fico de fase");
                        this.cancelarProceso(e);
                        return;
                    }
                    FasePNode pFaseFin = (FasePNode)this.faseGFin;
                    DivisionPNode pDivIni = (DivisionPNode)this.faseGIni;
                    if (pFaseFin.getTrFaseGrAsociada().equals(pDivIni.getTrFaseGrAsociada())) {
                        System.out.println("- [ Alerta ] Una transici\u00f3n de divisi\u00f3n no puede terminar en la fase de origen");
                        this.cancelarProceso(e);
                        return;
                    }
                } else if (this.faseGIni instanceof InicioPNode) {
                    if (!(this.faseGFin instanceof FasePNode)) {
                        System.out.println("- [ Alerta ] Una transici\u00f3n de inicio tiene que terminar en un gr\u00e1fico de fase");
                        this.cancelarProceso(e);
                        return;
                    }
                } else {
                    if (!(this.faseGIni instanceof FasePNode)) {
                        System.out.println("- [ Alerta ] Una transici\u00f3n de divisi\u00f3n tiene que terminar en un gr\u00e1fico de fase");
                        this.cancelarProceso(e);
                        return;
                    }
                    if (this.faseGFin instanceof UnionPNode) {
                        FasePNode pFaseIni = (FasePNode)this.faseGIni;
                        UnionPNode pUnionFin = (UnionPNode)this.faseGFin;
                        if (pFaseIni.getTrFaseGrAsociada().equals(pUnionFin.getTrFaseGrAsociada())) {
                            System.out.println("- [ Alerta ] Una transici\u00f3n de uni\u00f3n no puede provenir de la fase de uni\u00f3n");
                            this.cancelarProceso(e);
                            return;
                        }
                    }
                }
                this.pFinal = e.getPosition();
                this.trNew.setPNodoGraficoFaseFin(this.faseGFin);
                System.out.println("- [ Info ] Transici\u00f3n creada: " + this.trNew);
                this.trNew.setPickable(true);
                ModelaConf.setCreacionRapidaTransiciones(false);
                if ((e.getModifiers() & 2) != 0) {
                    ModelaConf.setCreacionRapidaTransiciones(true);
                }
                GraficoGeneradoEvent ggE = new GraficoGeneradoEvent((Object)this);
                ggE.setTipo(2);
                ggE.setGraficoGenerado(this.trNew);
                this.fireGraficoGenerado(ggE);
                this.cancelarProceso(e);
                return;
            }
            this.cancelarProceso(e);
            return;
        }
        pActual = e.getPosition();
        this.crearPath(e);
        if (e.getPickedNode() instanceof PNodoGrafico && !(e.getPickedNode() instanceof PostItPNode)) {
            if (this.trNew != null) {
                this.cancelarProceso(e);
                return;
            }
            this.faseGIni = (PNodoGrafico)e.getPickedNode();
            if (!(this.faseGIni instanceof FasePNode) && !(this.faseGIni instanceof DivisionPNode)) {
                this.pFinal = null;
                this.faseGFin = null;
                this.faseGIni = null;
                return;
            }
            this.trNew = new TransicionPNode("N", this.getCanvas());
            this.trNew.setPickable(false);
            this.crearLayer(e);
            this.crearPath(e);
            this.trNew.setPNodoGraficoFaseIni(this.faseGIni);
            this.pInicial = pActual;
            this.pFinal = null;
            this.faseGFin = null;
            this.layer.addChild((PNode)this.trNew);
            this.trNew.getPoints2D().addElement(this.pInicial.clone());
            this.trNew.updateBounds();
            return;
        }
        if (this.trNew != null) {
            this.trNew.getPoints2D().addElement(pActual.clone());
            this.trNew.updateBounds();
            this.trNew.repaint();
            return;
        }
        this.cancelarProceso(e);
    }

    public synchronized void addGraficoGeneradoListener(GraficoGeneradoListener l) {
        if (!this.GraficoGeneradoListeners.contains(l)) {
            this.GraficoGeneradoListeners.add(l);
        }
    }

    public synchronized void removeGraficoGeneradoListener(GraficoGeneradoListener l) {
        this.GraficoGeneradoListeners.remove(l);
    }

    protected void fireGraficoGenerado(GraficoGeneradoEvent e) {
        List listeners = (List)this.GraficoGeneradoListeners.clone();
        int count = listeners.size();
        for (int i = 0; i < count; ++i) {
            ((GraficoGeneradoListener)listeners.get(i)).obtenerGraficoGenerado(e);
        }
    }
}

