/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.nodes;

import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import gdtel.ui.graf.grafobjects.FlechaShp;
import gdtel.ui.piccolo.AccionPCanvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import modela.bd.obj.TrFaseGr;
import modela.conf.ModelaConf;
import modela.ui.ModelaUI;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.nodes.ImagenPNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.TransicionPNode;

public class EventoSinSalidaPNode
extends PNodoGrafico {
    private static final long serialVersionUID = 6279794347116787072L;

    public EventoSinSalidaPNode(PCanvasModela pCanvas) {
        this.sTipo = "EN";
        this.canvas = pCanvas;
        this.transicionesEntrada = new ArrayList();
        this.transicionesSalida = new ArrayList();
        this.colorFondo = Color.white;
        this.colorTexto = Color.black;
        this.colorBorde = Color.black;
        this.faseGraficaAsociada = new TrFaseGr();
        this.sTexto = "EN";
        this.imagenNodo = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_NODO_EVENTO_EN)).getImage();
        this.setBounds(120.0, 120.0, 55.0, 53.0);
        this.addListeners();
    }

    public EventoSinSalidaPNode(TrFaseGr nuevaFase, PCanvasModela pCanvas) {
        this.sTipo = "EN";
        this.canvas = pCanvas;
        this.transicionesEntrada = new ArrayList();
        this.transicionesSalida = new ArrayList();
        this.colorFondo = Color.white;
        this.colorTexto = Color.black;
        this.colorBorde = Color.black;
        this.faseGraficaAsociada = nuevaFase;
        this.sTexto = "EN";
        this.imagenNodo = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_NODO_EVENTO_EN)).getImage();
        if (nuevaFase != null) {
            this.inicializarBounds(nuevaFase.getX(), nuevaFase.getY(), nuevaFase.getAncho(), nuevaFase.getAlto());
        } else {
            this.inicializarBounds();
        }
        this.addListeners();
    }

    private void addListeners() {
        this.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent myEvent) {
                EventoSinSalidaPNode.this.onRightClick(myEvent);
            }

            public void mouseMoved(PInputEvent event) {
            }

            public void mouseExited(PInputEvent e) {
            }
        });
    }

    public void onRightClick(PInputEvent e) {
        if (e.getButton() == 3 && !(e.getPickedNode() instanceof ImagenPNode) && this.canvas.getAccionActual() == AccionPCanvas.ACCION_SEL && this.crearPopupMenu() && !this.popup.isVisible()) {
            Point2D p = e.getCanvasPosition();
            this.popup.show((JComponent)e.getComponent(), (int)p.getX(), (int)p.getY());
        }
    }

    public String toString() {
        if (this.faseGraficaAsociada == null) {
            return "Gr\u00e1fico de Evento No Salida (Sin Fase Asociada)";
        }
        if (this.faseGraficaAsociada.getTrFase() == null) {
            return "Gr\u00e1fico de Evento No Salida (Sin Fase Asociada)";
        }
        return "Gr\u00e1fico Evento No Salida (" + this.faseGraficaAsociada.getTrFase().toString() + ")";
    }

    protected void paint(PPaintContext paintContext) {
        try {
            PBounds clipActual;
            PBounds xyAndSizeFase = this.getBounds();
            Graphics2D g2 = paintContext.getGraphics();
            g2.setStroke(this.stroke);
            g2.setClip(null);
            if (this.canvas != null && (clipActual = this.canvas.getClipActual()) != null && this.canvas.isImprimiendo()) {
                g2.setClip((int)clipActual.getX() - 10, (int)clipActual.getY() - 10, (int)clipActual.getWidth() + 10, (int)clipActual.getHeight() + 10);
            }
            if (ModelaConf.getMostrarNodosClasicos()) {
                this.drawGraficoEN(xyAndSizeFase, g2);
            } else {
                this.drawImagenGraficoEN(g2);
            }
            g2.setClip(null);
            this.setBounds((Rectangle2D)this.getBounds());
            this.reposicionarGraficosAsociados();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addTransicionEntrada(TransicionPNode trPNode) {
        this.transicionesEntrada.add(trPNode);
    }

    public void addTransicionSalida(TransicionPNode trPNode) {
        this.transicionesSalida.add(trPNode);
    }

    private void drawGraficoEN(PBounds limitesFase, Graphics2D contextoGrafico) {
        if (this.colorFondo == null) {
            this.colorFondo = Color.white;
        }
        contextoGrafico.setPaint(this.colorFondo);
        contextoGrafico.setPaintMode();
        contextoGrafico.fillOval((int)limitesFase.getOrigin().getX(), (int)limitesFase.getOrigin().getY(), (int)limitesFase.getSize().getWidth(), (int)limitesFase.getSize().getHeight());
        if (this.colorBorde == null) {
            this.colorBorde = Color.black;
        }
        contextoGrafico.setPaint(this.colorBorde);
        contextoGrafico.setPaintMode();
        contextoGrafico.drawOval((int)limitesFase.getOrigin().getX(), (int)limitesFase.getOrigin().getY(), (int)limitesFase.getSize().getWidth(), (int)limitesFase.getSize().getHeight());
        this.sizeFuenteTexto = (int)Math.sqrt(limitesFase.getSize().getWidth() * limitesFase.getSize().getWidth()) / 2;
        contextoGrafico.setFont(new Font("Arial", 0, this.sizeFuenteTexto));
        FontMetrics fm = contextoGrafico.getFontMetrics();
        this.nFontHeight = fm.getAscent();
        this.posXTexto = (int)limitesFase.getCenter2D().getX() - (int)fm.getStringBounds(this.sTexto, contextoGrafico).getBounds().getWidth() / 2;
        this.posYTexto = (int)limitesFase.getCenter2D().getY() + this.nFontHeight / 2;
        if (this.colorTexto == null) {
            this.colorTexto = Color.black;
        }
        contextoGrafico.setPaint(this.colorTexto);
        contextoGrafico.setPaintMode();
        contextoGrafico.setClip((int)this.getBounds().getX(), (int)this.getBounds().getY(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight());
        contextoGrafico.drawString(this.sTexto, this.posXTexto, this.posYTexto);
        int[] xPoints = new int[4];
        int[] yPoints = new int[4];
        xPoints[0] = (int)limitesFase.x + (int)limitesFase.width / 4 * 3;
        yPoints[0] = (int)limitesFase.y;
        xPoints[1] = (int)limitesFase.x + (int)limitesFase.width / 4;
        yPoints[1] = (int)limitesFase.y + (int)limitesFase.height / 2;
        xPoints[2] = (int)limitesFase.x + (int)limitesFase.width / 4 * 3;
        yPoints[2] = (int)limitesFase.y + (int)limitesFase.height / 2;
        xPoints[3] = (int)limitesFase.x + (int)limitesFase.width / 4;
        yPoints[3] = (int)limitesFase.y + (int)limitesFase.height;
        contextoGrafico.setPaint(Color.RED);
        contextoGrafico.setPaintMode();
        contextoGrafico.drawPolyline(xPoints, yPoints, 4);
        FlechaShp flecha = new FlechaShp();
        flecha.setColor(Color.RED);
        flecha.setTipo(2);
        Point2D.Double ptIni = new Point2D.Double();
        Point2D.Double ptFin = new Point2D.Double();
        ptIni.setLocation(xPoints[2], yPoints[2]);
        ptFin.setLocation(xPoints[3], yPoints[3]);
        flecha.dibujar(ptIni, ptFin, contextoGrafico);
    }

    private void drawImagenGraficoEN(Graphics2D contextoGrafico) {
        if (this.colorBorde == null) {
            this.colorBorde = Color.black;
        }
        contextoGrafico.setPaint(this.colorBorde);
        contextoGrafico.setPaintMode();
        contextoGrafico.drawOval((int)this.getBounds().getOrigin().getX() - 1, (int)this.getBounds().getOrigin().getY() - 1, (int)this.getBounds().getSize().getWidth() + 2, (int)this.getBounds().getSize().getHeight() + 2);
        contextoGrafico.drawImage(this.imagenNodo, (int)this.getBounds().getX(), (int)this.getBounds().getY(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight(), null);
    }

    public PCanvasModela getCanvas() {
        return this.canvas;
    }
}

