/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolox.event.PSelectionEventHandler;
import gdtel.ui.piccolo.AccionPCanvas;
import gdtel.ui.piccolo.activities.PParpadeoActivity;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import modela.bd.obj.TrFaseGr;
import modela.conf.ModelaConf;
import modela.graf.CodificadorAtributosXML;
import modela.graf.CreadorXMLDefProc;
import modela.ui.ModelaUI;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.nodes.ImagenPNode;
import modela.ui.piccolo.nodes.PNodoGrafico;

public class PostItPNode
extends PNodoGrafico {
    private static final long serialVersionUID = -2741637145115557300L;
    protected PNodoGrafico pNodoGraficoAsociado;
    private JMenuItem menuEliminarGr = null;
    Image imagenNodoAsociado;
    private final int nAnchoPorDefecto = 75;
    private final int nAltoPorDefecto = 75;
    boolean bCalcularDistancia = true;
    double xDistancia = 0.0;
    double yDistancia = 0.0;

    public PostItPNode(PCanvasModela pCanvas) {
        this.jbInit(pCanvas);
    }

    public PostItPNode(PCanvasModela pCanvas, PNodoGrafico nodoAsociado) {
        this.jbInit(pCanvas);
        this.setPNodoGraficoAsociado(nodoAsociado);
        this.posicionarInicialmente();
    }

    private void jbInit(PCanvasModela pCanvas) {
        this.sTipo = "PI";
        this.canvas = pCanvas;
        this.transicionesEntrada = new ArrayList();
        this.transicionesSalida = new ArrayList();
        this.colorFondo = Color.white;
        this.colorTexto = Color.black;
        this.colorBorde = Color.black;
        this.faseGraficaAsociada = new TrFaseGr();
        this.sTexto = "...";
        this.sizeFuenteTexto = 10;
        this.bEnEdicion = false;
        this.pNodoGraficoAsociado = null;
        this.imagenNodo = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_NODO_POST_IT)).getImage();
        this.imagenNodoAsociado = new ImageIcon(this.getClass().getResource(ModelaUI.IMG_NODO_POST_IT_ASOCIADO)).getImage();
        this.bCalcularDistancia = true;
        this.posicionarInicialmente();
        this.addListeners();
    }

    private void addListeners() {
        this.addInputEventListener((PInputEventListener)new PBasicInputEventHandler(){

            public void mousePressed(PInputEvent myEvent) {
                PostItPNode.this.onRightClick(myEvent);
            }

            public void mouseMoved(PInputEvent event) {
            }

            public void mouseExited(PInputEvent e) {
            }
        });
    }

    public void onRightClick(PInputEvent e) {
        if (e.getButton() == 3) {
            if (this.canvas.getAccionActual() == AccionPCanvas.ACCION_SEL && this.crearPopupMenu() && !this.popup.isVisible()) {
                Point2D p = e.getCanvasPosition();
                this.popup.show((JComponent)e.getComponent(), (int)p.getX(), (int)p.getY());
            }
        } else if (e.getButton() == 1 && e.getClickCount() > 1 && !(e.getPickedNode() instanceof ImagenPNode) && this.canvas.getAccionActual() == AccionPCanvas.ACCION_SEL) {
            this.editarTextoPostIt();
        }
    }

    public boolean crearPopupMenu() {
        super.crearPopupMenu();
        this.menuEliminarGr = new JMenuItem("Eliminar");
        this.menuEliminarGr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                PostItPNode.this.canvas.eliminarPostItSeleccionados();
            }
        });
        this.popup.add((Component)this.menuEliminarGr, 0);
        this.popup.add((Component)new JSeparator(), 1);
        this.popup.getComponent(this.popup.getComponentCount() - 2).setVisible(false);
        this.menuAddPostIt.setVisible(false);
        return true;
    }

    public void eliminarPopupMenu() {
        super.eliminarPopupMenu();
        ActionListener[] actionListener = null;
        int nActions = 0;
        int i = 0;
        this.popup = null;
        if (this.menuEliminarGr != null) {
            actionListener = this.menuEliminarGr.getActionListeners();
            nActions = actionListener.length;
            for (i = 0; i < nActions; ++i) {
                this.menuEliminarGr.removeActionListener(actionListener[i]);
            }
            this.menuEliminarGr = null;
        }
    }

    public String toString() {
        return "Nota r\u00e1pida Post It";
    }

    protected void paint(PPaintContext paintContext) {
        if (ModelaConf.getMostrarPostIt()) {
            try {
                PBounds clipActual;
                this.setPickable(true);
                PBounds xyAndSizeFase = this.getBounds();
                Graphics2D g2 = paintContext.getGraphics();
                g2.setStroke(this.stroke);
                g2.setClip(null);
                if (this.canvas != null && (clipActual = this.canvas.getClipActual()) != null && this.canvas.isImprimiendo()) {
                    g2.setClip((int)clipActual.getX() - 10, (int)clipActual.getY() - 10, (int)clipActual.getWidth() + 10, (int)clipActual.getHeight() + 10);
                }
                this.drawImagenGraficoPostIt(g2);
                this.drawTextoPostIt(xyAndSizeFase, g2);
                g2.setClip(null);
                this.setBounds((Rectangle2D)this.getBounds());
                if (this.bEnEdicion) {
                    this.posicionarTextEdit();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else {
            if (this.canvas.getSelectionEventHandler() != null && this.canvas.getSelectionEventHandler() instanceof PSelectionEventHandler) {
                ((PSelectionEventHandler)this.canvas.getSelectionEventHandler()).undecorateSelectedNode((PNode)this);
            }
            this.setPickable(false);
        }
    }

    private void drawImagenGraficoPostIt(Graphics2D contextoGrafico) {
        if (this.pNodoGraficoAsociado == null) {
            contextoGrafico.drawImage(this.imagenNodo, (int)this.getBounds().getX(), (int)this.getBounds().getY(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight(), null);
        } else {
            contextoGrafico.drawImage(this.imagenNodoAsociado, (int)this.getBounds().getX(), (int)this.getBounds().getY(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight(), null);
        }
    }

    private void drawTextoPostIt(PBounds limitesFase, Graphics2D contextoGrafico) {
        contextoGrafico.setFont(ModelaConf.getFuentePostIt());
        FontMetrics fm = contextoGrafico.getFontMetrics();
        this.nFontHeight = fm.getAscent();
        Rectangle2D rectTexto = fm.getStringBounds(this.sTexto, contextoGrafico);
        int posXText = (int)limitesFase.getCenter2D().getX() - (int)rectTexto.getBounds().getWidth() / 2;
        int posYText = (int)limitesFase.getCenter2D().getY() + this.nFontHeight / 2;
        contextoGrafico.setClip((int)this.getBounds().getX(), (int)this.getBounds().getY(), (int)this.getBounds().getWidth(), (int)this.getBounds().getHeight());
        if (this.colorTexto == null) {
            this.colorTexto = Color.black;
        }
        contextoGrafico.setPaint(this.colorTexto);
        contextoGrafico.setPaintMode();
        this.drawCadena(contextoGrafico, this.sTexto, posXText, posYText);
        contextoGrafico.setClip(null);
    }

    private void drawCadena(Graphics2D contexto, String cadena, int posX, int posY) {
        if (contexto == null || cadena == null) {
            return;
        }
        if (contexto.getClip() == null) {
            return;
        }
        this.arrPalabras = new ArrayList();
        this.arrLongitudSegmento = new ArrayList();
        this.arrLineas = new ArrayList();
        FontMetrics fmCadena = contexto.getFontMetrics();
        Rectangle2D rectTextoCadena = fmCadena.getStringBounds(cadena, contexto);
        if (contexto.getClip().getBounds().getWidth() > rectTextoCadena.getWidth()) {
            contexto.drawString(cadena, posX, posY);
            return;
        }
        this.arrPalabras.clear();
        String strAuxPalabras = cadena;
        String strPalabra = "";
        int posEspacioBlanco = strAuxPalabras.indexOf(" ");
        while (posEspacioBlanco >= 0) {
            strPalabra = strAuxPalabras.substring(0, posEspacioBlanco);
            strAuxPalabras = strAuxPalabras.substring(posEspacioBlanco + 1, strAuxPalabras.length());
            posEspacioBlanco = strAuxPalabras.indexOf(" ");
            this.arrPalabras.add(strPalabra);
        }
        this.arrPalabras.add(strAuxPalabras);
        String strAux = "";
        int nPalabra = 0;
        this.arrLongitudSegmento.clear();
        Integer nLongitudSegmento = new Integer(0);
        boolean espacioEnBlanco = false;
        boolean bSalirWhile = true;
        boolean bLineaPorPalabra = false;
        while (nPalabra < this.arrPalabras.size()) {
            if (nPalabra == 0 || espacioEnBlanco) {
                strAux = (String)this.arrPalabras.get(nPalabra);
                espacioEnBlanco = false;
            } else {
                strAux = strAux + " " + (String)this.arrPalabras.get(nPalabra);
            }
            rectTextoCadena = fmCadena.getStringBounds(strAux, contexto);
            if (contexto.getClip().getBounds().getWidth() >= rectTextoCadena.getWidth()) {
                nLongitudSegmento = new Integer(strAux.length());
                ++nPalabra;
                bSalirWhile = false;
                continue;
            }
            if (!bSalirWhile) {
                this.arrLongitudSegmento.add(nLongitudSegmento);
                espacioEnBlanco = true;
                bSalirWhile = true;
                continue;
            }
            bLineaPorPalabra = true;
            break;
        }
        this.arrLineas.clear();
        if (!bLineaPorPalabra) {
            this.arrLongitudSegmento.add(nLongitudSegmento);
            int nInicioCorte = 0;
            int nFinCorte = 0;
            String segmentoAux = "";
            nInicioCorte = 0;
            nFinCorte = 0;
            for (int n = 0; n < this.arrLongitudSegmento.size(); ++n) {
                nFinCorte = nInicioCorte + (Integer)this.arrLongitudSegmento.get(n);
                segmentoAux = cadena.substring(nInicioCorte, nFinCorte);
                this.arrLineas.add(segmentoAux);
                nInicioCorte = nFinCorte + 1;
            }
        } else {
            this.arrLineas.clear();
            for (int p = 0; p < this.arrPalabras.size(); ++p) {
                this.arrLineas.add(this.arrPalabras.get(p));
            }
        }
        if (this.arrLineas.size() > 1) {
            int posXLinea = posX;
            int posYLinea = posY - fmCadena.getAscent() * this.arrLineas.size() / 2 + fmCadena.getAscent() / this.arrLineas.size();
            int nAnchoLineaEnPantalla = 0;
            String strLineaAEscribir = "";
            for (int nLinea = 0; nLinea < this.arrLineas.size(); ++nLinea) {
                strLineaAEscribir = (String)this.arrLineas.get(nLinea);
                strLineaAEscribir = strLineaAEscribir.trim();
                nAnchoLineaEnPantalla = (int)fmCadena.getStringBounds(strLineaAEscribir, contexto).getWidth();
                posXLinea = (int)this.getBounds().getCenter2D().getX() - nAnchoLineaEnPantalla / 2;
                contexto.drawString(strLineaAEscribir, posXLinea, posYLinea);
                posYLinea += fmCadena.getAscent();
            }
        } else {
            contexto.drawString(cadena, posX, posY);
        }
    }

    public void editarTextoPostIt() {
        this.bEnEdicion = true;
        this.textEdit = new JFiltroTextField();
        this.textEdit.setCambiarColorAlModificar(false);
        this.textEdit.setFont(ModelaConf.getFuentePostIt().deriveFont(this.nSizeLetraEdicion));
        this.textEdit.establecerTipografia(2);
        this.textEdit.setTipoFiltro(1);
        this.textEdit.setNumItems(500);
        this.textEdit.setHorizontalAlignment(0);
        this.textEdit.setText(this.sTexto);
        if (this.pNodoGraficoAsociado == null) {
            this.textEdit.setBackground(new Color(248, 240, 133));
        } else {
            this.textEdit.setBackground(new Color(248, 177, 133));
        }
        this.textEdit.setForeground(Color.BLACK);
        this.textEdit.setVisible(true);
        this.posicionarTextEdit();
        this.textEdit.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent anEvent) {
                if (anEvent.getKeyChar() == '\n') {
                    PostItPNode.this.aplicarNuevoTexto();
                } else if (anEvent.getKeyChar() == '\u001b') {
                    PostItPNode.this.cancelarEdicionPostIt();
                }
            }
        });
        this.textEdit.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                PostItPNode.this.aplicarNuevoTexto();
            }
        });
        this.canvas.add(this.textEdit);
        if (this.textEdit != null) {
            this.textEdit.requestFocus();
            this.textEdit.selectAll();
        }
    }

    private void posicionarTextEdit() {
        if (!this.bEnEdicion) {
            return;
        }
        if (this.textEdit == null) {
            return;
        }
        double posXtextEdit = this.getGlobalBounds().getX();
        double posYtextEdit = this.getGlobalBounds().getOrigin().getY();
        double altoTextEdit = this.getGlobalBounds().getY() + (double)((int)this.getGlobalBounds().getHeight()) - posYtextEdit;
        double anchoTextEdit = this.getGlobalBounds().getWidth();
        double gbX = posXtextEdit - this.canvas.getCamera().getViewBounds().getOrigin().getX();
        double vbX = this.canvas.getCamera().getViewBounds().getWidth();
        double dAncho = this.canvas.getWidth();
        posXtextEdit = gbX * dAncho / vbX;
        double gbY = posYtextEdit - this.canvas.getCamera().getViewBounds().getOrigin().getY();
        double vbY = this.canvas.getCamera().getViewBounds().getHeight();
        double dAlto = this.canvas.getHeight();
        posYtextEdit = gbY * dAlto / vbY;
        if ((anchoTextEdit = (double)((int)(anchoTextEdit * this.canvas.getCamera().getViewScale()))) * (altoTextEdit = (double)((int)(altoTextEdit * this.canvas.getCamera().getViewScale()))) < 2500.0) {
            if (anchoTextEdit < 50.0) {
                anchoTextEdit = 50.0;
            }
            if (altoTextEdit < 50.0) {
                altoTextEdit = 50.0;
            }
        }
        this.textEdit.setBounds((int)posXtextEdit + 1, (int)posYtextEdit, (int)anchoTextEdit - 1, (int)altoTextEdit);
    }

    protected void cancelarEdicionPostIt() {
        for (int nC = 0; nC < this.canvas.getComponents().length; ++nC) {
            if (!(this.canvas.getComponent(nC) instanceof JTextField)) continue;
            this.canvas.remove(nC);
        }
        this.textEdit = null;
        this.canvas.repaint();
        this.bEnEdicion = false;
    }

    protected void aplicarNuevoTexto() {
        if (this.textEdit != null && this.textEdit.getText() != null) {
            this.sTexto = this.textEdit.getText();
        }
        this.canvas.graficoModificado(this);
        this.cancelarEdicionPostIt();
    }

    public void eliminar() {
        if (this.pNodoGraficoAsociado != null) {
            this.pNodoGraficoAsociado.removePostIt(this);
        }
        this.marcarNodoGraficoAsociado(false);
        this.canvas.eliminarPNodoGrafico(this);
    }

    public void setPNodoGraficoAsociado(PNodoGrafico nodoAsociado) {
        this.pNodoGraficoAsociado = nodoAsociado;
    }

    public PNodoGrafico getPNodoGraficoAsociado() {
        return this.pNodoGraficoAsociado;
    }

    public void posicionarInicialmente() {
        long posXAux = 100L;
        long posYAux = 100L;
        if (this.pNodoGraficoAsociado != null) {
            if (this.pNodoGraficoAsociado.arrPostItAsociados != null && this.pNodoGraficoAsociado.arrPostItAsociados.size() > 0) {
                posXAux = (int)(((PostItPNode)this.pNodoGraficoAsociado.arrPostItAsociados.get(this.pNodoGraficoAsociado.arrPostItAsociados.size() - 1)).getGlobalBounds().getX() + 10.0);
                posYAux = (int)(((PostItPNode)this.pNodoGraficoAsociado.arrPostItAsociados.get(this.pNodoGraficoAsociado.arrPostItAsociados.size() - 1)).getGlobalBounds().getY() + 10.0);
            } else {
                posXAux = (long)(this.pNodoGraficoAsociado.getGlobalBounds().getX() + this.pNodoGraficoAsociado.getGlobalBounds().getWidth() + 5.0);
                posYAux = (long)this.pNodoGraficoAsociado.getGlobalBounds().getY();
            }
        }
        double d = posXAux;
        double d2 = posYAux;
        this.getClass();
        this.getClass();
        this.setBounds(d, d2, 75.0, 75.0);
    }

    public void marcarNodoGraficoAsociado(boolean pMarcar) {
        if (this.pNodoGraficoAsociado == null) {
            return;
        }
        if (this.canvas == null) {
            return;
        }
        if (pMarcar) {
            if (this.pNodoGraficoAsociado.getNumNotasActualmenteSeleccionadas() < 1) {
                this.canvas.aplicarEstilo(this.pNodoGraficoAsociado, this.canvas.EFECTO_PARPADEO, -1L, PParpadeoActivity.APLICAR_A_BORDE);
                this.pNodoGraficoAsociado.stroke = new BasicStroke(2.0f, 1, 1);
            }
            this.pNodoGraficoAsociado.actualizarNumNotasActualmenteSeleccionadas(1);
        } else {
            if (this.pNodoGraficoAsociado.getNumNotasActualmenteSeleccionadas() < 2) {
                this.canvas.eliminarEstilo(this.pNodoGraficoAsociado);
                this.pNodoGraficoAsociado.stroke = new BasicStroke(1.0f, 1, 1);
            }
            this.pNodoGraficoAsociado.actualizarNumNotasActualmenteSeleccionadas(-1);
        }
    }

    public void readaptarBounds() {
        if (this.pNodoGraficoAsociado == null) {
            return;
        }
        double margenIzquierdo = 0.0;
        double margenDerecho = 0.0;
        double margenSuperior = 0.0;
        double margenInferior = 0.0;
        double xParaPostIt = 0.0;
        double yParaPostIt = 0.0;
        margenIzquierdo = this.pNodoGraficoAsociado.getGlobalBounds().getX();
        margenDerecho = margenIzquierdo + this.pNodoGraficoAsociado.getGlobalBounds().getWidth();
        margenSuperior = this.pNodoGraficoAsociado.getGlobalBounds().getY();
        margenInferior = margenSuperior + this.pNodoGraficoAsociado.getGlobalBounds().getHeight();
        if (this.bCalcularDistancia) {
            this.xDistancia = (this.getGlobalBounds().getX() - margenIzquierdo) / (margenDerecho - margenIzquierdo) * 100.0;
            this.yDistancia = (this.getGlobalBounds().getY() - margenSuperior) / (margenInferior - margenSuperior) * 100.0;
            this.bCalcularDistancia = false;
        }
        xParaPostIt = margenIzquierdo + this.xDistancia * (margenDerecho - margenIzquierdo) / 100.0;
        yParaPostIt = margenSuperior + this.yDistancia * (margenInferior - margenSuperior) / 100.0;
        this.setX(xParaPostIt);
        this.setY(yParaPostIt);
        this.repaint();
    }

    public String toXMLCabecera() {
        String strXML = null;
        if (this.faseGraficaAsociada == null) {
            return null;
        }
        if (this.faseGraficaAsociada.getID() == null) {
            return null;
        }
        strXML = "<POST_IT id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.faseGraficaAsociada.getID().longValue())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        if (this.pNodoGraficoAsociado != null) {
            strXML = strXML + " nodo_asociado_id=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf(String.valueOf(this.pNodoGraficoAsociado.getTrFaseGrAsociada().getID())) + CreadorXMLDefProc.COMILLAS_DOBLES;
        }
        strXML = strXML + " texto=" + CreadorXMLDefProc.COMILLAS_DOBLES + CodificadorAtributosXML.codificar(this.sTexto) + CreadorXMLDefProc.COMILLAS_DOBLES;
        PBounds bounds = this.getFullBounds();
        Point2D pt = bounds.getOrigin();
        Dimension2D dim = bounds.getSize();
        strXML = strXML + " xizq=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf((long)pt.getX()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " yarr=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf((long)pt.getY()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " ancho=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf((long)dim.getWidth()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + " alto=" + CreadorXMLDefProc.COMILLAS_DOBLES + String.valueOf((long)dim.getHeight()) + CreadorXMLDefProc.COMILLAS_DOBLES;
        strXML = strXML + "/>";
        return strXML;
    }
}

