/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JFiltroTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import modela.bd.obj.TrCondicion;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.SeleccionCondicionesJDialog;

public class GeneradorCondicionesJDialog
extends JDialog
implements ContainerListener,
KeyListener {
    private static final long serialVersionUID = 8154492481854117749L;
    private DDPGrafico grafico = null;
    private final XYLayout xYLayout = new XYLayout();
    JFiltroTextArea decripTextArea = new JFiltroTextArea();
    protected JButton yBtn = new JButton();
    protected JButton oBtn = new JButton();
    protected JButton abrirParentesisBtn = new JButton();
    protected JButton cerrarParentesisBtn = new JButton();
    ImageIcon seleccionarIconN = new ImageIcon(GeneradorCondicionesJDialog.class.getResource(ModelaUI.IMG_SMALL_SELECCION));
    ImageIcon seleccionarIconS = new ImageIcon(GeneradorCondicionesJDialog.class.getResource(ModelaUI.IMG_SMALL_SELECCION_SOBRE));
    ImageIcon seleccionarIconD = new ImageIcon(GeneradorCondicionesJDialog.class.getResource(ModelaUI.IMG_SMALL_SELECCION_NO_ENABLED));
    private final JButton seleccionarBtn = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconD, this.seleccionarIconS, this.seleccionarIconS);
    ImageIcon aceptarIconN = new ImageIcon(GeneradorCondicionesJDialog.class.getResource(ModelaUI.IMG_SMALL_APLICAR));
    ImageIcon aceptarIconS = new ImageIcon(GeneradorCondicionesJDialog.class.getResource(ModelaUI.IMG_SMALL_APLICAR_SOBRE));
    JButton aceptarBtn = (JButton)CreadorButton.crearBoton(1, false, this.aceptarIconN, this.aceptarIconN, this.aceptarIconS, this.aceptarIconS);
    ImageIcon cancelarIconN = new ImageIcon(GeneradorCondicionesJDialog.class.getResource(ModelaUI.IMG_SMALL_CANCELAR));
    ImageIcon cancelarIconS = new ImageIcon(GeneradorCondicionesJDialog.class.getResource(ModelaUI.IMG_SMALL_CANCELAR_SOBRE));
    JButton cancelarBtn = (JButton)CreadorButton.crearBoton(1, false, this.cancelarIconN, this.cancelarIconN, this.cancelarIconS, this.cancelarIconS);
    private String m_strExpresionGenerada = null;

    public GeneradorCondicionesJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        this.setSize(new Dimension(545, 520));
        this.setModal(true);
        this.setTitle("Generaci\u00f3n de condiciones complejas");
        this.getContentPane().setLayout(this.xYLayout);
        this.setResizable(false);
        this.setEnabled(true);
        this.setModal(true);
        this.decripTextArea.setNumItems(4000);
        this.setSize(536, 300);
        this.yBtn.setText("Y");
        this.yBtn.setFont(new Font("Tahoma", 1, 10));
        this.oBtn.setText("O");
        this.oBtn.setFont(new Font("Tahoma", 1, 10));
        this.abrirParentesisBtn.setText("(");
        this.abrirParentesisBtn.setFont(new Font("Tahoma", 1, 10));
        this.cerrarParentesisBtn.setText(")");
        this.cerrarParentesisBtn.setFont(new Font("Tahoma", 1, 10));
        this.seleccionarBtn.setFocusPainted(false);
        this.seleccionarBtn.setBorderPainted(false);
        this.aceptarBtn.setFocusPainted(false);
        this.aceptarBtn.setBorderPainted(false);
        this.cancelarBtn.setFocusPainted(false);
        this.cancelarBtn.setBorderPainted(false);
        this.getContentPane().add((Component)this.decripTextArea.getScrollableArea(), new XYConstraints(20, 20, 490, 200));
        this.getContentPane().add((Component)this.yBtn, new XYConstraints(20, 230, 45, 25));
        this.getContentPane().add((Component)this.oBtn, new XYConstraints(70, 230, 45, 25));
        this.getContentPane().add((Component)this.yBtn, new XYConstraints(20, 230, 45, 25));
        this.getContentPane().add((Component)this.oBtn, new XYConstraints(70, 230, 45, 25));
        this.getContentPane().add((Component)this.abrirParentesisBtn, new XYConstraints(120, 230, 45, 25));
        this.getContentPane().add((Component)this.cerrarParentesisBtn, new XYConstraints(170, 230, 45, 25));
        this.getContentPane().add((Component)this.seleccionarBtn, new XYConstraints(230, 233, 80, 21));
        this.getContentPane().add((Component)this.aceptarBtn, new XYConstraints(325, 233, 80, 21));
        this.getContentPane().add((Component)this.cancelarBtn, new XYConstraints(420, 233, 80, 21));
        this.yBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneradorCondicionesJDialog.this.addY();
                GeneradorCondicionesJDialog.this.decripTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.oBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneradorCondicionesJDialog.this.addO();
                GeneradorCondicionesJDialog.this.decripTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.abrirParentesisBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneradorCondicionesJDialog.this.addAbreParentesis();
                GeneradorCondicionesJDialog.this.decripTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.cerrarParentesisBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GeneradorCondicionesJDialog.this.addCierraParentesis();
                GeneradorCondicionesJDialog.this.decripTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
            }
        });
        this.aceptarBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneradorCondicionesJDialog.this.aceptarBtn_actionPerformed(e);
            }
        });
        this.cancelarBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneradorCondicionesJDialog.this.cancelarBtn_actionPerformed(e);
            }
        });
        this.seleccionarBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneradorCondicionesJDialog.this.seleccionarBtn_actionPerformed(e);
            }
        });
        this.decripTextArea.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                if (evt.getKeyChar() == '\t') {
                    GeneradorCondicionesJDialog.this.yBtn.requestFocus();
                }
            }
        });
        this.addKeyAndContainerListenerRecursively(this);
        ModelaConf.setVentanaActiva(this);
    }

    void addY() {
        String strContenido = this.decripTextArea.getText() + " Y ";
        this.decripTextArea.setText(strContenido);
    }

    void addO() {
        String strContenido = this.decripTextArea.getText() + " O ";
        this.decripTextArea.setText(strContenido);
    }

    void addAbreParentesis() {
        String strContenido = this.decripTextArea.getText() + "(";
        this.decripTextArea.setText(strContenido);
    }

    void addCierraParentesis() {
        String strContenido = this.decripTextArea.getText() + ")";
        this.decripTextArea.setText(strContenido);
    }

    public String getExpresion() {
        return this.m_strExpresionGenerada;
    }

    public void setExpresion(String strExpresion) {
        if (strExpresion != null) {
            this.decripTextArea.setText(strExpresion);
        }
    }

    public void aceptarBtn_actionPerformed(ActionEvent e) {
        this.m_strExpresionGenerada = this.decripTextArea.getText();
        this.dispose();
    }

    public void cancelarBtn_actionPerformed(ActionEvent e) {
        this.m_strExpresionGenerada = null;
        this.dispose();
    }

    public void seleccionarBtn_actionPerformed(ActionEvent e) {
        ArrayList listaCondiciones = null;
        if (this.grafico == null) {
            return;
        }
        if (this.grafico.getCondicionesInvolucradas() != null && this.grafico.getCondicionesInvolucradas().getListaDatos() != null) {
            listaCondiciones = this.grafico.getCondicionesInvolucradas().getListaDatos();
        }
        SeleccionCondicionesJDialog selCondJDialog = new SeleccionCondicionesJDialog();
        selCondJDialog.cargarTablaCondiciones(listaCondiciones);
        selCondJDialog.setLocationRelativeTo(this);
        selCondJDialog.setVisible(true);
        TrCondicion condicion = selCondJDialog.getCondicion();
        if (condicion != null) {
            String strContenido = "";
            Object[] options = new Object[]{"S\u00cd", "NO"};
            int n = JOptionPane.showOptionDialog(this, "\u00bfLa condici\u00f3n seleccionada es una condici\u00f3n v\u00e1lida?", "Atenci\u00f3n", 0, 3, null, options, options[1]);
            strContenido = n == 1 ? this.decripTextArea.getText() + "$$NO$$" + condicion.getNombre() + "$$" : this.decripTextArea.getText() + "$$" + condicion.getNombre() + "$$";
            this.decripTextArea.setText(strContenido);
            this.decripTextArea.setBackground(ModelaUI.colorFondoTextoModificandose);
        }
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.dispose();
        } else if (code == 10) {
            // empty if block
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }
}

