/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.conf.ConfigImpresion;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JCheckBoxEx;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import modela.conf.ModelaConf;
import modela.ui.ModelaUI;
import modela.ui.informes.PrintPreview;

public class ImpresionJPanel
extends JPanel
implements ContainerListener,
KeyListener {
    private static final long serialVersionUID = -5023718760602898318L;
    ImageIcon imprimirIconN = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_IMPRIMIR));
    ImageIcon imprimirIconS = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_IMPRIMIR_SOBRE));
    ImageIcon imprimirIconD = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_IMPRIMIR_NO_ENABLED));
    ImageIcon imprimirPreliminarIconN = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_IMPRIMIR));
    ImageIcon imprimirPreliminarIconS = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_IMPRIMIR_SOBRE));
    ImageIcon imprimirPreliminarIconD = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_IMPRIMIR_NO_ENABLED));
    ImageIcon configurarIconN = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_CONFIGURAR));
    ImageIcon configurarIconS = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_CONFIGURAR_SOBRE));
    ImageIcon configurarIconD = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_CONFIGURAR_NO_ENABLED));
    ImageIcon salirIconN = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_SALIR));
    ImageIcon salirIconS = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_SALIR_SOBRE));
    ImageIcon salirIconD = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_SALIR_NO_ENABLED));
    ImageIcon hojaVerticalIcon = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_HOJA_VERTICAL));
    ImageIcon hojaHorizontalIcon = new ImageIcon(ImpresionJPanel.class.getResource(ModelaUI.IMG_PRINT_HOJA_HORIZONTAL));
    JButton butVertical = (JButton)CreadorButton.crearBoton(1, false, this.hojaVerticalIcon, this.hojaVerticalIcon, this.hojaVerticalIcon, this.hojaVerticalIcon);
    JButton butHorizontal = (JButton)CreadorButton.crearBoton(1, false, this.hojaHorizontalIcon, this.hojaHorizontalIcon, this.hojaHorizontalIcon, this.hojaHorizontalIcon);
    private final JButton botonCerrar = (JButton)CreadorButton.crearBoton(1, false, this.salirIconN, this.salirIconD, this.salirIconS, this.salirIconS);
    private final JButton botonConf = (JButton)CreadorButton.crearBoton(1, false, this.configurarIconN, this.configurarIconD, this.configurarIconS, this.configurarIconS);
    private final JButton botonImprimir = (JButton)CreadorButton.crearBoton(1, false, this.imprimirIconN, this.imprimirIconD, this.imprimirIconS, this.imprimirIconS);
    private final JButton botonImprimirPreliminar = (JButton)CreadorButton.crearBoton(1, false, this.imprimirPreliminarIconN, this.imprimirPreliminarIconD, this.imprimirPreliminarIconS, this.imprimirPreliminarIconS);
    JDialog dialogConf = null;
    Printable printable = null;
    PageFormat pf = new PageFormat();
    private final XYLayout xYLayout1 = new XYLayout();
    JPanel panelOpciones = new JPanel();
    TitledBorder bordeOpciones = null;
    ButtonGroup grupoOpciones = null;
    JRadioButton opcionVistaActual = null;
    JRadioButton opcionVistaTotal = null;
    JCheckBox checkPaginable = null;
    JCheckBoxEx checkTitulo = null;
    JCheckBoxEx checkPiePag = null;
    boolean bPaginable = false;
    Component componenteReferente = null;

    public ImpresionJPanel(Printable printable) {
        try {
            this.printable = printable;
            this.bPaginable = false;
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void jbInit() throws Exception {
        this.xYLayout1.setWidth(300);
        this.xYLayout1.setHeight(240);
        this.setLayout(this.xYLayout1);
        this.butHorizontal.setEnabled(false);
        this.butVertical.setEnabled(false);
        this.pf = ConfigImpresion.setPageFormatDefault();
        if (ConfigImpresion.orientacion == 0) {
            this.butHorizontal.setVisible(true);
            this.butVertical.setVisible(false);
        } else {
            this.butHorizontal.setVisible(false);
            this.butVertical.setVisible(true);
        }
        this.botonCerrar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImpresionJPanel.this.dialogConf.setVisible(false);
                ImpresionJPanel.this.dialogConf = null;
            }
        });
        this.botonConf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImpresionJPanel.this.pf = ConfigImpresion.getPageFormat();
                if (ConfigImpresion.orientacion == 0) {
                    ImpresionJPanel.this.butHorizontal.setVisible(true);
                    ImpresionJPanel.this.butVertical.setVisible(false);
                } else {
                    ImpresionJPanel.this.butVertical.setVisible(true);
                    ImpresionJPanel.this.butHorizontal.setVisible(false);
                }
            }
        });
        this.botonImprimir.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImpresionJPanel.this.bPaginable = false;
                ImpresionJPanel.this.print();
            }
        });
        this.botonImprimirPreliminar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ImpresionJPanel.this.bPaginable = true;
                ImpresionJPanel.this.printPreliminar();
            }
        });
        this.botonImprimir.setBorderPainted(false);
        this.botonImprimir.setFocusPainted(false);
        this.botonImprimirPreliminar.setBorderPainted(false);
        this.botonImprimirPreliminar.setFocusPainted(false);
        this.botonCerrar.setBorderPainted(false);
        this.botonCerrar.setFocusPainted(false);
        this.botonConf.setBorderPainted(false);
        this.botonConf.setFocusPainted(false);
        this.butHorizontal.setBorderPainted(false);
        this.butHorizontal.setFocusPainted(false);
        this.butVertical.setBorderPainted(false);
        this.butVertical.setFocusPainted(false);
        this.bordeOpciones = new TitledBorder("");
        this.bordeOpciones.setTitleFont(ModelaUI.fuentePrincipalNegrita);
        this.opcionVistaActual = new JRadioButton("Vista actual");
        this.opcionVistaTotal = new JRadioButton("Vista total");
        this.opcionVistaActual.setFont(ModelaUI.fuentePrincipal);
        this.opcionVistaTotal.setFont(ModelaUI.fuentePrincipal);
        this.opcionVistaActual.setFocusPainted(false);
        this.opcionVistaTotal.setFocusPainted(false);
        this.grupoOpciones = new ButtonGroup();
        this.opcionVistaActual.setSelected(true);
        this.grupoOpciones.add(this.opcionVistaActual);
        this.grupoOpciones.add(this.opcionVistaTotal);
        this.panelOpciones.setBorder(this.bordeOpciones);
        this.panelOpciones.setLayout(new XYLayout());
        this.panelOpciones.add((Component)this.opcionVistaActual, new XYConstraints(3, 5, 105, 15));
        this.panelOpciones.add((Component)this.opcionVistaTotal, new XYConstraints(3, 27, 100, 15));
        this.checkPaginable = new JCheckBox("Paginable");
        this.checkPaginable.setFocusPainted(false);
        this.checkTitulo = new JCheckBoxEx();
        this.checkTitulo.setText("Imprimir t\u00edtulo en el documento");
        this.bordeOpciones.setTitleFont(ModelaUI.fuentePrincipalNegrita);
        this.checkPiePag = new JCheckBoxEx();
        this.checkPiePag.setText("Imprimir ruta fichero en el pie de p\u00e1g.");
        this.bordeOpciones.setTitleFont(ModelaUI.fuentePrincipalNegrita);
        this.add((Component)this.checkTitulo, new XYConstraints(12, 10, 220, 20));
        this.add((Component)this.checkPiePag, new XYConstraints(12, 35, 250, 20));
        this.add((Component)this.butHorizontal, new XYConstraints(149, 65, 100, 120));
        this.add((Component)this.butVertical, new XYConstraints(149, 65, 100, 120));
        this.add((Component)this.panelOpciones, new XYConstraints(10, 65, 120, 58));
        this.add((Component)this.botonConf, new XYConstraints(10, 130, 120, 30));
        this.add((Component)this.botonImprimir, new XYConstraints(10, 195, 120, 30));
        this.add((Component)this.botonCerrar, new XYConstraints(140, 195, 120, 30));
        this.addKeyAndContainerListenerRecursively(this);
        this.checkTitulo.setSelected(true);
    }

    public void mostrar() {
        this.dialogConf = new JDialog();
        this.dialogConf.setSize(275, 255);
        this.dialogConf.setResizable(false);
        this.dialogConf.getContentPane().add(this);
        ModelaConf.setVentanaActiva(this.dialogConf);
        this.dialogConf.setLocationRelativeTo(this.componenteReferente);
        this.dialogConf.setModal(true);
        this.dialogConf.setTitle("Impresi\u00f3n");
        this.dialogConf.setVisible(true);
    }

    public void print() {
        PrinterJob pJ = ConfigImpresion.getPrintJob();
        if (pJ.printDialog()) {
            try {
                pJ.setPrintable(this.printable, this.pf);
                pJ.print();
            }
            catch (PrinterException pe) {
                System.out.println("\u00b7 [ Error ] Imprimiendo: " + pe);
            }
        }
    }

    public void printPreliminar() {
        this.dialogConf.setVisible(false);
        this.dialogConf.dispose();
        this.dialogConf = null;
        Thread runner = new Thread(){

            public void run() {
                new PrintPreview(ImpresionJPanel.this.printable, "Vista preliminar");
            }
        };
        runner.start();
    }

    public boolean isVistaActual() {
        return this.opcionVistaActual.isSelected();
    }

    public boolean imprimirTitulo() {
        return this.checkTitulo.isSelected();
    }

    public boolean imprimirPiePagina() {
        return this.checkPiePag.isSelected();
    }

    public boolean isVistaTotal() {
        return this.opcionVistaTotal.isSelected();
    }

    public boolean isPaginable() {
        return this.bPaginable;
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.dialogConf.dispose();
        } else if (code == 10) {
            this.performEnterAction(e);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    void performEnterAction(KeyEvent e) {
    }

    public void ocultarButtonRuta() {
        this.checkPiePag.setVisible(false);
    }

    public void setComponenteRelativoPosicion(Component comp) {
        this.componenteReferente = comp;
    }
}

