/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.piccolo.activities.PParpadeoActivity;
import gdtel.ui.swing.bd.BotonesMantenimientoJPanel;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JTreePanelEx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrMetafase;
import modela.ui.ModelaUI;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.events.GraficoEliminadoEvent;
import modela.ui.piccolo.events.GraficoEliminadoListener;
import modela.ui.piccolo.events.GraficoGeneradoDisponibleEvent;
import modela.ui.piccolo.events.GraficoGeneradoDisponibleListener;
import modela.ui.piccolo.events.GraficoModificadoEvent;
import modela.ui.piccolo.events.GraficoModificadoListener;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.swing.renderers.LocalizadorTreeRenderer;

public class LocalizadorFasesJPanel
extends JPanel {
    private static final long serialVersionUID = -4327950024912753952L;
    PCanvasModela canvas = null;
    JTreePanelEx treeFases = null;
    JFiltroTextField textBusqueda = new JFiltroTextField();
    protected ImageIcon buscarIconN = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_BUSCAR_EN_LISTA));
    protected ImageIcon buscarIconS = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_BUSCAR_EN_LISTA_SOBRE));
    protected JButton busquedaButton = (JButton)CreadorButton.crearBoton(1, false, this.buscarIconN, this.buscarIconN, this.buscarIconS, this.buscarIconS);
    JLabel labelLista = new JLabel();
    PNodoGrafico faseSeleccionada = null;
    ImageIcon localizarIconN = new ImageIcon(LocalizadorFasesJPanel.class.getResource(ModelaUI.IMG_BOTON_LOCALIZAR_FASE));
    ImageIcon localizarIconS = new ImageIcon(LocalizadorFasesJPanel.class.getResource(ModelaUI.IMG_BOTON_LOCALIZAR_FASE_SOBRE));
    JButton btnLocalizar = (JButton)CreadorButton.crearBoton(1, false, this.localizarIconN, this.localizarIconN, this.localizarIconS, this.localizarIconS);
    private final Insets MARGEN_BOTONES = new Insets(-2, -3, -2, -3);
    public ArrayList arrDeNodos = null;
    boolean bAplicarParpadeo = true;
    boolean bCargadoArray = false;
    String textoAnterior = "";
    String textoABuscar = "";
    int indice = 1;

    public LocalizadorFasesJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LocalizadorFasesJPanel(PCanvasModela pCanvas) {
        try {
            this.setCanvas(pCanvas);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.prepararDisenio();
        this.addListeners();
        this.limpiarListaElementos();
        this.treeFases.getTree().setCellRenderer(new LocalizadorTreeRenderer());
        this.bAplicarParpadeo = true;
    }

    private void prepararDisenio() {
        this.setLayout(new GridBagLayout());
        this.labelLista.setText("Fases existentes y gr\u00e1ficos asociados");
        this.labelLista.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.labelLista.setForeground(ModelaUI.colorSeleccion);
        GridBagConstraints constraintsLabel = new GridBagConstraints();
        constraintsLabel.gridx = 0;
        constraintsLabel.gridy = 0;
        constraintsLabel.gridwidth = 2;
        constraintsLabel.gridheight = 1;
        constraintsLabel.weightx = 1.0;
        constraintsLabel.anchor = 17;
        constraintsLabel.insets = new Insets(9, 10, 0, 2);
        this.add((Component)this.labelLista, constraintsLabel);
        JPanel panelBusqueda = new JPanel();
        GridBagConstraints constraintsPanelBusqueda = new GridBagConstraints();
        constraintsPanelBusqueda.gridx = 0;
        constraintsPanelBusqueda.gridy = 1;
        constraintsPanelBusqueda.gridwidth = 2;
        constraintsPanelBusqueda.gridheight = 1;
        constraintsPanelBusqueda.weightx = 1.0;
        constraintsPanelBusqueda.fill = 2;
        panelBusqueda.setLayout(new GridBagLayout());
        GridBagConstraints constraintsTextoBusqueda = new GridBagConstraints();
        constraintsTextoBusqueda.gridx = 0;
        constraintsTextoBusqueda.gridy = 0;
        constraintsTextoBusqueda.gridwidth = 1;
        constraintsTextoBusqueda.gridheight = 1;
        constraintsTextoBusqueda.weightx = 1.0;
        constraintsTextoBusqueda.fill = 2;
        constraintsTextoBusqueda.insets = new Insets(8, 10, 0, 0);
        this.textBusqueda.setCambiarColorAlModificar(false);
        this.textBusqueda.setToolTipText("Texto a buscar");
        this.textBusqueda.setEditable(true);
        this.textBusqueda.establecerTipografia(1);
        this.textBusqueda.setNumItems(100);
        panelBusqueda.add((Component)this.textBusqueda, constraintsTextoBusqueda);
        this.busquedaButton.setPreferredSize(new Dimension(30, 21));
        GridBagConstraints constraintsBotonBus = new GridBagConstraints();
        constraintsBotonBus.gridx = 1;
        constraintsBotonBus.gridy = 0;
        constraintsBotonBus.gridwidth = 1;
        constraintsBotonBus.gridheight = 1;
        constraintsBotonBus.insets = new Insets(8, 2, 0, 9);
        panelBusqueda.add((Component)this.busquedaButton, constraintsBotonBus);
        this.add((Component)panelBusqueda, constraintsPanelBusqueda);
        this.treeFases = new JTreePanelEx();
        this.treeFases.getTree().setRootVisible(false);
        this.faseSeleccionada = null;
        GridBagConstraints constraintsPanelArbol = new GridBagConstraints();
        constraintsPanelArbol.gridx = 0;
        constraintsPanelArbol.gridy = 2;
        constraintsPanelArbol.gridwidth = 3;
        constraintsPanelArbol.gridheight = 1;
        constraintsPanelArbol.weightx = 1.0;
        constraintsPanelArbol.weighty = 1.0;
        constraintsPanelArbol.fill = 1;
        constraintsPanelArbol.insets = new Insets(9, 10, 0, 9);
        this.add((Component)this.treeFases, constraintsPanelArbol);
        this.btnLocalizar.setBorderPainted(false);
        this.btnLocalizar.setFocusPainted(false);
        this.btnLocalizar.setMargin(this.MARGEN_BOTONES);
        GridBagConstraints constraintsBotonLoc = new GridBagConstraints();
        constraintsBotonLoc.gridx = 0;
        constraintsBotonLoc.gridy = 3;
        constraintsBotonLoc.gridwidth = 2;
        constraintsBotonLoc.gridheight = 1;
        constraintsBotonLoc.insets = new Insets(9, 5, 10, 2);
        constraintsBotonLoc.anchor = 10;
        this.add((Component)this.btnLocalizar, constraintsBotonLoc);
    }

    private void addListeners() {
        this.btnLocalizar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LocalizadorFasesJPanel.this.buttonLocalizar_actionPerformed();
            }
        });
        this.busquedaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LocalizadorFasesJPanel.this.buttonBuscar_actionPerformed();
            }
        });
        this.treeFases.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                LocalizadorFasesJPanel.this.faseSeleccionada = null;
                TreePath pathActual = e.getPath();
                if (((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject() instanceof PNodoGrafico) {
                    LocalizadorFasesJPanel.this.faseSeleccionada = (PNodoGrafico)((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject();
                }
            }
        });
        this.treeFases.getTree().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() > 1 && e.getButton() == 1) {
                    LocalizadorFasesJPanel.this.buttonLocalizar_actionPerformed();
                }
            }
        });
        this.canvas.addGraficoGeneradoDisponibleListener(new GraficoGeneradoDisponibleListener(){

            public void obtenerGraficoGeneradoDisponible(GraficoGeneradoDisponibleEvent ev) {
                LocalizadorFasesJPanel.this.actualizarTrasEvento(ev);
            }
        });
        this.canvas.addGraficoEliminadoListener(new GraficoEliminadoListener(){

            public void obtenerGraficoEliminado(GraficoEliminadoEvent ev) {
                LocalizadorFasesJPanel.this.actualizarTrasEvento(ev);
            }
        });
        this.canvas.addGraficoModificadoListener(new GraficoModificadoListener(){

            public void obtenerGraficoModificado(GraficoModificadoEvent ev) {
                LocalizadorFasesJPanel.this.actualizarTrasEvento(ev);
            }
        });
        this.textBusqueda.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent anEvent) {
                if (anEvent.getKeyChar() == '\n') {
                    LocalizadorFasesJPanel.this.buttonBuscar_actionPerformed();
                }
            }

            public void keyPressed(KeyEvent anEvent) {
                if (anEvent.getKeyCode() == 114) {
                    LocalizadorFasesJPanel.this.buttonBuscar_actionPerformed();
                }
            }
        });
    }

    void actualizarTrasEvento(EventObject ev) {
        if (ev instanceof GraficoModificadoEvent ? ((GraficoModificadoEvent)ev).getTipo() != 1 : (ev instanceof GraficoEliminadoEvent ? ((GraficoEliminadoEvent)ev).getTipo() != 1 : ev instanceof GraficoGeneradoDisponibleEvent && ((GraficoGeneradoDisponibleEvent)ev).getTipo() != 1)) {
            return;
        }
        ConjuntoDatos metaFasesExistentes = new ConjuntoDatos();
        if (this.canvas.getDiagrama() != null) {
            metaFasesExistentes = this.canvas.getDiagrama().getMetafasesInvolucradas();
        }
        this.actualizarTree(metaFasesExistentes);
        if (!this.textoABuscar.equals("")) {
            this.arrDeNodos = new ArrayList();
            this.treeFases.setArrayDeNodos(this.arrDeNodos);
            this.treeFases.searchNode(this.textoABuscar);
            this.indice = 0;
            this.bCargadoArray = true;
        }
        this.contraerArbol();
    }

    public void actualizarTree(ConjuntoDatos totalMetafases) {
        DefaultMutableTreeNode metafaseActual = new DefaultMutableTreeNode();
        DefaultMutableTreeNode faseActual = new DefaultMutableTreeNode();
        ArrayList fasesDeMetafaseActual = new ArrayList();
        ArrayList graficosDeFaseActual = new ArrayList();
        this.limpiarListaElementos();
        boolean bMetafaseInsertada = false;
        if (totalMetafases != null && this.canvas.getDiagrama() != null) {
            for (int i = 0; i < totalMetafases.obtenerNumRegistros(); ++i) {
                bMetafaseInsertada = false;
                fasesDeMetafaseActual = this.canvas.getDiagrama().obtenerFasesDeMetafase((TrMetafase)totalMetafases.obtenerDato(i));
                if (fasesDeMetafaseActual == null) continue;
                for (int n = 0; n < fasesDeMetafaseActual.size(); ++n) {
                    graficosDeFaseActual = this.canvas.localizarGraficosFaseEnCanvasActual((TrFase)fasesDeMetafaseActual.get(n), "FA");
                    if (graficosDeFaseActual == null || graficosDeFaseActual.size() <= 0) continue;
                    if (!bMetafaseInsertada) {
                        metafaseActual = this.treeFases.addObject(null, totalMetafases.obtenerDato(i), true);
                        bMetafaseInsertada = true;
                    }
                    faseActual = this.treeFases.addObject(metafaseActual, fasesDeMetafaseActual.get(n), true);
                    for (int f = 0; f < graficosDeFaseActual.size(); ++f) {
                        this.treeFases.addObject(faseActual, graficosDeFaseActual.get(f), true);
                    }
                }
            }
        }
        this.treeFases.repaint();
    }

    public void contraerArbol() {
        for (int r = 0; r < this.treeFases.getTree().getRowCount(); ++r) {
            this.treeFases.getTree().collapseRow(r);
        }
        if (this.treeFases.getTree().getRowCount() > 0) {
            this.treeFases.getTree().setSelectionRow(0);
        }
    }

    public void limpiarListaElementos() {
        this.bCargadoArray = false;
        this.treeFases.clear();
    }

    public void setCanvas(PCanvasModela pCanvas) {
        this.canvas = pCanvas;
        this.addListenersCanvas(this.canvas);
    }

    public void setAplicarParpadeo(boolean pValor) {
        this.bAplicarParpadeo = pValor;
    }

    private void addListenersCanvas(PCanvasModela pCanvasNew) {
        pCanvasNew.addGraficoGeneradoDisponibleListener(new GraficoGeneradoDisponibleListener(){

            public void obtenerGraficoGeneradoDisponible(GraficoGeneradoDisponibleEvent ev) {
                LocalizadorFasesJPanel.this.actualizarTrasEvento(ev);
            }
        });
        pCanvasNew.addGraficoEliminadoListener(new GraficoEliminadoListener(){

            public void obtenerGraficoEliminado(GraficoEliminadoEvent ev) {
                LocalizadorFasesJPanel.this.actualizarTrasEvento(ev);
            }
        });
        pCanvasNew.addGraficoModificadoListener(new GraficoModificadoListener(){

            public void obtenerGraficoModificado(GraficoModificadoEvent ev) {
                LocalizadorFasesJPanel.this.actualizarTrasEvento(ev);
            }
        });
    }

    void buttonLocalizar_actionPerformed() {
        if (this.canvas == null) {
            return;
        }
        if (this.faseSeleccionada == null) {
            return;
        }
        if (this.bAplicarParpadeo) {
            this.canvas.eliminarActivities();
        }
        Rectangle2D.Double enfocarExtension = new Rectangle2D.Double();
        ((Rectangle2D)enfocarExtension).setRect(this.faseSeleccionada.getGlobalBounds().getBounds2D().getX() - 20.0, this.faseSeleccionada.getGlobalBounds().getBounds2D().getY() - 20.0, this.faseSeleccionada.getGlobalBounds().getBounds2D().getWidth() + 40.0, this.faseSeleccionada.getGlobalBounds().getBounds2D().getHeight() + 40.0);
        this.canvas.aplicarVista(2, 500L, enfocarExtension);
        if (this.bAplicarParpadeo) {
            this.canvas.aplicarEstilo(this.faseSeleccionada, this.canvas.EFECTO_PARPADEO, 3500L, PParpadeoActivity.APLICAR_A_BORDE);
        }
    }

    public void buttonBuscar_actionPerformed() {
        JTree treeAux = this.treeFases.getTree();
        this.textoABuscar = this.textBusqueda.getText();
        this.textoABuscar = this.textoABuscar.toUpperCase();
        if (!this.textoABuscar.equals(this.textoAnterior)) {
            this.bCargadoArray = false;
            this.textoAnterior = this.textoABuscar;
            this.indice = 1;
            this.arrDeNodos = new ArrayList();
            this.treeFases.setArrayDeNodos(this.arrDeNodos);
        }
        if (this.textoABuscar.equals("")) {
            DefaultMutableTreeNode NodoRaiz = this.treeFases.getRootNode();
            Object[] pathToRaiz = NodoRaiz.getPath();
            TreePath pathRaiz = new TreePath(pathToRaiz);
            treeAux.setSelectionPath(pathRaiz);
            treeAux.scrollPathToVisible(pathRaiz);
            return;
        }
        if (!this.bCargadoArray) {
            this.treeFases.searchNode(this.textoABuscar);
            this.arrDeNodos = this.treeFases.getArrayDeNodos();
            if (this.arrDeNodos.size() == 0) {
                return;
            }
            this.bCargadoArray = true;
            DefaultMutableTreeNode primerNodo = (DefaultMutableTreeNode)this.arrDeNodos.get(0);
            Object[] pathToRaiz = primerNodo.getPath();
            TreePath pathPrimero = new TreePath(pathToRaiz);
            treeAux.setSelectionPath(pathPrimero);
            treeAux.scrollPathToVisible(pathPrimero);
            return;
        }
        if (this.indice == this.arrDeNodos.size()) {
            this.indice = 0;
        }
        if (this.indice < this.arrDeNodos.size()) {
            DefaultMutableTreeNode sigNodo = (DefaultMutableTreeNode)this.arrDeNodos.get(this.indice);
            ++this.indice;
            Object[] pathToRaiz = sigNodo.getPath();
            TreePath pathSig = new TreePath(pathToRaiz);
            treeAux.setSelectionPath(pathSig);
            treeAux.scrollPathToVisible(pathSig);
            return;
        }
    }
}

