/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import edu.umd.cs.piccolo.nodes.PPath;
import gdtel.bd.ConjuntoDatos;
import gdtel.ui.piccolo.activities.PParpadeoActivity;
import gdtel.ui.swing.bd.BotonesMantenimientoJPanel;
import gdtel.ui.swing.excontrols.CreadorButton;
import gdtel.ui.swing.excontrols.JFiltroTextField;
import gdtel.ui.swing.excontrols.JTreePanelEx;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import modela.bd.obj.TrTransicion;
import modela.ui.ModelaUI;
import modela.ui.piccolo.PCanvasModela;
import modela.ui.piccolo.events.GraficoEliminadoEvent;
import modela.ui.piccolo.events.GraficoEliminadoListener;
import modela.ui.piccolo.events.GraficoGeneradoDisponibleEvent;
import modela.ui.piccolo.events.GraficoGeneradoDisponibleListener;
import modela.ui.piccolo.events.GraficoModificadoEvent;
import modela.ui.piccolo.events.GraficoModificadoListener;
import modela.ui.piccolo.nodes.FasePNode;
import modela.ui.piccolo.nodes.PNodoGrafico;
import modela.ui.piccolo.nodes.TransicionPNode;
import modela.ui.swing.renderers.LocalizadorTreeRenderer;

public class LocalizadorTransicionesJPanel
extends JPanel {
    private static final long serialVersionUID = 8746977076821023010L;
    PCanvasModela canvas = null;
    JTreePanelEx treeTransiciones = null;
    TrTransicion transicionSeleccionada = null;
    ImageIcon localizarIconN = new ImageIcon(LocalizadorTransicionesJPanel.class.getResource(ModelaUI.IMG_BOTON_LOCALIZAR_TRANSI));
    ImageIcon localizarIconS = new ImageIcon(LocalizadorTransicionesJPanel.class.getResource(ModelaUI.IMG_BOTON_LOCALIZAR_TRANSI_SOBRE));
    JButton btnLocalizar = (JButton)CreadorButton.crearBoton(1, false, this.localizarIconN, this.localizarIconN, this.localizarIconS, this.localizarIconS);
    private final Insets MARGEN_BOTONES = new Insets(-2, -3, -2, -3);
    JFiltroTextField textBusqueda = new JFiltroTextField();
    protected ImageIcon buscarIconN = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_BUSCAR_EN_LISTA));
    protected ImageIcon buscarIconS = new ImageIcon(BotonesMantenimientoJPanel.class.getResource(ModelaUI.IMG_BUSCAR_EN_LISTA_SOBRE));
    protected JButton busquedaButton = (JButton)CreadorButton.crearBoton(1, false, this.buscarIconN, this.buscarIconN, this.buscarIconS, this.buscarIconS);
    JLabel labelLista = new JLabel();
    public ArrayList arrDeNodos = null;
    boolean bCargadoArray = false;
    String textoAnterior = "";
    String textoABuscar = "";
    int indice = 1;
    boolean bAplicarParpadeo = true;

    public LocalizadorTransicionesJPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public LocalizadorTransicionesJPanel(PCanvasModela pCanvas) {
        try {
            this.setCanvas(pCanvas);
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.prepararDisenio();
        this.addListeners();
        this.limpiarListaElementos();
        this.treeTransiciones.getTree().setCellRenderer(new LocalizadorTreeRenderer());
        this.bAplicarParpadeo = true;
    }

    private void prepararDisenio() {
        this.setLayout(new GridBagLayout());
        this.labelLista.setText("Gr\u00e1ficos de transici\u00f3n existente");
        this.labelLista.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.labelLista.setForeground(ModelaUI.colorSeleccion);
        GridBagConstraints constraintsLabel = new GridBagConstraints();
        constraintsLabel.gridx = 0;
        constraintsLabel.gridy = 0;
        constraintsLabel.gridwidth = 2;
        constraintsLabel.gridheight = 1;
        constraintsLabel.weightx = 1.0;
        constraintsLabel.anchor = 17;
        constraintsLabel.insets = new Insets(9, 10, 0, 2);
        this.add((Component)this.labelLista, constraintsLabel);
        JPanel panelBusqueda = new JPanel();
        GridBagConstraints constraintsPanelBusqueda = new GridBagConstraints();
        constraintsPanelBusqueda.gridx = 0;
        constraintsPanelBusqueda.gridy = 1;
        constraintsPanelBusqueda.gridwidth = 2;
        constraintsPanelBusqueda.gridheight = 1;
        constraintsPanelBusqueda.weightx = 1.0;
        constraintsPanelBusqueda.fill = 2;
        panelBusqueda.setLayout(new GridBagLayout());
        GridBagConstraints constraintsTextoBusqueda = new GridBagConstraints();
        constraintsTextoBusqueda.gridx = 0;
        constraintsTextoBusqueda.gridy = 0;
        constraintsTextoBusqueda.gridwidth = 1;
        constraintsTextoBusqueda.gridheight = 1;
        constraintsTextoBusqueda.weightx = 1.0;
        constraintsTextoBusqueda.fill = 2;
        constraintsTextoBusqueda.insets = new Insets(8, 10, 0, 0);
        this.textBusqueda.setCambiarColorAlModificar(false);
        this.textBusqueda.setToolTipText("Texto a buscar");
        this.textBusqueda.setEditable(true);
        this.textBusqueda.establecerTipografia(1);
        this.textBusqueda.setNumItems(100);
        panelBusqueda.add((Component)this.textBusqueda, constraintsTextoBusqueda);
        this.busquedaButton.setPreferredSize(new Dimension(30, 21));
        GridBagConstraints constraintsBotonBus = new GridBagConstraints();
        constraintsBotonBus.gridx = 1;
        constraintsBotonBus.gridy = 0;
        constraintsBotonBus.gridwidth = 1;
        constraintsBotonBus.gridheight = 1;
        constraintsBotonBus.insets = new Insets(8, 2, 0, 9);
        panelBusqueda.add((Component)this.busquedaButton, constraintsBotonBus);
        this.add((Component)panelBusqueda, constraintsPanelBusqueda);
        this.treeTransiciones = new JTreePanelEx();
        this.treeTransiciones.getTree().setRootVisible(false);
        this.transicionSeleccionada = null;
        GridBagConstraints constraintsPanelArbol = new GridBagConstraints();
        constraintsPanelArbol.gridx = 0;
        constraintsPanelArbol.gridy = 2;
        constraintsPanelArbol.gridwidth = 3;
        constraintsPanelArbol.gridheight = 1;
        constraintsPanelArbol.weightx = 1.0;
        constraintsPanelArbol.weighty = 1.0;
        constraintsPanelArbol.fill = 1;
        constraintsPanelArbol.insets = new Insets(9, 10, 0, 9);
        this.add((Component)this.treeTransiciones, constraintsPanelArbol);
        this.btnLocalizar.setBorderPainted(false);
        this.btnLocalizar.setFocusPainted(false);
        this.btnLocalizar.setMargin(this.MARGEN_BOTONES);
        GridBagConstraints constraintsBotonLoc = new GridBagConstraints();
        constraintsBotonLoc.gridx = 0;
        constraintsBotonLoc.gridy = 3;
        constraintsBotonLoc.gridwidth = 2;
        constraintsBotonLoc.gridheight = 1;
        constraintsBotonLoc.insets = new Insets(9, 5, 10, 2);
        constraintsBotonLoc.anchor = 10;
        this.add((Component)this.btnLocalizar, constraintsBotonLoc);
    }

    private void addListeners() {
        this.btnLocalizar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LocalizadorTransicionesJPanel.this.buttonLocalizar_actionPerformed();
            }
        });
        this.busquedaButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                LocalizadorTransicionesJPanel.this.buttonBuscar_actionPerformed();
            }
        });
        this.treeTransiciones.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                LocalizadorTransicionesJPanel.this.transicionSeleccionada = null;
                TreePath pathActual = e.getPath();
                if (((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject() instanceof TrTransicion) {
                    LocalizadorTransicionesJPanel.this.transicionSeleccionada = (TrTransicion)((DefaultMutableTreeNode)pathActual.getLastPathComponent()).getUserObject();
                }
            }
        });
        this.treeTransiciones.getTree().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() > 1 && e.getButton() == 1) {
                    LocalizadorTransicionesJPanel.this.buttonLocalizar_actionPerformed();
                }
            }
        });
        this.canvas.addGraficoGeneradoDisponibleListener(new GraficoGeneradoDisponibleListener(){

            public void obtenerGraficoGeneradoDisponible(GraficoGeneradoDisponibleEvent ev) {
                LocalizadorTransicionesJPanel.this.actualizarTrasEvento(ev);
            }
        });
        this.canvas.addGraficoEliminadoListener(new GraficoEliminadoListener(){

            public void obtenerGraficoEliminado(GraficoEliminadoEvent ev) {
                LocalizadorTransicionesJPanel.this.actualizarTrasEvento(ev);
            }
        });
        this.canvas.addGraficoModificadoListener(new GraficoModificadoListener(){

            public void obtenerGraficoModificado(GraficoModificadoEvent ev) {
                LocalizadorTransicionesJPanel.this.actualizarTrasEvento(ev);
            }
        });
        this.textBusqueda.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent anEvent) {
                if (anEvent.getKeyChar() == '\n') {
                    LocalizadorTransicionesJPanel.this.buttonBuscar_actionPerformed();
                }
            }

            public void keyPressed(KeyEvent anEvent) {
                if (anEvent.getKeyCode() == 114) {
                    LocalizadorTransicionesJPanel.this.buttonBuscar_actionPerformed();
                }
            }
        });
    }

    void actualizarTrasEvento(EventObject ev) {
        if (ev instanceof GraficoModificadoEvent ? ((GraficoModificadoEvent)ev).getTipo() == 1 : (ev instanceof GraficoEliminadoEvent ? ((GraficoEliminadoEvent)ev).getTipo() == 1 : ev instanceof GraficoGeneradoDisponibleEvent && ((GraficoGeneradoDisponibleEvent)ev).getTipo() == 1)) {
            return;
        }
        ArrayList listaTransicionesConGr = this.canvas.obtenerTransiciones(true, false);
        ConjuntoDatos transiConGrafico = new ConjuntoDatos();
        transiConGrafico.setListaDatos(listaTransicionesConGr);
        this.actualizarLista(transiConGrafico);
        if (!this.textoABuscar.equals("")) {
            this.arrDeNodos = new ArrayList();
            this.treeTransiciones.setArrayDeNodos(this.arrDeNodos);
            this.treeTransiciones.searchNode(this.textoABuscar);
            this.indice = 0;
            this.bCargadoArray = true;
        }
        this.contraerArbol();
    }

    public void actualizarLista(ConjuntoDatos totalTransiciones) {
        DefaultMutableTreeNode rootTransiciones = new DefaultMutableTreeNode();
        DefaultMutableTreeNode rootEventos = new DefaultMutableTreeNode();
        this.limpiarListaElementos();
        if (totalTransiciones != null && this.canvas.getDiagrama() != null) {
            totalTransiciones.ordenar();
            rootTransiciones = this.treeTransiciones.addObject(null, "Transiciones", true);
            rootEventos = this.treeTransiciones.addObject(null, "Eventos", true);
            for (int n = 0; n < totalTransiciones.obtenerNumRegistros(); ++n) {
                if (((TrTransicion)totalTransiciones.obtenerDato(n)).getTIPO().equals("EN") || ((TrTransicion)totalTransiciones.obtenerDato(n)).getTIPO().equals("ES")) {
                    this.treeTransiciones.addObject(rootEventos, totalTransiciones.obtenerDato(n), true);
                    continue;
                }
                this.treeTransiciones.addObject(rootTransiciones, totalTransiciones.obtenerDato(n), true);
            }
        }
        this.treeTransiciones.repaint();
    }

    public void contraerArbol() {
        for (int r = 0; r < this.treeTransiciones.getTree().getRowCount(); ++r) {
            this.treeTransiciones.getTree().collapseRow(r);
        }
        if (this.treeTransiciones.getTree().getRowCount() > 0) {
            this.treeTransiciones.getTree().setSelectionRow(0);
        }
    }

    public void limpiarListaElementos() {
        this.treeTransiciones.clear();
    }

    public void setCanvas(PCanvasModela pCanvas) {
        this.canvas = pCanvas;
        this.addListenersCanvas(this.canvas);
    }

    public void setAplicarParpadeo(boolean pValor) {
        this.bAplicarParpadeo = pValor;
    }

    private void addListenersCanvas(PCanvasModela pCanvasNew) {
        pCanvasNew.addGraficoGeneradoDisponibleListener(new GraficoGeneradoDisponibleListener(){

            public void obtenerGraficoGeneradoDisponible(GraficoGeneradoDisponibleEvent ev) {
                LocalizadorTransicionesJPanel.this.actualizarTrasEvento(ev);
            }
        });
        pCanvasNew.addGraficoEliminadoListener(new GraficoEliminadoListener(){

            public void obtenerGraficoEliminado(GraficoEliminadoEvent ev) {
                LocalizadorTransicionesJPanel.this.actualizarTrasEvento(ev);
            }
        });
        pCanvasNew.addGraficoModificadoListener(new GraficoModificadoListener(){

            public void obtenerGraficoModificado(GraficoModificadoEvent ev) {
                LocalizadorTransicionesJPanel.this.actualizarTrasEvento(ev);
            }
        });
    }

    void buttonLocalizar_actionPerformed() {
        ArrayList arrGraficos;
        if (this.canvas == null) {
            return;
        }
        if (this.transicionSeleccionada == null) {
            return;
        }
        if (this.bAplicarParpadeo) {
            this.canvas.eliminarActivities();
        }
        if ((arrGraficos = this.canvas.obtenerGraficosRelacionados(this.transicionSeleccionada)) == null) {
            return;
        }
        if (arrGraficos.size() < 1) {
            return;
        }
        ArrayList<Rectangle2D> arrExtensiones = new ArrayList<Rectangle2D>();
        for (int g = 0; g < arrGraficos.size(); ++g) {
            if (arrGraficos.get(g) instanceof PPath) {
                arrExtensiones.add(((PPath)arrGraficos.get(g)).getGlobalBounds().getBounds2D());
                continue;
            }
            if (!(arrGraficos.get(g) instanceof PNodoGrafico)) continue;
            arrExtensiones.add(((PNodoGrafico)arrGraficos.get(g)).getGlobalBounds().getBounds2D());
        }
        Rectangle2D rectanguloEnfoque = this.canvas.calcularExtension(arrExtensiones);
        if (rectanguloEnfoque == null) {
            return;
        }
        this.canvas.aplicarVista(2, 500L, rectanguloEnfoque);
        if (this.bAplicarParpadeo) {
            for (int n = 0; n < arrGraficos.size(); ++n) {
                if (arrGraficos.get(n) instanceof TransicionPNode) {
                    this.canvas.aplicarEstilo((TransicionPNode)arrGraficos.get(n), this.canvas.EFECTO_PARPADEO, 3500L, PParpadeoActivity.APLICAR_A_RELLENO);
                    continue;
                }
                if (!(arrGraficos.get(n) instanceof PNodoGrafico) || arrGraficos.get(n) instanceof FasePNode) continue;
                this.canvas.aplicarEstilo((PNodoGrafico)arrGraficos.get(n), this.canvas.EFECTO_PARPADEO, 3500L, PParpadeoActivity.APLICAR_A_BORDE);
            }
        }
    }

    void buttonBuscar_actionPerformed() {
        JTree treeAux = this.treeTransiciones.getTree();
        this.textoABuscar = this.textBusqueda.getText();
        this.textoABuscar = this.textoABuscar.toUpperCase();
        if (!this.textoABuscar.equals(this.textoAnterior)) {
            this.bCargadoArray = false;
            this.textoAnterior = this.textoABuscar;
            this.indice = 1;
            this.arrDeNodos = new ArrayList();
            this.treeTransiciones.setArrayDeNodos(this.arrDeNodos);
        }
        if (this.textoABuscar.equals("")) {
            DefaultMutableTreeNode NodoRaiz = this.treeTransiciones.getRootNode();
            Object[] pathToRaiz = NodoRaiz.getPath();
            TreePath pathRaiz = new TreePath(pathToRaiz);
            treeAux.setSelectionPath(pathRaiz);
            return;
        }
        if (!this.bCargadoArray) {
            this.treeTransiciones.searchNode(this.textoABuscar);
            this.arrDeNodos = this.treeTransiciones.getArrayDeNodos();
            if (this.arrDeNodos.size() == 0) {
                return;
            }
            this.bCargadoArray = true;
            DefaultMutableTreeNode primerNodo = (DefaultMutableTreeNode)this.arrDeNodos.get(0);
            Object[] pathToRaiz = primerNodo.getPath();
            TreePath pathPrimero = new TreePath(pathToRaiz);
            treeAux.setSelectionPath(pathPrimero);
            treeAux.scrollPathToVisible(pathPrimero);
            return;
        }
        if (this.indice == this.arrDeNodos.size()) {
            this.indice = 0;
        }
        if (this.indice < this.arrDeNodos.size()) {
            DefaultMutableTreeNode sigNodo = (DefaultMutableTreeNode)this.arrDeNodos.get(this.indice);
            ++this.indice;
            Object[] pathToRaiz = sigNodo.getPath();
            TreePath pathSig = new TreePath(pathToRaiz);
            treeAux.setSelectionPath(pathSig);
            treeAux.scrollPathToVisible(pathSig);
            return;
        }
    }
}

