/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.XYLayout;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import gdtel.ui.swing.excontrols.CreadorButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import modela.bd.obj.TrTipoCategoria;
import modela.bd.obj.TrTipoEvol;
import modela.conf.ModelaConf;
import modela.ui.ModelaUI;
import modela.ui.swing.PropDefProcJPanel;
import modela.ui.swing.renderers.FamiliaSubfamilaTreeRenderer;

public class MantenimiemtoSelccionArbolFamiliaJDialog
extends JDialog
implements ContainerListener,
KeyListener {
    private static final long serialVersionUID = -6396399072543741230L;
    private final JLabel tituloLabel = new JLabel("\u00c1rbol de Familias");
    private final XYLayout xYLayout = new XYLayout();
    private JTree arbolTree;
    DefaultMutableTreeNode defaultMutableTNode;
    DefaultMutableTreeNode nodoPdre = new DefaultMutableTreeNode(null);
    private PropDefProcJPanel pPanel;
    DefaultTreeModel treeModel;
    private ConjuntoDatos cdFamilia;
    TrTipoEvol elementoSeleccion = null;
    private boolean bMostrarProcedimientos = true;
    private boolean bBandera;
    boolean bAsociandoProcedimiento = false;
    ImageIcon cerrarIconN = new ImageIcon(MantenimiemtoSelccionArbolFamiliaJDialog.class.getResource(ModelaUI.IMG_MTTO_CERRAR));
    ImageIcon cerrarIconS = new ImageIcon(MantenimiemtoSelccionArbolFamiliaJDialog.class.getResource(ModelaUI.IMG_MTTO_CERRAR_SOBRE));
    ImageIcon seleccionarIconN = new ImageIcon(MantenimiemtoSelccionArbolFamiliaJDialog.class.getResource(ModelaUI.IMG_MTTO_SELECCIONAR));
    ImageIcon seleccionarIconS = new ImageIcon(MantenimiemtoSelccionArbolFamiliaJDialog.class.getResource(ModelaUI.IMG_MTTO_SELECCIONAR_SOBRE));
    protected JButton botonSeleccion = (JButton)CreadorButton.crearBoton(1, false, this.seleccionarIconN, this.seleccionarIconN, this.seleccionarIconS, this.seleccionarIconS);
    protected JButton botonCerrar = (JButton)CreadorButton.crearBoton(1, false, this.cerrarIconN, this.cerrarIconN, this.cerrarIconS, this.cerrarIconS);
    protected boolean bElementoSeleccionado = false;
    public ArrayList elementosSeleccionados;

    public MantenimiemtoSelccionArbolFamiliaJDialog(ConjuntoDatos cd, boolean bMostrarProcedimiento) {
        try {
            this.cdFamilia = cd;
            this.bMostrarProcedimientos = bMostrarProcedimiento;
            this.bAsociandoProcedimiento = false;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setModal(true);
        this.bElementoSeleccionado = false;
        this.bBandera = true;
        this.setTitle("Mantenimiento del \u00e1rbol de Familias");
        this.pPanel = new PropDefProcJPanel();
        this.crearArbol();
        this.arbolTree.setCellRenderer(new FamiliaSubfamilaTreeRenderer());
        this.elementosSeleccionados = null;
        this.setResizable(false);
        this.setSize(new Dimension(720, 550));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.getContentPane().setLayout(this.xYLayout);
        this.botonSeleccion.setVisible(true);
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        JScrollPane pArbol = new JScrollPane(this.arbolTree);
        this.getContentPane().add((Component)pArbol, new XYConstraints(20, 40, 170, 350));
        this.botonCerrar.setVisible(true);
        this.getContentPane().add((Component)this.botonSeleccion, new XYConstraints(450, 485, 115, 37));
        this.getContentPane().add((Component)this.botonCerrar, new XYConstraints(575, 485, 115, 37));
        this.getContentPane().add((Component)this.pPanel, new XYConstraints(190, 2, 520, 455));
        this.setLocationRelativeTo(null);
        this.botonSeleccion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MantenimiemtoSelccionArbolFamiliaJDialog.this.selElemento(true);
                MantenimiemtoSelccionArbolFamiliaJDialog.this.bElementoSeleccionado = true;
            }
        });
        this.botonCerrar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MantenimiemtoSelccionArbolFamiliaJDialog.this.bElementoSeleccionado = false;
                MantenimiemtoSelccionArbolFamiliaJDialog.this.elementosSeleccionados = null;
                MantenimiemtoSelccionArbolFamiliaJDialog.this.dispose();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                MantenimiemtoSelccionArbolFamiliaJDialog.this.bElementoSeleccionado = false;
                MantenimiemtoSelccionArbolFamiliaJDialog.this.dispose();
            }
        });
        this.pPanel.inicializarCampos(2);
        this.arbolTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    MantenimiemtoSelccionArbolFamiliaJDialog.this.selElemento(MantenimiemtoSelccionArbolFamiliaJDialog.this.bAsociandoProcedimiento);
                    MantenimiemtoSelccionArbolFamiliaJDialog.this.bElementoSeleccionado = true;
                }
                if (e.getSource() != null) {
                    MantenimiemtoSelccionArbolFamiliaJDialog.this.selElemento(false);
                }
            }
        });
        this.arbolTree.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                MantenimiemtoSelccionArbolFamiliaJDialog.this.selElemento(false);
            }
        });
        this.addKeyAndContainerListenerRecursively(this);
        ModelaConf.setVentanaActiva(this);
    }

    public ArrayList obtenerElementosSeleccionados() {
        return this.elementosSeleccionados;
    }

    private void crearArbol() {
        DefaultMutableTreeNode rama;
        int m;
        DefaultMutableTreeNode top = new DefaultMutableTreeNode(null);
        this.treeModel = new DefaultTreeModel(top);
        this.arbolTree = new JTree(this.treeModel);
        ArrayList datos = null;
        try {
            datos = this.cdFamilia.listaDatos;
        }
        catch (Exception fallo) {
            System.out.println("\u00b7 [ Alerta ] El conjunto de datos es nulo");
            return;
        }
        TrTipoEvol trEvol = null;
        if (datos.size() == 0) {
            return;
        }
        if (!this.bMostrarProcedimientos) {
            for (m = 0; m < datos.size(); ++m) {
                this.bBandera = true;
                trEvol = (TrTipoEvol)datos.get(m);
                if (trEvol.getProcedimientoPadre() != null) continue;
                TrTipoCategoria trCategoria = trEvol.getCATEGORIA();
                if (trCategoria != null && trCategoria.getTipoCategoria().equals("P")) {
                    this.bBandera = false;
                }
                rama = new DefaultMutableTreeNode(trEvol);
                if (this.bBandera) {
                    top.add(rama);
                }
                this.crearElemento(this.arbolTree, rama, trEvol);
            }
        }
        if (this.bMostrarProcedimientos) {
            for (m = 0; m < datos.size(); ++m) {
                trEvol = (TrTipoEvol)datos.get(m);
                if (trEvol.getProcedimientoPadre() != null) continue;
                rama = new DefaultMutableTreeNode(trEvol);
                top.add(rama);
                this.crearElemento(this.arbolTree, rama, trEvol);
            }
        }
        if (this.treeModel != null) {
            this.treeModel.reload();
        }
    }

    public void crearElemento(JTree arbol, DefaultMutableTreeNode nodoPadre, TrTipoEvol ele) {
        DefaultMutableTreeNode nodoHijo = new DefaultMutableTreeNode(null);
        ConjuntoDatos x = new ConjuntoDatos();
        x = ele.getProcedimientosHijos();
        if (x == null) {
            return;
        }
        if (x.getListaDatos().size() == 0) {
            return;
        }
        ArrayList array = x.getListaDatos();
        TrTipoEvol hijo = null;
        for (int g = 0; g < array.size(); ++g) {
            this.bBandera = true;
            hijo = (TrTipoEvol)array.get(g);
            nodoHijo = new DefaultMutableTreeNode(hijo);
            TrTipoCategoria trCategoria = hijo.getCATEGORIA();
            if (trCategoria != null && !this.bMostrarProcedimientos && trCategoria.getTipoCategoria().equals("P")) {
                this.bBandera = false;
            }
            if (this.bBandera) {
                nodoPadre.add(nodoHijo);
            }
            this.treeModel.reload();
            arbol.setRootVisible(false);
            arbol.setSelectionRow(0);
            arbol.setExpandsSelectedPaths(false);
            this.crearElemento(arbol, nodoHijo, hijo);
        }
    }

    public TrTipoEvol obtenerElemntoSeleccionado() {
        return this.elementoSeleccion;
    }

    public void selElemento(boolean cerrarPantalla) {
        boolean cerrar = cerrarPantalla;
        this.pPanel.limpiarCampos();
        this.elementoSeleccion = null;
        this.elementosSeleccionados = null;
        this.elementosSeleccionados = new ArrayList();
        DefaultMutableTreeNode nodoSeleccionado = null;
        Object objSuperior = null;
        objSuperior = this.arbolTree.getLastSelectedPathComponent();
        nodoSeleccionado = (DefaultMutableTreeNode)objSuperior;
        Object objInferior = null;
        if (nodoSeleccionado == null || nodoSeleccionado.isRoot()) {
            if (cerrar) {
                JOptionPane.showMessageDialog(this, MantenimientoJDialog.TEXTO_NINGUN_ELEMENTO_SELECCIONADO, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            }
            return;
        }
        objInferior = nodoSeleccionado.getUserObject();
        this.elementoSeleccion = (TrTipoEvol)objInferior;
        TreePath[] paths = this.arbolTree.getSelectionModel().getSelectionPaths();
        for (int i = 0; i < paths.length; ++i) {
            TrTipoCategoria trCategoria;
            TreeNode node = (TreeNode)paths[i].getLastPathComponent();
            Object objetoSel = ((DefaultMutableTreeNode)node).getUserObject();
            if (objetoSel == null || !(objetoSel instanceof TrTipoEvol) || (trCategoria = ((TrTipoEvol)objetoSel).getCATEGORIA()) == null || !trCategoria.getTipoCategoria().equals("P")) continue;
            this.elementosSeleccionados.add(objetoSel);
        }
        if (this.elementosSeleccionados.size() < 1 && this.elementoSeleccion == null) {
            if (cerrar) {
                JOptionPane.showMessageDialog(this, MantenimientoJDialog.TEXTO_NINGUN_ELEMENTO_SELECCIONADO, MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            }
            return;
        }
        TrTipoEvol objAsig = this.elementoSeleccion;
        this.pPanel.setValoresAsignables(objAsig);
        if (cerrar && this.bAsociandoProcedimiento && this.elementosSeleccionados.size() <= 0) {
            return;
        }
        if (cerrar) {
            this.dispose();
        }
    }

    public void setProcedimientosvisibles(boolean opcion) {
        this.bMostrarProcedimientos = opcion;
        this.crearArbol();
    }

    public void setAsociandoProcedimiento(boolean pValor) {
        this.bAsociandoProcedimiento = pValor;
    }

    public boolean isAsociandoProcedimiento() {
        return this.bAsociandoProcedimiento;
    }

    public boolean isElementoSeleccionado() {
        return this.bElementoSeleccionado;
    }

    private void addKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        c.addKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            cont.addContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.addKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    private void removeKeyAndContainerListenerRecursively(Component c) {
        c.removeKeyListener(this);
        if (c instanceof Container) {
            Container cont = (Container)c;
            cont.removeContainerListener(this);
            Component[] children = cont.getComponents();
            for (int i = 0; i < children.length; ++i) {
                this.removeKeyAndContainerListenerRecursively(children[i]);
            }
        }
    }

    public void componentAdded(ContainerEvent e) {
        this.addKeyAndContainerListenerRecursively(e.getChild());
    }

    public void componentRemoved(ContainerEvent e) {
        this.removeKeyAndContainerListenerRecursively(e.getChild());
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (code == 27) {
            this.dispose();
        } else if (code == 10) {
            this.performEnterAction(e);
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    void performEnterAction(KeyEvent e) {
    }
}

