/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrAccionTareaFase;
import modela.bd.obj.TrTipoTarea;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropAccionTareaEnFaseJPanel;
import modela.ui.swing.renderers.AtributosListRenderer;

public class MantenimientoAccionTareaEnFaseJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 1337887481184072035L;
    PropAccionTareaEnFaseJPanel pPanel;
    private JLabel tituloLabel = new JLabel("Acciones asociadas");
    private DDPGrafico grafico = null;
    private TrTipoTarea m_tipoTarea = null;
    private final int ANCHO_ACTUAL = 650;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoAccionTareaEnFaseJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MantenimientoAccionTareaEnFaseJDialog(TrTipoTarea tipoTarea) {
        try {
            this.m_tipoTarea = tipoTarea;
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setTitle("Mantenimiento de acciones en tarea en fase");
        this.pPanel = new PropAccionTareaEnFaseJPanel();
        this.pPanel.inicializarCampos(7);
        this.pPanel.setTipoTarea(this.m_tipoTarea);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoAccionTareaEnFaseJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoAccionTareaEnFaseJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoAccionTareaEnFaseJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoAccionTareaEnFaseJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoAccionTareaEnFaseJDialog.this.establecerModoTrabajo(2);
                        MantenimientoAccionTareaEnFaseJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoAccionTareaEnFaseJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoAccionTareaEnFaseJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoAccionTareaEnFaseJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoAccionTareaEnFaseJDialog.this.establecerModoTrabajo(7);
                    MantenimientoAccionTareaEnFaseJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoAccionTareaEnFaseJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoAccionTareaEnFaseJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoAccionTareaEnFaseJDialog.this.establecerModoTrabajo(7);
                    MantenimientoAccionTareaEnFaseJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoAccionTareaEnFaseJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoAccionTareaEnFaseJDialog.this.establecerModoTrabajo(2);
                    MantenimientoAccionTareaEnFaseJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoAccionTareaEnFaseJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.listaAsignable.setCellRenderer(new AtributosListRenderer());
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int[] indicesEliminar = this.listaAsignable.getSelectedIndices();
        for (int ind = indicesEliminar.length - 1; ind >= 0; --ind) {
            this.listaAsignable.removeItem(indicesEliminar[ind]);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrAccionTareaFase accion;
        double accionID = this.pPanel.getAccionSeleccionada();
        if (!this.comprobarExistenciaAccion(accionID, -1)) {
            accion = null;
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            accion = (TrAccionTareaFase)this.pPanel.getValoresAsignables();
            if (accion == null) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar la acci\u00f3n:\nLa acci\u00f3n ya existe en la lista de acciones en tarea en fase.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.addItem(accion);
        this.listaAsignable.setSelectedValue(accion, true);
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean aplicarModificar() {
        int nSelectedIndex;
        double accionID = this.pPanel.getAccionSeleccionada();
        if (!this.comprobarExistenciaAccion(accionID, nSelectedIndex = this.listaAsignable.getSelectedIndex())) {
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar la acci\u00f3n:\nLa acci\u00f3n ya existe en la lista de acciones en tarea en fase.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        if (cdElementos != null) {
            cdElementos.ordenar();
        }
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public ConjuntoDatos getElementos() {
        ConjuntoDatos conjuntoAcciones = new ConjuntoDatos();
        conjuntoAcciones.setListaDatos(this.listaAsignable.toArrayList());
        return conjuntoAcciones;
    }

    public boolean comprobarExistenciaAccion(double accionID, int nSelectedIndex) {
        if (accionID < 0.0) {
            return false;
        }
        if (this.listaAsignable.getNumItems() <= 0) {
            return false;
        }
        boolean bID = false;
        boolean bEncontrado = false;
        for (int i = 0; i < this.listaAsignable.getNumItems() && !bEncontrado; ++i) {
            bID = false;
            TrAccionTareaFase accionAux = (TrAccionTareaFase)this.listaAsignable.getElementAt(i);
            if (accionAux != null && i != nSelectedIndex && accionAux.getAccion() != null && accionID == accionAux.getAccion().getID()) {
                bID = true;
            }
            if (!bID) continue;
            bEncontrado = true;
        }
        return bEncontrado;
    }
}

