/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.ConjuntoDatosModela;
import modela.bd.obj.ConjuntoDatosAccion;
import modela.bd.obj.ConjuntoDatosCondicion;
import modela.bd.obj.TrAccion;
import modela.bd.obj.TrAviso;
import modela.bd.obj.TrCondicion;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropAvisoJPanel;

public class MantenimientoAvisoJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 5108690847994012481L;
    private DDPGrafico grafico = null;
    PropAvisoJPanel pPanel;
    private JLabel tituloLabel = new JLabel("Lista de avisos");
    private final int ANCHO_ACTUAL = 600;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoAvisoJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setTitle("Mantenimiento de avisos");
        this.pPanel = new PropAvisoJPanel();
        this.pPanel.inicializarCampos(7);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoAvisoJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoAvisoJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoAvisoJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoAvisoJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoAvisoJDialog.this.establecerModoTrabajo(2);
                        MantenimientoAvisoJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoAvisoJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoAvisoJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoAvisoJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoAvisoJDialog.this.establecerModoTrabajo(7);
                    MantenimientoAvisoJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoAvisoJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoAvisoJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoAvisoJDialog.this.establecerModoTrabajo(7);
                    MantenimientoAvisoJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoAvisoJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoAvisoJDialog.this.establecerModoTrabajo(2);
                    MantenimientoAvisoJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoAvisoJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrAviso Aviso = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        Aviso = (TrAviso)this.pPanel.getValoresAsignables();
        if (Aviso == null) {
            return false;
        }
        if (this.grafico.getAvisosInvolucrados().existeElemento(Aviso, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible crear el aviso:\nYa existe un aviso con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        TrAccion accionAux = new TrAccion();
        accionAux.setNombre(Aviso.getNOMBRE());
        if (((ConjuntoDatosAccion)this.grafico.getAccionesInvolucradas()).existeElemento(accionAux, false) != null) {
            JOptionPane.showMessageDialog(this, "Imposible crear el aviso:\nYa existe una acci\u00f3n con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        TrCondicion condicionAux = new TrCondicion();
        condicionAux.setNombre(Aviso.getNOMBRE());
        if (((ConjuntoDatosCondicion)this.grafico.getCondicionesInvolucradas()).existeElemento(condicionAux, false) != null) {
            JOptionPane.showMessageDialog(this, "Imposible crear el aviso:\nYa existe una condici\u00f3n con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        this.listaAsignable.addItem(Aviso);
        this.listaAsignable.setSelectedValue(Aviso, true);
        this.listaAsignable.updateUI();
        if (this.grafico != null) {
            ConjuntoDatosModela c = new ConjuntoDatosModela();
            c.setListaDatos(this.listaAsignable.toArrayList());
            this.grafico.setAvisosInvolucrados(c);
        }
        return true;
    }

    public boolean aplicarModificar() {
        if ((TrAviso)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex()) == null) {
            return false;
        }
        TrAviso avisoAux = new TrAviso();
        avisoAux.setXID(((TrAviso)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex())).getXID());
        avisoAux.setNOMBRE(this.pPanel.getNombreTmp());
        if (this.grafico.getAvisosInvolucrados().existeElemento(avisoAux, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe un aviso con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        TrAccion accionAux = new TrAccion();
        accionAux.setNombre(avisoAux.getNOMBRE());
        if (((ConjuntoDatosAccion)this.grafico.getAccionesInvolucradas()).existeElemento(accionAux, false) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe una acci\u00f3n con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        TrCondicion condicionAux = new TrCondicion();
        condicionAux.setNombre(avisoAux.getNOMBRE());
        if (((ConjuntoDatosCondicion)this.grafico.getCondicionesInvolucradas()).existeElemento(condicionAux, false) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe una condici\u00f3n con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarAvisos(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getAvisosInvolucrados());
        return true;
    }
}

