/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrAvisoTransicion;
import modela.bd.obj.TrTransicionDefProcedimiento;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.Portapapeles;
import modela.ui.swing.PropAvisoTransicionJPanel;
import modela.ui.swing.renderers.AtributosListRenderer;

public class MantenimientoAvisoTransicionJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 7819399238150658467L;
    PropAvisoTransicionJPanel pPanel;
    private final JLabel tituloLabel = new JLabel("Avisos asociados");
    DDPGrafico grafico = null;
    private final int ANCHO_ACTUAL = 650;
    private final int ALTO_ACTUAL = 515;
    TrTransicionDefProcedimiento transicionDefProc = null;

    public MantenimientoAvisoTransicionJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setTitle("Mantenimiento de avisos en transicion");
        this.pPanel = new PropAvisoTransicionJPanel();
        this.pPanel.inicializarCampos(7);
        this.transicionDefProc = null;
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.setTipoAlmacenado(4);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    if (MantenimientoAvisoTransicionJDialog.this.listaAsignable.crearPopupMenu() && !MantenimientoAvisoTransicionJDialog.this.listaAsignable.popup.isVisible()) {
                        Portapapeles.setGrafico(MantenimientoAvisoTransicionJDialog.this.grafico);
                        MantenimientoAvisoTransicionJDialog.this.listaAsignable.popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoAvisoTransicionJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoAvisoTransicionJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoAvisoTransicionJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoAvisoTransicionJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoAvisoTransicionJDialog.this.establecerModoTrabajo(2);
                        MantenimientoAvisoTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                        if (!MantenimientoAvisoTransicionJDialog.this.isDesdeSeleccionLimitada()) {
                            MantenimientoAvisoTransicionJDialog.this.botones.modificarButton_mousePressed(e);
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoAvisoTransicionJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoAvisoTransicionJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoAvisoTransicionJDialog.this.establecerModoTrabajo(7);
                    MantenimientoAvisoTransicionJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoAvisoTransicionJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoAvisoTransicionJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoAvisoTransicionJDialog.this.establecerModoTrabajo(7);
                    MantenimientoAvisoTransicionJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoAvisoTransicionJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoAvisoTransicionJDialog.this.establecerModoTrabajo(2);
                    MantenimientoAvisoTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                    if (!MantenimientoAvisoTransicionJDialog.this.isDesdeSeleccionLimitada()) {
                        MantenimientoAvisoTransicionJDialog.this.botones.modificarButton_mousePressed(null);
                    }
                }
            }
        });
        this.listaAsignable.setCellRenderer(new AtributosListRenderer());
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int[] indicesEliminar = this.listaAsignable.getSelectedIndices();
        for (int ind = indicesEliminar.length - 1; ind >= 0; --ind) {
            this.listaAsignable.removeItem(indicesEliminar[ind]);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        if (this.transicionDefProc != null) {
            this.transicionDefProc.getConjuntoAvisoTransicion().setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public void setTransicionDefProc(TrTransicionDefProcedimiento transiAsociada) {
        this.transicionDefProc = transiAsociada;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        double avisoID = this.pPanel.getAvisoSeleccionado();
        if (!this.comprobarExistenciaAviso(avisoID, -1)) {
            TrAvisoTransicion aviso = null;
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            aviso = (TrAvisoTransicion)this.pPanel.getValoresAsignables();
            if (aviso == null) {
                return false;
            }
            this.listaAsignable.addItem(aviso);
            this.listaAsignable.setSelectedValue(aviso, true);
            this.listaAsignable.updateUI();
            if (this.transicionDefProc != null) {
                this.transicionDefProc.getConjuntoAvisoTransicion().setListaDatos(this.listaAsignable.toArrayList());
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar el aviso:\nEl aviso ya existe en la lista de avisos en transici\u00f3n.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        return true;
    }

    public boolean aplicarModificar() {
        int nSelectedIndex;
        double avisoID = this.pPanel.getAvisoSeleccionado();
        if (!this.comprobarExistenciaAviso(avisoID, nSelectedIndex = this.listaAsignable.getSelectedIndex())) {
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            this.listaAsignable.updateUI();
            if (this.transicionDefProc != null) {
                this.transicionDefProc.getConjuntoAvisoTransicion().setListaDatos(this.listaAsignable.toArrayList());
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible asociar el aviso:\nEl aviso ya existe en la lista de avisos en transici\u00f3n.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        if (cdElementos != null) {
            cdElementos.ordenar();
        }
        super.inicializarListaElementos(cdElementos);
    }

    public void setAvisosInvolucrados(ConjuntoDatos cdAvisos) {
        if (this.pPanel != null) {
            this.pPanel.setAvisosInvolucrados(cdAvisos);
        }
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public boolean comprobarExistenciaAviso(double avisoID, int nSelectedIndex) {
        if (avisoID < 0.0) {
            return false;
        }
        if (this.listaAsignable.getNumItems() <= 0) {
            return false;
        }
        boolean bID = false;
        boolean bEncontrado = false;
        for (int i = 0; i < this.listaAsignable.getNumItems() && !bEncontrado; ++i) {
            bID = false;
            TrAvisoTransicion avisoAux = (TrAvisoTransicion)this.listaAsignable.getElementAt(i);
            if (avisoAux != null && i != nSelectedIndex && avisoAux.getAviso() != null && avisoID == avisoAux.getAviso().getID()) {
                bID = true;
            }
            if (!bID) continue;
            bEncontrado = true;
        }
        return bEncontrado;
    }
}

