/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.ConjuntoDatosFase;
import modela.bd.obj.TrFase;
import modela.bd.obj.TrTipoEvol;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropFaseJPanel;

public class MantenimientoFasesJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 1476594821627235889L;
    PropFaseJPanel pPanel;
    private final JLabel tituloLabel = new JLabel("Lista de fases");
    private DDPGrafico grafico = null;
    private TrTipoEvol tipoEvolDefecto = null;
    private boolean bDesdeUtilidadGrf;
    private final int ANCHO_ACTUAL = 690;
    private final int ALTO_ACTUAL = 515;
    private int nBotones = 3;

    public MantenimientoFasesJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public MantenimientoFasesJDialog(int numBotones) {
        this.nBotones = numBotones;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.bDesdeUtilidadGrf = false;
        this.pPanel = new PropFaseJPanel();
        this.pPanel.inicializarCampos(7);
        this.tipoEvolDefecto = null;
        this.botones.permitirEliminar(false);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.setLocationRelativeTo(null);
        this.setTitle("Mantenimiento de fases");
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (MantenimientoFasesJDialog.this.getAccion() == 1 || MantenimientoFasesJDialog.this.getAccion() == 3) {
                        MantenimientoFasesJDialog.this.botones.activaModificar(true);
                    }
                    if (e.getClickCount() == 2) {
                        MantenimientoFasesJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoFasesJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoFasesJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoFasesJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoFasesJDialog.this.establecerModoTrabajo(2);
                        MantenimientoFasesJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoFasesJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoFasesJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoFasesJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoFasesJDialog.this.establecerModoTrabajo(7);
                    MantenimientoFasesJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoFasesJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoFasesJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoFasesJDialog.this.establecerModoTrabajo(7);
                    MantenimientoFasesJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoFasesJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoFasesJDialog.this.establecerModoTrabajo(2);
                    MantenimientoFasesJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoFasesJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, this.nBotones);
        ModelaConf.setVentanaActiva(this);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        if (nuevoGrafico.getDDP().getTIPOEVOL() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.tipoEvolDefecto = this.grafico.getDDP().getTIPOEVOL();
        this.pPanel.setTipoEvolDefecto(this.tipoEvolDefecto);
        this.pPanel.setGrafico(this.grafico);
        this.inicializarPantalla();
    }

    public boolean inicializarPantalla() {
        if (this.grafico == null) {
            return false;
        }
        this.inicializarListaElementos(this.grafico.getFasesInvolucradas());
        this.inicializarMetafases();
        return true;
    }

    public boolean eliminarElemento() {
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        int n = JOptionPane.showOptionDialog(this, "\u00bfConfirma eliminar el elemento seleccionado?", "Eliminar", 0, 3, null, options, options[1]);
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.botones.activaModificar(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        this.listaAsignable.removeItem(index);
        if (index > 0) {
            this.listaAsignable.setSelectedIndex(index - 1);
            IAsignable obj = this.listaAsignable.getElementAt(index - 1);
            this.pPanel.setValoresAsignables(obj);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
        } else if (index == 0) {
            if (!this.listaAsignable.hasAnyObject()) {
                this.establecerModoTrabajo(7);
                this.pPanel.limpiarCampos();
                this.botones.activaModificar(false);
            } else {
                this.listaAsignable.setSelectedIndex(index);
                IAsignable obj = this.listaAsignable.getElementAt(index);
                this.pPanel.setValoresAsignables(obj);
                this.establecerModoTrabajo(2);
                this.botones.modificarButton_mousePressed(null);
            }
        }
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrFase fase = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        fase = (TrFase)this.pPanel.getValoresAsignables();
        if (fase == null) {
            return false;
        }
        if (fase.getTIPOEVOL() != null && fase.getTIPOEVOL().getNombre() == null && fase.getTIPOEVOL().getABREVIATURA() == null && fase.getTIPOEVOL().getSISTEMA() == null) {
            fase.setTIPOEVOL(null);
        }
        if (((ConjuntoDatosFase)this.grafico.getFasesInvolucradas()).existeElemento(fase, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible crear la fase:\nYa existe una fase con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        this.listaAsignable.addItem(fase);
        this.listaAsignable.setSelectedValue(fase, true);
        this.listaAsignable.updateUI();
        if (this.grafico != null) {
            ConjuntoDatosFase c = new ConjuntoDatosFase();
            c.setListaDatos(this.listaAsignable.toArrayList());
            this.grafico.setFasesInvolucradas(c);
        }
        this.dispararInformarArriba(fase);
        return true;
    }

    public boolean aplicarModificar() {
        if ((TrFase)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex()) == null) {
            return false;
        }
        TrFase faseAux = new TrFase();
        faseAux.setFASEID(((TrFase)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex())).getFASEID());
        faseAux.setNOMBRE(this.pPanel.getNombreTmp());
        if (((ConjuntoDatosFase)this.grafico.getFasesInvolucradas()).existeElemento(faseAux, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe una fase con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        faseAux.setTIPOEVOL(this.pPanel.getTipoEvolTmp());
        if (this.grafico != null && !this.grafico.obtenerValidezTipoEvolucion(faseAux)) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible modificar la fase:\nLa fase seleccionada est\u00e1 asociada a un DDP que la est\u00e1 usando.", "Atenci\u00f3n:", 2);
            return false;
        }
        TrFase fase = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        fase = (TrFase)this.pPanel.getValoresAsignables();
        if (fase.getTIPOEVOL() != null && fase.getTIPOEVOL().getNombre() == null && fase.getTIPOEVOL().getABREVIATURA() == null && fase.getTIPOEVOL().getSISTEMA() == null) {
            fase.setTIPOEVOL(null);
        }
        this.listaAsignable.updateUI();
        this.dispararInformarArriba(fase);
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void inicializarMetafases() {
        PropFaseJPanel panelFase = this.pPanel;
        if (this.pPanel == null) {
            return;
        }
        if (this.grafico == null) {
            return;
        }
        panelFase.setGrafico(this.grafico);
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            ((ConjuntoDatosFase)this.elementosAsignados).setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public void cerrar() {
        if (!this.bDesdeUtilidadGrf) {
            this.refrescarGrafico();
        }
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public void setDesdeUtilidadGrf(boolean pValor) {
        this.bDesdeUtilidadGrf = pValor;
    }

    public boolean getDesdeUtilidadGrf() {
        return this.bDesdeUtilidadGrf;
    }

    public void dispararInformarArriba(TrFase faseActual) {
        if (faseActual == null) {
            return;
        }
        if (faseActual.isInformar()) {
            if (faseActual.getMETAFASE() != null) {
                faseActual.getMETAFASE().setINFORMAR(true);
            }
            try {
                DDPGrafico graficoAux = null;
                ArrayList arrProcUsanFase = this.grafico.getProcedimientosUsanFase(faseActual);
                for (int n = 0; n < arrProcUsanFase.size(); ++n) {
                    graficoAux = (DDPGrafico)arrProcUsanFase.get(n);
                    if (graficoAux.getDDP() == null || graficoAux.getDDP().getTIPOEVOL() == null) continue;
                    graficoAux.getDDP().getTIPOEVOL().setINFORMAR(true);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

