/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.ConjuntoDatosModela;
import modela.bd.obj.TrTipoIndicacionFicha;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropIndicacionFichaJPanel;

public class MantenimientoIndicacionFichaJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 2069241096921957721L;
    private DDPGrafico grafico = null;
    PropIndicacionFichaJPanel pPanel;
    private JLabel tituloLabel = new JLabel("Lista de tipos de indicaci\u00f3n");
    private final int ANCHO_ACTUAL = 600;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoIndicacionFichaJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setModoModificarTrasBusqueda(false);
        this.setTitle("Selecci\u00f3n del tipo de indicaci\u00f3n");
        this.pPanel = new PropIndicacionFichaJPanel();
        this.pPanel.inicializarCampos(7);
        this.botones.setVisible(false);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoIndicacionFichaJDialog.this.elementoSeleccionado = (IAsignable)MantenimientoIndicacionFichaJDialog.this.listaAsignable.getSelectedValue();
                        MantenimientoIndicacionFichaJDialog.this.dispose();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoIndicacionFichaJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoIndicacionFichaJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoIndicacionFichaJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoIndicacionFichaJDialog.this.establecerModoTrabajo(2);
                        MantenimientoIndicacionFichaJDialog.this.pPanel.setValoresAsignables(objAsig);
                    }
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoIndicacionFichaJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoIndicacionFichaJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoIndicacionFichaJDialog.this.establecerModoTrabajo(7);
                    MantenimientoIndicacionFichaJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoIndicacionFichaJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoIndicacionFichaJDialog.this.establecerModoTrabajo(2);
                    MantenimientoIndicacionFichaJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoIndicacionFichaJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 170, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        return true;
    }

    public boolean aplicar() {
        if (this.getAccion() == 1) {
            return this.aplicarNuevo();
        }
        if (this.getAccion() == 3) {
            return this.aplicarModificar();
        }
        return false;
    }

    public boolean aplicarNuevo() {
        TrTipoIndicacionFicha Indicacion = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        Indicacion = (TrTipoIndicacionFicha)this.pPanel.getValoresAsignables();
        if (Indicacion == null) {
            return false;
        }
        this.listaAsignable.addItem(Indicacion);
        this.listaAsignable.setSelectedValue(Indicacion, true);
        this.listaAsignable.updateUI();
        if (this.grafico != null) {
            ConjuntoDatosModela c = new ConjuntoDatosModela();
            c.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean aplicarModificar() {
        return false;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarAvisos(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getAvisosInvolucrados());
        return true;
    }

    public void asignarPrueba() {
        TrTipoIndicacionFicha Indicacion = new TrTipoIndicacionFicha();
        Indicacion.setAbreviatura("Ejemplo ");
        Indicacion.setDescripcion("Ejemplo");
        this.listaAsignable.addItem(Indicacion);
        this.listaAsignable.setSelectedValue(Indicacion, true);
        this.listaAsignable.updateUI();
        TrTipoIndicacionFicha Indicacion2 = new TrTipoIndicacionFicha();
        Indicacion2.setAbreviatura("Ejemplo 2");
        Indicacion2.setDescripcion("Ejemplo 2");
        this.listaAsignable.addItem(Indicacion2);
        this.listaAsignable.setSelectedValue(Indicacion2, true);
        this.listaAsignable.updateUI();
    }
}

