/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.ConjuntoDatosModela;
import modela.bd.obj.ConjuntoDatosMetafase;
import modela.bd.obj.TrMetafase;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropMetafaseJPanel;
import modela.ui.swing.renderers.ColorMetafaseListRenderer;

public class MantenimientoMetafasesJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = -1959218235596449480L;
    PropMetafaseJPanel pPanel;
    int orden = 0;
    int currentModoTrabajo = 0;
    private final JLabel tituloLabel = new JLabel("Lista de metafases");
    private boolean bDesdeUtilidadGrf;
    private DDPGrafico grafico = null;
    private final int ANCHO_ACTUAL = 600;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoMetafasesJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        if (this.listaAsignable.getNumItems() == 1) {
            this.pPanel.defaultCheck.setSelected(true);
            this.pPanel.defaultCheck.setEnabled(false);
        }
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        if (this.listaAsignable.getNumItems() == 0) {
            this.pPanel.defaultCheck.setSelected(true);
            this.pPanel.defaultCheck.setEnabled(false);
        }
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrMetafase metafase = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        metafase = (TrMetafase)this.pPanel.getValoresAsignables();
        if (metafase == null) {
            return false;
        }
        if (((ConjuntoDatosMetafase)this.grafico.getMetafasesInvolucradas()).existeElemento(metafase, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible crear la metafase:\nYa existe una metafase con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        this.listaAsignable.addItem(metafase);
        this.listaAsignable.setSelectedValue(metafase, true);
        this.listaAsignable.updateUI();
        if (this.grafico != null) {
            ConjuntoDatosMetafase c = new ConjuntoDatosMetafase();
            c.setListaDatos(this.listaAsignable.toArrayList());
            this.grafico.setMetafasesInvolucradas(c);
            this.actualizarMetafasePorDefecto(metafase);
        }
        return true;
    }

    public boolean aplicarModificar() {
        if ((TrMetafase)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex()) == null) {
            return false;
        }
        TrMetafase metafaseAux = new TrMetafase();
        metafaseAux.setMETAID(((TrMetafase)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex())).getMETAID());
        metafaseAux.setNOMBRE(this.pPanel.getNombreTmp());
        metafaseAux.setDefaultMetafase(this.pPanel.isDefaultTmp());
        if (((ConjuntoDatosMetafase)this.grafico.getMetafasesInvolucradas()).existeElemento(metafaseAux, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe una metafase con el nombre indicado.", "Atenci\u00f3n", 2);
            return false;
        }
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        this.actualizarMetafasePorDefecto(metafaseAux);
        this.listaAsignable.updateUI();
        return true;
    }

    public void cerrar() {
        if (!this.bDesdeUtilidadGrf) {
            this.refrescarGrafico();
        }
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        this.actualizarMetafasePorDefecto(null);
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            ((ConjuntoDatosMetafase)this.elementosAsignados).setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    private void jbInit() {
        this.bDesdeUtilidadGrf = false;
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.pPanel = new PropMetafaseJPanel();
        this.setPanelAtributable(this.pPanel);
        this.setLocationRelativeTo(null);
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.setTitle("Mantenimiento de metafases");
        this.botones.permitirEliminar(true);
        this.listaAsignable.setCellRenderer(new ColorMetafaseListRenderer());
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                Point p;
                int index;
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getClickCount() == 2) {
                    MantenimientoMetafasesJDialog.this.dobleClick();
                    return;
                }
                if (e.getSource() != null && (index = MantenimientoMetafasesJDialog.this.listaAsignable.locationToIndex(p = e.getPoint())) >= 0 && index <= MantenimientoMetafasesJDialog.this.listaAsignable.getNumItems()) {
                    IAsignable objAsig = MantenimientoMetafasesJDialog.this.listaAsignable.getElementAt(index);
                    MantenimientoMetafasesJDialog.this.establecerModoTrabajo(2);
                    MantenimientoMetafasesJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoMetafasesJDialog.this.botones.modificarButton_mousePressed(e);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoMetafasesJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoMetafasesJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoMetafasesJDialog.this.establecerModoTrabajo(7);
                    MantenimientoMetafasesJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoMetafasesJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoMetafasesJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoMetafasesJDialog.this.establecerModoTrabajo(7);
                    MantenimientoMetafasesJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoMetafasesJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoMetafasesJDialog.this.establecerModoTrabajo(2);
                    MantenimientoMetafasesJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoMetafasesJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 195, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public void setDesdeUtilidadGrf(boolean pValor) {
        this.bDesdeUtilidadGrf = pValor;
    }

    public boolean getDesdeUtilidadGrf() {
        return this.bDesdeUtilidadGrf;
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarMetafases(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getMetafasesInvolucradas());
        return true;
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        if (nuevoGrafico.getDDP().getTIPOEVOL() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
    }

    public void actualizarMetafasePorDefecto(TrMetafase metafasePorDefecto) {
        if (metafasePorDefecto != null && metafasePorDefecto.isDefaultMetafase()) {
            for (int n = 0; n < this.grafico.getMetafasesInvolucradas().listaDatos.size(); ++n) {
                TrMetafase metaAuxBucle = (TrMetafase)this.grafico.getMetafasesInvolucradas().listaDatos.get(n);
                metaAuxBucle.setDefaultMetafase(false);
                if (!metaAuxBucle.getNOMBRE().equals(metafasePorDefecto.getNOMBRE())) continue;
                metaAuxBucle.setDefaultMetafase(true);
                this.grafico.establecerMetafaseActiva(metaAuxBucle);
            }
        } else if (this.grafico.getMetafaseActiva() == null && this.grafico.getMetafasesInvolucradas() != null && this.grafico.getMetafasesInvolucradas().listaDatos.size() > 0) {
            ConjuntoDatosModela cdAuxiliar = this.grafico.getMetafasesInvolucradas();
            cdAuxiliar.ordenar();
            TrMetafase metafaseAux = (TrMetafase)cdAuxiliar.obtenerDato(0);
            metafaseAux.setDefaultMetafase(true);
            this.grafico.establecerMetafaseActiva(metafaseAux);
        }
    }
}

