/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrOrganismoProc;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropOrganismoProcedimientoJPanel;

public class MantenimientoOrganismoProcJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 4965843018210812125L;
    PropOrganismoProcedimientoJPanel pPanel;
    private final JLabel tituloLabel = new JLabel("Lista de organismos asociados");
    private DDPGrafico grafico;
    private final int ANCHO_ACTUAL = 690;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoOrganismoProcJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.setTitle("Mantenimiento de organismos asociados");
        this.pPanel = new PropOrganismoProcedimientoJPanel();
        this.pPanel.inicializarCampos(7);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoOrganismoProcJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoOrganismoProcJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoOrganismoProcJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoOrganismoProcJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoOrganismoProcJDialog.this.establecerModoTrabajo(2);
                        MantenimientoOrganismoProcJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoOrganismoProcJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoOrganismoProcJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoOrganismoProcJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoOrganismoProcJDialog.this.establecerModoTrabajo(7);
                    MantenimientoOrganismoProcJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoOrganismoProcJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoOrganismoProcJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoOrganismoProcJDialog.this.establecerModoTrabajo(7);
                    MantenimientoOrganismoProcJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoOrganismoProcJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoOrganismoProcJDialog.this.establecerModoTrabajo(2);
                    MantenimientoOrganismoProcJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoOrganismoProcJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 250, 25));
        super.setLocationRelativeTo(null);
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrOrganismoProc organismoProc = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        organismoProc = (TrOrganismoProc)this.pPanel.getValoresAsignables();
        if (organismoProc == null) {
            return false;
        }
        if (this.listaAsignable.toArrayList() != null) {
            for (int n = 0; n < this.listaAsignable.toArrayList().size(); ++n) {
                TrOrganismoProc auxOrg = (TrOrganismoProc)this.listaAsignable.toArrayList().get(n);
                if (!auxOrg.esDuplicidadAtributos(organismoProc)) continue;
            }
        }
        this.listaAsignable.addItem(organismoProc);
        this.listaAsignable.setSelectedValue(organismoProc, true);
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean aplicarModificar() {
        if ((TrOrganismoProc)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex()) == null) {
            return false;
        }
        TrOrganismoProc trOrganismoPretendido = new TrOrganismoProc();
        trOrganismoPretendido.setXOrganismoProc(((TrOrganismoProc)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex())).getXOrganismoProc());
        trOrganismoPretendido.setOrganismoAsociado(this.pPanel.trOrganismoAsociado);
        trOrganismoPretendido.setTipoAsociacion(this.pPanel.tipoAsociacion.getText());
        trOrganismoPretendido.setObservaciones(this.pPanel.observOrganismoProcArea.getText());
        boolean bYaExiste = false;
        for (int i = 0; i < this.listaAsignable.getNumItems(); ++i) {
            TrOrganismoProc trOrganismoAux = (TrOrganismoProc)this.listaAsignable.getElementAt(i);
            if (!trOrganismoAux.esDuplicidadAtributos(trOrganismoPretendido) || trOrganismoAux.getXOrganismoProc().longValue() == trOrganismoPretendido.getXOrganismoProc().longValue()) continue;
            bYaExiste = true;
            break;
        }
        if (bYaExiste) {
            // empty if block
        }
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarOrganismoProcedimiento(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getDDP().getTIPOEVOL().getOrganismosProcedimientoInvolucrados());
        return true;
    }
}

