/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.TrPlazoCompuestoDefProc;
import modela.bd.obj.TrTransicion;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropPlazoCompuestoDefProcJPanel;

public class MantenimientoPlazoCompuestoDefProcJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = -3640776712461717094L;
    PropPlazoCompuestoDefProcJPanel pPanel;
    private final JLabel tituloLabel = new JLabel("Lista de plazos compuestos");
    private DDPGrafico grafico;
    private final int ANCHO_ACTUAL = 790;
    private final int ALTO_ACTUAL = 540;

    public MantenimientoPlazoCompuestoDefProcJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void jbInit() {
        this.grafico = null;
        this.setTitle("Mantenimiento de plazos compuestos en el procedimiento");
        this.pPanel = new PropPlazoCompuestoDefProcJPanel();
        this.pPanel.inicializarCampos(7);
        this.setPanelAtributable(this.pPanel);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.tituloLabel.setForeground(ModelaUI.colorSeleccion);
        this.setLocationRelativeTo(null);
        this.insertarButton.setVisible(false);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoPlazoCompuestoDefProcJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoPlazoCompuestoDefProcJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoPlazoCompuestoDefProcJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoPlazoCompuestoDefProcJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoPlazoCompuestoDefProcJDialog.this.establecerModoTrabajo(2);
                        MantenimientoPlazoCompuestoDefProcJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoPlazoCompuestoDefProcJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoPlazoCompuestoDefProcJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoPlazoCompuestoDefProcJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoPlazoCompuestoDefProcJDialog.this.establecerModoTrabajo(7);
                    MantenimientoPlazoCompuestoDefProcJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoPlazoCompuestoDefProcJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoPlazoCompuestoDefProcJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoPlazoCompuestoDefProcJDialog.this.establecerModoTrabajo(7);
                    MantenimientoPlazoCompuestoDefProcJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoPlazoCompuestoDefProcJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoPlazoCompuestoDefProcJDialog.this.establecerModoTrabajo(2);
                    MantenimientoPlazoCompuestoDefProcJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoPlazoCompuestoDefProcJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.tituloLabel, new XYConstraints(20, 15, 200, 25));
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        String abrevTemp = null;
        TrPlazoCompuestoDefProc plz = null;
        TrPlazoCompuestoDefProc elementoListaAbrev = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        plz = (TrPlazoCompuestoDefProc)this.pPanel.getValoresAsignables();
        if (plz == null) {
            return false;
        }
        boolean encontrado = false;
        boolean transicionEncontrada = false;
        abrevTemp = this.pPanel.getAbreviaturaTemp();
        if (abrevTemp != null) {
            for (int i = 0; i < this.listaAsignable.getNumItems(); ++i) {
                elementoListaAbrev = (TrPlazoCompuestoDefProc)this.listaAsignable.getElementAt(i);
                if (!elementoListaAbrev.getABREVIATURA().equals(abrevTemp)) continue;
                ConjuntoDatos cdTrans = new ConjuntoDatos();
                cdTrans = elementoListaAbrev.getTransicionesIni();
                for (int y = 0; y < cdTrans.listaDatos.size(); ++y) {
                    TrTransicion trTrans = null;
                    trTrans = (TrTransicion)cdTrans.listaDatos.get(y);
                    Vector Vtrans = new Vector();
                    Vtrans = this.pPanel.getTransicionesTablaIni();
                    if (Vtrans == null) continue;
                    for (int x = 0; x < Vtrans.size(); ++x) {
                        TrTransicion TransTemp = (TrTransicion)Vtrans.get(x);
                        if (!TransTemp.equals(trTrans)) continue;
                        transicionEncontrada = true;
                        System.out.println("\u00b7 [ Alerta ] Hay transiciones iguales");
                    }
                }
            }
        }
        if (transicionEncontrada) {
            JOptionPane.showMessageDialog(this, "Imposible crear el plazo:\nTiene transiciones repetidas con otros plazos con la misma abreviatura.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            this.pPanel.limpiarTablaTransicionesIni();
            return false;
        }
        if (encontrado) {
            JOptionPane.showMessageDialog(this, "Imposible crear el plazo:\nYa existe una plazo con el nombre indicado.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        if (!encontrado) {
            this.listaAsignable.addItem(plz);
            this.listaAsignable.setSelectedValue(plz, true);
            this.listaAsignable.updateUI();
            return true;
        }
        this.listaAsignable.addItem(plz);
        this.listaAsignable.setSelectedValue(plz, true);
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean aplicarModificar() {
        if ((TrPlazoCompuestoDefProc)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex()) == null) {
            return false;
        }
        TrPlazoCompuestoDefProc trPlazoDelPanel = new TrPlazoCompuestoDefProc();
        trPlazoDelPanel.setXID(((TrPlazoCompuestoDefProc)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex())).getXID());
        trPlazoDelPanel.setABREVIATURA(this.pPanel.getAbreviaturaTemp());
        String abrevTemp = null;
        TrPlazoCompuestoDefProc elementoListaAbrev = null;
        boolean transicionEncontrada = false;
        abrevTemp = this.pPanel.getAbreviaturaTemp();
        if (abrevTemp != null) {
            for (int i = 0; i < this.listaAsignable.getNumItems(); ++i) {
                elementoListaAbrev = (TrPlazoCompuestoDefProc)this.listaAsignable.getElementAt(i);
                if (!elementoListaAbrev.getABREVIATURA().equals(abrevTemp) || elementoListaAbrev.getXID().longValue() == trPlazoDelPanel.getXID().longValue()) continue;
                ConjuntoDatos cdTrans = new ConjuntoDatos();
                cdTrans = elementoListaAbrev.getTransicionesIni();
                for (int y = 0; y < cdTrans.listaDatos.size(); ++y) {
                    TrTransicion trTrans = null;
                    trTrans = (TrTransicion)cdTrans.listaDatos.get(y);
                    Vector Vtrans = new Vector();
                    Vtrans = this.pPanel.getTransicionesTablaIni();
                    if (Vtrans == null) continue;
                    for (int x = 0; x < Vtrans.size(); ++x) {
                        TrTransicion TransTemp = (TrTransicion)Vtrans.get(x);
                        if (!TransTemp.equals(trTrans)) continue;
                        transicionEncontrada = true;
                        System.out.println("\u00b7 [ Alerta ] Hay transiciones iguales");
                    }
                }
            }
        }
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        if (transicionEncontrada) {
            JOptionPane.showMessageDialog(this, "Imposible modificar el plazo, tiene transiciones repetidas con otros plazos con la misma abreviatura.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            this.elementosAsignados.setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.pPanel.setGrafico(nuevoGrafico);
        this.grafico = nuevoGrafico;
    }

    public boolean comprobarExistenciaPlazos(TrPlazoCompuestoDefProc plazo, int nSelectedIndex) {
        if (this.listaAsignable.getNumItems() <= 0) {
            return false;
        }
        if (plazo == null) {
            return false;
        }
        boolean bEncontrado = false;
        for (int i = 0; i < this.listaAsignable.getNumItems() && !bEncontrado; ++i) {
            TrPlazoCompuestoDefProc plazoAux = (TrPlazoCompuestoDefProc)this.listaAsignable.getElementAt(i);
            if (plazoAux == null || i == nSelectedIndex || plazo.getABREVIATURA() == null || plazoAux.getABREVIATURA() == null || !plazo.getABREVIATURA().equals(plazoAux.getABREVIATURA())) continue;
            bEncontrado = true;
        }
        return bEncontrado;
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarPlazoCompuesto(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getDDP().getTIPOEVOL().getPlazosCompuestosProcedimiento());
        return true;
    }
}

