/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.ConjuntoDatosTarea;
import modela.bd.obj.TrBloquePermitido;
import modela.bd.obj.TrDocumentoPermitido;
import modela.bd.obj.TrTarea;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropTareaJPanel;
import modela.ui.swing.filtros.TareaListModelFilter;
import modela.ui.swing.renderers.TareaEnFaseCellRenderer;

public class MantenimientoTareaJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 6875636639423342535L;
    PropTareaJPanel pPanel;
    private JLabel tituloListaLabel = new JLabel();
    private DDPGrafico grafico = null;
    private JLabel jLabel1 = new JLabel();
    private boolean m_bFiltroBloque = false;
    private TareaListModelFilter model;
    private final int ANCHO_ACTUAL = 600;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoTareaJDialog() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void jbInit() {
        this.m_bFiltroBloque = false;
        this.setTitle("Mantenimiento de tareas");
        this.pPanel = new PropTareaJPanel();
        this.setPanelAtributable(this.pPanel);
        this.establecerModoTrabajo(7);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.tituloListaLabel.setText("Tareas...");
        this.tituloListaLabel.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.jLabel1.setText("Lista de tareas");
        this.jLabel1.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.jLabel1.setForeground(ModelaUI.colorSeleccion);
        this.botones.permitirEliminar(true);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoTareaJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoTareaJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index < MantenimientoTareaJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoTareaJDialog.this.listaAsignable.getElementAt(index);
                        MantenimientoTareaJDialog.this.establecerModoTrabajo(2);
                        MantenimientoTareaJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoTareaJDialog.this.botones.modificarButton_mousePressed(e);
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoTareaJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoTareaJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoTareaJDialog.this.establecerModoTrabajo(7);
                    MantenimientoTareaJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoTareaJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoTareaJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoTareaJDialog.this.establecerModoTrabajo(7);
                    MantenimientoTareaJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoTareaJDialog.this.listaAsignable.getSelectedValue();
                    MantenimientoTareaJDialog.this.establecerModoTrabajo(2);
                    MantenimientoTareaJDialog.this.pPanel.setValoresAsignables(objAsig);
                    MantenimientoTareaJDialog.this.botones.modificarButton_mousePressed(null);
                }
            }
        });
        this.getContentPane().add((Component)this.jLabel1, new XYConstraints(20, 15, 130, 20));
        this.listaAsignable.setCellRenderer(new TareaEnFaseCellRenderer());
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 4);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrTarea tareaInicial = (TrTarea)this.pPanel.getValoresAsignablesTemporales();
        if (!this.comprobarExistenciaTarea(tareaInicial, -1)) {
            TrTarea tarea = null;
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
            tarea = (TrTarea)this.pPanel.getValoresAsignables();
            if (this.pPanel.getValoresAsignables() instanceof TrBloquePermitido) {
                tarea = (TrBloquePermitido)this.pPanel.getValoresAsignables();
            }
            if (this.pPanel.getValoresAsignables() instanceof TrDocumentoPermitido) {
                tarea = (TrDocumentoPermitido)this.pPanel.getValoresAsignables();
            }
            if (!(this.pPanel.getValoresAsignables() instanceof TrBloquePermitido) && !(this.pPanel.getValoresAsignables() instanceof TrDocumentoPermitido)) {
                tarea = (TrTarea)this.pPanel.getValoresAsignables();
            }
            if (tarea == null) {
                return false;
            }
            this.listaAsignable.addItem(tarea);
            this.listaAsignable.setSelectedValue(tarea, true);
            this.listaAsignable.updateUI();
            this.aplicarFiltro(false);
            if (this.grafico != null) {
                ConjuntoDatosTarea c = new ConjuntoDatosTarea();
                c.setListaDatos(this.listaAsignable.toArrayList());
                this.grafico.setTareasInvolucradas(c);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible crear la tarea:\nYa existe una tarea con estas caracter\u00edsticas.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        return true;
    }

    public boolean aplicarModificar() {
        int nSelectedIndex;
        TrTarea tareaInicial = (TrTarea)this.pPanel.getValoresAsignablesTemporales();
        if (!this.comprobarExistenciaTarea(tareaInicial, nSelectedIndex = this.listaAsignable.getSelectedIndex())) {
            if (!this.pPanel.obtenerValoresCampos()) {
                return false;
            }
        } else {
            JOptionPane.showMessageDialog(this, "Imposible modificar la tarea:\nYa existe una tarea con estas caracter\u00edsticas.", MantenimientoJDialog.TEXTO_TITULO_MENSAJES, 2);
            return false;
        }
        this.listaAsignable.updateUI();
        this.aplicarFiltro(false);
        this.listaAsignable.updateUI();
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setValoresAsignables(obj);
        this.establecerModoTrabajo(2);
        return true;
    }

    public boolean refrescarGrafico() {
        this.m_bFiltroBloque = false;
        if (this.elementosAsignados != null) {
            ((ConjuntoDatosTarea)this.elementosAsignados).setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public void cerrar() {
        this.refrescarGrafico();
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        if (this.grafico == null) {
            cdElementos.ordenar();
            super.inicializarListaElementos(cdElementos);
            return;
        }
        this.grafico.getTareasInvolucradas().ordenar();
        super.inicializarListaElementos(this.grafico.getTareasInvolucradas());
        this.aplicarFiltro(true);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.pPanel.setGrafico(this.grafico);
    }

    public DDPGrafico getGrafico() {
        return this.grafico;
    }

    public boolean eliminarElemento() {
        if (this.grafico == null) {
            return false;
        }
        if (this.grafico.getDestructorDDP() == null) {
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            return false;
        }
        String msgPanel = new String();
        int[] indicesOriginal = this.listaAsignable.getSelectedIndices();
        this.establecerModoTrabajo(2);
        int nElementos = this.listaAsignable.getSelectedValues().length;
        Object[] options = new Object[]{"Aceptar", "Cancelar"};
        msgPanel = nElementos > 1 ? "\u00bfConfirma eliminar los elementos seleccionados?" : "\u00bfConfirma eliminar el elemento seleccionado?";
        int n = JOptionPane.showOptionDialog(this, msgPanel, "Eliminar", 0, 3, null, options, options[1]);
        if (n == -1) {
            n = 1;
        }
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        this.refrescarGrafico();
        int resulEliminar = this.grafico.getDestructorDDP().eliminarTareas(this.listaAsignable.getSelectedValues());
        if (resulEliminar == 0) {
            msgPanel = nElementos > 1 ? "Ha sido imposible eliminar los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades." : "Ha sido imposible eliminar el elemento seleccionado.\nCompruebe que no est\u00e1 intentando eliminar un elemento relacionado con otras entidades.";
            JOptionPane.showMessageDialog(this, msgPanel, "Atenci\u00f3n", 2);
            this.listaAsignable.setSelectedIndices(indicesOriginal);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            this.pPanel.restaurarColoresDeFondo();
            return false;
        }
        if (resulEliminar < nElementos) {
            JOptionPane.showMessageDialog(this, "Ha sido imposible eliminar alguno de los elementos seleccionados.\nCompruebe que no est\u00e1 intentando eliminar elementos relacionados con otras entidades.", "Atenci\u00f3n", 2);
        }
        this.listaAsignable.setSelectedIndex(-1);
        this.establecerModoTrabajo(7);
        this.pPanel.limpiarCampos();
        this.inicializarListaElementos(this.grafico.getTareasInvolucradas());
        return true;
    }

    public boolean comprobarExistenciaTarea(TrTarea tarea, int nSelectedIndex) {
        if (this.listaAsignable.getNumItems() <= 0) {
            return false;
        }
        if (tarea == null) {
            return false;
        }
        boolean bTipoElemento = false;
        boolean bID = false;
        boolean bEncontrado = false;
        for (int i = 0; i < this.listaAsignable.getNumItems() && !bEncontrado; ++i) {
            bTipoElemento = false;
            bID = false;
            TrTarea tareaAux = (TrTarea)this.listaAsignable.getElementAt(i);
            if (tareaAux != null && i != nSelectedIndex) {
                if (tarea instanceof TrBloquePermitido && tareaAux instanceof TrBloquePermitido) {
                    bTipoElemento = true;
                    TrBloquePermitido bloquePermitido = (TrBloquePermitido)tarea;
                    TrBloquePermitido bloquePermitidoAux = (TrBloquePermitido)tareaAux;
                    if (bloquePermitido.getBloqueFin() != null && bloquePermitido.getBloqueFin() != null && bloquePermitido.getBloqueFin().getID() == bloquePermitidoAux.getBloqueFin().getID()) {
                        bID = true;
                    }
                }
                if (tarea instanceof TrDocumentoPermitido && tareaAux instanceof TrDocumentoPermitido) {
                    bTipoElemento = true;
                    TrDocumentoPermitido tipoDocPermitido = (TrDocumentoPermitido)tarea;
                    TrDocumentoPermitido tipoDocPermitidoAux = (TrDocumentoPermitido)tareaAux;
                    if (tipoDocPermitido.getTipoDocumento() != null && tipoDocPermitidoAux.getTipoDocumento() != null && tipoDocPermitido.getTipoDocumento().getID() == tipoDocPermitidoAux.getTipoDocumento().getID()) {
                        bID = true;
                    }
                }
            }
            if (!bTipoElemento || !bID) continue;
            bEncontrado = true;
        }
        return bEncontrado;
    }

    public void setFiltroBloque(boolean bFiltroBloque) {
        this.m_bFiltroBloque = bFiltroBloque;
    }

    private void aplicarFiltro(boolean bCrearModel) {
        if (this.m_bFiltroBloque) {
            if (bCrearModel) {
                this.model = new TareaListModelFilter(this.listaAsignable.getModel());
                this.model.setFiltroBloque(true);
                this.model.aplicarFiltro();
                this.listaAsignable.setFiltro(this.model);
            } else {
                this.model.aplicarFiltro();
            }
        }
    }
}

