/*
 * Decompiled with CFR 0.152.
 */
package modela.ui.swing;

import gdtel.bd.ConjuntoDatos;
import gdtel.ui.IAsignable;
import gdtel.ui.swing.XYConstraints;
import gdtel.ui.swing.bd.MantenimientoJDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import modela.bd.obj.ConjuntoDatosTransicion;
import modela.bd.obj.TrTransicion;
import modela.conf.ModelaConf;
import modela.graf.DDPGrafico;
import modela.ui.ModelaUI;
import modela.ui.swing.PropTransicionJPanel;
import modela.ui.swing.renderers.TransicionesListCellRenderer;

public class MantenimientoTransicionJDialog
extends MantenimientoJDialog {
    private static final long serialVersionUID = 2149033928281786691L;
    PropTransicionJPanel pPanel;
    private DDPGrafico grafico = null;
    private JLabel jLabel1 = new JLabel();
    boolean bDesdeUtilidadGrf;
    boolean bViendoPropiedades;
    private final int ANCHO_ACTUAL = 835;
    private final int ALTO_ACTUAL = 515;

    public MantenimientoTransicionJDialog(boolean bMostrarTransiDefProc) {
        try {
            this.jbInit(bMostrarTransiDefProc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void jbInit(boolean bMostrarAccConAviPer) {
        this.setTitle("Mantenimiento de transiciones");
        this.bDesdeUtilidadGrf = false;
        this.bViendoPropiedades = false;
        this.pPanel = new PropTransicionJPanel(bMostrarAccConAviPer);
        this.setSize(new Dimension(this.ANCHO_ACTUAL, this.ALTO_ACTUAL));
        this.jLabel1.setText("Lista de transiciones");
        this.jLabel1.setFont(ModelaUI.fuenteSecundariaNegrita);
        this.jLabel1.setForeground(ModelaUI.colorSeleccion);
        this.pPanel.inicializarCampos(2);
        this.setPanelAtributable(this.pPanel);
        this.botones.permitirEliminar(false);
        this.botones.permitirInsertar(false);
        this.listaAsignable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    return;
                }
                super.mousePressed(e);
                if (e.getSource() != null) {
                    if (e.getClickCount() == 2) {
                        MantenimientoTransicionJDialog.this.dobleClick();
                        return;
                    }
                    Point p = e.getPoint();
                    int index = MantenimientoTransicionJDialog.this.listaAsignable.locationToIndex(p);
                    if (index >= 0 && index <= MantenimientoTransicionJDialog.this.listaAsignable.getNumItems()) {
                        IAsignable objAsig = MantenimientoTransicionJDialog.this.listaAsignable.getElementAt(index);
                        if (!MantenimientoTransicionJDialog.this.bDesdeUtilidadGrf) {
                            MantenimientoTransicionJDialog.this.establecerModoTrabajo(2);
                            MantenimientoTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                            MantenimientoTransicionJDialog.this.botones.modificarButton_mousePressed(e);
                        } else if (!MantenimientoTransicionJDialog.this.bViendoPropiedades) {
                            MantenimientoTransicionJDialog.this.establecerModoTrabajo(8);
                            MantenimientoTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                        } else {
                            MantenimientoTransicionJDialog.this.establecerModoTrabajo(2);
                            MantenimientoTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                            MantenimientoTransicionJDialog.this.pPanel.actualizarListas();
                            MantenimientoTransicionJDialog.this.botones.modificarButton_mousePressed(e);
                        }
                    }
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (MantenimientoTransicionJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoTransicionJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoTransicionJDialog.this.establecerModoTrabajo(7);
                    MantenimientoTransicionJDialog.this.pPanel.limpiarCampos();
                    return;
                }
            }
        });
        this.listaAsignable.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent kevt) {
                super.keyReleased(kevt);
                if (MantenimientoTransicionJDialog.this.listaAsignable.getSelectedValues() == null || MantenimientoTransicionJDialog.this.listaAsignable.getSelectedValues().length <= 0) {
                    MantenimientoTransicionJDialog.this.establecerModoTrabajo(7);
                    MantenimientoTransicionJDialog.this.pPanel.limpiarCampos();
                } else {
                    IAsignable objAsig = (IAsignable)MantenimientoTransicionJDialog.this.listaAsignable.getSelectedValue();
                    if (!MantenimientoTransicionJDialog.this.bDesdeUtilidadGrf) {
                        MantenimientoTransicionJDialog.this.establecerModoTrabajo(2);
                        MantenimientoTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoTransicionJDialog.this.botones.modificarButton_mousePressed(null);
                    } else if (!MantenimientoTransicionJDialog.this.bViendoPropiedades) {
                        MantenimientoTransicionJDialog.this.establecerModoTrabajo(8);
                        MantenimientoTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                    } else {
                        MantenimientoTransicionJDialog.this.establecerModoTrabajo(2);
                        MantenimientoTransicionJDialog.this.pPanel.setValoresAsignables(objAsig);
                        MantenimientoTransicionJDialog.this.botones.modificarButton_mousePressed(null);
                    }
                }
            }
        });
        this.getContentPane().add((Component)this.jLabel1, new XYConstraints(20, 15, 140, 20));
        this.listaAsignable.setCellRenderer(new TransicionesListCellRenderer());
        this.addControles(this.ANCHO_ACTUAL, this.ALTO_ACTUAL, 2);
        ModelaConf.setVentanaActiva(this);
    }

    public boolean eliminarElemento() {
        Object[] opciones = new Object[]{"Aceptar", "Cancelar"};
        int n = JOptionPane.showOptionDialog(this, "\u00bfDesea realmente eliminar el elemento?", "Eliminar", 0, 3, null, opciones, opciones[1]);
        if (n == 1) {
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        this.listaAsignable.removeItem(index);
        if (index > 0) {
            this.listaAsignable.setSelectedIndex(index - 1);
            IAsignable obj = this.listaAsignable.getElementAt(index - 1);
            this.pPanel.setValoresAsignables(obj);
            this.establecerModoTrabajo(2);
            this.botones.modificarButton_mousePressed(null);
        } else if (index == 0) {
            if (!this.listaAsignable.hasAnyObject()) {
                this.establecerModoTrabajo(7);
                this.pPanel.limpiarCampos();
            } else {
                this.listaAsignable.setSelectedIndex(index);
                IAsignable obj = this.listaAsignable.getElementAt(index);
                this.pPanel.setValoresAsignables(obj);
                this.establecerModoTrabajo(2);
                this.botones.modificarButton_mousePressed(null);
            }
        }
        return true;
    }

    public boolean modificarElemento() {
        this.establecerModoTrabajo(3);
        return true;
    }

    public boolean insertarElemento() {
        this.establecerModoTrabajo(1);
        this.pPanel.inicializarFoco();
        return true;
    }

    public boolean aplicar() {
        boolean bRespuesta = false;
        if (this.getAccion() == 1) {
            bRespuesta = this.aplicarNuevo();
        } else if (this.getAccion() == 3) {
            bRespuesta = this.aplicarModificar();
        }
        if (!bRespuesta) {
            this.botones.setModoModificarPorDefault(false);
        }
        return bRespuesta;
    }

    public boolean aplicarNuevo() {
        TrTransicion trTrans = null;
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        trTrans = (TrTransicion)this.pPanel.getValoresAsignables();
        if (trTrans == null) {
            return false;
        }
        this.listaAsignable.addItem(trTrans);
        this.listaAsignable.setSelectedValue(trTrans, true);
        this.listaAsignable.updateUI();
        if (this.pPanel.getGrafico() != null && this.pPanel.getGrafico().getCanvas() != null) {
            this.pPanel.getGrafico().getCanvas().actualizarIconosTr();
        }
        return true;
    }

    public boolean aplicarModificar() {
        if ((TrTransicion)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex()) == null) {
            return false;
        }
        TrTransicion transiAux = new TrTransicion();
        transiAux.setTRANID(((TrTransicion)this.listaAsignable.getElementAt(this.listaAsignable.getSelectedIndex())).getTRANID());
        transiAux.setTIPO(this.pPanel.getTipoTmp());
        transiAux.setETIQUETA(this.pPanel.getEtiquetaTmp());
        transiAux.setTrFaseIni(this.pPanel.getFaseIniTmp());
        transiAux.setTrFaseFin(this.pPanel.getFaseFinTmp());
        if (this.grafico.getTransicionesInvolucradas().existeElemento(transiAux, true) != null) {
            JOptionPane.showMessageDialog(this, "Imposible modificar:\nYa existe una transici\u00f3n con id\u00e9nticas caracter\u00edsticas.", "Atenci\u00f3n", 2);
            return false;
        }
        if (!this.pPanel.obtenerValoresCampos()) {
            return false;
        }
        this.listaAsignable.updateUI();
        if (this.pPanel.getGrafico() != null && this.pPanel.getGrafico().getCanvas() != null) {
            this.pPanel.getGrafico().getCanvas().actualizarIconosTr();
        }
        return true;
    }

    public boolean cancelar() {
        if (this.listaAsignable == null) {
            this.pPanel.limpiarCampos();
            this.establecerModoTrabajo(7);
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        if (!this.listaAsignable.hasAnyObject()) {
            this.establecerModoTrabajo(7);
            this.pPanel.limpiarCampos();
            this.botones.setModoModificarPorDefault(false);
            return false;
        }
        int index = this.listaAsignable.getSelectedIndex();
        if (index < 0) {
            index = 0;
        }
        this.listaAsignable.setSelectedIndex(index);
        IAsignable obj = this.listaAsignable.getElementAt(index);
        this.pPanel.setCancelando(true);
        this.pPanel.setValoresAsignables(obj);
        if (this.grafico != null && this.grafico.getCanvas() != null) {
            this.grafico.getCanvas().actualizarIconosTr();
        }
        this.establecerModoTrabajo(2);
        return true;
    }

    public boolean refrescarGrafico() {
        if (this.elementosAsignados != null) {
            ((ConjuntoDatosTransicion)this.elementosAsignados).setListaDatos(this.listaAsignable.toArrayList());
        }
        return true;
    }

    public void cerrar() {
        if (!this.bDesdeUtilidadGrf) {
            this.refrescarGrafico();
        }
    }

    public void inicializarListaElementos(ConjuntoDatos cdElementos) {
        cdElementos.ordenar();
        super.inicializarListaElementos(cdElementos);
    }

    public void setGrafico(DDPGrafico nuevoGrafico) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        if (nuevoGrafico.getDDP().getTIPOEVOL() == null) {
            return;
        }
        this.pPanel.setGrafico(this.grafico);
        this.grafico = nuevoGrafico;
        this.inicializarPantalla();
    }

    public boolean inicializarPantalla() {
        if (this.grafico == null) {
            return false;
        }
        this.inicializarListaElementos(this.grafico.getTransicionesInvolucradas());
        this.inicializarGraficoAsociado();
        this.inicializarTiposActo();
        return true;
    }

    public void inicializarGraficoAsociado() {
        PropTransicionJPanel panelTransicion = this.pPanel;
        if (this.pPanel == null) {
            return;
        }
        if (this.grafico == null) {
            return;
        }
        panelTransicion.setGrafico(this.grafico);
    }

    public void inicializarTiposActo() {
        PropTransicionJPanel panelTransicion = this.pPanel;
        if (this.pPanel == null) {
            return;
        }
        if (this.grafico == null) {
            return;
        }
        panelTransicion.setTiposActoInvolucrados(this.grafico.getTiposActoInvolucrados());
    }

    public void setGrafico(DDPGrafico nuevoGrafico, ConjuntoDatos listaFiltrada) {
        if (nuevoGrafico == null) {
            return;
        }
        if (nuevoGrafico.getDDP() == null) {
            return;
        }
        if (nuevoGrafico.getDDP().getTIPOEVOL() == null) {
            return;
        }
        if (listaFiltrada == null) {
            return;
        }
        this.grafico = nuevoGrafico;
        this.inicializarPantalla(listaFiltrada);
    }

    public boolean inicializarPantalla(ConjuntoDatos listaFiltrada) {
        if (this.grafico == null) {
            return false;
        }
        this.inicializarListaElementos(listaFiltrada);
        this.inicializarGraficoAsociado();
        this.inicializarTiposActo();
        return true;
    }

    public void setDesdeUtilidadGrf(boolean pValor) {
        this.bDesdeUtilidadGrf = pValor;
        this.setModoModificarTrasBusqueda(!this.bDesdeUtilidadGrf);
    }

    public boolean getDesdeUtilidadGrf() {
        return this.bDesdeUtilidadGrf;
    }

    public void setViendoPropiedades(boolean pValor) {
        this.bViendoPropiedades = pValor;
        this.setModoModificarTrasBusqueda(this.bViendoPropiedades);
    }

    public boolean getViendoPropiedades() {
        return this.bViendoPropiedades;
    }
}

